/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ExplosionParticleInfo;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionBrewer;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.crafting.RecipeAccess;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.chunk.PalettedContainerFactory;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.redstone.CollectingNeighborUpdater;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WorldDataMutable;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.Scoreboard;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.block.CapturedBlockState;
import org.bukkit.craftbukkit.v1_21_R6.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftSpawnCategory;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;

public abstract class World
implements GeneratorAccess,
AutoCloseable {
    public static final Codec<ResourceKey<World>> g = ResourceKey.a(Registries.bx);
    public static final ResourceKey<World> h = ResourceKey.a(Registries.bx, MinecraftKey.b("overworld"));
    public static final ResourceKey<World> i = ResourceKey.a(Registries.bx, MinecraftKey.b("the_nether"));
    public static final ResourceKey<World> j = ResourceKey.a(Registries.bx, MinecraftKey.b("the_end"));
    public static final int k = 30000000;
    public static final int l = 512;
    public static final int m = 32;
    public static final int n = 15;
    public static final int o = 24000;
    public static final int p = 20000000;
    public static final int q = -20000000;
    public static final WeightedList<ExplosionParticleInfo> a = WeightedList.b().a(new ExplosionParticleInfo(Particles.af, 0.5f, 1.0f)).a(new ExplosionParticleInfo(Particles.ai, 1.0f, 1.0f)).a();
    protected final List<TickingBlockEntity> r = Lists.newArrayList();
    protected final CollectingNeighborUpdater s;
    private final List<TickingBlockEntity> b = Lists.newArrayList();
    private boolean c;
    public final Thread d;
    private final boolean e;
    private int f;
    protected int t = RandomSource.a().f();
    protected final int u = 1013904223;
    protected float v;
    public float w;
    protected float x;
    public float y;
    public final RandomSource z = RandomSource.a();
    @Deprecated
    private final RandomSource C = RandomSource.b();
    private final Holder<DimensionManager> D;
    public final WorldDataMutable A;
    private final boolean E;
    private final BiomeManager F;
    private final ResourceKey<World> G;
    private final IRegistryCustom H;
    private final DamageSources I;
    private final PalettedContainerFactory J;
    private long K;
    private final CraftWorld world;
    public ChunkGenerator generator;
    public boolean preventPoiUpdated = false;
    public boolean captureBlockStates = false;
    public boolean captureTreeGeneration = false;
    public Map<BlockPosition, CapturedBlockState> capturedBlockStates = new LinkedHashMap<BlockPosition, CapturedBlockState>();
    public Map<BlockPosition, TileEntity> capturedTileEntities = new HashMap<BlockPosition, TileEntity>();
    public List<EntityItem> captureDrops;
    public final Object2LongOpenHashMap<SpawnCategory> ticksPerSpawnCategory = new Object2LongOpenHashMap();
    public boolean populating;

    public CraftWorld getWorld() {
        return this.world;
    }

    public CraftServer getCraftServer() {
        return (CraftServer)Bukkit.getServer();
    }

    public abstract ResourceKey<WorldDimension> getTypeKey();

    protected World(WorldDataMutable worlddatamutable, ResourceKey<World> resourcekey, IRegistryCustom iregistrycustom, Holder<DimensionManager> holder, boolean flag, boolean flag1, long i2, int j2, ChunkGenerator gen, BiomeProvider biomeProvider, World.Environment env) {
        this.generator = gen;
        this.world = new CraftWorld((WorldServer)this, gen, biomeProvider, env);
        for (SpawnCategory spawnCategory : SpawnCategory.values()) {
            if (!CraftSpawnCategory.isValidForLimits(spawnCategory)) continue;
            this.ticksPerSpawnCategory.put((Object)spawnCategory, (long)this.getCraftServer().getTicksPerSpawns(spawnCategory));
        }
        this.A = worlddatamutable;
        this.D = holder;
        DimensionManager dimensionmanager = holder.a();
        this.G = resourcekey;
        this.E = flag;
        this.d = Thread.currentThread();
        this.F = new BiomeManager(this, i2);
        this.e = flag1;
        this.s = new CollectingNeighborUpdater(this, j2);
        this.H = iregistrycustom;
        this.J = PalettedContainerFactory.a(iregistrycustom);
        this.I = new DamageSources(iregistrycustom);
    }

    @Override
    public boolean D_() {
        return this.E;
    }

    @Override
    @Nullable
    public MinecraftServer q() {
        return null;
    }

    public boolean k(BlockPosition blockposition) {
        return !this.u(blockposition) && World.g(blockposition);
    }

    public static boolean l(BlockPosition blockposition) {
        return !World.b(blockposition.v()) && World.g(blockposition);
    }

    private static boolean g(BlockPosition blockposition) {
        return blockposition.u() >= -30000000 && blockposition.w() >= -30000000 && blockposition.u() < 30000000 && blockposition.w() < 30000000;
    }

    private static boolean b(int i2) {
        return i2 < -20000000 || i2 >= 20000000;
    }

    public Chunk m(BlockPosition blockposition) {
        return this.d(SectionPosition.a(blockposition.u()), SectionPosition.a(blockposition.w()));
    }

    public Chunk d(int i2, int j2) {
        return (Chunk)this.a(i2, j2, ChunkStatus.n);
    }

    @Override
    @Nullable
    public IChunkAccess a(int i2, int j2, ChunkStatus chunkstatus, boolean flag) {
        IChunkAccess ichunkaccess = this.X().a(i2, j2, chunkstatus, flag);
        if (ichunkaccess == null && flag) {
            throw new IllegalStateException("Should always be able to create a chunk!");
        }
        return ichunkaccess;
    }

    @Override
    public boolean a(BlockPosition blockposition, IBlockData iblockdata, int i2) {
        return this.a(blockposition, iblockdata, i2, 512);
    }

    @Override
    public boolean a(BlockPosition blockposition, IBlockData iblockdata, int i2, int j2) {
        IBlockData iblockdata1;
        if (this.captureTreeGeneration) {
            CapturedBlockState blockstate = this.capturedBlockStates.get(blockposition);
            if (blockstate == null) {
                blockstate = CapturedBlockState.getTreeBlockState(this, blockposition, i2);
                this.capturedBlockStates.put(blockposition.j(), blockstate);
            }
            blockstate.setData(iblockdata);
            blockstate.setFlag(i2);
            return true;
        }
        if (this.u(blockposition)) {
            return false;
        }
        if (!this.D_() && this.am()) {
            return false;
        }
        Chunk chunk = this.m(blockposition);
        Block block = iblockdata.b();
        boolean captured = false;
        if (this.captureBlockStates && !this.capturedBlockStates.containsKey(blockposition)) {
            CapturedBlockState blockstate = CapturedBlockState.getBlockState(this, blockposition, i2);
            this.capturedBlockStates.put(blockposition.j(), blockstate);
            captured = true;
        }
        if ((iblockdata1 = chunk.a(blockposition, iblockdata, i2)) == null) {
            if (this.captureBlockStates && captured) {
                this.capturedBlockStates.remove(blockposition);
            }
            return false;
        }
        IBlockData iblockdata2 = this.a_(blockposition);
        if (!this.captureBlockStates) {
            this.notifyAndUpdatePhysics(blockposition, chunk, iblockdata1, iblockdata, iblockdata2, i2, j2);
        }
        return true;
    }

    public void notifyAndUpdatePhysics(BlockPosition blockposition, Chunk chunk, IBlockData oldBlock, IBlockData newBlock, IBlockData actualBlock, int i2, int j2) {
        IBlockData iblockdata = newBlock;
        IBlockData iblockdata1 = oldBlock;
        IBlockData iblockdata2 = actualBlock;
        if (iblockdata2 == iblockdata) {
            if (iblockdata1 != iblockdata2) {
                this.b(blockposition, iblockdata1, iblockdata2);
            }
            if ((i2 & 2) != 0 && (!this.E || (i2 & 4) == 0) && (this.E || chunk == null || chunk.G() != null && chunk.G().a(FullChunkStatus.c))) {
                this.a(blockposition, iblockdata1, iblockdata, i2);
            }
            if ((i2 & 1) != 0) {
                this.a(blockposition, iblockdata1.b());
                if (!this.E && iblockdata.q()) {
                    this.b(blockposition, newBlock.b());
                }
            }
            if ((i2 & 0x10) == 0 && j2 > 0) {
                int k2 = i2 & 0xFFFFFFDE;
                iblockdata1.b(this, blockposition, k2, j2 - 1);
                CraftWorld world = ((WorldServer)this).getWorld();
                if (world != null) {
                    BlockPhysicsEvent event = new BlockPhysicsEvent(world.getBlockAt(blockposition.u(), blockposition.v(), blockposition.w()), (BlockData)CraftBlockData.fromData(iblockdata));
                    this.getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return;
                    }
                }
                iblockdata.a((GeneratorAccess)this, blockposition, k2, j2 - 1);
                iblockdata.b(this, blockposition, k2, j2 - 1);
            }
            if (!this.preventPoiUpdated) {
                this.a(blockposition, iblockdata1, iblockdata2);
            }
        }
    }

    public void a(BlockPosition blockposition, IBlockData iblockdata, IBlockData iblockdata1) {
    }

    @Override
    public boolean a(BlockPosition blockposition, boolean flag) {
        Fluid fluid = this.b_(blockposition);
        return this.a(blockposition, fluid.g(), 3 | (flag ? 64 : 0));
    }

    @Override
    public boolean a(BlockPosition blockposition, boolean flag, @Nullable Entity entity, int i2) {
        boolean flag1;
        IBlockData iblockdata = this.a_(blockposition);
        if (iblockdata.l()) {
            return false;
        }
        Fluid fluid = this.b_(blockposition);
        if (!(iblockdata.b() instanceof BlockFireAbstract)) {
            this.c(2001, blockposition, Block.j(iblockdata));
        }
        if (flag) {
            TileEntity tileentity = iblockdata.x() ? this.c_(blockposition) : null;
            Block.a(iblockdata, this, blockposition, tileentity, entity, ItemStack.l);
        }
        if (flag1 = this.a(blockposition, fluid.g(), 3, i2)) {
            this.a(GameEvent.f, blockposition, GameEvent.a.a(entity, iblockdata));
        }
        return flag1;
    }

    public void b(BlockPosition blockposition, IBlockData iblockdata) {
    }

    public boolean c(BlockPosition blockposition, IBlockData iblockdata) {
        return this.a(blockposition, iblockdata, 3);
    }

    public abstract void a(BlockPosition var1, IBlockData var2, IBlockData var3, int var4);

    public void b(BlockPosition blockposition, IBlockData iblockdata, IBlockData iblockdata1) {
    }

    public void a(BlockPosition blockposition, Block block, @Nullable Orientation orientation) {
    }

    public void a(BlockPosition blockposition, Block block, EnumDirection enumdirection, @Nullable Orientation orientation) {
    }

    public void b(BlockPosition blockposition, Block block, @Nullable Orientation orientation) {
    }

    public void a(IBlockData iblockdata, BlockPosition blockposition, Block block, @Nullable Orientation orientation, boolean flag) {
    }

    @Override
    public void a(EnumDirection enumdirection, BlockPosition blockposition, BlockPosition blockposition1, IBlockData iblockdata, int i2, int j2) {
        this.s.a(enumdirection, iblockdata, blockposition, blockposition1, i2, j2);
    }

    @Override
    public int a(HeightMap.Type heightmap_type, int i2, int j2) {
        int k2 = i2 >= -30000000 && j2 >= -30000000 && i2 < 30000000 && j2 < 30000000 ? (this.b(SectionPosition.a(i2), SectionPosition.a(j2)) ? this.d(SectionPosition.a(i2), SectionPosition.a(j2)).a(heightmap_type, i2 & 0xF, j2 & 0xF) + 1 : this.M_()) : this.T() + 1;
        return k2;
    }

    @Override
    public LevelLightEngine E_() {
        return this.X().r();
    }

    @Override
    public IBlockData a_(BlockPosition blockposition) {
        CapturedBlockState previous;
        if (this.captureTreeGeneration && (previous = this.capturedBlockStates.get(blockposition)) != null) {
            return previous.getHandle();
        }
        if (this.u(blockposition)) {
            return Blocks.nY.m();
        }
        Chunk chunk = this.d(SectionPosition.a(blockposition.u()), SectionPosition.a(blockposition.w()));
        return chunk.a_(blockposition);
    }

    @Override
    public Fluid b_(BlockPosition blockposition) {
        if (this.u(blockposition)) {
            return FluidTypes.a.g();
        }
        Chunk chunk = this.m(blockposition);
        return chunk.b_(blockposition);
    }

    public boolean aa() {
        return !this.H_().a() && this.f < 4;
    }

    public boolean ab() {
        return !this.H_().a() && !this.aa();
    }

    public boolean ac() {
        if (!this.H_().j()) {
            return false;
        }
        int i2 = (int)(this.ah() % 24000L);
        return i2 >= 12600 && i2 <= 23400;
    }

    @Override
    public void a(@Nullable Entity entity, BlockPosition blockposition, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1) {
        this.a(entity, (double)blockposition.u() + 0.5, (double)blockposition.v() + 0.5, (double)blockposition.w() + 0.5, soundeffect, soundcategory, f2, f1);
    }

    public abstract void a(@Nullable Entity var1, double var2, double var4, double var6, Holder<SoundEffect> var8, SoundCategory var9, float var10, float var11, long var12);

    public void a(@Nullable Entity entity, double d0, double d1, double d2, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1, long i2) {
        this.a(entity, d0, d1, d2, BuiltInRegistries.b.e(soundeffect), soundcategory, f2, f1, i2);
    }

    public abstract void a(@Nullable Entity var1, Entity var2, Holder<SoundEffect> var3, SoundCategory var4, float var5, float var6, long var7);

    public void a(@Nullable Entity entity, double d0, double d1, double d2, SoundEffect soundeffect, SoundCategory soundcategory) {
        this.a(entity, d0, d1, d2, soundeffect, soundcategory, 1.0f, 1.0f);
    }

    public void a(@Nullable Entity entity, double d0, double d1, double d2, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1) {
        this.a(entity, d0, d1, d2, soundeffect, soundcategory, f2, f1, this.C.g());
    }

    public void a(@Nullable Entity entity, double d0, double d1, double d2, Holder<SoundEffect> holder, SoundCategory soundcategory, float f2, float f1) {
        this.a(entity, d0, d1, d2, holder, soundcategory, f2, f1, this.C.g());
    }

    public void a(@Nullable Entity entity, Entity entity1, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1) {
        this.a(entity, entity1, BuiltInRegistries.b.e(soundeffect), soundcategory, f2, f1, this.C.g());
    }

    public void a(BlockPosition blockposition, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1, boolean flag) {
        this.a((double)blockposition.u() + 0.5, (double)blockposition.v() + 0.5, (double)blockposition.w() + 0.5, soundeffect, soundcategory, f2, f1, flag);
    }

    public void a(Entity entity, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1) {
    }

    public void a(double d0, double d1, double d2, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1, boolean flag) {
    }

    public void a(SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1) {
    }

    @Override
    public void a(ParticleParam particleparam, double d0, double d1, double d2, double d3, double d4, double d5) {
    }

    public void a(ParticleParam particleparam, boolean flag, boolean flag1, double d0, double d1, double d2, double d3, double d4, double d5) {
    }

    public void b(ParticleParam particleparam, double d0, double d1, double d2, double d3, double d4, double d5) {
    }

    public void a(ParticleParam particleparam, boolean flag, double d0, double d1, double d2, double d3, double d4, double d5) {
    }

    public float a(float f2) {
        float f1 = this.f(f2);
        return f1 * ((float)Math.PI * 2);
    }

    public void a(TickingBlockEntity tickingblockentity) {
        (this.c ? this.b : this.r).add(tickingblockentity);
    }

    public void ad() {
        this.c = true;
        if (!this.b.isEmpty()) {
            this.r.addAll(this.b);
            this.b.clear();
        }
        Iterator<TickingBlockEntity> iterator = this.r.iterator();
        boolean flag = this.w().i();
        while (iterator.hasNext()) {
            TickingBlockEntity tickingblockentity = iterator.next();
            if (tickingblockentity.b()) {
                iterator.remove();
                continue;
            }
            if (!flag || !this.n(tickingblockentity.c())) continue;
            tickingblockentity.a();
        }
        this.c = false;
    }

    public <T extends Entity> void a(Consumer<T> consumer, T t0) {
        try {
            consumer.accept(t0);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Ticking entity");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Entity being ticked");
            t0.a(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    public boolean h(Entity entity) {
        return true;
    }

    public boolean a(long i2) {
        return true;
    }

    public boolean n(BlockPosition blockposition) {
        return this.a(ChunkCoordIntPair.a(blockposition));
    }

    public void a(@Nullable Entity entity, double d0, double d1, double d2, float f2, a world_a) {
        this.a(entity, Explosion.a(this, entity), null, d0, d1, d2, f2, false, world_a, Particles.x, Particles.w, a, SoundEffects.lw);
    }

    public void a(@Nullable Entity entity, double d0, double d1, double d2, float f2, boolean flag, a world_a) {
        this.a(entity, Explosion.a(this, entity), null, d0, d1, d2, f2, flag, world_a, Particles.x, Particles.w, a, SoundEffects.lw);
    }

    public void a(@Nullable Entity entity, @Nullable DamageSource damagesource, @Nullable ExplosionDamageCalculator explosiondamagecalculator, Vec3D vec3d, float f2, boolean flag, a world_a) {
        this.a(entity, damagesource, explosiondamagecalculator, vec3d.a(), vec3d.b(), vec3d.c(), f2, flag, world_a, Particles.x, Particles.w, a, SoundEffects.lw);
    }

    public void a(@Nullable Entity entity, @Nullable DamageSource damagesource, @Nullable ExplosionDamageCalculator explosiondamagecalculator, double d0, double d1, double d2, float f2, boolean flag, a world_a) {
        this.a(entity, damagesource, explosiondamagecalculator, d0, d1, d2, f2, flag, world_a, Particles.x, Particles.w, a, SoundEffects.lw);
    }

    public abstract void a(@Nullable Entity var1, @Nullable DamageSource var2, @Nullable ExplosionDamageCalculator var3, double var4, double var6, double var8, float var10, boolean var11, a var12, ParticleParam var13, ParticleParam var14, WeightedList<ExplosionParticleInfo> var15, Holder<SoundEffect> var16);

    public abstract String N();

    @Override
    @Nullable
    public TileEntity c_(BlockPosition blockposition) {
        return this.getBlockEntity(blockposition, true);
    }

    @Nullable
    public TileEntity getBlockEntity(BlockPosition blockposition, boolean validate) {
        if (this.capturedTileEntities.containsKey(blockposition)) {
            return this.capturedTileEntities.get(blockposition);
        }
        return this.u(blockposition) ? null : (!this.D_() && Thread.currentThread() != this.d ? null : this.m(blockposition).a(blockposition, Chunk.EnumTileEntityState.a));
    }

    public void b(TileEntity tileentity) {
        BlockPosition blockposition = tileentity.aD_();
        if (!this.u(blockposition)) {
            if (this.captureBlockStates) {
                this.capturedTileEntities.put(blockposition.j(), tileentity);
                return;
            }
            this.m(blockposition).b(tileentity);
        }
    }

    public void o(BlockPosition blockposition) {
        if (!this.u(blockposition)) {
            this.m(blockposition).d(blockposition);
        }
    }

    public boolean p(BlockPosition blockposition) {
        return this.u(blockposition) ? false : this.X().b(SectionPosition.a(blockposition.u()), SectionPosition.a(blockposition.w()));
    }

    public boolean a(BlockPosition blockposition, Entity entity, EnumDirection enumdirection) {
        if (this.u(blockposition)) {
            return false;
        }
        IChunkAccess ichunkaccess = this.a(SectionPosition.a(blockposition.u()), SectionPosition.a(blockposition.w()), ChunkStatus.n, false);
        return ichunkaccess == null ? false : ichunkaccess.a_(blockposition).a((IBlockAccess)this, blockposition, entity, enumdirection);
    }

    public boolean a(BlockPosition blockposition, Entity entity) {
        return this.a(blockposition, entity, EnumDirection.b);
    }

    public void ae() {
        double d0 = 1.0 - (double)(this.d(1.0f) * 5.0f) / 16.0;
        double d1 = 1.0 - (double)(this.b(1.0f) * 5.0f) / 16.0;
        double d2 = 0.5 + 2.0 * MathHelper.a((double)MathHelper.b(this.f(1.0f) * ((float)Math.PI * 2)), -0.25, 0.25);
        this.f = (int)((1.0 - d2 * d0 * d1) * 11.0);
    }

    public void b(boolean flag) {
        this.X().b(flag);
    }

    public abstract void a(WorldData.a var1);

    public abstract WorldData.a A();

    public WorldData.a b(WorldData.a worlddata_a) {
        WorldBorder worldborder = this.u();
        if (!worldborder.a(worlddata_a.b())) {
            BlockPosition blockposition = this.a(HeightMap.Type.e, BlockPosition.a(worldborder.g(), 0.0, worldborder.h()));
            return WorldData.a.a(worlddata_a.a(), blockposition, worlddata_a.d(), worlddata_a.e());
        }
        return worlddata_a;
    }

    protected void af() {
        if (!this.H_().g()) {
            return;
        }
        if (this.A.h()) {
            this.w = 1.0f;
            if (this.A.f()) {
                this.y = 1.0f;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.X().close();
    }

    @Override
    @Nullable
    public IBlockAccess c(int i2, int j2) {
        return this.a(i2, j2, ChunkStatus.n, false);
    }

    @Override
    public List<Entity> a(@Nullable Entity entity, AxisAlignedBB axisalignedbb, Predicate<? super Entity> predicate) {
        Profiler.a().f("getEntities");
        ArrayList list = Lists.newArrayList();
        this.K().a(axisalignedbb, (T entity1) -> {
            if (entity1 != entity && predicate.test((Entity)entity1)) {
                list.add(entity1);
            }
        });
        for (EntityComplexPart entitycomplexpart : this.t()) {
            if (entitycomplexpart == entity || entitycomplexpart.a == entity || !predicate.test(entitycomplexpart) || !axisalignedbb.c(entitycomplexpart.de())) continue;
            list.add(entitycomplexpart);
        }
        return list;
    }

    @Override
    public <T extends Entity> List<T> a(EntityTypeTest<Entity, T> entitytypetest, AxisAlignedBB axisalignedbb, Predicate<? super T> predicate) {
        ArrayList list = Lists.newArrayList();
        this.a(entitytypetest, axisalignedbb, predicate, list);
        return list;
    }

    public <T extends Entity> void a(EntityTypeTest<Entity, T> entitytypetest, AxisAlignedBB axisalignedbb, Predicate<? super T> predicate, List<? super T> list) {
        this.a(entitytypetest, axisalignedbb, predicate, list, Integer.MAX_VALUE);
    }

    public <T extends Entity> void a(EntityTypeTest<Entity, T> entitytypetest, AxisAlignedBB axisalignedbb, Predicate<? super T> predicate, List<? super T> list, int i2) {
        Profiler.a().f("getEntities");
        this.K().a(entitytypetest, axisalignedbb, (U entity) -> {
            if (predicate.test(entity)) {
                list.add((Object)entity);
                if (list.size() >= i2) {
                    return AbortableIterationConsumer.a.b;
                }
            }
            if (entity instanceof EntityEnderDragon) {
                EntityEnderDragon entityenderdragon = (EntityEnderDragon)entity;
                for (EntityComplexPart entitycomplexpart : entityenderdragon.s()) {
                    Entity t0 = (Entity)entitytypetest.a(entitycomplexpart);
                    if (t0 == null || !predicate.test(t0)) continue;
                    list.add((Object)t0);
                    if (list.size() < i2) continue;
                    return AbortableIterationConsumer.a.b;
                }
            }
            return AbortableIterationConsumer.a.a;
        });
    }

    public <T extends Entity> boolean b(EntityTypeTest<Entity, T> entitytypetest, AxisAlignedBB axisalignedbb, Predicate<? super T> predicate) {
        Profiler.a().f("hasEntities");
        MutableBoolean mutableboolean = new MutableBoolean();
        this.K().a(entitytypetest, axisalignedbb, (U entity) -> {
            if (predicate.test(entity)) {
                mutableboolean.setTrue();
                return AbortableIterationConsumer.a.b;
            }
            if (entity instanceof EntityEnderDragon) {
                EntityEnderDragon entityenderdragon = (EntityEnderDragon)entity;
                for (EntityComplexPart entitycomplexpart : entityenderdragon.s()) {
                    Entity t0 = (Entity)entitytypetest.a(entitycomplexpart);
                    if (t0 == null || !predicate.test(t0)) continue;
                    mutableboolean.setTrue();
                    return AbortableIterationConsumer.a.b;
                }
            }
            return AbortableIterationConsumer.a.a;
        });
        return mutableboolean.isTrue();
    }

    public List<Entity> i(Entity entity, AxisAlignedBB axisalignedbb) {
        return this.a(entity, axisalignedbb, IEntitySelector.a(entity));
    }

    @Nullable
    public abstract Entity a(int var1);

    @Nullable
    public Entity d(UUID uuid) {
        return this.K().a(uuid);
    }

    @Nullable
    public Entity a(UUID uuid) {
        return this.d(uuid);
    }

    @Nullable
    public EntityHuman b(UUID uuid) {
        return this.c(uuid);
    }

    public abstract Collection<EntityComplexPart> t();

    public void q(BlockPosition blockposition) {
        if (this.D(blockposition)) {
            this.m(blockposition).i();
        }
    }

    public void a(TileEntity tileentity) {
    }

    public long ag() {
        return this.A.b();
    }

    public long ah() {
        return this.A.c();
    }

    public boolean a(Entity entity, BlockPosition blockposition) {
        return true;
    }

    public void a(Entity entity, byte b0) {
    }

    public void a(Entity entity, DamageSource damagesource) {
    }

    public void a(BlockPosition blockposition, Block block, int i2, int j2) {
        this.a_(blockposition).a(this, blockposition, i2, j2);
    }

    @Override
    public WorldData F_() {
        return this.A;
    }

    public abstract TickRateManager w();

    public float b(float f2) {
        return MathHelper.h(f2, this.x, this.y) * this.d(f2);
    }

    public void c(float f2) {
        float f1;
        this.x = f1 = MathHelper.a(f2, 0.0f, 1.0f);
        this.y = f1;
    }

    public float d(float f2) {
        return MathHelper.h(f2, this.v, this.w);
    }

    public void e(float f2) {
        float f1;
        this.v = f1 = MathHelper.a(f2, 0.0f, 1.0f);
        this.w = f1;
    }

    private boolean a() {
        return this.H_().g() && !this.H_().h();
    }

    public boolean ai() {
        return this.a() && (double)this.b(1.0f) > 0.9;
    }

    public boolean aj() {
        return this.a() && (double)this.d(1.0f) > 0.2;
    }

    public boolean r(BlockPosition blockposition) {
        return this.s(blockposition) == BiomeBase.Precipitation.b;
    }

    public BiomeBase.Precipitation s(BlockPosition blockposition) {
        if (!this.aj()) {
            return BiomeBase.Precipitation.a;
        }
        if (!this.h(blockposition)) {
            return BiomeBase.Precipitation.a;
        }
        if (this.a(HeightMap.Type.e, blockposition).v() > blockposition.v()) {
            return BiomeBase.Precipitation.a;
        }
        BiomeBase biomebase = this.v(blockposition).a();
        return biomebase.a(blockposition, this.T());
    }

    @Nullable
    public abstract WorldMap a(MapId var1);

    public void b(int i2, BlockPosition blockposition, int j2) {
    }

    public CrashReportSystemDetails a(CrashReport crashreport) {
        CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Affected level", 1);
        crashreportsystemdetails.a("All players", () -> {
            List<? extends EntityHuman> list = this.C();
            int i2 = list.size();
            return i2 + " total; " + list.stream().map(EntityHuman::hj).collect(Collectors.joining(", "));
        });
        IChunkProvider ichunkprovider = this.X();
        Objects.requireNonNull(ichunkprovider);
        crashreportsystemdetails.a("Chunk stats", ichunkprovider::e);
        crashreportsystemdetails.a("Level dimension", () -> this.al().a().toString());
        try {
            this.A.a(crashreportsystemdetails, this);
        }
        catch (Throwable throwable) {
            crashreportsystemdetails.a("Level Data Unobtainable", throwable);
        }
        return crashreportsystemdetails;
    }

    public abstract void a(int var1, BlockPosition var2, int var3);

    public void a(double d0, double d1, double d2, double d3, double d4, double d5, List<FireworkExplosion> list) {
    }

    public abstract Scoreboard W();

    public void b(BlockPosition blockposition, Block block) {
        for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.a) {
            BlockPosition blockposition1 = blockposition.a(enumdirection);
            if (!this.D(blockposition1)) continue;
            IBlockData iblockdata = this.a_(blockposition1);
            if (iblockdata.a(Blocks.hP)) {
                this.a(iblockdata, blockposition1, block, (Orientation)null, false);
                continue;
            }
            if (!iblockdata.d(this, blockposition1) || !(iblockdata = this.a_(blockposition1 = blockposition1.a(enumdirection))).a(Blocks.hP)) continue;
            this.a(iblockdata, blockposition1, block, (Orientation)null, false);
        }
    }

    @Override
    public DifficultyDamageScaler d_(BlockPosition blockposition) {
        long i2 = 0L;
        float f2 = 0.0f;
        if (this.D(blockposition)) {
            f2 = this.av();
            i2 = this.m(blockposition).w();
        }
        return new DifficultyDamageScaler(this.aq(), this.ah(), i2, f2);
    }

    @Override
    public int G_() {
        return this.f;
    }

    public void c(int i2) {
    }

    public void a(Packet<?> packet) {
        throw new UnsupportedOperationException("Can't send packets to server unless you're on the client.");
    }

    @Override
    public DimensionManager H_() {
        return this.D.a();
    }

    public Holder<DimensionManager> ak() {
        return this.D;
    }

    public ResourceKey<World> al() {
        return this.G;
    }

    @Override
    public RandomSource I_() {
        return this.z;
    }

    @Override
    public boolean a(BlockPosition blockposition, Predicate<IBlockData> predicate) {
        return predicate.test(this.a_(blockposition));
    }

    @Override
    public boolean b(BlockPosition blockposition, Predicate<Fluid> predicate) {
        return predicate.test(this.b_(blockposition));
    }

    public abstract RecipeAccess V();

    public BlockPosition a(int i2, int j2, int k2, int l2) {
        this.t = this.t * 3 + 1013904223;
        int i1 = this.t >> 2;
        return new BlockPosition(i2 + (i1 & 0xF), j2 + (i1 >> 16 & l2), k2 + (i1 >> 8 & 0xF));
    }

    public boolean x() {
        return false;
    }

    @Override
    public BiomeManager J_() {
        return this.F;
    }

    public final boolean am() {
        return this.e;
    }

    public abstract LevelEntityGetter<Entity> K();

    @Override
    public long K_() {
        return this.K++;
    }

    @Override
    public IRegistryCustom L_() {
        return this.H;
    }

    public DamageSources an() {
        return this.I;
    }

    public abstract PotionBrewer P();

    public abstract FuelValues Q();

    public int t(BlockPosition blockposition) {
        return 0;
    }

    public PalettedContainerFactory ao() {
        return this.J;
    }

    public static enum a implements INamable
    {
        a("none"),
        b("block"),
        c("mob"),
        d("tnt"),
        e("trigger"),
        STANDARD("standard");

        public static final Codec<a> f;
        private final String g;

        private a(String s2) {
            this.g = s2;
        }

        @Override
        public String c() {
            return this.g;
        }

        static {
            f = INamable.a(a::values);
        }
    }
}

