/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawner;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import org.bukkit.event.entity.EntityRemoveEvent;

public class TrialSpawnerData {
    private static final String j = "spawn_data";
    private static final String k = "next_mob_spawns_at";
    private static final int l = 20;
    private static final int m = 18000;
    public final Set<UUID> a = new HashSet<UUID>();
    public final Set<UUID> b = new HashSet<UUID>();
    long c;
    long d;
    int e;
    public Optional<MobSpawnerData> f = Optional.empty();
    Optional<ResourceKey<LootTable>> g = Optional.empty();
    @Nullable
    private Entity n;
    @Nullable
    private WeightedList<ItemStack> o;
    double h;
    double i;

    public a a() {
        return new a(Set.copyOf(this.a), Set.copyOf(this.b), this.c, this.d, this.e, this.f, this.g);
    }

    public void a(a trialspawnerdata_a) {
        this.a.clear();
        this.a.addAll(trialspawnerdata_a.b);
        this.b.clear();
        this.b.addAll(trialspawnerdata_a.c);
        this.c = trialspawnerdata_a.d;
        this.d = trialspawnerdata_a.e;
        this.e = trialspawnerdata_a.f;
        this.f = trialspawnerdata_a.g;
        this.g = trialspawnerdata_a.h;
    }

    public void b() {
        this.b.clear();
        this.f = Optional.empty();
        this.c();
    }

    public void c() {
        this.a.clear();
        this.e = 0;
        this.d = 0L;
        this.c = 0L;
    }

    public boolean a(TrialSpawner trialspawner, RandomSource randomsource) {
        boolean flag = this.b(trialspawner, randomsource).a().i("id").isPresent();
        return flag || !trialspawner.a().i().c();
    }

    public boolean a(TrialSpawnerConfig trialspawnerconfig, int i2) {
        return this.e >= trialspawnerconfig.a(i2);
    }

    public boolean d() {
        return this.b.isEmpty();
    }

    public boolean a(WorldServer worldserver, TrialSpawnerConfig trialspawnerconfig, int i2) {
        return worldserver.ag() >= this.d && this.b.size() < trialspawnerconfig.b(i2);
    }

    public int a(BlockPosition blockposition) {
        if (this.a.isEmpty()) {
            SystemUtils.b("Trial Spawner at " + String.valueOf(blockposition) + " has no detected players");
        }
        return Math.max(0, this.a.size() - 1);
    }

    public void a(WorldServer worldserver, BlockPosition blockposition, TrialSpawner trialspawner) {
        boolean flag;
        boolean bl = flag = (blockposition.a() + worldserver.ag()) % 20L != 0L;
        if (!(flag || trialspawner.g().equals(TrialSpawnerState.f) && trialspawner.d())) {
            boolean flag1;
            List<UUID> list = trialspawner.j().detect(worldserver, trialspawner.k(), blockposition, trialspawner.f(), true);
            if (!trialspawner.d() && !list.isEmpty()) {
                Optional<Pair<EntityHuman, Holder<MobEffectList>>> optional = TrialSpawnerData.a(worldserver, list);
                optional.ifPresent(pair -> {
                    EntityHuman entityhuman = (EntityHuman)pair.getFirst();
                    if (pair.getSecond() == MobEffects.E) {
                        TrialSpawnerData.a(entityhuman);
                    }
                    worldserver.c(3020, BlockPosition.a(entityhuman.bR()), 0);
                    trialspawner.a(worldserver, blockposition);
                });
                flag1 = optional.isPresent();
            } else {
                flag1 = false;
            }
            if (!trialspawner.g().equals(TrialSpawnerState.f) || flag1) {
                List<UUID> list1;
                boolean flag2 = trialspawner.h().a.isEmpty();
                List<UUID> list2 = list1 = flag2 ? list : trialspawner.j().detect(worldserver, trialspawner.k(), blockposition, trialspawner.f(), false);
                if (this.a.addAll(list1)) {
                    this.d = Math.max(worldserver.ag() + 40L, this.d);
                    if (!flag1) {
                        int i2 = trialspawner.d() ? 3019 : 3013;
                        worldserver.c(i2, blockposition, this.a.size());
                    }
                }
            }
        }
    }

    private static Optional<Pair<EntityHuman, Holder<MobEffectList>>> a(WorldServer worldserver, List<UUID> list) {
        EntityHuman entityhuman = null;
        for (UUID uuid : list) {
            EntityHuman entityhuman1 = worldserver.c(uuid);
            if (entityhuman1 == null) continue;
            Holder<MobEffectList> holder = MobEffects.H;
            if (entityhuman1.d(holder)) {
                return Optional.of(Pair.of((Object)entityhuman1, holder));
            }
            if (!entityhuman1.d(MobEffects.E)) continue;
            entityhuman = entityhuman1;
        }
        return Optional.ofNullable(entityhuman).map(entityhuman2 -> Pair.of((Object)entityhuman2, MobEffects.E));
    }

    public void a(TrialSpawner trialspawner, WorldServer worldserver) {
        Stream stream = this.b.stream();
        Objects.requireNonNull(worldserver);
        stream.map(worldserver::d).forEach(entity -> {
            if (entity != null) {
                worldserver.c(3012, entity.dF(), TrialSpawner.a.a.a());
                if (entity instanceof EntityInsentient) {
                    EntityInsentient entityinsentient = (EntityInsentient)entity;
                    entityinsentient.b(worldserver);
                }
                entity.remove(Entity.RemovalReason.b, EntityRemoveEvent.Cause.DESPAWN);
            }
        });
        if (!trialspawner.c().i().c()) {
            this.f = Optional.empty();
        }
        this.e = 0;
        this.b.clear();
        this.d = worldserver.ag() + (long)trialspawner.c().h();
        trialspawner.i();
        this.c = worldserver.ag() + trialspawner.c().a();
    }

    private static void a(EntityHuman entityhuman) {
        MobEffect mobeffect = entityhuman.e(MobEffects.E);
        if (mobeffect != null) {
            int i2 = mobeffect.e() + 1;
            int j2 = 18000 * i2;
            entityhuman.g(MobEffects.E);
            entityhuman.a(new MobEffect(MobEffects.H, j2, 0));
        }
    }

    public boolean a(WorldServer worldserver, float f2, int i2) {
        long j2 = this.c - (long)i2;
        return (float)worldserver.ag() >= (float)j2 + f2;
    }

    public boolean b(WorldServer worldserver, float f2, int i2) {
        long j2 = this.c - (long)i2;
        return (float)(worldserver.ag() - j2) % f2 == 0.0f;
    }

    public boolean a(WorldServer worldserver) {
        return worldserver.ag() >= this.c;
    }

    protected MobSpawnerData b(TrialSpawner trialspawner, RandomSource randomsource) {
        if (this.f.isPresent()) {
            return this.f.get();
        }
        WeightedList<MobSpawnerData> weightedlist = trialspawner.a().i();
        Optional<MobSpawnerData> optional = weightedlist.c() ? this.f : weightedlist.a(randomsource);
        this.f = Optional.of(optional.orElseGet(MobSpawnerData::new));
        trialspawner.i();
        return this.f.get();
    }

    @Nullable
    public Entity a(TrialSpawner trialspawner, World world, TrialSpawnerState trialspawnerstate) {
        NBTTagCompound nbttagcompound;
        if (!trialspawnerstate.d()) {
            return null;
        }
        if (this.n == null && (nbttagcompound = this.b(trialspawner, world.I_()).a()).i("id").isPresent()) {
            this.n = EntityTypes.a(nbttagcompound, world, EntitySpawnReason.q, Function.identity());
        }
        return this.n;
    }

    public NBTTagCompound a(TrialSpawnerState trialspawnerstate) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        if (trialspawnerstate == TrialSpawnerState.c) {
            nbttagcompound.a(k, this.d);
        }
        this.f.ifPresent(mobspawnerdata -> nbttagcompound.a(j, MobSpawnerData.b, mobspawnerdata));
        return nbttagcompound;
    }

    public double e() {
        return this.h;
    }

    public double f() {
        return this.i;
    }

    WeightedList<ItemStack> a(WorldServer worldserver, TrialSpawnerConfig trialspawnerconfig, BlockPosition blockposition) {
        long i2;
        LootParams lootparams;
        if (this.o != null) {
            return this.o;
        }
        LootTable loottable = worldserver.q().bi().a(trialspawnerconfig.k());
        ObjectArrayList<ItemStack> objectarraylist = loottable.a(lootparams = new LootParams.a(worldserver).a(LootContextParameterSets.b), i2 = TrialSpawnerData.a(worldserver, blockposition));
        if (objectarraylist.isEmpty()) {
            return WeightedList.a();
        }
        WeightedList.a<ItemStack> weightedlist_a = WeightedList.b();
        for (ItemStack itemstack : objectarraylist) {
            weightedlist_a.a(itemstack.c(1), itemstack.M());
        }
        this.o = weightedlist_a.a();
        return this.o;
    }

    private static long a(WorldServer worldserver, BlockPosition blockposition) {
        BlockPosition blockposition1 = new BlockPosition(MathHelper.d((float)blockposition.u() / 30.0f), MathHelper.d((float)blockposition.v() / 20.0f), MathHelper.d((float)blockposition.w() / 30.0f));
        return worldserver.H() + blockposition1.a();
    }

    public static final class a
    extends Record {
        private final Set<UUID> b;
        private final Set<UUID> c;
        private final long d;
        private final long e;
        private final int f;
        private final Optional<MobSpawnerData> g;
        private final Optional<ResourceKey<LootTable>> h;
        public static final MapCodec<a> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)UUIDUtil.b.lenientOptionalFieldOf("registered_players", Set.of()).forGetter(a::a), (App)UUIDUtil.b.lenientOptionalFieldOf("current_mobs", Set.of()).forGetter(a::b), (App)Codec.LONG.lenientOptionalFieldOf("cooldown_ends_at", (Object)0L).forGetter(a::c), (App)Codec.LONG.lenientOptionalFieldOf(TrialSpawnerData.k, (Object)0L).forGetter(a::d), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).lenientOptionalFieldOf("total_mobs_spawned", (Object)0).forGetter(a::e), (App)MobSpawnerData.b.lenientOptionalFieldOf(TrialSpawnerData.j).forGetter(a::f), (App)LootTable.a.lenientOptionalFieldOf("ejecting_loot_table").forGetter(a::g)).apply((Applicative)instance, a::new));

        public a(Set<UUID> detectedPlayers, Set<UUID> currentMobs, long cooldownEndsAt, long nextMobSpawnsAt, int totalMobsSpawned, Optional<MobSpawnerData> nextSpawnData, Optional<ResourceKey<LootTable>> ejectingLootTable) {
            this.b = detectedPlayers;
            this.c = currentMobs;
            this.d = cooldownEndsAt;
            this.e = nextMobSpawnsAt;
            this.f = totalMobsSpawned;
            this.g = nextSpawnData;
            this.h = ejectingLootTable;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "detectedPlayers;currentMobs;cooldownEndsAt;nextMobSpawnsAt;totalMobsSpawned;nextSpawnData;ejectingLootTable", "b", "c", "d", "e", "f", "g", "h"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "detectedPlayers;currentMobs;cooldownEndsAt;nextMobSpawnsAt;totalMobsSpawned;nextSpawnData;ejectingLootTable", "b", "c", "d", "e", "f", "g", "h"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "detectedPlayers;currentMobs;cooldownEndsAt;nextMobSpawnsAt;totalMobsSpawned;nextSpawnData;ejectingLootTable", "b", "c", "d", "e", "f", "g", "h"}, this, o2);
        }

        public Set<UUID> a() {
            return this.b;
        }

        public Set<UUID> b() {
            return this.c;
        }

        public long c() {
            return this.d;
        }

        public long d() {
            return this.e;
        }

        public int e() {
            return this.f;
        }

        public Optional<MobSpawnerData> f() {
            return this.g;
        }

        public Optional<ResourceKey<LootTable>> g() {
            return this.h;
        }
    }
}

