/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.feature.FeatureCountTracker;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.generator.CraftLimitedRegion;
import org.bukkit.craftbukkit.v1_21_R6.generator.structure.CraftStructure;
import org.bukkit.craftbukkit.v1_21_R6.util.RandomSourceWrapper;
import org.bukkit.event.Event;
import org.bukkit.event.world.AsyncStructureSpawnEvent;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.LimitedRegion;
import org.bukkit.generator.WorldInfo;
import org.bukkit.util.BoundingBox;

public abstract class ChunkGenerator {
    public static final Codec<ChunkGenerator> a = BuiltInRegistries.ab.q().dispatchStable(ChunkGenerator::b, Function.identity());
    protected final WorldChunkManager b;
    private final Supplier<List<FeatureSorter.b>> c;
    public final Function<Holder<BiomeBase>, BiomeSettingsGeneration> d;

    public ChunkGenerator(WorldChunkManager worldchunkmanager) {
        this(worldchunkmanager, holder -> ((BiomeBase)holder.a()).d());
    }

    public ChunkGenerator(WorldChunkManager worldchunkmanager, Function<Holder<BiomeBase>, BiomeSettingsGeneration> function) {
        this.b = worldchunkmanager;
        this.d = function;
        this.c = Suppliers.memoize(() -> FeatureSorter.a(List.copyOf(worldchunkmanager.c()), holder -> ((BiomeSettingsGeneration)function.apply((Holder<BiomeBase>)holder)).c(), true));
    }

    public void a() {
        this.c.get();
    }

    protected abstract MapCodec<? extends ChunkGenerator> b();

    public ChunkGeneratorStructureState a(HolderLookup<StructureSet> holderlookup, RandomState randomstate, long i2) {
        return ChunkGeneratorStructureState.a(randomstate, i2, this.b, holderlookup);
    }

    public Optional<ResourceKey<MapCodec<? extends ChunkGenerator>>> c() {
        return BuiltInRegistries.ab.d(this.b());
    }

    public CompletableFuture<IChunkAccess> a(RandomState randomstate, Blender blender, StructureManager structuremanager, IChunkAccess ichunkaccess) {
        return CompletableFuture.supplyAsync(() -> {
            ichunkaccess.a(this.b, randomstate.b());
            return ichunkaccess;
        }, SystemUtils.h().a("init_biomes"));
    }

    public abstract void a(RegionLimitedWorldAccess var1, long var2, RandomState var4, BiomeManager var5, StructureManager var6, IChunkAccess var7);

    @Nullable
    public Pair<BlockPosition, Holder<Structure>> a(WorldServer worldserver, HolderSet<Structure> holderset, BlockPosition blockposition, int i2, boolean flag) {
        if (SharedConstants.aK) {
            return null;
        }
        ChunkGeneratorStructureState chunkgeneratorstructurestate = worldserver.n().h();
        Object2ObjectArrayMap map = new Object2ObjectArrayMap();
        for (Holder holder : holderset) {
            for (StructurePlacement structureplacement : chunkgeneratorstructurestate.a(holder)) {
                map.computeIfAbsent(structureplacement, structureplacement1 -> new ObjectArraySet()).add(holder);
            }
        }
        if (map.isEmpty()) {
            return null;
        }
        Pair<BlockPosition, Holder<Structure>> pair = null;
        double d2 = Double.MAX_VALUE;
        StructureManager structuremanager = worldserver.b();
        ArrayList list = new ArrayList(map.size());
        for (Map.Entry map_entry : map.entrySet()) {
            StructurePlacement structureplacement12 = (StructurePlacement)map_entry.getKey();
            if (structureplacement12 instanceof ConcentricRingsStructurePlacement) {
                BlockPosition blockPosition;
                double d1;
                ConcentricRingsStructurePlacement concentricringsstructureplacement = (ConcentricRingsStructurePlacement)structureplacement12;
                Pair<BlockPosition, Holder<Structure>> pair1 = this.a((Set)map_entry.getValue(), worldserver, structuremanager, blockposition, flag, concentricringsstructureplacement);
                if (pair1 == null || !((d1 = blockposition.j(blockPosition = (BlockPosition)pair1.getFirst())) < d2)) continue;
                d2 = d1;
                pair = pair1;
                continue;
            }
            if (!(structureplacement12 instanceof RandomSpreadStructurePlacement)) continue;
            list.add(map_entry);
        }
        if (!list.isEmpty()) {
            int j2 = SectionPosition.a(blockposition.u());
            int k2 = SectionPosition.a(blockposition.w());
            for (int l2 = 0; l2 <= i2; ++l2) {
                boolean flag1 = false;
                for (Map.Entry entry : list) {
                    RandomSpreadStructurePlacement randomspreadstructureplacement = (RandomSpreadStructurePlacement)entry.getKey();
                    Pair<BlockPosition, Holder<Structure>> pair2 = ChunkGenerator.a((Set)entry.getValue(), worldserver, structuremanager, j2, k2, l2, flag, chunkgeneratorstructurestate.d(), randomspreadstructureplacement);
                    if (pair2 == null) continue;
                    flag1 = true;
                    double d22 = blockposition.j((BaseBlockPosition)pair2.getFirst());
                    if (!(d22 < d2)) continue;
                    d2 = d22;
                    pair = pair2;
                }
                if (!flag1) continue;
                return pair;
            }
        }
        return pair;
    }

    @Nullable
    private Pair<BlockPosition, Holder<Structure>> a(Set<Holder<Structure>> set, WorldServer worldserver, StructureManager structuremanager, BlockPosition blockposition, boolean flag, ConcentricRingsStructurePlacement concentricringsstructureplacement) {
        List<ChunkCoordIntPair> list = worldserver.n().h().a(concentricringsstructureplacement);
        if (list == null) {
            throw new IllegalStateException("Somehow tried to find structures for a placement that doesn't exist");
        }
        Pair<BlockPosition, Holder<Structure>> pair = null;
        double d0 = Double.MAX_VALUE;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (ChunkCoordIntPair chunkcoordintpair : list) {
            Pair<BlockPosition, Holder<Structure>> pair1;
            blockposition_mutableblockposition.d(SectionPosition.a(chunkcoordintpair.h, 8), 32, SectionPosition.a(chunkcoordintpair.i, 8));
            double d1 = blockposition_mutableblockposition.j(blockposition);
            boolean flag1 = pair == null || d1 < d0;
            if (!flag1 || (pair1 = ChunkGenerator.a(set, worldserver, structuremanager, flag, concentricringsstructureplacement, chunkcoordintpair)) == null) continue;
            pair = pair1;
            d0 = d1;
        }
        return pair;
    }

    @Nullable
    private static Pair<BlockPosition, Holder<Structure>> a(Set<Holder<Structure>> set, IWorldReader iworldreader, StructureManager structuremanager, int i2, int j2, int k2, boolean flag, long l2, RandomSpreadStructurePlacement randomspreadstructureplacement) {
        int i1 = randomspreadstructureplacement.a();
        for (int j1 = -k2; j1 <= k2; ++j1) {
            boolean flag1 = j1 == -k2 || j1 == k2;
            for (int k1 = -k2; k1 <= k2; ++k1) {
                int i22;
                int l1;
                ChunkCoordIntPair chunkcoordintpair;
                Pair<BlockPosition, Holder<Structure>> pair;
                boolean flag2;
                boolean bl = flag2 = k1 == -k2 || k1 == k2;
                if (!flag1 && !flag2 || (pair = ChunkGenerator.a(set, iworldreader, structuremanager, flag, randomspreadstructureplacement, chunkcoordintpair = randomspreadstructureplacement.a(l2, l1 = i2 + i1 * j1, i22 = j2 + i1 * k1))) == null) continue;
                return pair;
            }
        }
        return null;
    }

    @Nullable
    private static Pair<BlockPosition, Holder<Structure>> a(Set<Holder<Structure>> set, IWorldReader iworldreader, StructureManager structuremanager, boolean flag, StructurePlacement structureplacement, ChunkCoordIntPair chunkcoordintpair) {
        for (Holder<Structure> holder : set) {
            StructureCheckResult structurecheckresult = structuremanager.a(chunkcoordintpair, holder.a(), structureplacement, flag);
            if (structurecheckresult == StructureCheckResult.b) continue;
            if (!flag && structurecheckresult == StructureCheckResult.a) {
                return Pair.of((Object)structureplacement.a(chunkcoordintpair), holder);
            }
            IChunkAccess ichunkaccess = iworldreader.a(chunkcoordintpair.h, chunkcoordintpair.i, ChunkStatus.d);
            StructureStart structurestart = structuremanager.a(SectionPosition.a(ichunkaccess), holder.a(), ichunkaccess);
            if (structurestart == null || !structurestart.b() || flag && !ChunkGenerator.a(structuremanager, structurestart)) continue;
            return Pair.of((Object)structureplacement.a(structurestart.c()), holder);
        }
        return null;
    }

    private static boolean a(StructureManager structuremanager, StructureStart structurestart) {
        if (structurestart.d()) {
            structuremanager.a(structurestart);
            return true;
        }
        return false;
    }

    public void addVanillaDecorations(GeneratorAccessSeed generatoraccessseed, IChunkAccess ichunkaccess, StructureManager structuremanager) {
        ChunkCoordIntPair chunkcoordintpair = ichunkaccess.f();
        if (!SharedConstants.a(chunkcoordintpair)) {
            SectionPosition sectionposition = SectionPosition.a(chunkcoordintpair, generatoraccessseed.at());
            BlockPosition blockposition = sectionposition.j();
            IRegistry<Structure> iregistry = generatoraccessseed.L_().f(Registries.bm);
            Map<Integer, List<Structure>> map = iregistry.s().collect(Collectors.groupingBy(structure -> structure.c().ordinal()));
            List<FeatureSorter.b> list = this.c.get();
            SeededRandom seededrandom = new SeededRandom(new XoroshiroRandomSource(RandomSupport.a()));
            long i2 = seededrandom.a(generatoraccessseed.H(), blockposition.u(), blockposition.w());
            ObjectArraySet set = new ObjectArraySet();
            ChunkCoordIntPair.a(sectionposition.r(), 1).forEach(arg_0 -> ChunkGenerator.lambda$addVanillaDecorations$6(generatoraccessseed, (Set)set, arg_0));
            set.retainAll(this.b.c());
            int j2 = list.size();
            try {
                IRegistry<PlacedFeature> iregistry1 = generatoraccessseed.L_().f(Registries.bj);
                int k2 = Math.max(WorldGenStage.Decoration.values().length, j2);
                for (int l2 = 0; l2 < k2; ++l2) {
                    int i1 = 0;
                    if (structuremanager.a()) {
                        for (Structure structure2 : map.getOrDefault(l2, Collections.emptyList())) {
                            seededrandom.b(i2, i1, l2);
                            Supplier<String> supplier = () -> {
                                Optional<String> optional = iregistry.d(structure2).map(Object::toString);
                                Objects.requireNonNull(structure2);
                                return (String)optional.orElseGet(structure2::toString);
                            };
                            try {
                                generatoraccessseed.a(supplier);
                                structuremanager.a(sectionposition, structure2).forEach(structurestart -> structurestart.a(generatoraccessseed, structuremanager, this, seededrandom, ChunkGenerator.a(ichunkaccess), chunkcoordintpair));
                            }
                            catch (Exception exception) {
                                CrashReport crashreport = CrashReport.a(exception, "Feature placement");
                                CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Feature");
                                Objects.requireNonNull(supplier);
                                crashreportsystemdetails.a("Description", supplier::get);
                                throw new ReportedException(crashreport);
                            }
                            ++i1;
                        }
                    }
                    if (l2 >= j2) continue;
                    IntArraySet intset = new IntArraySet();
                    for (Holder holder : set) {
                        List<HolderSet<PlacedFeature>> list1 = this.d.apply(holder).c();
                        if (l2 >= list1.size()) continue;
                        HolderSet<PlacedFeature> holderset = list1.get(l2);
                        FeatureSorter.b featuresorter_b = list.get(l2);
                        holderset.a().map(Holder::a).forEach(arg_0 -> ChunkGenerator.lambda$addVanillaDecorations$9((IntSet)intset, featuresorter_b, arg_0));
                    }
                    int j1 = intset.size();
                    int[] aint = intset.toIntArray();
                    Arrays.sort(aint);
                    FeatureSorter.b featuresorter_b1 = list.get(l2);
                    for (int k1 = 0; k1 < j1; ++k1) {
                        int l1 = aint[k1];
                        PlacedFeature placedfeature = featuresorter_b1.a().get(l1);
                        Supplier<String> supplier1 = () -> {
                            Optional<String> optional = iregistry1.d(placedfeature).map(Object::toString);
                            Objects.requireNonNull(placedfeature);
                            return (String)optional.orElseGet(placedfeature::toString);
                        };
                        seededrandom.b(i2, l1, l2);
                        try {
                            generatoraccessseed.a(supplier1);
                            placedfeature.b(generatoraccessseed, this, seededrandom, blockposition);
                            continue;
                        }
                        catch (Exception exception1) {
                            CrashReport crashreport1 = CrashReport.a(exception1, "Feature placement");
                            CrashReportSystemDetails crashreportsystemdetails1 = crashreport1.a("Feature");
                            Objects.requireNonNull(supplier1);
                            crashreportsystemdetails1.a("Description", supplier1::get);
                            throw new ReportedException(crashreport1);
                        }
                    }
                }
                generatoraccessseed.a((Supplier<String>)null);
                if (SharedConstants.aW) {
                    FeatureCountTracker.a(generatoraccessseed.a());
                }
            }
            catch (Exception exception2) {
                CrashReport crashreport2 = CrashReport.a(exception2, "Biome decoration");
                crashreport2.a("Generation").a("CenterX", chunkcoordintpair.h).a("CenterZ", chunkcoordintpair.i).a("Decoration Seed", i2);
                throw new ReportedException(crashreport2);
            }
        }
    }

    public void a(GeneratorAccessSeed generatoraccessseed, IChunkAccess ichunkaccess, StructureManager structuremanager) {
        this.applyBiomeDecoration(generatoraccessseed, ichunkaccess, structuremanager, true);
    }

    public void applyBiomeDecoration(GeneratorAccessSeed generatoraccessseed, IChunkAccess ichunkaccess, StructureManager structuremanager, boolean vanilla) {
        CraftWorld world;
        if (vanilla) {
            this.addVanillaDecorations(generatoraccessseed, ichunkaccess, structuremanager);
        }
        if (!(world = generatoraccessseed.getMinecraftWorld().getWorld()).getPopulators().isEmpty()) {
            CraftLimitedRegion limitedRegion = new CraftLimitedRegion(generatoraccessseed, ichunkaccess.f());
            int x2 = ichunkaccess.f().h;
            int z2 = ichunkaccess.f().i;
            for (BlockPopulator populator : world.getPopulators()) {
                SeededRandom seededrandom = new SeededRandom(new LegacyRandomSource(generatoraccessseed.H()));
                seededrandom.a(generatoraccessseed.H(), x2, z2);
                populator.populate((WorldInfo)world, (Random)new RandomSourceWrapper.RandomWrapper(seededrandom), x2, z2, (LimitedRegion)limitedRegion);
            }
            limitedRegion.saveEntities();
            limitedRegion.breakLink();
        }
    }

    private static StructureBoundingBox a(IChunkAccess ichunkaccess) {
        ChunkCoordIntPair chunkcoordintpair = ichunkaccess.f();
        int i2 = chunkcoordintpair.d();
        int j2 = chunkcoordintpair.e();
        LevelHeightAccessor levelheightaccessor = ichunkaccess.B();
        int k2 = levelheightaccessor.M_() + 1;
        int l2 = levelheightaccessor.ar();
        return new StructureBoundingBox(i2, k2, j2, i2 + 15, l2, j2 + 15);
    }

    public abstract void a(RegionLimitedWorldAccess var1, StructureManager var2, RandomState var3, IChunkAccess var4);

    public abstract void a(RegionLimitedWorldAccess var1);

    public int a(LevelHeightAccessor levelheightaccessor) {
        return 64;
    }

    public WorldChunkManager d() {
        return this.b;
    }

    public abstract int e();

    public WeightedList<BiomeSettingsMobs.c> a(Holder<BiomeBase> holder, StructureManager structuremanager, EnumCreatureType enumcreaturetype, BlockPosition blockposition) {
        Map<Structure, LongSet> map = structuremanager.b(blockposition);
        for (Map.Entry<Structure, LongSet> map_entry : map.entrySet()) {
            Structure structure = map_entry.getKey();
            StructureSpawnOverride structurespawnoverride = structure.b().get(enumcreaturetype);
            if (structurespawnoverride == null) continue;
            MutableBoolean mutableboolean = new MutableBoolean(false);
            Predicate<StructureStart> predicate = structurespawnoverride.a() == StructureSpawnOverride.a.a ? structurestart -> structuremanager.a(blockposition, (StructureStart)structurestart) : structurestart -> structurestart.a().b(blockposition);
            structuremanager.a(structure, map_entry.getValue(), (StructureStart structurestart) -> {
                if (mutableboolean.isFalse() && predicate.test((StructureStart)structurestart)) {
                    mutableboolean.setTrue();
                }
            });
            if (!mutableboolean.isTrue()) continue;
            return structurespawnoverride.b();
        }
        return holder.a().b().a(enumcreaturetype);
    }

    public void a(IRegistryCustom iregistrycustom, ChunkGeneratorStructureState chunkgeneratorstructurestate, StructureManager structuremanager, IChunkAccess ichunkaccess, StructureTemplateManager structuretemplatemanager, ResourceKey<World> resourcekey) {
        if (!SharedConstants.aJ) {
            ChunkCoordIntPair chunkcoordintpair = ichunkaccess.f();
            SectionPosition sectionposition = SectionPosition.a(ichunkaccess);
            RandomState randomstate = chunkgeneratorstructurestate.c();
            chunkgeneratorstructurestate.a().forEach(holder -> {
                StructurePlacement structureplacement = ((StructureSet)holder.a()).b();
                List<StructureSet.a> list = ((StructureSet)holder.a()).a();
                for (StructureSet.a structureset_a : list) {
                    StructureStart structurestart = structuremanager.a(sectionposition, structureset_a.a().a(), ichunkaccess);
                    if (structurestart == null || !structurestart.b()) continue;
                    return;
                }
                if (structureplacement.b(chunkgeneratorstructurestate, chunkcoordintpair.h, chunkcoordintpair.i)) {
                    if (list.size() == 1) {
                        this.a(list.get(0), structuremanager, iregistrycustom, randomstate, structuretemplatemanager, chunkgeneratorstructurestate.d(), ichunkaccess, chunkcoordintpair, sectionposition, resourcekey);
                    } else {
                        ArrayList<StructureSet.a> arraylist = new ArrayList<StructureSet.a>(list.size());
                        arraylist.addAll(list);
                        SeededRandom seededrandom = new SeededRandom(new LegacyRandomSource(0L));
                        seededrandom.c(chunkgeneratorstructurestate.d(), chunkcoordintpair.h, chunkcoordintpair.i);
                        int i2 = 0;
                        for (StructureSet.a structureset_a1 : arraylist) {
                            i2 += structureset_a1.b();
                        }
                        while (!arraylist.isEmpty()) {
                            StructureSet.a structureset_a2;
                            int j2 = seededrandom.a(i2);
                            int k2 = 0;
                            Iterator iterator = arraylist.iterator();
                            while (iterator.hasNext() && (j2 -= (structureset_a2 = (StructureSet.a)iterator.next()).b()) >= 0) {
                                ++k2;
                            }
                            StructureSet.a structureset_a3 = (StructureSet.a)arraylist.get(k2);
                            if (this.a(structureset_a3, structuremanager, iregistrycustom, randomstate, structuretemplatemanager, chunkgeneratorstructurestate.d(), ichunkaccess, chunkcoordintpair, sectionposition, resourcekey)) {
                                return;
                            }
                            arraylist.remove(k2);
                            i2 -= structureset_a3.b();
                        }
                    }
                }
            });
        }
    }

    private boolean a(StructureSet.a structureset_a, StructureManager structuremanager, IRegistryCustom iregistrycustom, RandomState randomstate, StructureTemplateManager structuretemplatemanager, long i2, IChunkAccess ichunkaccess, ChunkCoordIntPair chunkcoordintpair, SectionPosition sectionposition, ResourceKey<World> resourcekey) {
        Structure structure = structureset_a.a().a();
        int j2 = ChunkGenerator.a(structuremanager, ichunkaccess, sectionposition, structure);
        HolderSet<BiomeBase> holderset = structure.a();
        Objects.requireNonNull(holderset);
        Predicate<Holder<BiomeBase>> predicate = holderset::a;
        StructureStart structurestart = structure.a(structureset_a.a(), resourcekey, iregistrycustom, this, this.b, randomstate, structuretemplatemanager, i2, chunkcoordintpair, j2, ichunkaccess, predicate);
        if (structurestart.b()) {
            StructureBoundingBox box = structurestart.a();
            AsyncStructureSpawnEvent event = new AsyncStructureSpawnEvent((org.bukkit.World)structuremanager.a.getMinecraftWorld().getWorld(), CraftStructure.minecraftToBukkit(structure), new BoundingBox((double)box.h(), (double)box.i(), (double)box.j(), (double)box.k(), (double)box.l(), (double)box.m()), chunkcoordintpair.h, chunkcoordintpair.i);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return true;
            }
            structuremanager.a(sectionposition, structure, structurestart, (StructureAccess)ichunkaccess);
            return true;
        }
        return false;
    }

    private static int a(StructureManager structuremanager, IChunkAccess ichunkaccess, SectionPosition sectionposition, Structure structure) {
        StructureStart structurestart = structuremanager.a(sectionposition, structure, ichunkaccess);
        return structurestart != null ? structurestart.f() : 0;
    }

    public void a(GeneratorAccessSeed generatoraccessseed, StructureManager structuremanager, IChunkAccess ichunkaccess) {
        int i2 = 8;
        ChunkCoordIntPair chunkcoordintpair = ichunkaccess.f();
        int j2 = chunkcoordintpair.h;
        int k2 = chunkcoordintpair.i;
        int l2 = chunkcoordintpair.d();
        int i1 = chunkcoordintpair.e();
        SectionPosition sectionposition = SectionPosition.a(ichunkaccess);
        for (int j1 = j2 - 8; j1 <= j2 + 8; ++j1) {
            for (int k1 = k2 - 8; k1 <= k2 + 8; ++k1) {
                long l1 = ChunkCoordIntPair.c(j1, k1);
                for (StructureStart structurestart : generatoraccessseed.a(j1, k1).g().values()) {
                    try {
                        if (!structurestart.b() || !structurestart.a().a(l2, i1, l2 + 15, i1 + 15)) continue;
                        structuremanager.a(sectionposition, structurestart.h(), l1, (StructureAccess)ichunkaccess);
                    }
                    catch (Exception exception) {
                        CrashReport crashreport = CrashReport.a(exception, "Generating structure reference");
                        CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Structure");
                        Optional<IRegistry<Structure>> optional = generatoraccessseed.L_().a(Registries.bm);
                        crashreportsystemdetails.a("Id", () -> optional.map(iregistry -> iregistry.b(structurestart.h()).toString()).orElse("UNKNOWN"));
                        crashreportsystemdetails.a("Name", () -> BuiltInRegistries.S.b(structurestart.h().e()).toString());
                        crashreportsystemdetails.a("Class", () -> structurestart.h().getClass().getCanonicalName());
                        throw new ReportedException(crashreport);
                    }
                }
            }
        }
    }

    public abstract CompletableFuture<IChunkAccess> a(Blender var1, RandomState var2, StructureManager var3, IChunkAccess var4);

    public abstract int f();

    public abstract int g();

    public abstract int a(int var1, int var2, HeightMap.Type var3, LevelHeightAccessor var4, RandomState var5);

    public abstract BlockColumn a(int var1, int var2, LevelHeightAccessor var3, RandomState var4);

    public int b(int i2, int j2, HeightMap.Type heightmap_type, LevelHeightAccessor levelheightaccessor, RandomState randomstate) {
        return this.a(i2, j2, heightmap_type, levelheightaccessor, randomstate);
    }

    public int c(int i2, int j2, HeightMap.Type heightmap_type, LevelHeightAccessor levelheightaccessor, RandomState randomstate) {
        return this.a(i2, j2, heightmap_type, levelheightaccessor, randomstate) - 1;
    }

    public abstract void a(List<String> var1, RandomState var2, BlockPosition var3);

    @Deprecated
    public BiomeSettingsGeneration a(Holder<BiomeBase> holder) {
        return this.d.apply(holder);
    }

    private static /* synthetic */ void lambda$addVanillaDecorations$9(IntSet intset, FeatureSorter.b featuresorter_b, PlacedFeature placedfeature) {
        intset.add(featuresorter_b.b().applyAsInt(placedfeature));
    }

    private static /* synthetic */ void lambda$addVanillaDecorations$6(GeneratorAccessSeed generatoraccessseed, Set set, ChunkCoordIntPair chunkcoordintpair1) {
        IChunkAccess ichunkaccess1 = generatoraccessseed.a(chunkcoordintpair1.h, chunkcoordintpair1.i);
        for (ChunkSection chunksection : ichunkaccess1.d()) {
            PalettedContainerRO<Holder<BiomeBase>> palettedcontainerro = chunksection.i();
            Objects.requireNonNull(set);
            palettedcontainerro.a(set::add);
        }
    }
}

