/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.packs;

import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.metadata.pack.ResourcePackInfo;
import net.minecraft.server.packs.repository.EnumResourcePackVersion;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import org.bukkit.Bukkit;
import org.bukkit.FeatureFlag;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R6.CraftFeatureFlag;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.packs.CraftDataPackFormat;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftChatMessage;
import org.bukkit.packs.DataPack;
import org.bukkit.packs.DataPackFormat;

public class CraftDataPack
implements DataPack {
    private final ResourcePackLoader handle;
    private final ResourcePackInfo resourcePackInfo;

    public CraftDataPack(ResourcePackLoader handler) {
        this.handle = handler;
        try (IResourcePack iresourcepack = this.handle.c.a(this.handle.a());){
            ResourcePackInfo resourcepackinfo = iresourcepack.a(ResourcePackInfo.b);
            if (resourcepackinfo == null) {
                resourcepackinfo = iresourcepack.a(ResourcePackInfo.c);
            }
            this.resourcePackInfo = resourcepackinfo;
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public ResourcePackLoader getHandle() {
        return this.handle;
    }

    public String getRawId() {
        return this.getHandle().g();
    }

    public String getTitle() {
        return CraftChatMessage.fromComponent(this.getHandle().b());
    }

    public String getDescription() {
        return CraftChatMessage.fromComponent(this.getHandle().c());
    }

    public int getPackFormat() {
        return this.getMaxSupportedPackFormat();
    }

    public int getMinSupportedPackFormat() {
        return this.resourcePackInfo.b().a().b();
    }

    public int getMaxSupportedPackFormat() {
        return this.resourcePackInfo.b().b().b();
    }

    public DataPackFormat getMinSupportedFormat() {
        return new CraftDataPackFormat(this.resourcePackInfo.b().a());
    }

    public DataPackFormat getMaxSupportedFormat() {
        return new CraftDataPackFormat(this.resourcePackInfo.b().b());
    }

    public boolean isRequired() {
        return this.getHandle().i();
    }

    public DataPack.Compatibility getCompatibility() {
        return switch (this.getHandle().d()) {
            default -> throw new MatchException(null, null);
            case EnumResourcePackVersion.d -> DataPack.Compatibility.COMPATIBLE;
            case EnumResourcePackVersion.b -> DataPack.Compatibility.NEW;
            case EnumResourcePackVersion.a -> DataPack.Compatibility.OLD;
            case EnumResourcePackVersion.c -> DataPack.Compatibility.UNKNOWN;
        };
    }

    public boolean isEnabled() {
        return ((CraftServer)Bukkit.getServer()).getServer().aI().e().contains(this.getRawId());
    }

    public DataPack.Source getSource() {
        if (this.getHandle().l() == PackSource.c) {
            return DataPack.Source.BUILT_IN;
        }
        if (this.getHandle().l() == PackSource.d) {
            return DataPack.Source.FEATURE;
        }
        if (this.getHandle().l() == PackSource.e) {
            return DataPack.Source.WORLD;
        }
        if (this.getHandle().l() == PackSource.f) {
            return DataPack.Source.SERVER;
        }
        return DataPack.Source.DEFAULT;
    }

    public Set<FeatureFlag> getRequestedFeatures() {
        return CraftFeatureFlag.getFromNMS(this.getHandle().e()).stream().map(FeatureFlag.class::cast).collect(Collectors.toUnmodifiableSet());
    }

    public NamespacedKey getKey() {
        return NamespacedKey.fromString((String)this.getRawId());
    }

    public String toString() {
        String requestedFeatures = this.getRequestedFeatures().stream().map(featureFlag -> featureFlag.getKey().toString()).collect(Collectors.joining(","));
        return "CraftDataPack{rawId=" + this.getRawId() + ",id=" + String.valueOf(this.getKey()) + ",title=" + this.getTitle() + ",description=" + this.getDescription() + ",packformat=" + this.getPackFormat() + ",minSupportedPackFormat=" + this.getMinSupportedPackFormat() + ",maxSupportedPackFormat=" + this.getMaxSupportedPackFormat() + ",compatibility=" + String.valueOf(this.getCompatibility()) + ",source=" + String.valueOf(this.getSource()) + ",enabled=" + this.isEnabled() + ",requestedFeatures=[" + requestedFeatures + "]}";
    }
}

