/*
 * Decompiled with CFR 0.152.
 */
package org.nothings.stb.image.decoding;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.nothings.stb.image.ColorComponents;
import org.nothings.stb.image.ImageInfo;
import org.nothings.stb.image.ImageResult;
import org.nothings.stb.image.decoding.Decoder;
import org.nothings.stb.image.decoding.FakePtrByte;
import org.nothings.stb.image.decoding.Utility;

public class BmpDecoder
extends Decoder {
    private static final long[] mul_table = new long[]{0L, 255L, 85L, 73L, 17L, 33L, 65L, 129L, 1L};
    private static final long[] shift_table = new long[]{0L, 0L, 0L, 1L, 0L, 2L, 4L, 6L, 0L};

    private BmpDecoder(InputStream stream) {
        super(stream);
    }

    private static int stbi__high_bit(long z) {
        int n = 0;
        if (z == 0L) {
            return -1;
        }
        if (z >= 65536L) {
            n += 16;
            z >>= 16;
        }
        if (z >= 256L) {
            n += 8;
            z >>= 8;
        }
        if (z >= 16L) {
            n += 4;
            z >>= 4;
        }
        if (z >= 4L) {
            n += 2;
            z >>= 2;
        }
        if (z >= 2L) {
            ++n;
            z >>= 1;
        }
        return n;
    }

    private static int stbi__bitcount(long a) {
        a = (a & 0x55555555L) + (a >> 1 & 0x55555555L);
        a = (a & 0x33333333L) + (a >> 2 & 0x33333333L);
        a = a + (a >> 4) & 0xF0F0F0FL;
        a += a >> 8;
        a += a >> 16;
        return (int)(a & 0xFFL);
    }

    private static int stbi__shiftsigned(long v, int shift, int bits) {
        v = shift < 0 ? (v <<= -shift) : (v >>= shift);
        return (int)((v >>= 8 - bits) * (long)((int)mul_table[bits])) >> (int)shift_table[bits];
    }

    private void stbi__bmp_parse_header(stbi__bmp_data info) throws Exception {
        int hsz = 0;
        if (this.stbi__get8() != 66 || this.stbi__get8() != 77) {
            BmpDecoder.stbi__err("not BMP");
        }
        this.stbi__get32le();
        this.stbi__get16le();
        this.stbi__get16le();
        info.offset = (int)this.stbi__get32le();
        info.hsz = hsz = (int)this.stbi__get32le();
        info.ma = 0L;
        info.mb = 0L;
        info.mg = 0L;
        info.mr = 0L;
        if (hsz != 12 && hsz != 40 && hsz != 56 && hsz != 108 && hsz != 124) {
            BmpDecoder.stbi__err("unknown BMP");
        }
        if (hsz == 12) {
            this.img_x = this.stbi__get16le();
            this.img_y = this.stbi__get16le();
        } else {
            this.img_x = (int)this.stbi__get32le();
            this.img_y = (int)this.stbi__get32le();
        }
        if (this.stbi__get16le() != 1) {
            BmpDecoder.stbi__err("bad BMP");
        }
        info.bpp = this.stbi__get16le();
        if (hsz != 12) {
            int compress = (int)this.stbi__get32le();
            if (compress == 1 || compress == 2) {
                BmpDecoder.stbi__err("BMP RLE");
            }
            this.stbi__get32le();
            this.stbi__get32le();
            this.stbi__get32le();
            this.stbi__get32le();
            this.stbi__get32le();
            if (hsz == 40 || hsz == 56) {
                if (hsz == 56) {
                    this.stbi__get32le();
                    this.stbi__get32le();
                    this.stbi__get32le();
                    this.stbi__get32le();
                }
                if (info.bpp == 16 || info.bpp == 32) {
                    if (compress == 0) {
                        if (info.bpp == 32) {
                            info.mr = 0xFF0000L;
                            info.mg = 65280L;
                            info.mb = 255L;
                            info.ma = -16777216L;
                            info.all_a = 0L;
                        } else {
                            info.mr = 31744L;
                            info.mg = 992L;
                            info.mb = 31L;
                        }
                    } else if (compress == 3) {
                        info.mr = this.stbi__get32le();
                        info.mg = this.stbi__get32le();
                        info.mb = this.stbi__get32le();
                        if (info.mr == info.mg && info.mg == info.mb) {
                            BmpDecoder.stbi__err("bad BMP");
                        }
                    } else {
                        BmpDecoder.stbi__err("bad BMP");
                    }
                }
            } else {
                int i = 0;
                if (hsz != 108 && hsz != 124) {
                    BmpDecoder.stbi__err("bad BMP");
                }
                info.mr = this.stbi__get32le();
                info.mg = this.stbi__get32le();
                info.mb = this.stbi__get32le();
                info.ma = this.stbi__get32le();
                this.stbi__get32le();
                for (i = 0; i < 12; ++i) {
                    this.stbi__get32le();
                }
                if (hsz == 124) {
                    this.stbi__get32le();
                    this.stbi__get32le();
                    this.stbi__get32le();
                    this.stbi__get32le();
                }
            }
        }
    }

    private ImageResult InternalDecode(ColorComponents requiredComponents) throws Exception {
        long mr = 0L;
        long mg = 0L;
        long mb = 0L;
        long ma = 0L;
        long all_a = 0L;
        byte[] pal = new byte[1024];
        int psize = 0;
        int i = 0;
        int j = 0;
        int width = 0;
        boolean flip_vertically = false;
        int pad = 0;
        int target = 0;
        stbi__bmp_data info = new stbi__bmp_data();
        info.all_a = 255L;
        this.stbi__bmp_parse_header(info);
        flip_vertically = this.img_y > 0;
        this.img_y = Math.abs(this.img_y);
        mr = info.mr;
        mg = info.mg;
        mb = info.mb;
        ma = info.ma;
        all_a = info.all_a;
        if (info.hsz == 12) {
            if (info.bpp < 24) {
                psize = (info.offset - 14 - 24) / 3;
            }
        } else if (info.bpp < 16) {
            psize = info.offset - 14 - info.hsz >> 2;
        }
        this.img_n = ma != 0L ? 4 : 3;
        target = requiredComponents != null && requiredComponents.getValue() >= 3 ? requiredComponents.getValue() : this.img_n;
        byte[] _out_ = new byte[target * this.img_x * this.img_y];
        if (info.bpp < 16) {
            int z = 0;
            if (psize == 0 || psize > 256) {
                BmpDecoder.stbi__err("invalid");
            }
            for (i = 0; i < psize; ++i) {
                pal[i * 4 + 2] = (byte)this.stbi__get8();
                pal[i * 4 + 1] = (byte)this.stbi__get8();
                pal[i * 4 + 0] = (byte)this.stbi__get8();
                if (info.hsz != 12) {
                    this.stbi__get8();
                }
                pal[i * 4 + 3] = -1;
            }
            this.stbi__skip(info.offset - 14 - info.hsz - psize * (info.hsz == 12 ? 3 : 4));
            if (info.bpp == 1) {
                width = this.img_x + 7 >> 3;
            } else if (info.bpp == 4) {
                width = this.img_x + 1 >> 1;
            } else if (info.bpp == 8) {
                width = this.img_x;
            } else {
                BmpDecoder.stbi__err("bad bpp");
            }
            pad = -width & 3;
            if (info.bpp == 1) {
                for (j = 0; j < this.img_y; ++j) {
                    int bit_offset = 7;
                    short v = this.stbi__get8();
                    for (i = 0; i < this.img_x; ++i) {
                        int color = v >> bit_offset & 1;
                        _out_[z++] = pal[color * 4 + 0];
                        _out_[z++] = pal[color * 4 + 1];
                        _out_[z++] = pal[color * 4 + 2];
                        if (target == 4) {
                            _out_[z++] = -1;
                        }
                        if (i + 1 == this.img_x) break;
                        if (--bit_offset >= 0) continue;
                        bit_offset = 7;
                        v = this.stbi__get8();
                    }
                    this.stbi__skip(pad);
                }
            } else {
                for (j = 0; j < this.img_y; ++j) {
                    for (i = 0; i < this.img_x; i += 2) {
                        int v = this.stbi__get8();
                        int v2 = 0;
                        if (info.bpp == 4) {
                            v2 = v & 0xF;
                            v >>= 4;
                        }
                        _out_[z++] = pal[v * 4 + 0];
                        _out_[z++] = pal[v * 4 + 1];
                        _out_[z++] = pal[v * 4 + 2];
                        if (target == 4) {
                            _out_[z++] = -1;
                        }
                        if (i + 1 == this.img_x) break;
                        v = info.bpp == 8 ? (int)this.stbi__get8() : v2;
                        _out_[z++] = pal[v * 4 + 0];
                        _out_[z++] = pal[v * 4 + 1];
                        _out_[z++] = pal[v * 4 + 2];
                        if (target != 4) continue;
                        _out_[z++] = -1;
                    }
                    this.stbi__skip(pad);
                }
            }
        } else {
            int rshift = 0;
            int gshift = 0;
            int bshift = 0;
            int ashift = 0;
            int rcount = 0;
            int gcount = 0;
            int bcount = 0;
            int acount = 0;
            int z = 0;
            int easy = 0;
            this.stbi__skip(info.offset - 14 - info.hsz);
            width = info.bpp == 24 ? 3 * this.img_x : (info.bpp == 16 ? 2 * this.img_x : 0);
            pad = -width & 3;
            if (info.bpp == 24) {
                easy = 1;
            } else if (info.bpp == 32 && mb == 255L && mg == 65280L && mr == 0xFF0000L && ma == -16777216L) {
                easy = 2;
            }
            if (easy == 0) {
                if (mr == 0L || mg == 0L || mb == 0L) {
                    BmpDecoder.stbi__err("bad masks");
                }
                rshift = BmpDecoder.stbi__high_bit(mr) - 7;
                rcount = BmpDecoder.stbi__bitcount(mr);
                gshift = BmpDecoder.stbi__high_bit(mg) - 7;
                gcount = BmpDecoder.stbi__bitcount(mg);
                bshift = BmpDecoder.stbi__high_bit(mb) - 7;
                bcount = BmpDecoder.stbi__bitcount(mb);
                ashift = BmpDecoder.stbi__high_bit(ma) - 7;
                acount = BmpDecoder.stbi__bitcount(ma);
            }
            for (j = 0; j < this.img_y; ++j) {
                if (easy != 0) {
                    for (i = 0; i < this.img_x; ++i) {
                        byte a = 0;
                        _out_[z + 2] = (byte)this.stbi__get8();
                        _out_[z + 1] = (byte)this.stbi__get8();
                        _out_[z + 0] = (byte)this.stbi__get8();
                        z += 3;
                        a = (byte)(easy == 2 ? (int)this.stbi__get8() : 255);
                        all_a |= (long)a;
                        if (target != 4) continue;
                        _out_[z++] = a;
                    }
                } else {
                    int bpp = info.bpp;
                    for (i = 0; i < this.img_x; ++i) {
                        long v = bpp == 16 ? (long)this.stbi__get16le() : this.stbi__get32le();
                        long a = 0L;
                        _out_[z++] = (byte)(BmpDecoder.stbi__shiftsigned(v & mr, rshift, rcount) & 0xFF);
                        _out_[z++] = (byte)(BmpDecoder.stbi__shiftsigned(v & mg, gshift, gcount) & 0xFF);
                        _out_[z++] = (byte)(BmpDecoder.stbi__shiftsigned(v & mb, bshift, bcount) & 0xFF);
                        a = ma != 0L ? (long)BmpDecoder.stbi__shiftsigned(v & ma, ashift, acount) : 255L;
                        all_a |= a;
                        if (target != 4) continue;
                        _out_[z++] = (byte)(a & 0xFFL);
                    }
                }
                this.stbi__skip(pad);
            }
        }
        if (target == 4 && all_a == 0L) {
            for (i = 4 * this.img_x * this.img_y - 1; i >= 0; i -= 4) {
                _out_[i] = -1;
            }
        }
        if (flip_vertically) {
            int t = 0;
            FakePtrByte ptr = new FakePtrByte(_out_);
            for (j = 0; j < this.img_y >> 1; ++j) {
                FakePtrByte p1 = ptr.cloneAdd(j * this.img_x * target);
                FakePtrByte p2 = ptr.cloneAdd((this.img_y - 1 - j) * this.img_x * target);
                for (i = 0; i < this.img_x * target; ++i) {
                    t = p1.getAt(i);
                    p1.setAt(i, p2.getAt(i));
                    p2.setAt(i, t);
                }
            }
        }
        if (requiredComponents != null && requiredComponents.getValue() != target) {
            _out_ = Utility.stbi__convert_format(_out_, target, requiredComponents.getValue(), this.img_x, this.img_y);
        }
        return new ImageResult(this.img_x, this.img_y, ColorComponents.fromInt(this.img_n), requiredComponents != null ? requiredComponents : ColorComponents.fromInt(this.img_n), 8, _out_);
    }

    private static boolean TestInternal(InputStream stream) throws Exception {
        if (stream.read() != 66) {
            return false;
        }
        if (stream.read() != 77) {
            return false;
        }
        Utility.stbi__get32le(stream);
        Utility.stbi__get16le(stream);
        Utility.stbi__get16le(stream);
        Utility.stbi__get32le(stream);
        int sz = (int)Utility.stbi__get32le(stream);
        boolean r = sz == 12 || sz == 40 || sz == 56 || sz == 108 || sz == 124;
        return r;
    }

    public static boolean Test(byte[] data) {
        try {
            return BmpDecoder.TestInternal(new ByteArrayInputStream(data));
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static ImageInfo Info(byte[] data) {
        try {
            stbi__bmp_data info = new stbi__bmp_data();
            info.all_a = 255L;
            ByteArrayInputStream stream = new ByteArrayInputStream(data);
            BmpDecoder decoder = new BmpDecoder(stream);
            decoder.stbi__bmp_parse_header(info);
            return new ImageInfo(decoder.img_x, decoder.img_y, info.ma != 0L ? ColorComponents.RedGreenBlueAlpha : ColorComponents.RedGreenBlue, 8);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static ImageResult Decode(byte[] data, ColorComponents requiredComponents) throws Exception {
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        BmpDecoder decoder = new BmpDecoder(stream);
        return decoder.InternalDecode(requiredComponents);
    }

    public static ImageResult Decode(byte[] data) throws Exception {
        return BmpDecoder.Decode(data, null);
    }

    private static class stbi__bmp_data {
        public int bpp;
        public int offset;
        public int hsz;
        public long mr;
        public long mg;
        public long mb;
        public long ma;
        public long all_a;

        private stbi__bmp_data() {
        }
    }
}

