/*
 * Decompiled with CFR 0.152.
 */
package org.nothings.stb.image.decoding;

import java.util.Arrays;

class FakePtrByte {
    private byte[] array;
    public int offset;

    public FakePtrByte(FakePtrByte ptr, int offset) {
        this.array = ptr.array;
        this.offset = ptr.offset + offset;
    }

    public FakePtrByte(byte[] data, int offset) {
        this.array = data;
        this.offset = offset;
    }

    public FakePtrByte(byte[] data) {
        this(data, 0);
    }

    public void clear(int count) {
        Arrays.fill(this.array, this.offset, this.offset + count, (byte)0);
    }

    public int get() {
        return this.array[this.offset] & 0xFF;
    }

    public void set(int value) {
        this.array[this.offset] = (byte)value;
    }

    public int getAt(int offset) {
        return this.array[this.offset + offset] & 0xFF;
    }

    public void setAt(int offset, int value) {
        this.array[this.offset + offset] = (byte)value;
    }

    public void move(int offset) {
        this.offset += offset;
    }

    public void increase() {
        this.move(1);
    }

    public int getAndIncrease() {
        int result = this.array[this.offset] & 0xFF;
        ++this.offset;
        return result;
    }

    public void setAndIncrease(int value) {
        this.array[this.offset] = (byte)value;
        ++this.offset;
    }

    public FakePtrByte cloneAdd(int offset) {
        return new FakePtrByte(this.array, this.offset + offset);
    }

    public FakePtrByte clone() {
        return new FakePtrByte(this.array, this.offset);
    }

    public void fill(int value, int count) {
        Arrays.fill(this.array, this.offset, this.offset + count, (byte)value);
    }

    public void fillAndIncrease(int value, int count) {
        this.fill(value, count);
        this.offset += count;
    }

    public void memcpy(FakePtrByte b, int count) {
        System.arraycopy(b.array, b.offset, this.array, this.offset, count);
    }
}

