/*
 * Decompiled with CFR 0.152.
 */
package org.nothings.stb.image.decoding;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import org.nothings.stb.image.ColorComponents;
import org.nothings.stb.image.ImageInfo;
import org.nothings.stb.image.ImageResult;
import org.nothings.stb.image.decoding.Decoder;
import org.nothings.stb.image.decoding.FakePtrByte;
import org.nothings.stb.image.decoding.FakePtrInt;
import org.nothings.stb.image.decoding.FakePtrShort;
import org.nothings.stb.image.decoding.Utility;

public class JpgDecoder
extends Decoder {
    private static final long MAX_UNSIGNED_INT = 0xFFFFFFFFL;
    private static final int STBI__ZFAST_BITS = 9;
    private static final int[] stbi__bmask = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535};
    private static final int[] stbi__jbias = new int[]{0, -1, -3, -7, -15, -31, -63, -127, -255, -511, -1023, -2047, -4095, -8191, -16383, -32767};
    private static final short[] stbi__jpeg_dezigzag = new short[]{0, 1, 8, 16, 9, 2, 3, 10, 17, 24, 32, 25, 18, 11, 4, 5, 12, 19, 26, 33, 40, 48, 41, 34, 27, 20, 13, 6, 7, 14, 21, 28, 35, 42, 49, 56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51, 58, 59, 52, 45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63};
    private final stbi__huffman[] huff_dc = new stbi__huffman[4];
    private final stbi__huffman[] huff_ac = new stbi__huffman[4];
    private int[][] dequant;
    private short[][] fast_ac;
    private int img_h_max;
    private int img_v_max;
    private int img_mcu_x;
    private int img_mcu_y;
    private int img_mcu_w;
    private int img_mcu_h;
    private final img_comp[] img_comp = new img_comp[4];
    private long code_buffer;
    private int code_bits;
    private int marker;
    private int nomore;
    private int progressive;
    private int spec_start;
    private int spec_end;
    private int succ_high;
    private int succ_low;
    private int eob_run;
    private int jfif;
    private int app14_color_transform;
    private int rgb;
    private int scan_n;
    private final int[] order = new int[4];
    private int restart_interval;
    private int todo;
    private idct_block_kernel idct_block_kernel;
    private YCbCr_to_RGB_kernel YCbCr_to_RGB_kernel;
    private Resampler resample_row_hv_2_kernel;

    private JpgDecoder(InputStream stream) {
        super(stream);
        int i;
        for (i = 0; i < 4; ++i) {
            this.huff_ac[i] = new stbi__huffman();
            this.huff_dc[i] = new stbi__huffman();
        }
        for (i = 0; i < this.img_comp.length; ++i) {
            this.img_comp[i] = new img_comp();
        }
        this.fast_ac = new short[4][];
        for (i = 0; i < this.fast_ac.length; ++i) {
            this.fast_ac[i] = new short[512];
        }
        this.dequant = new int[4][];
        for (i = 0; i < this.dequant.length; ++i) {
            this.dequant[i] = new int[64];
        }
    }

    private static int stbi__build_huffman(stbi__huffman h, int[] count) throws Exception {
        int i = 0;
        int j = 0;
        int k = 0;
        long code = 0L;
        for (i = 0; i < 16; ++i) {
            for (j = 0; j < count[i]; ++j) {
                h.size[k++] = (short)(i + 1);
            }
        }
        h.size[k] = 0;
        code = 0L;
        k = 0;
        for (j = 1; j <= 16; ++j) {
            h.delta[j] = (int)((long)k - code);
            if (h.size[k] == j) {
                while (h.size[k] == j) {
                    h.code[k++] = (int)code++;
                }
                if (code - 1L >= (long)(1 << j)) {
                    JpgDecoder.stbi__err("bad code lengths");
                }
            }
            h.maxcode[j] = code << 16 - j;
            code <<= 1;
        }
        h.maxcode[j] = -1L;
        Arrays.fill(h.fast, (short)255);
        for (i = 0; i < k; ++i) {
            short s = h.size[i];
            if (s > 9) continue;
            int c = h.code[i] << 9 - s;
            int m = 1 << 9 - s;
            for (j = 0; j < m; ++j) {
                h.fast[c + j] = (short)i;
            }
        }
        return 1;
    }

    private static void stbi__build_fast_ac(short[] fast_ac, stbi__huffman h) {
        int i = 0;
        for (i = 0; i < 512; ++i) {
            short fast = h.fast[i];
            fast_ac[i] = 0;
            if (fast >= 255) continue;
            short rs = h.values[fast];
            int run = rs >> 4 & 0xF;
            int magbits = rs & 0xF;
            short len = h.size[fast];
            if (magbits == 0 || len + magbits > 9) continue;
            int k = (i << len & 0x1FF) >> 9 - magbits;
            int m = 1 << magbits - 1;
            if (k < m) {
                k += (-1 << magbits) + 1;
            }
            if (k < -128 || k > 127) continue;
            fast_ac[i] = (short)(k * 256 + run * 16 + len + magbits);
        }
    }

    private void clamp_code_buffer() {
        this.code_buffer &= 0xFFFFFFFFL;
    }

    private void stbi__grow_buffer_unsafe() throws Exception {
        do {
            long b;
            long l = b = this.nomore != 0 ? 0L : (long)this.stbi__get8();
            if (b == 255L) {
                short c = this.stbi__get8();
                while (c == 255) {
                    c = this.stbi__get8();
                }
                if (c != 0) {
                    this.marker = c;
                    this.nomore = 1;
                    return;
                }
            }
            this.code_buffer |= b << 24 - this.code_bits;
            this.clamp_code_buffer();
            this.code_bits += 8;
        } while (this.code_bits <= 24);
    }

    private int stbi__jpeg_huff_decode(stbi__huffman h) throws Exception {
        long temp = 0L;
        int c = 0;
        int k = 0;
        if (this.code_bits < 16) {
            this.stbi__grow_buffer_unsafe();
        }
        if ((k = h.fast[c = (int)(this.code_buffer >> 23 & 0x1FFL)]) < 255) {
            short s = h.size[k];
            if (s > this.code_bits) {
                return -1;
            }
            this.code_buffer <<= s;
            this.clamp_code_buffer();
            this.code_bits -= s;
            return h.values[k];
        }
        temp = this.code_buffer >> 16;
        k = 10;
        while (temp >= h.maxcode[k]) {
            ++k;
        }
        if (k == 17) {
            this.code_bits -= 16;
            return -1;
        }
        if (k > this.code_bits) {
            return -1;
        }
        c = (int)((this.code_buffer >> 32 - k & (long)stbi__bmask[k]) + (long)h.delta[k]);
        this.code_bits -= k;
        this.code_buffer <<= k;
        this.clamp_code_buffer();
        return h.values[c];
    }

    private int stbi__extend_receive(int n) throws Exception {
        int sgn = 0;
        if (this.code_bits < n) {
            this.stbi__grow_buffer_unsafe();
        }
        sgn = (int)this.code_buffer >> 31;
        long k = Utility._lrotl(this.code_buffer, n);
        this.code_buffer = k & (long)(~stbi__bmask[n]);
        this.clamp_code_buffer();
        this.code_bits -= n;
        return (int)((k &= (long)stbi__bmask[n]) + (long)(stbi__jbias[n] & ~sgn));
    }

    private int stbi__jpeg_get_bits(int n) throws Exception {
        if (this.code_bits < n) {
            this.stbi__grow_buffer_unsafe();
        }
        long k = Utility._lrotl(this.code_buffer, n);
        this.code_buffer = k & (long)(~stbi__bmask[n]);
        this.clamp_code_buffer();
        this.code_bits -= n;
        return (int)(k &= (long)stbi__bmask[n]);
    }

    private int stbi__jpeg_get_bit() throws Exception {
        if (this.code_bits < 1) {
            this.stbi__grow_buffer_unsafe();
        }
        long k = this.code_buffer;
        this.code_buffer <<= 1;
        this.clamp_code_buffer();
        --this.code_bits;
        return (int)(k & Integer.MIN_VALUE);
    }

    private int stbi__jpeg_decode_block(short[] data, stbi__huffman hdc, stbi__huffman hac, short[] fac, int b, int[] dequant) throws Exception {
        int diff = 0;
        int dc = 0;
        int k = 0;
        int t = 0;
        if (this.code_bits < 16) {
            this.stbi__grow_buffer_unsafe();
        }
        if ((t = this.stbi__jpeg_huff_decode(hdc)) < 0) {
            JpgDecoder.stbi__err("bad huffman code");
        }
        Arrays.fill(data, (short)0);
        diff = t != 0 ? this.stbi__extend_receive(t) : 0;
        this.img_comp[b].dc_pred = dc = this.img_comp[b].dc_pred + diff;
        data[0] = (short)(dc * dequant[0]);
        k = 1;
        do {
            short zig = 0;
            int c = 0;
            int r = 0;
            int s = 0;
            if (this.code_bits < 16) {
                this.stbi__grow_buffer_unsafe();
            }
            if ((r = fac[c = (int)(this.code_buffer >> 23 & 0x1FFL)]) != 0) {
                k += r >> 4 & 0xF;
                s = r & 0xF;
                this.code_buffer <<= s;
                this.clamp_code_buffer();
                this.code_bits -= s;
                zig = stbi__jpeg_dezigzag[k++];
                data[zig] = (short)((r >> 8) * dequant[zig]);
                continue;
            }
            int rs = this.stbi__jpeg_huff_decode(hac);
            if (rs < 0) {
                JpgDecoder.stbi__err("bad huffman code");
            }
            s = rs & 0xF;
            r = rs >> 4;
            if (s == 0) {
                if (rs != 240) break;
                k += 16;
                continue;
            }
            k += r;
            zig = stbi__jpeg_dezigzag[k++];
            data[zig] = (short)(this.stbi__extend_receive(s) * dequant[zig]);
        } while (k < 64);
        return 1;
    }

    private int stbi__jpeg_decode_block_prog_dc(FakePtrShort data, stbi__huffman hdc, int b) throws Exception {
        int diff = 0;
        int dc = 0;
        int t = 0;
        if (this.spec_end != 0) {
            JpgDecoder.stbi__err("can't merge dc and ac");
        }
        if (this.code_bits < 16) {
            this.stbi__grow_buffer_unsafe();
        }
        if (this.succ_high == 0) {
            data.fill((short)0, 64);
            t = this.stbi__jpeg_huff_decode(hdc);
            diff = t != 0 ? this.stbi__extend_receive(t) : 0;
            this.img_comp[b].dc_pred = dc = this.img_comp[b].dc_pred + diff;
            data.setAt(0, (short)(dc << this.succ_low));
        } else if (this.stbi__jpeg_get_bit() != 0) {
            short val = data.getAt(0);
            data.setAt(0, (short)(val + (short)(1 << this.succ_low)));
        }
        return 1;
    }

    private int stbi__jpeg_decode_block_prog_ac(FakePtrShort data, stbi__huffman hac, short[] fac) throws Exception {
        int k = 0;
        if (this.spec_start == 0) {
            JpgDecoder.stbi__err("can't merge dc and ac");
        }
        if (this.succ_high == 0) {
            int shift = this.succ_low;
            if (this.eob_run != 0) {
                --this.eob_run;
                return 1;
            }
            k = this.spec_start;
            do {
                short zig = 0;
                int c = 0;
                int r = 0;
                int s = 0;
                if (this.code_bits < 16) {
                    this.stbi__grow_buffer_unsafe();
                }
                if ((r = fac[c = (int)(this.code_buffer >> 23 & 0x1FFL)]) != 0) {
                    k += r >> 4 & 0xF;
                    s = r & 0xF;
                    this.code_buffer <<= s;
                    this.clamp_code_buffer();
                    this.code_bits -= s;
                    zig = stbi__jpeg_dezigzag[k++];
                    data.setAt(zig, (short)(r >> 8 << shift));
                    continue;
                }
                int rs = this.stbi__jpeg_huff_decode(hac);
                if (rs < 0) {
                    JpgDecoder.stbi__err("bad huffman code");
                }
                s = rs & 0xF;
                r = rs >> 4;
                if (s == 0) {
                    if (r < 15) {
                        this.eob_run = 1 << r;
                        if (r != 0) {
                            this.eob_run += this.stbi__jpeg_get_bits(r);
                        }
                        --this.eob_run;
                        break;
                    }
                    k += 16;
                    continue;
                }
                k += r;
                zig = stbi__jpeg_dezigzag[k++];
                data.setAt(zig, (short)(this.stbi__extend_receive(s) << shift));
            } while (k <= this.spec_end);
        } else {
            short bit = (short)(1 << this.succ_low);
            if (this.eob_run != 0) {
                --this.eob_run;
                for (k = this.spec_start; k <= this.spec_end; ++k) {
                    short idx = stbi__jpeg_dezigzag[k];
                    short value = data.getAt(idx);
                    if (value == 0 || this.stbi__jpeg_get_bit() == 0 || (value & bit) != 0) continue;
                    short val = data.getAt(idx);
                    if (value > 0) {
                        data.setAt(idx, (short)(val + bit));
                        continue;
                    }
                    data.setAt(idx, (short)(val - bit));
                }
            } else {
                k = this.spec_start;
                block2: do {
                    int r = 0;
                    int s = 0;
                    int rs = this.stbi__jpeg_huff_decode(hac);
                    if (rs < 0) {
                        JpgDecoder.stbi__err("bad huffman code");
                    }
                    s = rs & 0xF;
                    r = rs >> 4;
                    if (s == 0) {
                        if (r < 15) {
                            this.eob_run = (1 << r) - 1;
                            if (r != 0) {
                                this.eob_run += this.stbi__jpeg_get_bits(r);
                            }
                            r = 64;
                        }
                    } else {
                        if (s != 1) {
                            JpgDecoder.stbi__err("bad huffman code");
                        }
                        s = this.stbi__jpeg_get_bit() != 0 ? (int)bit : (int)(-bit);
                    }
                    while (k <= this.spec_end) {
                        short idx;
                        short value;
                        if ((value = data.getAt(idx = stbi__jpeg_dezigzag[k++])) != 0) {
                            if (this.stbi__jpeg_get_bit() == 0 || (value & bit) != 0) continue;
                            short val = data.getAt(idx);
                            if (value > 0) {
                                data.setAt(idx, (short)(val + bit));
                                continue;
                            }
                            data.setAt(idx, (short)(val - bit));
                            continue;
                        }
                        if (r == 0) {
                            data.setAt(idx, (short)s);
                            continue block2;
                        }
                        --r;
                    }
                } while (k <= this.spec_end);
            }
        }
        return 1;
    }

    private static int stbi__clamp(int x) {
        if (x < 0) {
            return 0;
        }
        if (x > 255) {
            return 255;
        }
        return x;
    }

    private static void stbi__idct_block(FakePtrByte _out_, int out_stride, FakePtrShort data) {
        int x3;
        int x2;
        int x1;
        int x0;
        int p5;
        int p4;
        int p3;
        int p2;
        int p1;
        int t3;
        int t2;
        int t1;
        int t0;
        int i = 0;
        int[] val = new int[64];
        FakePtrInt v = new FakePtrInt(val);
        FakePtrShort d = data;
        for (i = 0; i < 8; ++i) {
            if (d.getAt(8) == 0 && d.getAt(16) == 0 && d.getAt(24) == 0 && d.getAt(32) == 0 && d.getAt(40) == 0 && d.getAt(48) == 0 && d.getAt(56) == 0) {
                int dcterm = d.getAt(0) * 4;
                v.setAt(0, dcterm);
                v.setAt(8, dcterm);
                v.setAt(16, dcterm);
                v.setAt(24, dcterm);
                v.setAt(32, dcterm);
                v.setAt(40, dcterm);
                v.setAt(48, dcterm);
                v.setAt(56, dcterm);
            } else {
                t0 = 0;
                t1 = 0;
                t2 = 0;
                t3 = 0;
                p1 = 0;
                p2 = 0;
                p3 = 0;
                p4 = 0;
                p5 = 0;
                x0 = 0;
                x1 = 0;
                x2 = 0;
                x3 = 0;
                p2 = d.getAt(16);
                p3 = d.getAt(48);
                p1 = (p2 + p3) * 2217;
                t2 = p1 + p3 * -7567;
                t3 = p1 + p2 * 3135;
                p2 = d.getAt(0);
                p3 = d.getAt(32);
                t0 = (p2 + p3) * 4096;
                t1 = (p2 - p3) * 4096;
                x0 = t0 + t3;
                x3 = t0 - t3;
                x1 = t1 + t2;
                x2 = t1 - t2;
                t0 = d.getAt(56);
                t1 = d.getAt(40);
                t2 = d.getAt(24);
                t3 = d.getAt(8);
                p3 = t0 + t2;
                p4 = t1 + t3;
                p1 = t0 + t3;
                p2 = t1 + t2;
                p5 = (p3 + p4) * 4816;
                t0 *= 1223;
                t1 *= 8410;
                t2 *= 12586;
                t3 *= 6149;
                p1 = p5 + p1 * -3685;
                p2 = p5 + p2 * -10497;
                t3 += p1 + (p4 *= -1597);
                t2 += p2 + (p3 *= -8034);
                t1 += p2 + p4;
                t0 += p1 + p3;
                x2 += 512;
                x3 += 512;
                v.setAt(0, (x0 += 512) + t3 >> 10);
                v.setAt(56, x0 - t3 >> 10);
                v.setAt(8, (x1 += 512) + t2 >> 10);
                v.setAt(48, x1 - t2 >> 10);
                v.setAt(16, x2 + t1 >> 10);
                v.setAt(40, x2 - t1 >> 10);
                v.setAt(24, x3 + t0 >> 10);
                v.setAt(32, x3 - t0 >> 10);
            }
            d.increase();
            v.increase();
        }
        v = new FakePtrInt(val);
        FakePtrByte o = _out_.clone();
        for (i = 0; i < 8; ++i) {
            t0 = 0;
            t1 = 0;
            t2 = 0;
            t3 = 0;
            p1 = 0;
            p2 = 0;
            p3 = 0;
            p4 = 0;
            p5 = 0;
            x0 = 0;
            x1 = 0;
            x2 = 0;
            x3 = 0;
            p2 = v.getAt(2);
            p3 = v.getAt(6);
            p1 = (p2 + p3) * 2217;
            t2 = p1 + p3 * -7567;
            t3 = p1 + p2 * 3135;
            p2 = v.getAt(0);
            p3 = v.getAt(4);
            t0 = (p2 + p3) * 4096;
            t1 = (p2 - p3) * 4096;
            x0 = t0 + t3;
            x3 = t0 - t3;
            x1 = t1 + t2;
            x2 = t1 - t2;
            t0 = v.getAt(7);
            t1 = v.getAt(5);
            t2 = v.getAt(3);
            t3 = v.getAt(1);
            p3 = t0 + t2;
            p4 = t1 + t3;
            p1 = t0 + t3;
            p2 = t1 + t2;
            p5 = (p3 + p4) * 4816;
            t0 *= 1223;
            t1 *= 8410;
            t2 *= 12586;
            t3 *= 6149;
            p1 = p5 + p1 * -3685;
            p2 = p5 + p2 * -10497;
            t3 += p1 + (p4 *= -1597);
            t2 += p2 + (p3 *= -8034);
            t1 += p2 + p4;
            t0 += p1 + p3;
            x2 += 0x1010000;
            x3 += 0x1010000;
            o.setAt(0, JpgDecoder.stbi__clamp((x0 += 0x1010000) + t3 >> 17));
            o.setAt(7, JpgDecoder.stbi__clamp(x0 - t3 >> 17));
            o.setAt(1, JpgDecoder.stbi__clamp((x1 += 0x1010000) + t2 >> 17));
            o.setAt(6, JpgDecoder.stbi__clamp(x1 - t2 >> 17));
            o.setAt(2, JpgDecoder.stbi__clamp(x2 + t1 >> 17));
            o.setAt(5, JpgDecoder.stbi__clamp(x2 - t1 >> 17));
            o.setAt(3, JpgDecoder.stbi__clamp(x3 + t0 >> 17));
            o.setAt(4, JpgDecoder.stbi__clamp(x3 - t0 >> 17));
            v.move(8);
            o.move(out_stride);
        }
    }

    private int stbi__get_marker() throws Exception {
        int x = 0;
        if (this.marker != 255) {
            x = this.marker;
            this.marker = 255;
            return x;
        }
        x = this.stbi__get8();
        if (x != 255) {
            return 255;
        }
        while (x == 255) {
            x = this.stbi__get8();
        }
        return x;
    }

    private void stbi__jpeg_reset() {
        this.code_bits = 0;
        this.code_buffer = 0L;
        this.nomore = 0;
        this.img_comp[3].dc_pred = 0;
        this.img_comp[2].dc_pred = 0;
        this.img_comp[1].dc_pred = 0;
        this.img_comp[0].dc_pred = 0;
        this.marker = 255;
        this.todo = this.restart_interval != 0 ? this.restart_interval : Integer.MAX_VALUE;
        this.eob_run = 0;
    }

    private int stbi__parse_entropy_coded_data() throws Exception {
        this.stbi__jpeg_reset();
        if (this.progressive == 0) {
            if (this.scan_n == 1) {
                int i = 0;
                int j = 0;
                short[] data = new short[64];
                int n = this.order[0];
                int w = this.img_comp[n].x + 7 >> 3;
                int h = this.img_comp[n].y + 7 >> 3;
                for (j = 0; j < h; ++j) {
                    for (i = 0; i < w; ++i) {
                        int ha = this.img_comp[n].ha;
                        if (this.stbi__jpeg_decode_block(data, this.huff_dc[this.img_comp[n].hd], this.huff_ac[ha], this.fast_ac[ha], n, this.dequant[this.img_comp[n].tq]) == 0) {
                            return 0;
                        }
                        this.idct_block_kernel.Do(new FakePtrByte(this.img_comp[n].data, this.img_comp[n].w2 * j * 8 + i * 8), this.img_comp[n].w2, new FakePtrShort(data));
                        if (--this.todo > 0) continue;
                        if (this.code_bits < 24) {
                            this.stbi__grow_buffer_unsafe();
                        }
                        if (this.marker < 208 || this.marker > 215) {
                            return 1;
                        }
                        this.stbi__jpeg_reset();
                    }
                }
                return 1;
            }
            int i = 0;
            int j = 0;
            int k = 0;
            int x = 0;
            int y = 0;
            short[] data = new short[64];
            for (j = 0; j < this.img_mcu_y; ++j) {
                for (i = 0; i < this.img_mcu_x; ++i) {
                    for (k = 0; k < this.scan_n; ++k) {
                        int n = this.order[k];
                        for (y = 0; y < this.img_comp[n].v; ++y) {
                            for (x = 0; x < this.img_comp[n].h; ++x) {
                                int x2 = (i * this.img_comp[n].h + x) * 8;
                                int y2 = (j * this.img_comp[n].v + y) * 8;
                                int ha = this.img_comp[n].ha;
                                if (this.stbi__jpeg_decode_block(data, this.huff_dc[this.img_comp[n].hd], this.huff_ac[ha], this.fast_ac[ha], n, this.dequant[this.img_comp[n].tq]) == 0) {
                                    return 0;
                                }
                                this.idct_block_kernel.Do(new FakePtrByte(this.img_comp[n].data, this.img_comp[n].w2 * y2 + x2), this.img_comp[n].w2, new FakePtrShort(data));
                            }
                        }
                    }
                    if (--this.todo > 0) continue;
                    if (this.code_bits < 24) {
                        this.stbi__grow_buffer_unsafe();
                    }
                    if (this.marker < 208 || this.marker > 215) {
                        return 1;
                    }
                    this.stbi__jpeg_reset();
                }
            }
            return 1;
        }
        if (this.scan_n == 1) {
            int i = 0;
            int j = 0;
            int n = this.order[0];
            int w = this.img_comp[n].x + 7 >> 3;
            int h = this.img_comp[n].y + 7 >> 3;
            for (j = 0; j < h; ++j) {
                for (i = 0; i < w; ++i) {
                    int ha;
                    FakePtrShort data = new FakePtrShort(this.img_comp[n].coeff, 64 * (i + j * this.img_comp[n].coeff_w));
                    if (this.spec_start == 0 ? this.stbi__jpeg_decode_block_prog_dc(data, this.huff_dc[this.img_comp[n].hd], n) == 0 : this.stbi__jpeg_decode_block_prog_ac(data, this.huff_ac[ha = this.img_comp[n].ha], this.fast_ac[ha]) == 0) {
                        return 0;
                    }
                    if (--this.todo > 0) continue;
                    if (this.code_bits < 24) {
                        this.stbi__grow_buffer_unsafe();
                    }
                    if (this.marker < 208 || this.marker > 215) {
                        return 1;
                    }
                    this.stbi__jpeg_reset();
                }
            }
            return 1;
        }
        int i = 0;
        int j = 0;
        int k = 0;
        int x = 0;
        int y = 0;
        for (j = 0; j < this.img_mcu_y; ++j) {
            for (i = 0; i < this.img_mcu_x; ++i) {
                for (k = 0; k < this.scan_n; ++k) {
                    int n = this.order[k];
                    for (y = 0; y < this.img_comp[n].v; ++y) {
                        for (x = 0; x < this.img_comp[n].h; ++x) {
                            int x2 = i * this.img_comp[n].h + x;
                            int y2 = j * this.img_comp[n].v + y;
                            FakePtrShort data = new FakePtrShort(this.img_comp[n].coeff, 64 * (x2 + y2 * this.img_comp[n].coeff_w));
                            if (this.stbi__jpeg_decode_block_prog_dc(data, this.huff_dc[this.img_comp[n].hd], n) != 0) continue;
                            return 0;
                        }
                    }
                }
                if (--this.todo > 0) continue;
                if (this.code_bits < 24) {
                    this.stbi__grow_buffer_unsafe();
                }
                if (this.marker < 208 || this.marker > 215) {
                    return 1;
                }
                this.stbi__jpeg_reset();
            }
        }
        return 1;
    }

    private static void stbi__jpeg_dequantize(FakePtrShort data, int[] dequant) {
        int i = 0;
        for (i = 0; i < 64; ++i) {
            short val = data.getAt(i);
            val = (short)(val * dequant[i]);
            data.setAt(i, val);
        }
    }

    private void stbi__jpeg_finish() {
        if (this.progressive != 0) {
            int i = 0;
            int j = 0;
            int n = 0;
            for (n = 0; n < this.img_n; ++n) {
                int w = this.img_comp[n].x + 7 >> 3;
                int h = this.img_comp[n].y + 7 >> 3;
                for (j = 0; j < h; ++j) {
                    for (i = 0; i < w; ++i) {
                        FakePtrShort data = new FakePtrShort(this.img_comp[n].coeff, 64 * (i + j * this.img_comp[n].coeff_w));
                        JpgDecoder.stbi__jpeg_dequantize(data, this.dequant[this.img_comp[n].tq]);
                        this.idct_block_kernel.Do(new FakePtrByte(this.img_comp[n].data, this.img_comp[n].w2 * j * 8 + i * 8), this.img_comp[n].w2, data);
                    }
                }
            }
        }
    }

    private int stbi__process_marker(int m) throws Exception {
        int L = 0;
        switch (m) {
            case 255: {
                JpgDecoder.stbi__err("expected marker");
                break;
            }
            case 221: {
                if (this.stbi__get16be() != 4) {
                    JpgDecoder.stbi__err("bad DRI len");
                }
                this.restart_interval = this.stbi__get16be();
                return 1;
            }
            case 219: {
                boolean sixteen;
                for (L = this.stbi__get16be() - 2; L > 0; L -= sixteen ? 129 : 65) {
                    short q = this.stbi__get8();
                    int p = q >> 4;
                    sixteen = p != 0;
                    int t = q & 0xF;
                    int i = 0;
                    if (p != 0 && p != 1) {
                        JpgDecoder.stbi__err("bad DQT type");
                    }
                    if (t > 3) {
                        JpgDecoder.stbi__err("bad DQT table");
                    }
                    for (i = 0; i < 64; ++i) {
                        this.dequant[t][JpgDecoder.stbi__jpeg_dezigzag[i]] = sixteen ? this.stbi__get16be() : (int)this.stbi__get8();
                    }
                }
                return L == 0 ? 1 : 0;
            }
            case 196: {
                int n;
                for (L = this.stbi__get16be() - 2; L > 0; L -= n) {
                    short[] v;
                    int[] sizes = new int[16];
                    int i = 0;
                    n = 0;
                    short q = this.stbi__get8();
                    int tc = q >> 4;
                    int th = q & 0xF;
                    if (tc > 1 || th > 3) {
                        JpgDecoder.stbi__err("bad DHT header");
                    }
                    for (i = 0; i < 16; ++i) {
                        sizes[i] = this.stbi__get8();
                        n += sizes[i];
                    }
                    L -= 17;
                    if (tc == 0) {
                        if (JpgDecoder.stbi__build_huffman(this.huff_dc[th], sizes) == 0) {
                            return 0;
                        }
                        v = this.huff_dc[th].values;
                    } else {
                        if (JpgDecoder.stbi__build_huffman(this.huff_ac[th], sizes) == 0) {
                            return 0;
                        }
                        v = this.huff_ac[th].values;
                    }
                    for (i = 0; i < n; ++i) {
                        v[i] = this.stbi__get8();
                    }
                    if (tc == 0) continue;
                    JpgDecoder.stbi__build_fast_ac(this.fast_ac[th], this.huff_ac[th]);
                }
                return L == 0 ? 1 : 0;
            }
        }
        if (m >= 224 && m <= 239 || m == 254) {
            L = this.stbi__get16be();
            if (L < 2) {
                if (m == 254) {
                    JpgDecoder.stbi__err("bad COM len");
                } else {
                    JpgDecoder.stbi__err("bad APP len");
                }
            }
            if (m == 224 && (L -= 2) >= 5) {
                short[] tag = new short[]{74, 70, 73, 70, 0};
                boolean ok = true;
                int i = 0;
                for (i = 0; i < 5; ++i) {
                    if (this.stbi__get8() == tag[i]) continue;
                    ok = false;
                }
                L -= 5;
                if (ok) {
                    this.jfif = 1;
                }
            } else if (m == 238 && L >= 12) {
                short[] tag = new short[]{65, 100, 111, 98, 101, 0};
                boolean ok = true;
                int i = 0;
                for (i = 0; i < 6; ++i) {
                    if (this.stbi__get8() == tag[i]) continue;
                    ok = false;
                }
                L -= 6;
                if (ok) {
                    this.stbi__get8();
                    this.stbi__get16be();
                    this.stbi__get16be();
                    this.app14_color_transform = this.stbi__get8();
                    L -= 6;
                }
            }
            this.stbi__skip(L);
            return 1;
        }
        return 0;
    }

    private int stbi__process_scan_header() throws Exception {
        int i = 0;
        int Ls = this.stbi__get16be();
        this.scan_n = this.stbi__get8();
        if (this.scan_n < 1 || this.scan_n > 4 || this.scan_n > this.img_n) {
            JpgDecoder.stbi__err("bad SOS component count");
        }
        if (Ls != 6 + 2 * this.scan_n) {
            JpgDecoder.stbi__err("bad SOS len");
        }
        for (i = 0; i < this.scan_n; ++i) {
            short id = this.stbi__get8();
            int which = 0;
            short q = this.stbi__get8();
            for (which = 0; which < this.img_n && this.img_comp[which].id != id; ++which) {
            }
            if (which == this.img_n) {
                return 0;
            }
            this.img_comp[which].hd = q >> 4;
            if (this.img_comp[which].hd > 3) {
                JpgDecoder.stbi__err("bad DC huff");
            }
            this.img_comp[which].ha = q & 0xF;
            if (this.img_comp[which].ha > 3) {
                JpgDecoder.stbi__err("bad AC huff");
            }
            this.order[i] = which;
        }
        short aa = 0;
        this.spec_start = this.stbi__get8();
        this.spec_end = this.stbi__get8();
        aa = this.stbi__get8();
        this.succ_high = aa >> 4;
        this.succ_low = aa & 0xF;
        if (this.progressive != 0) {
            if (this.spec_start > 63 || this.spec_end > 63 || this.spec_start > this.spec_end || this.succ_high > 13 || this.succ_low > 13) {
                JpgDecoder.stbi__err("bad SOS");
            }
        } else {
            if (this.spec_start != 0) {
                JpgDecoder.stbi__err("bad SOS");
            }
            if (this.succ_high != 0 || this.succ_low != 0) {
                JpgDecoder.stbi__err("bad SOS");
            }
            this.spec_end = 63;
        }
        return 1;
    }

    private int stbi__free_jpeg_components(int ncomp, int why) {
        int i = 0;
        for (i = 0; i < ncomp; ++i) {
            if (this.img_comp[i].raw_data != null) {
                this.img_comp[i].raw_data = null;
                this.img_comp[i].data = null;
            }
            if (this.img_comp[i].raw_coeff != null) {
                this.img_comp[i].raw_coeff = null;
                this.img_comp[i].coeff = null;
            }
            if (this.img_comp[i].linebuf == null) continue;
            this.img_comp[i].linebuf = null;
        }
        return why;
    }

    private int stbi__process_frame_header(int scan) throws Exception {
        int Lf = 0;
        short p = 0;
        int i = 0;
        short q = 0;
        int h_max = 1;
        int v_max = 1;
        int c = 0;
        Lf = this.stbi__get16be();
        if (Lf < 11) {
            JpgDecoder.stbi__err("bad SOF len");
        }
        if ((p = this.stbi__get8()) != 8) {
            JpgDecoder.stbi__err("only 8-bit");
        }
        this.img_y = this.stbi__get16be();
        if (this.img_y == 0) {
            JpgDecoder.stbi__err("no header height");
        }
        this.img_x = this.stbi__get16be();
        if (this.img_x == 0) {
            JpgDecoder.stbi__err("0 width");
        }
        if ((c = this.stbi__get8()) != 3 && c != 1 && c != 4) {
            JpgDecoder.stbi__err("bad component count");
        }
        this.img_n = c;
        for (i = 0; i < c; ++i) {
            this.img_comp[i].data = null;
            this.img_comp[i].linebuf = null;
        }
        if (Lf != 8 + 3 * this.img_n) {
            JpgDecoder.stbi__err("bad SOF len");
        }
        this.rgb = 0;
        for (i = 0; i < this.img_n; ++i) {
            short[] rgb = new short[]{82, 71, 66};
            this.img_comp[i].id = this.stbi__get8();
            if (this.img_n == 3 && this.img_comp[i].id == rgb[i]) {
                ++this.rgb;
            }
            q = this.stbi__get8();
            this.img_comp[i].h = q >> 4;
            if (this.img_comp[i].h == 0 || this.img_comp[i].h > 4) {
                JpgDecoder.stbi__err("bad H");
            }
            this.img_comp[i].v = q & 0xF;
            if (this.img_comp[i].v == 0 || this.img_comp[i].v > 4) {
                JpgDecoder.stbi__err("bad V");
            }
            this.img_comp[i].tq = this.stbi__get8();
            if (this.img_comp[i].tq <= 3) continue;
            JpgDecoder.stbi__err("bad TQ");
        }
        if (scan != 0) {
            return 1;
        }
        for (i = 0; i < this.img_n; ++i) {
            if (this.img_comp[i].h > h_max) {
                h_max = this.img_comp[i].h;
            }
            if (this.img_comp[i].v <= v_max) continue;
            v_max = this.img_comp[i].v;
        }
        this.img_h_max = h_max;
        this.img_v_max = v_max;
        this.img_mcu_w = h_max * 8;
        this.img_mcu_h = v_max * 8;
        this.img_mcu_x = (this.img_x + this.img_mcu_w - 1) / this.img_mcu_w;
        this.img_mcu_y = (this.img_y + this.img_mcu_h - 1) / this.img_mcu_h;
        for (i = 0; i < this.img_n; ++i) {
            this.img_comp[i].x = (this.img_x * this.img_comp[i].h + h_max - 1) / h_max;
            this.img_comp[i].y = (this.img_y * this.img_comp[i].v + v_max - 1) / v_max;
            this.img_comp[i].w2 = this.img_mcu_x * this.img_comp[i].h * 8;
            this.img_comp[i].h2 = this.img_mcu_y * this.img_comp[i].v * 8;
            this.img_comp[i].coeff = null;
            this.img_comp[i].raw_coeff = null;
            this.img_comp[i].linebuf = null;
            this.img_comp[i].raw_data = new byte[this.img_comp[i].w2 * this.img_comp[i].h2 + 15];
            this.img_comp[i].data = new FakePtrByte(this.img_comp[i].raw_data);
            if (this.progressive == 0) continue;
            this.img_comp[i].coeff_w = this.img_comp[i].w2 / 8;
            this.img_comp[i].coeff_h = this.img_comp[i].h2 / 8;
            this.img_comp[i].raw_coeff = new short[this.img_comp[i].w2 * this.img_comp[i].h2 + 15];
            this.img_comp[i].coeff = new FakePtrShort(this.img_comp[i].raw_coeff);
        }
        return 1;
    }

    private boolean stbi__decode_jpeg_header(int scan) throws Exception {
        this.jfif = 0;
        this.app14_color_transform = -1;
        this.marker = 255;
        int m = this.stbi__get_marker();
        if (m != 216) {
            if (scan == 1) {
                return false;
            }
            JpgDecoder.stbi__err("no SOI");
        }
        if (scan == 1) {
            return true;
        }
        m = this.stbi__get_marker();
        while (m != 192 && m != 193 && m != 194) {
            if (this.stbi__process_marker(m) == 0) {
                return false;
            }
            m = this.stbi__get_marker();
            while (m == 255) {
                if (this.stbi__at_eof()) {
                    JpgDecoder.stbi__err("no SOF");
                }
                m = this.stbi__get_marker();
            }
        }
        this.progressive = m == 194 ? 1 : 0;
        return this.stbi__process_frame_header(scan) != 0;
    }

    private int stbi__decode_jpeg_image() throws Exception {
        int m = 0;
        for (m = 0; m < 4; ++m) {
            this.img_comp[m].raw_data = null;
            this.img_comp[m].raw_coeff = null;
        }
        this.restart_interval = 0;
        if (!this.stbi__decode_jpeg_header(0)) {
            return 0;
        }
        m = this.stbi__get_marker();
        while (m != 217) {
            if (m == 218) {
                if (this.stbi__process_scan_header() == 0) {
                    return 0;
                }
                if (this.stbi__parse_entropy_coded_data() == 0) {
                    return 0;
                }
                if (this.marker == 255) {
                    while (!this.stbi__at_eof()) {
                        short x = this.stbi__get8();
                        if (x != 255) continue;
                        this.marker = this.stbi__get8();
                        break;
                    }
                }
            } else if (m == 220) {
                int Ld = this.stbi__get16be();
                long NL = this.stbi__get16be();
                if (Ld != 4) {
                    JpgDecoder.stbi__err("bad DNL len");
                }
                if (NL != (long)this.img_y) {
                    JpgDecoder.stbi__err("bad DNL height");
                }
            } else if (this.stbi__process_marker(m) == 0) {
                return 0;
            }
            m = this.stbi__get_marker();
        }
        if (this.progressive != 0) {
            this.stbi__jpeg_finish();
        }
        return 1;
    }

    private static FakePtrByte resample_row_1(FakePtrByte _out_, FakePtrByte in_near, FakePtrByte in_far, int w, int hs) {
        return in_near.clone();
    }

    private static FakePtrByte stbi__resample_row_v_2(FakePtrByte _out_, FakePtrByte in_near, FakePtrByte in_far, int w, int hs) {
        int i = 0;
        for (i = 0; i < w; ++i) {
            int value = 3 * in_near.getAt(i) + in_far.getAt(i) + 2 >> 2;
            _out_.setAt(i, value);
        }
        return _out_.clone();
    }

    private static FakePtrByte stbi__resample_row_h_2(FakePtrByte _out_, FakePtrByte in_near, FakePtrByte in_far, int w, int hs) {
        int i = 0;
        FakePtrByte input = in_near;
        if (w == 1) {
            int value = input.getAt(0);
            _out_.setAt(0, value);
            _out_.setAt(1, value);
            return _out_;
        }
        _out_.setAt(0, input.getAt(0));
        _out_.setAt(1, input.getAt(0) * 3 + input.getAt(1) + 2 >> 2);
        for (i = 1; i < w - 1; ++i) {
            int n = 3 * input.getAt(i) + 2;
            _out_.setAt(i * 2 + 0, n + input.getAt(i - 1) >> 2);
            _out_.setAt(i * 2 + 1, n + input.getAt(i + 1) >> 2);
        }
        _out_.setAt(i * 2 + 0, input.getAt(w - 2) * 3 + input.getAt(w - 1) + 2 >> 2);
        _out_.setAt(i * 2 + 1, input.getAt(w - 1));
        return _out_.clone();
    }

    private static FakePtrByte stbi__resample_row_hv_2(FakePtrByte _out_, FakePtrByte in_near, FakePtrByte in_far, int w, int hs) {
        int i = 0;
        int t0 = 0;
        int t1 = 0;
        if (w == 1) {
            int value = 3 * in_near.getAt(0) + in_far.getAt(0) + 2 >> 2;
            _out_.setAt(0, value);
            _out_.setAt(1, value);
            return _out_;
        }
        t1 = 3 * in_near.getAt(0) + in_far.getAt(0);
        _out_.setAt(0, t1 + 2 >> 2);
        for (i = 1; i < w; ++i) {
            t0 = t1;
            t1 = 3 * in_near.getAt(i) + in_far.getAt(i);
            _out_.setAt(i * 2 - 1, 3 * t0 + t1 + 8 >> 4);
            _out_.setAt(i * 2, 3 * t1 + t0 + 8 >> 4);
        }
        _out_.setAt(w * 2 - 1, t1 + 2 >> 2);
        return _out_.clone();
    }

    private static FakePtrByte stbi__resample_row_generic(FakePtrByte _out_, FakePtrByte in_near, FakePtrByte in_far, int w, int hs) {
        int i = 0;
        int j = 0;
        for (i = 0; i < w; ++i) {
            for (j = 0; j < hs; ++j) {
                _out_.setAt(i * hs + j, in_near.getAt(i));
            }
        }
        return _out_.clone();
    }

    private static void stbi__YCbCr_to_RGB_row(FakePtrByte out, FakePtrByte y, FakePtrByte pcb, FakePtrByte pcr, int count, int step) {
        FakePtrByte _out_ = out.clone();
        int i = 0;
        for (i = 0; i < count; ++i) {
            int y_fixed = (y.getAt(i) << 20) + 524288;
            int r = 0;
            int g = 0;
            int b = 0;
            int cr = pcr.getAt(i) - 128;
            int cb = pcb.getAt(i) - 128;
            r = y_fixed + cr * 1470208;
            g = y_fixed + cr * -748800 + (cb * -360960 & 0xFFFF0000);
            b = y_fixed + cb * 1858048;
            _out_.setAt(0, JpgDecoder.stbi__clamp(r >>= 20));
            _out_.setAt(1, JpgDecoder.stbi__clamp(g >>= 20));
            _out_.setAt(2, JpgDecoder.stbi__clamp(b >>= 20));
            _out_.setAt(3, 255);
            _out_.move(step);
        }
    }

    private void stbi__setup_jpeg() {
        this.idct_block_kernel = (output, out_stride, data) -> JpgDecoder.stbi__idct_block(output, out_stride, data);
        this.YCbCr_to_RGB_kernel = (output, y, pcb, pcr, count, step) -> JpgDecoder.stbi__YCbCr_to_RGB_row(output, y, pcb, pcr, count, step);
        this.resample_row_hv_2_kernel = (a, b, c, d, e) -> JpgDecoder.stbi__resample_row_hv_2(a, b, c, d, e);
    }

    private void stbi__cleanup_jpeg() {
        this.stbi__free_jpeg_components(this.img_n, 0);
    }

    private static int stbi__blinn_8x8(int x, int y) {
        long t = x * y + 128;
        return (int)(t + (t >> 8) >> 8);
    }

    private ImageResult load_jpeg_image(ColorComponents req_comp) throws Exception {
        int comp = 0;
        int out_y = 0;
        int out_x = 0;
        int n = 0;
        int decode_n = 0;
        boolean is_rgb = false;
        this.img_n = 0;
        if (this.stbi__decode_jpeg_image() == 0) {
            this.stbi__cleanup_jpeg();
            return null;
        }
        n = req_comp != null ? req_comp.getValue() : (this.img_n >= 3 ? 3 : 1);
        is_rgb = this.img_n == 3 && (this.rgb == 3 || this.app14_color_transform == 0 && this.jfif == 0);
        decode_n = this.img_n == 3 && n < 3 && !is_rgb ? 1 : this.img_n;
        int k = 0;
        int i = 0;
        int j = 0;
        FakePtrByte[] coutput = new FakePtrByte[4];
        stbi__resample[] res_comp = new stbi__resample[4];
        for (int kkk = 0; kkk < res_comp.length; ++kkk) {
            res_comp[kkk] = new stbi__resample();
        }
        for (k = 0; k < decode_n; ++k) {
            stbi__resample r = res_comp[k];
            this.img_comp[k].linebuf = new byte[this.img_x + 3];
            r.hs = this.img_h_max / this.img_comp[k].h;
            r.vs = this.img_v_max / this.img_comp[k].v;
            r.ystep = r.vs >> 1;
            r.w_lores = (this.img_x + r.hs - 1) / r.hs;
            r.ypos = 0;
            r.line0 = this.img_comp[k].data.clone();
            r.line1 = this.img_comp[k].data.clone();
            r.resample = r.hs == 1 && r.vs == 1 ? (a, b, c, d, e) -> JpgDecoder.resample_row_1(a, b, c, d, e) : (r.hs == 1 && r.vs == 2 ? (a, b, c, d, e) -> JpgDecoder.stbi__resample_row_v_2(a, b, c, d, e) : (r.hs == 2 && r.vs == 1 ? (a, b, c, d, e) -> JpgDecoder.stbi__resample_row_h_2(a, b, c, d, e) : (r.hs == 2 && r.vs == 2 ? this.resample_row_hv_2_kernel : (a, b, c, d, e) -> JpgDecoder.stbi__resample_row_generic(a, b, c, d, e))));
        }
        byte[] output = new byte[n * this.img_x * this.img_y];
        FakePtrByte ptr = new FakePtrByte(output);
        for (j = 0; j < this.img_y; ++j) {
            FakePtrByte y;
            FakePtrByte _out_ = ptr.cloneAdd(n * this.img_x * j);
            for (k = 0; k < decode_n; ++k) {
                stbi__resample r = res_comp[k];
                boolean y_bot = r.ystep >= r.vs >> 1;
                coutput[k] = r.resample.Do(new FakePtrByte(this.img_comp[k].linebuf), y_bot ? r.line1 : r.line0, y_bot ? r.line0 : r.line1, r.w_lores, r.hs);
                if (++r.ystep < r.vs) continue;
                r.ystep = 0;
                r.line0 = r.line1.clone();
                if (++r.ypos >= this.img_comp[k].y) continue;
                r.line1.move(this.img_comp[k].w2);
            }
            if (n >= 3) {
                y = coutput[0];
                if (this.img_n == 3) {
                    if (is_rgb) {
                        for (i = 0; i < this.img_x; ++i) {
                            _out_.setAt(0, y.getAt(i));
                            _out_.setAt(1, coutput[1].getAt(i));
                            _out_.setAt(2, coutput[2].getAt(i));
                            _out_.setAt(3, 255);
                            _out_.move(n);
                        }
                        continue;
                    }
                    this.YCbCr_to_RGB_kernel.Do(_out_, y, coutput[1], coutput[2], this.img_x, n);
                    continue;
                }
                if (this.img_n == 4) {
                    int m;
                    if (this.app14_color_transform == 0) {
                        for (i = 0; i < this.img_x; ++i) {
                            m = coutput[3].getAt(i);
                            _out_.setAt(0, JpgDecoder.stbi__blinn_8x8(coutput[0].getAt(i), m));
                            _out_.setAt(1, JpgDecoder.stbi__blinn_8x8(coutput[1].getAt(i), m));
                            _out_.setAt(2, JpgDecoder.stbi__blinn_8x8(coutput[2].getAt(i), m));
                            _out_.setAt(3, 255);
                            _out_.move(n);
                        }
                        continue;
                    }
                    if (this.app14_color_transform == 2) {
                        this.YCbCr_to_RGB_kernel.Do(_out_, y, coutput[1], coutput[2], this.img_x, n);
                        for (i = 0; i < this.img_x; ++i) {
                            m = coutput[3].getAt(i);
                            _out_.setAt(0, JpgDecoder.stbi__blinn_8x8(255 - _out_.getAt(0), m));
                            _out_.setAt(1, JpgDecoder.stbi__blinn_8x8(255 - _out_.getAt(1), m));
                            _out_.setAt(2, JpgDecoder.stbi__blinn_8x8(255 - _out_.getAt(2), m));
                            _out_.move(n);
                        }
                        continue;
                    }
                    this.YCbCr_to_RGB_kernel.Do(_out_, y, coutput[1], coutput[2], this.img_x, n);
                    continue;
                }
                for (i = 0; i < this.img_x; ++i) {
                    int v = y.getAt(i);
                    _out_.setAt(0, v);
                    _out_.setAt(1, v);
                    _out_.setAt(2, v);
                    _out_.setAt(3, 255);
                    _out_.move(n);
                }
                continue;
            }
            if (is_rgb) {
                if (n == 1) {
                    for (i = 0; i < this.img_x; ++i) {
                        _out_.setAndIncrease(Utility.stbi__compute_y(coutput[0].getAt(i), coutput[1].getAt(i), coutput[2].getAt(i)));
                    }
                    continue;
                }
                for (i = 0; i < this.img_x; ++i) {
                    _out_.setAt(0, Utility.stbi__compute_y(coutput[0].getAt(i), coutput[1].getAt(i), coutput[2].getAt(i)));
                    _out_.setAt(1, 255);
                    _out_.move(2);
                }
                continue;
            }
            if (this.img_n == 4 && this.app14_color_transform == 0) {
                for (i = 0; i < this.img_x; ++i) {
                    int m = coutput[3].getAt(i);
                    int r = JpgDecoder.stbi__blinn_8x8(coutput[0].getAt(i), m);
                    int g = JpgDecoder.stbi__blinn_8x8(coutput[1].getAt(i), m);
                    int b2 = JpgDecoder.stbi__blinn_8x8(coutput[2].getAt(i), m);
                    _out_.setAt(0, Utility.stbi__compute_y(r, g, b2));
                    _out_.setAt(1, 255);
                    _out_.move(n);
                }
                continue;
            }
            if (this.img_n == 4 && this.app14_color_transform == 2) {
                for (i = 0; i < this.img_x; ++i) {
                    _out_.setAt(0, JpgDecoder.stbi__blinn_8x8(255 - coutput[0].getAt(i), coutput[3].getAt(i)));
                    _out_.setAt(1, 255);
                    _out_.move(n);
                }
                continue;
            }
            y = coutput[0];
            if (n == 1) {
                for (i = 0; i < this.img_x; ++i) {
                    _out_.setAt(i, y.getAt(i));
                }
                continue;
            }
            for (i = 0; i < this.img_x; ++i) {
                _out_.setAndIncrease(y.getAt(i));
                _out_.setAndIncrease(255);
            }
        }
        this.stbi__cleanup_jpeg();
        out_x = this.img_x;
        out_y = this.img_y;
        comp = this.img_n >= 3 ? 3 : 1;
        return new ImageResult(out_x, out_y, ColorComponents.fromInt(comp), req_comp != null ? req_comp : ColorComponents.fromInt(comp), 8, output);
    }

    private ImageResult InternalDecode(ColorComponents requiredComponents) throws Exception {
        this.stbi__setup_jpeg();
        return this.load_jpeg_image(requiredComponents);
    }

    public static boolean Test(byte[] data) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(data);
            JpgDecoder decoder = new JpgDecoder(stream);
            decoder.stbi__setup_jpeg();
            return decoder.stbi__decode_jpeg_header(1);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static ImageInfo Info(byte[] data) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(data);
            JpgDecoder decoder = new JpgDecoder(stream);
            decoder.stbi__setup_jpeg();
            boolean r = decoder.stbi__decode_jpeg_header(2);
            if (!r) {
                return null;
            }
            return new ImageInfo(decoder.img_x, decoder.img_y, decoder.img_n >= 3 ? ColorComponents.RedGreenBlue : ColorComponents.Grey, 8);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static ImageResult Decode(byte[] data, ColorComponents requiredComponents) throws Exception {
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        JpgDecoder decoder = new JpgDecoder(stream);
        return decoder.InternalDecode(requiredComponents);
    }

    public static ImageResult Decode(byte[] data) throws Exception {
        return JpgDecoder.Decode(data, null);
    }

    private static class stbi__huffman {
        public final int[] code = new int[256];
        public final int[] delta = new int[17];
        public final short[] fast = new short[512];
        public final long[] maxcode = new long[18];
        public final short[] size = new short[257];
        public final short[] values = new short[256];

        private stbi__huffman() {
        }
    }

    private static class img_comp {
        public int id;
        public int h;
        public int v;
        public int tq;
        public int hd;
        public int ha;
        public int dc_pred;
        public int x;
        public int y;
        public int w2;
        public int h2;
        public byte[] raw_data;
        public FakePtrByte data;
        public short[] raw_coeff;
        public FakePtrShort coeff;
        public byte[] linebuf;
        public int coeff_w;
        public int coeff_h;

        private img_comp() {
        }
    }

    private static interface idct_block_kernel {
        public void Do(FakePtrByte var1, int var2, FakePtrShort var3);
    }

    private static interface YCbCr_to_RGB_kernel {
        public void Do(FakePtrByte var1, FakePtrByte var2, FakePtrByte var3, FakePtrByte var4, int var5, int var6);
    }

    private static interface Resampler {
        public FakePtrByte Do(FakePtrByte var1, FakePtrByte var2, FakePtrByte var3, int var4, int var5);
    }

    private static class stbi__resample {
        public int hs;
        public FakePtrByte line0;
        public FakePtrByte line1;
        public Resampler resample;
        public int vs;
        public int w_lores;
        public int ypos;
        public int ystep;

        private stbi__resample() {
        }
    }
}

