/*
 * Decompiled with CFR 0.152.
 */
package org.nothings.stb.image.decoding;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import org.nothings.stb.image.ColorComponents;
import org.nothings.stb.image.ImageInfo;
import org.nothings.stb.image.ImageResult;
import org.nothings.stb.image.decoding.Decoder;
import org.nothings.stb.image.decoding.FakePtrByte;
import org.nothings.stb.image.decoding.Pair;
import org.nothings.stb.image.decoding.Utility;
import org.nothings.stb.image.decoding.ZLib;

public class PngDecoder
extends Decoder {
    private static final int STBI__F_none = 0;
    private static final int STBI__F_sub = 1;
    private static final int STBI__F_up = 2;
    private static final int STBI__F_avg = 3;
    private static final int STBI__F_paeth = 4;
    private static final int STBI__F_avg_first = 5;
    private static final int STBI__F_paeth_first = 6;
    private static final short[] first_row_filter = new short[]{0, 1, 0, 5, 6};
    private static final short[] stbi__depth_scale_table = new short[]{0, 255, 85, 0, 17, 0, 0, 0, 1};
    private static final short[] png_sig = new short[]{137, 80, 78, 71, 13, 10, 26, 10};
    protected int img_out_n;
    private int stbi__unpremultiply_on_load;
    private int stbi__de_iphone_flag;
    private byte[] idata;
    private byte[] expanded;
    private byte[] _out_;
    private int depth;

    private PngDecoder(InputStream stream) {
        super(stream);
    }

    private stbi__pngchunk stbi__get_chunk_header() throws Exception {
        stbi__pngchunk c = new stbi__pngchunk();
        c.length = this.stbi__get32be();
        c.type = (int)this.stbi__get32be();
        return c;
    }

    private static boolean stbi__check_png_header(InputStream input) throws Exception {
        int i = 0;
        for (i = 0; i < 8; ++i) {
            if (Utility.stbi__get8(input) == png_sig[i]) continue;
            return false;
        }
        return true;
    }

    private static int stbi__paeth(int a, int b, int c) {
        int p = a + b - c;
        int pa = Math.abs(p - a);
        int pb = Math.abs(p - b);
        int pc = Math.abs(p - c);
        if (pa <= pb && pa <= pc) {
            return a;
        }
        if (pb <= pc) {
            return b;
        }
        return c;
    }

    private int stbi__create_png_image_raw(FakePtrByte rawOriginal, long raw_len, int out_n, int x, int y, int depth, int color) throws Exception {
        FakePtrByte cur;
        FakePtrByte raw = rawOriginal.clone();
        int shorts = depth == 16 ? 2 : 1;
        int i = 0;
        int j = 0;
        int stride = x * out_n * shorts;
        long img_len = 0L;
        int img_width_shorts = 0;
        int k = 0;
        int output_shorts = out_n * shorts;
        int filter_shorts = this.img_n * shorts;
        int width = x;
        this._out_ = new byte[x * y * output_shorts];
        img_width_shorts = this.img_n * x * depth + 7 >> 3;
        img_len = (img_width_shorts + 1) * y;
        if (raw_len < img_len) {
            PngDecoder.stbi__err("not enough pixels");
        }
        FakePtrByte ptr = new FakePtrByte(this._out_);
        for (j = 0; j < y; ++j) {
            cur = new FakePtrByte(ptr, stride * j);
            int filter = raw.getAndIncrease();
            if (filter > 4) {
                PngDecoder.stbi__err("invalid filter");
            }
            if (depth < 8) {
                cur.move(x * out_n - img_width_shorts);
                filter_shorts = 1;
                width = img_width_shorts;
            }
            FakePtrByte prior = new FakePtrByte(cur, -stride);
            if (j == 0) {
                filter = first_row_filter[filter];
            }
            block28: for (k = 0; k < filter_shorts; ++k) {
                switch (filter) {
                    case 0: {
                        cur.setAt(k, raw.getAt(k));
                        continue block28;
                    }
                    case 1: {
                        cur.setAt(k, raw.getAt(k));
                        continue block28;
                    }
                    case 2: {
                        cur.setAt(k, raw.getAt(k) + prior.getAt(k) & 0xFF);
                        continue block28;
                    }
                    case 3: {
                        cur.setAt(k, raw.getAt(k) + (prior.getAt(k) >> 1) & 0xFF);
                        continue block28;
                    }
                    case 4: {
                        cur.setAt(k, raw.getAt(k) + PngDecoder.stbi__paeth(0, prior.getAt(k), 0) & 0xFF);
                        continue block28;
                    }
                    case 5: {
                        cur.setAt(k, raw.getAt(k));
                        continue block28;
                    }
                    case 6: {
                        cur.setAt(k, raw.getAt(k));
                    }
                }
            }
            if (depth == 8) {
                if (this.img_n != out_n) {
                    cur.setAt(this.img_n, 255);
                }
                raw.move(this.img_n);
                cur.move(out_n);
                prior.move(out_n);
            } else if (depth == 16) {
                if (this.img_n != out_n) {
                    cur.setAt(filter_shorts, 255);
                    cur.setAt(filter_shorts + 1, 255);
                }
                raw.move(filter_shorts);
                cur.move(output_shorts);
                prior.move(output_shorts);
            } else {
                raw.move(1);
                cur.move(1);
                prior.move(1);
            }
            if (depth < 8 || this.img_n == out_n) {
                int nk = (width - 1) * filter_shorts;
                switch (filter) {
                    case 0: {
                        cur.memcpy(raw, nk);
                        break;
                    }
                    case 1: {
                        for (k = 0; k < nk; ++k) {
                            cur.setAt(k, raw.getAt(k) + cur.getAt(k - filter_shorts) & 0xFF);
                        }
                        break;
                    }
                    case 2: {
                        for (k = 0; k < nk; ++k) {
                            cur.setAt(k, raw.getAt(k) + prior.getAt(k) & 0xFF);
                        }
                        break;
                    }
                    case 3: {
                        for (k = 0; k < nk; ++k) {
                            cur.setAt(k, raw.getAt(k) + (prior.getAt(k) + cur.getAt(k - filter_shorts) >> 1) & 0xFF);
                        }
                        break;
                    }
                    case 4: {
                        for (k = 0; k < nk; ++k) {
                            cur.setAt(k, raw.getAt(k) + PngDecoder.stbi__paeth(cur.getAt(k - filter_shorts), prior.getAt(k), prior.getAt(k - filter_shorts)) & 0xFF);
                        }
                        break;
                    }
                    case 5: {
                        for (k = 0; k < nk; ++k) {
                            cur.setAt(k, raw.getAt(k) + (cur.getAt(k - filter_shorts) >> 1) & 0xFF);
                        }
                        break;
                    }
                    case 6: {
                        for (k = 0; k < nk; ++k) {
                            cur.setAt(k, raw.getAt(k) + PngDecoder.stbi__paeth(cur.getAt(k - filter_shorts), 0, 0) & 0xFF);
                        }
                        break;
                    }
                }
                raw.move(nk);
                continue;
            }
            switch (filter) {
                case 0: {
                    for (i = x - 1; i >= 1; --i) {
                        for (k = 0; k < filter_shorts; ++k) {
                            cur.setAt(k, raw.getAt(k));
                        }
                        cur.setAt(filter_shorts, 255);
                        raw.move(filter_shorts);
                        cur.move(output_shorts);
                        prior.move(output_shorts);
                    }
                    break;
                }
                case 1: {
                    for (i = x - 1; i >= 1; --i) {
                        for (k = 0; k < filter_shorts; ++k) {
                            cur.setAt(k, raw.getAt(k) + cur.getAt(k - output_shorts) & 0xFF);
                        }
                        cur.setAt(filter_shorts, 255);
                        raw.move(filter_shorts);
                        cur.move(output_shorts);
                        prior.move(output_shorts);
                    }
                    break;
                }
                case 2: {
                    for (i = x - 1; i >= 1; --i) {
                        for (k = 0; k < filter_shorts; ++k) {
                            cur.setAt(k, raw.getAt(k) + prior.getAt(k) & 0xFF);
                        }
                        cur.setAt(filter_shorts, 255);
                        raw.move(filter_shorts);
                        cur.move(output_shorts);
                        prior.move(output_shorts);
                    }
                    break;
                }
                case 3: {
                    for (i = x - 1; i >= 1; --i) {
                        for (k = 0; k < filter_shorts; ++k) {
                            cur.setAt(k, raw.getAt(k) + (prior.getAt(k) + cur.getAt(k - output_shorts) >> 1) & 0xFF);
                        }
                        cur.setAt(filter_shorts, 255);
                        raw.move(filter_shorts);
                        cur.move(output_shorts);
                        prior.move(output_shorts);
                    }
                    break;
                }
                case 4: {
                    for (i = x - 1; i >= 1; --i) {
                        for (k = 0; k < filter_shorts; ++k) {
                            cur.setAt(k, raw.getAt(k) + PngDecoder.stbi__paeth(cur.getAt(k - output_shorts), prior.getAt(k), prior.getAt(k - output_shorts)) & 0xFF);
                        }
                        cur.setAt(filter_shorts, 255);
                        raw.move(filter_shorts);
                        cur.move(output_shorts);
                        prior.move(output_shorts);
                    }
                    break;
                }
                case 5: {
                    for (i = x - 1; i >= 1; --i) {
                        for (k = 0; k < filter_shorts; ++k) {
                            cur.setAt(k, raw.getAt(k) + (cur.getAt(k - output_shorts) >> 1) & 0xFF);
                        }
                        cur.setAt(filter_shorts, 255);
                        raw.move(filter_shorts);
                        cur.move(output_shorts);
                        prior.move(output_shorts);
                    }
                    break;
                }
                case 6: {
                    for (i = x - 1; i >= 1; --i) {
                        for (k = 0; k < filter_shorts; ++k) {
                            cur.setAt(k, raw.getAt(k) + PngDecoder.stbi__paeth(cur.getAt(k - output_shorts), 0, 0) & 0xFF);
                        }
                        cur.setAt(filter_shorts, 255);
                        raw.move(filter_shorts);
                        cur.move(output_shorts);
                        prior.move(output_shorts);
                    }
                    break;
                }
            }
            if (depth != 16) continue;
            cur = new FakePtrByte(ptr, stride * j);
            for (i = 0; i < x; ++i) {
                cur.setAt(filter_shorts + 1, 255);
                cur.move(output_shorts);
            }
        }
        if (depth < 8) {
            for (j = 0; j < y; ++j) {
                int q;
                short scale;
                cur = new FakePtrByte(ptr, stride * j);
                FakePtrByte _in_ = new FakePtrByte(ptr, stride * j + x * out_n - img_width_shorts);
                short s = scale = color == 0 ? stbi__depth_scale_table[depth] : (short)1;
                if (depth == 4) {
                    for (k = x * this.img_n; k >= 2; k -= 2) {
                        cur.setAndIncrease(scale * (_in_.get() >> 4));
                        cur.setAndIncrease(scale * (_in_.get() & 0xF));
                        _in_.increase();
                    }
                    if (k > 0) {
                        cur.setAndIncrease(scale * (_in_.get() >> 4));
                    }
                } else if (depth == 2) {
                    for (k = x * this.img_n; k >= 4; k -= 4) {
                        cur.setAndIncrease(scale * (_in_.get() >> 6));
                        cur.setAndIncrease(scale * (_in_.get() >> 4 & 3));
                        cur.setAndIncrease(scale * (_in_.get() >> 2 & 3));
                        cur.setAndIncrease(scale * (_in_.get() & 3));
                        _in_.increase();
                    }
                    if (k > 0) {
                        cur.setAndIncrease(scale * (_in_.get() >> 6));
                    }
                    if (k > 1) {
                        cur.setAndIncrease(scale * (_in_.get() >> 4 & 3));
                    }
                    if (k > 2) {
                        cur.setAndIncrease(scale * (_in_.get() >> 2 & 3));
                    }
                } else if (depth == 1) {
                    for (k = x * this.img_n; k >= 8; k -= 8) {
                        cur.setAndIncrease(scale * (_in_.get() >> 7));
                        cur.setAndIncrease(scale * (_in_.get() >> 6 & 1));
                        cur.setAndIncrease(scale * (_in_.get() >> 5 & 1));
                        cur.setAndIncrease(scale * (_in_.get() >> 4 & 1));
                        cur.setAndIncrease(scale * (_in_.get() >> 3 & 1));
                        cur.setAndIncrease(scale * (_in_.get() >> 2 & 1));
                        cur.setAndIncrease(scale * (_in_.get() >> 1 & 1));
                        cur.setAndIncrease(scale * (_in_.get() & 1));
                        _in_.increase();
                    }
                    if (k > 0) {
                        cur.setAndIncrease(scale * (_in_.get() >> 7));
                    }
                    if (k > 1) {
                        cur.setAndIncrease(scale * (_in_.get() >> 6 & 1));
                    }
                    if (k > 2) {
                        cur.setAndIncrease(scale * (_in_.get() >> 5 & 1));
                    }
                    if (k > 3) {
                        cur.setAndIncrease(scale * (_in_.get() >> 4 & 1));
                    }
                    if (k > 4) {
                        cur.setAndIncrease(scale * (_in_.get() >> 3 & 1));
                    }
                    if (k > 5) {
                        cur.setAndIncrease(scale * (_in_.get() >> 2 & 1));
                    }
                    if (k > 6) {
                        cur.setAndIncrease(scale * (_in_.get() >> 1 & 1));
                    }
                }
                if (this.img_n == out_n) continue;
                cur = new FakePtrByte(ptr, stride * j);
                if (this.img_n == 1) {
                    for (q = x - 1; q >= 0; --q) {
                        cur.setAt(q * 2 + 1, 255);
                        cur.setAt(q * 2 + 0, cur.getAt(q));
                    }
                    continue;
                }
                for (q = x - 1; q >= 0; --q) {
                    cur.setAt(q * 4 + 3, 255);
                    cur.setAt(q * 4 + 2, cur.getAt(q * 3 + 2));
                    cur.setAt(q * 4 + 1, cur.getAt(q * 3 + 1));
                    cur.setAt(q * 4 + 0, cur.getAt(q * 3 + 0));
                }
            }
        } else if (depth == 16) {
            throw new UnsupportedOperationException("16-bit images are not supported yet");
        }
        return 1;
    }

    private int stbi__create_png_image(FakePtrByte image_dataOriginal, long image_data_len, int out_n, int depth, int color, int interlaced) throws Exception {
        FakePtrByte image_data = image_dataOriginal.clone();
        int shorts = depth == 16 ? 2 : 1;
        int out_shorts = out_n * shorts;
        int p = 0;
        if (interlaced == 0) {
            return this.stbi__create_png_image_raw(image_data, image_data_len, out_n, this.img_x, this.img_y, depth, color);
        }
        byte[] _final_ = new byte[this.img_x * this.img_y * out_shorts];
        int[] xorig = new int[7];
        int[] yorig = new int[7];
        int[] xspc = new int[7];
        int[] yspc = new int[7];
        for (p = 0; p < 7; ++p) {
            xorig[0] = 0;
            xorig[1] = 4;
            xorig[2] = 0;
            xorig[3] = 2;
            xorig[4] = 0;
            xorig[5] = 1;
            xorig[6] = 0;
            yorig[0] = 0;
            yorig[1] = 0;
            yorig[2] = 4;
            yorig[3] = 0;
            yorig[4] = 2;
            yorig[5] = 0;
            yorig[6] = 1;
            xspc[0] = 8;
            xspc[1] = 8;
            xspc[2] = 4;
            xspc[3] = 4;
            xspc[4] = 2;
            xspc[5] = 2;
            xspc[6] = 1;
            yspc[0] = 8;
            yspc[1] = 8;
            yspc[2] = 8;
            yspc[3] = 4;
            yspc[4] = 4;
            yspc[5] = 2;
            yspc[6] = 2;
            int i = 0;
            int j = 0;
            int x = 0;
            int y = 0;
            x = (this.img_x - xorig[p] + xspc[p] - 1) / xspc[p];
            y = (this.img_y - yorig[p] + yspc[p] - 1) / yspc[p];
            if (x == 0 || y == 0) continue;
            int img_len = ((this.img_n * x * depth + 7 >> 3) + 1) * y;
            if (this.stbi__create_png_image_raw(image_data, image_data_len, out_n, x, y, depth, color) == 0) {
                return 0;
            }
            FakePtrByte finalPtr = new FakePtrByte(_final_);
            FakePtrByte outPtr = new FakePtrByte(this._out_);
            for (j = 0; j < y; ++j) {
                for (i = 0; i < x; ++i) {
                    int out_y = j * yspc[p] + yorig[p];
                    int out_x = i * xspc[p] + xorig[p];
                    FakePtrByte ptr1 = new FakePtrByte(finalPtr, out_y * this.img_x * out_shorts + out_x * out_shorts);
                    FakePtrByte ptr2 = new FakePtrByte(outPtr, (j * x + i) * out_shorts);
                    ptr1.memcpy(ptr2, out_shorts);
                }
            }
            image_data.move(img_len);
            image_data_len -= (long)img_len;
        }
        this._out_ = _final_;
        return 1;
    }

    private int stbi__compute_transparency(short[] tc, int out_n) {
        long i = 0L;
        long pixel_count = this.img_x * this.img_y;
        FakePtrByte p = new FakePtrByte(this._out_);
        if (out_n == 2) {
            for (i = 0L; i < pixel_count; ++i) {
                p.setAt(1, p.getAt(0) == tc[0] ? 0 : 255);
                p.move(2);
            }
        } else {
            for (i = 0L; i < pixel_count; ++i) {
                if (p.getAt(0) == tc[0] && p.getAt(1) == tc[1] && p.getAt(2) == tc[2]) {
                    p.setAt(3, 0);
                }
                p.move(4);
            }
        }
        return 1;
    }

    private int stbi__compute_transparency16(int[] tc, int out_n) {
        throw new UnsupportedOperationException("16-bit images are not supported yet");
    }

    private int stbi__expand_png_palette(short[] palette, int len, int pal_img_n) {
        int i = 0;
        int pixel_count = this.img_x * this.img_y;
        FakePtrByte orig = new FakePtrByte(this._out_);
        this._out_ = new byte[pixel_count * pal_img_n];
        FakePtrByte p = new FakePtrByte(this._out_);
        if (pal_img_n == 3) {
            for (i = 0; i < pixel_count; ++i) {
                int n = orig.getAt(i) * 4;
                p.setAt(0, palette[n]);
                p.setAt(1, palette[n + 1]);
                p.setAt(2, palette[n + 2]);
                p.move(3);
            }
        } else {
            for (i = 0; i < pixel_count; ++i) {
                int n = orig.getAt(i) * 4;
                p.setAt(0, palette[n]);
                p.setAt(1, palette[n + 1]);
                p.setAt(2, palette[n + 2]);
                p.setAt(3, palette[n + 3]);
                p.move(4);
            }
        }
        return 1;
    }

    private void stbi_set_unpremultiply_on_load(int flag_true_if_should_unpremultiply) {
        this.stbi__unpremultiply_on_load = flag_true_if_should_unpremultiply;
    }

    private void stbi_convert_iphone_png_to_rgb(int flag_true_if_should_convert) {
        this.stbi__de_iphone_flag = flag_true_if_should_convert;
    }

    private void stbi__de_iphone() {
        long i = 0L;
        long pixel_count = this.img_x * this.img_y;
        FakePtrByte p = new FakePtrByte(this._out_);
        if (this.img_out_n == 3) {
            for (i = 0L; i < pixel_count; ++i) {
                int t = p.getAt(0);
                p.setAt(0, p.getAt(2));
                p.setAt(2, t);
                p.move(3);
            }
        } else if (this.stbi__unpremultiply_on_load != 0) {
            for (i = 0L; i < pixel_count; ++i) {
                int a = p.getAt(3);
                int t = p.getAt(0);
                if (a != 0) {
                    int half = a / 2;
                    p.setAt(0, (p.getAt(2) * 255 + half) / a);
                    p.setAt(1, (p.getAt(1) * 255 + half) / a);
                    p.setAt(2, (t * 255 + half) / a);
                } else {
                    p.setAt(0, p.getAt(2));
                    p.setAt(2, t);
                }
                p.move(4);
            }
        } else {
            for (i = 0L; i < pixel_count; ++i) {
                int t = p.getAt(0);
                p.setAt(0, p.getAt(2));
                p.setAt(2, t);
                p.move(4);
            }
        }
    }

    private int stbi__parse_png_file(int scan, int req_comp) throws Exception {
        short[] palette = new short[1024];
        int pal_img_n = 0;
        boolean has_trans = false;
        short[] tc = new short[3];
        tc[0] = 0;
        int[] tc16 = new int[3];
        int ioff = 0;
        int idata_limit = 0;
        int i = 0;
        long pal_len = 0L;
        boolean first = true;
        int k = 0;
        short interlace = 0;
        short color = 0;
        boolean is_iphone = false;
        this.expanded = null;
        this.idata = null;
        this._out_ = null;
        if (!PngDecoder.stbi__check_png_header(this.InputStream)) {
            return 0;
        }
        if (scan == 1) {
            return 1;
        }
        while (true) {
            stbi__pngchunk c = this.stbi__get_chunk_header();
            switch (c.type) {
                case 1130840649: {
                    is_iphone = true;
                    this.stbi__skip((int)c.length);
                    break;
                }
                case 1229472850: {
                    short comp = 0;
                    short filter = 0;
                    if (!first) {
                        PngDecoder.stbi__err("multiple IHDR");
                    }
                    first = false;
                    if (c.length != 13L) {
                        PngDecoder.stbi__err("bad IHDR len");
                    }
                    this.img_x = (int)this.stbi__get32be();
                    if (this.img_x > 0x1000000) {
                        PngDecoder.stbi__err("too large");
                    }
                    this.img_y = (int)this.stbi__get32be();
                    if (this.img_y > 0x1000000) {
                        PngDecoder.stbi__err("too large");
                    }
                    this.depth = this.stbi__get8();
                    if (this.depth != 1 && this.depth != 2 && this.depth != 4 && this.depth != 8 && this.depth != 16) {
                        PngDecoder.stbi__err("1/2/4/8/16-bit only");
                    }
                    if ((color = this.stbi__get8()) > 6) {
                        PngDecoder.stbi__err("bad ctype");
                    }
                    if (color == 3 && this.depth == 16) {
                        PngDecoder.stbi__err("bad ctype");
                    }
                    if (color == 3) {
                        pal_img_n = 3;
                    } else if ((color & 1) != 0) {
                        PngDecoder.stbi__err("bad ctype");
                    }
                    comp = this.stbi__get8();
                    if (comp != 0) {
                        PngDecoder.stbi__err("bad comp method");
                    }
                    if ((filter = this.stbi__get8()) != 0) {
                        PngDecoder.stbi__err("bad filter method");
                    }
                    if ((interlace = this.stbi__get8()) > 1) {
                        PngDecoder.stbi__err("bad interlace method");
                    }
                    if (this.img_x == 0 || this.img_y == 0) {
                        PngDecoder.stbi__err("0-pixel image");
                    }
                    if (pal_img_n == 0) {
                        this.img_n = ((color & 2) != 0 ? 3 : 1) + ((color & 4) != 0 ? 1 : 0);
                        if (0x40000000 / this.img_x / this.img_n < this.img_y) {
                            PngDecoder.stbi__err("too large");
                        }
                        if (scan != 2) break;
                        return 1;
                    }
                    this.img_n = 1;
                    if (0x40000000 / this.img_x / 4 >= this.img_y) break;
                    PngDecoder.stbi__err("too large");
                    break;
                }
                case 1347179589: {
                    if (first) {
                        PngDecoder.stbi__err("first not IHDR");
                    }
                    if (c.length > 768L) {
                        PngDecoder.stbi__err("invalid PLTE");
                    }
                    if ((pal_len = c.length / 3L) * 3L != c.length) {
                        PngDecoder.stbi__err("invalid PLTE");
                    }
                    i = 0;
                    while ((long)i < pal_len) {
                        palette[i * 4 + 0] = this.stbi__get8();
                        palette[i * 4 + 1] = this.stbi__get8();
                        palette[i * 4 + 2] = this.stbi__get8();
                        palette[i * 4 + 3] = 255;
                        ++i;
                    }
                    break;
                }
                case 1951551059: {
                    if (first) {
                        PngDecoder.stbi__err("first not IHDR");
                    }
                    if (this.idata != null) {
                        PngDecoder.stbi__err("tRNS after IDAT");
                    }
                    if (pal_img_n != 0) {
                        if (scan == 2) {
                            this.img_n = 4;
                            return 1;
                        }
                        if (pal_len == 0L) {
                            PngDecoder.stbi__err("tRNS before PLTE");
                        }
                        if (c.length > pal_len) {
                            PngDecoder.stbi__err("bad tRNS len");
                        }
                        pal_img_n = 4;
                        i = 0;
                        while ((long)i < c.length) {
                            palette[i * 4 + 3] = this.stbi__get8();
                            ++i;
                        }
                    } else {
                        if ((this.img_n & 1) == 0) {
                            PngDecoder.stbi__err("tRNS with alpha");
                        }
                        if (c.length != (long)this.img_n * 2L) {
                            PngDecoder.stbi__err("bad tRNS len");
                        }
                        has_trans = true;
                        if (this.depth == 16) {
                            for (k = 0; k < this.img_n; ++k) {
                                tc16[k] = this.stbi__get16be();
                            }
                        } else {
                            for (k = 0; k < this.img_n; ++k) {
                                tc[k] = (short)((short)(this.stbi__get16be() & 0xFF) * stbi__depth_scale_table[this.depth]);
                            }
                        }
                    }
                    break;
                }
                case 1229209940: {
                    if (first) {
                        PngDecoder.stbi__err("first not IHDR");
                    }
                    if (pal_img_n != 0 && pal_len == 0L) {
                        PngDecoder.stbi__err("no PLTE");
                    }
                    if (scan == 2) {
                        this.img_n = pal_img_n;
                        return 1;
                    }
                    if ((int)((long)ioff + c.length) < ioff) {
                        return 0;
                    }
                    if ((long)ioff + c.length > (long)idata_limit) {
                        long idata_limit_old = idata_limit;
                        if (idata_limit == 0) {
                            idata_limit = (int)(c.length > 4096L ? c.length : 4096L);
                        }
                        while ((long)ioff + c.length > (long)idata_limit) {
                            idata_limit *= 2;
                        }
                        this.idata = this.idata == null ? new byte[idata_limit] : Arrays.copyOf(this.idata, idata_limit);
                    }
                    if (!this.stbi__getn(this.idata, ioff, (int)c.length)) {
                        PngDecoder.stbi__err("outofdata");
                    }
                    ioff += (int)c.length;
                    break;
                }
                case 1229278788: {
                    int raw_len = 0;
                    long bpl = 0L;
                    if (first) {
                        PngDecoder.stbi__err("first not IHDR");
                    }
                    if (scan != 0) {
                        return 1;
                    }
                    if (this.idata == null) {
                        PngDecoder.stbi__err("no IDAT");
                    }
                    bpl = (this.img_x * this.depth + 7) / 8;
                    raw_len = (int)(bpl * (long)this.img_y * (long)this.img_n + (long)this.img_y);
                    Pair<byte[], Integer> pair = ZLib.stbi_zlib_decode_malloc_guesssize_headerflag(this.idata, ioff, raw_len, is_iphone ? 0 : 1);
                    this.expanded = (byte[])pair.first;
                    raw_len = (Integer)pair.second;
                    if (this.expanded == null) {
                        return 0;
                    }
                    this.idata = null;
                    this.img_out_n = req_comp == this.img_n + 1 && req_comp != 3 && pal_img_n == 0 || has_trans ? this.img_n + 1 : this.img_n;
                    if (this.stbi__create_png_image(new FakePtrByte(this.expanded), raw_len, this.img_out_n, this.depth, color, interlace) == 0) {
                        return 0;
                    }
                    if (has_trans && (this.depth == 16 ? this.stbi__compute_transparency16(tc16, this.img_out_n) == 0 : this.stbi__compute_transparency(tc, this.img_out_n) == 0)) {
                        return 0;
                    }
                    if (is_iphone && this.stbi__de_iphone_flag != 0 && this.img_out_n > 2) {
                        this.stbi__de_iphone();
                    }
                    if (pal_img_n != 0) {
                        this.img_n = pal_img_n;
                        this.img_out_n = pal_img_n;
                        if (req_comp >= 3) {
                            this.img_out_n = req_comp;
                        }
                        if (this.stbi__expand_png_palette(palette, (int)pal_len, this.img_out_n) == 0) {
                            return 0;
                        }
                    } else if (has_trans) {
                        ++this.img_n;
                    }
                    this.expanded = null;
                    return 1;
                }
                default: {
                    if (first) {
                        PngDecoder.stbi__err("first not IHDR");
                    }
                    if ((c.type & 0x20000000) == 0) {
                        PngDecoder.stbi__err(c.type + " PNG chunk not known");
                    }
                    this.stbi__skip((int)c.length);
                }
            }
            this.stbi__get32be();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageResult InternalDecode(ColorComponents requiredComponents) throws Exception {
        int req_comp = ColorComponents.toReqComp(requiredComponents);
        if (req_comp < 0 || req_comp > 4) {
            PngDecoder.stbi__err("bad req_comp");
        }
        try {
            if (this.stbi__parse_png_file(0, req_comp) == 0) {
                PngDecoder.stbi__err("could not parse png");
            }
            int bits_per_channel = 8;
            bits_per_channel = this.depth < 8 ? 8 : this.depth;
            byte[] result = this._out_;
            this._out_ = null;
            if (req_comp != 0 && req_comp != this.img_out_n) {
                result = bits_per_channel == 8 ? Utility.stbi__convert_format(result, this.img_out_n, req_comp, this.img_x, this.img_y) : Utility.stbi__convert_format16(result, this.img_out_n, req_comp, this.img_x, this.img_y);
                this.img_out_n = req_comp;
            }
            ImageResult imageResult = new ImageResult(this.img_x, this.img_y, ColorComponents.fromInt(this.img_n), requiredComponents != null ? requiredComponents : ColorComponents.fromInt(this.img_n), bits_per_channel, result);
            return imageResult;
        }
        finally {
            this._out_ = null;
            this.expanded = null;
            this.idata = null;
        }
    }

    public static boolean Test(byte[] data) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(data);
            return PngDecoder.stbi__check_png_header(stream);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static ImageInfo Info(byte[] data) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(data);
            PngDecoder decoder = new PngDecoder(stream);
            int r = decoder.stbi__parse_png_file(2, 0);
            if (r == 0) {
                return null;
            }
            return new ImageInfo(decoder.img_x, decoder.img_y, ColorComponents.fromInt(decoder.img_n), decoder.depth);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static ImageResult Decode(byte[] data, ColorComponents requiredComponents) throws Exception {
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        PngDecoder decoder = new PngDecoder(stream);
        return decoder.InternalDecode(requiredComponents);
    }

    public static ImageResult Decode(byte[] data) throws Exception {
        return PngDecoder.Decode(data, null);
    }

    private static class stbi__pngchunk {
        public long length;
        public int type;

        private stbi__pngchunk() {
        }
    }
}

