/*
 * Decompiled with CFR 0.152.
 */
package org.nothings.stb.image.decoding;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.nothings.stb.image.ColorComponents;
import org.nothings.stb.image.ImageInfo;
import org.nothings.stb.image.ImageResult;
import org.nothings.stb.image.decoding.Decoder;
import org.nothings.stb.image.decoding.FakePtrByte;
import org.nothings.stb.image.decoding.Utility;

public class PsdDecoder
extends Decoder {
    private PsdDecoder(InputStream stream) {
        super(stream);
    }

    private int stbi__psd_decode_rle(FakePtrByte po, int pixelCount) throws Exception {
        FakePtrByte p = po.clone();
        int count = 0;
        int nleft = 0;
        int len = 0;
        count = 0;
        while ((nleft = pixelCount - count) > 0) {
            len = this.stbi__get8();
            if (len == 128) continue;
            if (len < 128) {
                if (++len > nleft) {
                    return 0;
                }
                count += len;
                while (len != 0) {
                    p.set(this.stbi__get8());
                    p.move(4);
                    --len;
                }
                continue;
            }
            if (len <= 128) continue;
            short val = 0;
            if ((len = 257 - len) > nleft) {
                return 0;
            }
            val = this.stbi__get8();
            count += len;
            while (len != 0) {
                p.set(val);
                p.move(4);
                --len;
            }
        }
        return 1;
    }

    private ImageResult InternalDecode(ColorComponents requiredComponents, int bpc) throws Exception {
        int req_comp;
        FakePtrByte p;
        byte[] _out_;
        int pixelCount = 0;
        int channelCount = 0;
        int compression = 0;
        int channel = 0;
        int i = 0;
        int bitdepth = 0;
        int w = 0;
        int h = 0;
        if (this.stbi__get32be() != 943870035L) {
            PsdDecoder.stbi__err("not PSD");
        }
        if (this.stbi__get16be() != 1) {
            PsdDecoder.stbi__err("wrong version");
        }
        this.stbi__skip(6);
        channelCount = this.stbi__get16be();
        if (channelCount < 0 || channelCount > 16) {
            PsdDecoder.stbi__err("wrong channel count");
        }
        h = (int)this.stbi__get32be();
        w = (int)this.stbi__get32be();
        bitdepth = this.stbi__get16be();
        if (bitdepth != 8 && bitdepth != 16) {
            PsdDecoder.stbi__err("unsupported bit depth");
        }
        if (this.stbi__get16be() != 3) {
            PsdDecoder.stbi__err("wrong color format");
        }
        this.stbi__skip((int)this.stbi__get32be());
        this.stbi__skip((int)this.stbi__get32be());
        this.stbi__skip((int)this.stbi__get32be());
        compression = this.stbi__get16be();
        if (compression > 1) {
            PsdDecoder.stbi__err("bad compression");
        }
        int bits_per_channel = 8;
        if (compression == 0 && bitdepth == 16 && bpc == 16) {
            _out_ = new byte[8 * w * h];
            bits_per_channel = 16;
        } else {
            _out_ = new byte[4 * w * h];
        }
        pixelCount = w * h;
        FakePtrByte ptr = new FakePtrByte(_out_);
        if (compression != 0) {
            this.stbi__skip(h * channelCount * 2);
            for (channel = 0; channel < 4; ++channel) {
                p = new FakePtrByte(ptr, channel);
                if (channel >= channelCount) {
                    for (i = 0; i < pixelCount; ++i) {
                        p.set(channel == 3 ? 255 : 0);
                        p.move(4);
                    }
                    continue;
                }
                if (this.stbi__psd_decode_rle(p, pixelCount) != 0) continue;
                PsdDecoder.stbi__err("corrupt");
            }
        } else {
            for (channel = 0; channel < 4; ++channel) {
                if (channel >= channelCount) {
                    if (bitdepth == 16 && bpc == 16) {
                        throw new UnsupportedOperationException("16-bit images are not supported yet");
                    }
                    p = new FakePtrByte(ptr, channel);
                    short val = (short)(channel == 3 ? 255 : 0);
                    for (i = 0; i < pixelCount; ++i) {
                        p.set(val);
                        p.move(4);
                    }
                    continue;
                }
                if (bits_per_channel == 16) {
                    throw new UnsupportedOperationException("16-bit images are not supported yet");
                }
                p = new FakePtrByte(ptr, channel);
                if (bitdepth == 16) {
                    for (i = 0; i < pixelCount; ++i) {
                        p.set(this.stbi__get16be() >> 8);
                        p.move(4);
                    }
                    continue;
                }
                for (i = 0; i < pixelCount; ++i) {
                    p.set(this.stbi__get8());
                    p.move(4);
                }
            }
        }
        if (channelCount >= 4) {
            if (bits_per_channel == 16) {
                throw new UnsupportedOperationException("16-bit images are not supported yet");
            }
            for (i = 0; i < w * h; ++i) {
                FakePtrByte pixel = new FakePtrByte(ptr, 4 * i);
                if (pixel.getAt(3) == 0 || pixel.getAt(3) == 255) continue;
                float a = (float)pixel.getAt(3) / 255.0f;
                float ra = 1.0f / a;
                float inv_a = 255.0f * (1.0f - ra);
                pixel.setAt(0, (int)((float)pixel.getAt(0) * ra + inv_a));
                pixel.setAt(1, (int)((float)pixel.getAt(1) * ra + inv_a));
                pixel.setAt(2, (int)((float)pixel.getAt(2) * ra + inv_a));
            }
        }
        if ((req_comp = ColorComponents.toReqComp(requiredComponents)) != 0 && req_comp != 4) {
            _out_ = bits_per_channel == 16 ? Utility.stbi__convert_format16(_out_, 4, req_comp, w, h) : Utility.stbi__convert_format(_out_, 4, req_comp, w, h);
        }
        return new ImageResult(w, h, ColorComponents.RedGreenBlueAlpha, requiredComponents != null ? requiredComponents : ColorComponents.RedGreenBlueAlpha, bits_per_channel, _out_);
    }

    public static boolean Test(byte[] data) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(data);
            return Utility.stbi__get32be(stream) == 943870035L;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static ImageInfo Info(byte[] data) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(data);
            if (Utility.stbi__get32be(stream) != 943870035L) {
                return null;
            }
            if (Utility.stbi__get16be(stream) != 1) {
                return null;
            }
            Utility.stbi__skip(stream, 6);
            int channelCount = Utility.stbi__get16be(stream);
            if (channelCount < 0 || channelCount > 16) {
                return null;
            }
            int height = (int)Utility.stbi__get32be(stream);
            int width = (int)Utility.stbi__get32be(stream);
            int depth = Utility.stbi__get16be(stream);
            if (depth != 8 && depth != 16) {
                return null;
            }
            if (Utility.stbi__get16be(stream) != 3) {
                return null;
            }
            return new ImageInfo(width, height, ColorComponents.RedGreenBlueAlpha, depth);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static ImageResult Decode(byte[] data, ColorComponents requiredComponents, int bpc) throws Exception {
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        PsdDecoder decoder = new PsdDecoder(stream);
        return decoder.InternalDecode(requiredComponents, bpc);
    }

    public static ImageResult Decode(byte[] data, ColorComponents requiredComponents) throws Exception {
        return PsdDecoder.Decode(data, requiredComponents, 8);
    }

    public static ImageResult Decode(byte[] data) throws Exception {
        return PsdDecoder.Decode(data, null);
    }
}

