/*
 * Decompiled with CFR 0.152.
 */
package org.nothings.stb.image;

import java.io.IOException;
import org.nothings.stb.image.ColorComponents;
import org.nothings.stb.image.decoding.BmpDecoder;
import org.nothings.stb.image.decoding.GifDecoder;
import org.nothings.stb.image.decoding.JpgDecoder;
import org.nothings.stb.image.decoding.PngDecoder;
import org.nothings.stb.image.decoding.PsdDecoder;
import org.nothings.stb.image.decoding.TgaDecoder;
import org.nothings.stb.image.decoding.Utility;

public class ImageResult {
    private int width;
    private int height;
    private ColorComponents colorComponents;
    private ColorComponents sourceComponents;
    private int bitsPerChannel;
    private byte[] data;

    public ImageResult(int width, int height, ColorComponents sourceComponents, ColorComponents colorComponents, int bitsPerChannel, byte[] data) {
        this.width = width;
        this.height = height;
        this.sourceComponents = sourceComponents;
        this.colorComponents = colorComponents;
        this.bitsPerChannel = bitsPerChannel;
        this.data = data;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public ColorComponents getColorComponents() {
        return this.colorComponents;
    }

    public ColorComponents getSourceComponents() {
        return this.sourceComponents;
    }

    public int getBitsPerChannel() {
        return this.bitsPerChannel;
    }

    public byte[] getData() {
        return this.data;
    }

    public static ImageResult FromData(byte[] data, ColorComponents requiredComponents, boolean use8BitsPerChannel) throws IOException {
        ImageResult result = null;
        if (JpgDecoder.Test(data)) {
            result = JpgDecoder.Decode(data, requiredComponents);
        } else if (PngDecoder.Test(data)) {
            result = PngDecoder.Decode(data, requiredComponents);
        } else if (BmpDecoder.Test(data)) {
            result = BmpDecoder.Decode(data, requiredComponents);
        } else if (GifDecoder.Test(data)) {
            result = GifDecoder.Decode(data, requiredComponents);
        } else if (PsdDecoder.Test(data)) {
            result = PsdDecoder.Decode(data, requiredComponents);
        } else if (TgaDecoder.Test(data)) {
            result = TgaDecoder.Decode(data, requiredComponents);
        }
        if (result == null) {
            throw new IOException("unknown image type");
        }
        if (use8BitsPerChannel && result.bitsPerChannel != 8) {
            result.data = Utility.stbi__convert_16_to_8(result.data, result.width, result.height, result.colorComponents.getValue());
        }
        return result;
    }
}

