/*
 * Decompiled with CFR 0.152.
 */
package org.nothings.stb.image.decoding;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.nothings.stb.image.ColorComponents;
import org.nothings.stb.image.ImageInfo;
import org.nothings.stb.image.ImageResult;
import org.nothings.stb.image.decoding.Decoder;
import org.nothings.stb.image.decoding.FakePtrByte;
import org.nothings.stb.image.decoding.Utility;

public class PsdDecoder
extends Decoder {
    private PsdDecoder(InputStream stream) {
        super(stream);
    }

    private int stbi__psd_decode_rle(FakePtrByte po, int pixelCount) throws IOException {
        FakePtrByte p = po.clone();
        int count = 0;
        int nleft = 0;
        int len = 0;
        count = 0;
        while ((nleft = pixelCount - count) > 0) {
            len = this.stbi__get8();
            if (len == 128) continue;
            if (len < 128) {
                if (++len > nleft) {
                    return 0;
                }
                count += len;
                while (len != 0) {
                    p.set(this.stbi__get8());
                    p.move(4);
                    --len;
                }
                continue;
            }
            if (len <= 128) continue;
            short val = 0;
            if ((len = 257 - len) > nleft) {
                return 0;
            }
            val = this.stbi__get8();
            count += len;
            while (len != 0) {
                p.set(val);
                p.move(4);
                --len;
            }
        }
        return 1;
    }

    private int stbi__psd_decode_rle16(FakePtrByte po, int pixelCount) throws IOException {
        FakePtrByte p = po.clone();
        int count = 0;
        while (pixelCount - count > 0) {
            int len = this.stbi__get8();
            if (len == 128) continue;
            if (len < 128) {
                if (++len > pixelCount - count) {
                    return 0;
                }
                count += len;
                while (len-- != 0) {
                    int v = this.stbi__get16be();
                    p.set((short)(v >> 8 & 0xFF));
                    p.setAt(1, (short)(v & 0xFF));
                    p.move(8);
                }
                continue;
            }
            int run = 257 - len;
            if (run > pixelCount - count) {
                return 0;
            }
            int v = this.stbi__get16be();
            count += run;
            while (run-- != 0) {
                p.set((short)(v >> 8 & 0xFF));
                p.setAt(1, (short)(v & 0xFF));
                p.move(8);
            }
        }
        return 1;
    }

    private ImageResult InternalDecode(ColorComponents requiredComponents, int bpc) throws IOException {
        int req_comp;
        short val;
        int i;
        int lo;
        int hi;
        FakePtrByte p;
        int channel;
        if (this.stbi__get32be() != 943870035L) {
            PsdDecoder.stbi__err("not PSD");
        }
        if (this.stbi__get16be() != 1) {
            PsdDecoder.stbi__err("wrong version");
        }
        this.stbi__skip(6);
        int channelCount = this.stbi__get16be();
        if (channelCount < 0 || channelCount > 16) {
            PsdDecoder.stbi__err("wrong channel count");
        }
        int h = (int)this.stbi__get32be();
        int w = (int)this.stbi__get32be();
        int bitdepth = this.stbi__get16be();
        if (bitdepth != 8 && bitdepth != 16) {
            PsdDecoder.stbi__err("unsupported bit depth");
        }
        if (this.stbi__get16be() != 3) {
            PsdDecoder.stbi__err("wrong color format");
        }
        this.stbi__skip((int)this.stbi__get32be());
        this.stbi__skip((int)this.stbi__get32be());
        this.stbi__skip((int)this.stbi__get32be());
        int compression = this.stbi__get16be();
        if (compression > 1) {
            PsdDecoder.stbi__err("bad compression");
        }
        int bits_per_channel = bitdepth == 16 && bpc == 16 ? 16 : 8;
        byte[] _out_ = new byte[(bits_per_channel == 16 ? 8 : 4) * w * h];
        int pixelCount = w * h;
        FakePtrByte ptr = new FakePtrByte(_out_);
        if (compression != 0) {
            this.stbi__skip(h * channelCount * 2);
            for (channel = 0; channel < 4; ++channel) {
                p = new FakePtrByte(ptr, channel);
                if (channel >= channelCount) {
                    if (bits_per_channel == 16) {
                        hi = channel == 3 ? 255 : 0;
                        lo = channel == 3 ? 255 : 0;
                        for (i = 0; i < pixelCount; ++i) {
                            p.set((short)hi);
                            p.setAt(1, (short)lo);
                            p.move(8);
                        }
                        continue;
                    }
                    val = (short)(channel == 3 ? 255 : 0);
                    for (i = 0; i < pixelCount; ++i) {
                        p.set(val);
                        p.move(4);
                    }
                    continue;
                }
                if (bits_per_channel == 16) {
                    if (this.stbi__psd_decode_rle16(p, pixelCount) != 0) continue;
                    PsdDecoder.stbi__err("corrupt");
                    continue;
                }
                if (this.stbi__psd_decode_rle(p, pixelCount) != 0) continue;
                PsdDecoder.stbi__err("corrupt");
            }
        } else {
            for (channel = 0; channel < 4; ++channel) {
                p = new FakePtrByte(ptr, channel);
                if (channel >= channelCount) {
                    if (bits_per_channel == 16) {
                        hi = channel == 3 ? 255 : 0;
                        lo = channel == 3 ? 255 : 0;
                        for (i = 0; i < pixelCount; ++i) {
                            p.set((short)hi);
                            p.setAt(1, (short)lo);
                            p.move(8);
                        }
                        continue;
                    }
                    val = (short)(channel == 3 ? 255 : 0);
                    for (i = 0; i < pixelCount; ++i) {
                        p.set(val);
                        p.move(4);
                    }
                    continue;
                }
                if (bits_per_channel == 16) {
                    for (i = 0; i < pixelCount; ++i) {
                        int v = this.stbi__get16be();
                        p.set((short)(v >> 8 & 0xFF));
                        p.setAt(1, (short)(v & 0xFF));
                        p.move(8);
                    }
                    continue;
                }
                if (bitdepth == 16) {
                    for (i = 0; i < pixelCount; ++i) {
                        p.set((short)(this.stbi__get16be() >> 8));
                        p.move(4);
                    }
                    continue;
                }
                for (i = 0; i < pixelCount; ++i) {
                    p.set(this.stbi__get8());
                    p.move(4);
                }
            }
        }
        if (channelCount >= 4) {
            if (bits_per_channel == 16) {
                for (int px = 0; px < w * h; ++px) {
                    int off = px * 8;
                    int r = (_out_[off] & 0xFF) << 8 | _out_[off + 1] & 0xFF;
                    int g = (_out_[off + 2] & 0xFF) << 8 | _out_[off + 3] & 0xFF;
                    int b = (_out_[off + 4] & 0xFF) << 8 | _out_[off + 5] & 0xFF;
                    int a = (_out_[off + 6] & 0xFF) << 8 | _out_[off + 7] & 0xFF;
                    if (a == 0 || a == 65535) continue;
                    float af = (float)a / 65535.0f;
                    float ra = 1.0f / af;
                    float inv_a = 65535.0f * (1.0f - ra);
                    int nr = (int)((float)r * ra + inv_a);
                    int ng = (int)((float)g * ra + inv_a);
                    int nb = (int)((float)b * ra + inv_a);
                    if (nr < 0) {
                        nr = 0;
                    } else if (nr > 65535) {
                        nr = 65535;
                    }
                    if (ng < 0) {
                        ng = 0;
                    } else if (ng > 65535) {
                        ng = 65535;
                    }
                    if (nb < 0) {
                        nb = 0;
                    } else if (nb > 65535) {
                        nb = 65535;
                    }
                    _out_[off] = (byte)(nr >> 8 & 0xFF);
                    _out_[off + 1] = (byte)(nr & 0xFF);
                    _out_[off + 2] = (byte)(ng >> 8 & 0xFF);
                    _out_[off + 3] = (byte)(ng & 0xFF);
                    _out_[off + 4] = (byte)(nb >> 8 & 0xFF);
                    _out_[off + 5] = (byte)(nb & 0xFF);
                }
            } else {
                for (i = 0; i < w * h; ++i) {
                    int off = 4 * i;
                    int a = _out_[off + 3] & 0xFF;
                    if (a == 0 || a == 255) continue;
                    float af = (float)a / 255.0f;
                    float ra = 1.0f / af;
                    float inv_a = 255.0f * (1.0f - ra);
                    _out_[off] = (byte)((float)(_out_[off] & 0xFF) * ra + inv_a);
                    _out_[off + 1] = (byte)((float)(_out_[off + 1] & 0xFF) * ra + inv_a);
                    _out_[off + 2] = (byte)((float)(_out_[off + 2] & 0xFF) * ra + inv_a);
                }
            }
        }
        if ((req_comp = ColorComponents.toReqComp(requiredComponents)) != 0 && req_comp != 4) {
            _out_ = bits_per_channel == 16 ? Utility.stbi__convert_format16(_out_, 4, req_comp, w, h) : Utility.stbi__convert_format(_out_, 4, req_comp, w, h);
        }
        return new ImageResult(w, h, ColorComponents.RedGreenBlueAlpha, requiredComponents != null ? requiredComponents : ColorComponents.RedGreenBlueAlpha, bits_per_channel, _out_);
    }

    public static boolean Test(byte[] data) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(data);
            return Utility.stbi__get32be(stream) == 943870035L;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static ImageInfo Info(byte[] data) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(data);
            if (Utility.stbi__get32be(stream) != 943870035L) {
                return null;
            }
            if (Utility.stbi__get16be(stream) != 1) {
                return null;
            }
            Utility.stbi__skip(stream, 6);
            int channelCount = Utility.stbi__get16be(stream);
            if (channelCount < 0 || channelCount > 16) {
                return null;
            }
            int height = (int)Utility.stbi__get32be(stream);
            int width = (int)Utility.stbi__get32be(stream);
            int depth = Utility.stbi__get16be(stream);
            if (depth != 8 && depth != 16) {
                return null;
            }
            if (Utility.stbi__get16be(stream) != 3) {
                return null;
            }
            return new ImageInfo(width, height, ColorComponents.RedGreenBlueAlpha, depth);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static ImageResult Decode(byte[] data, ColorComponents requiredComponents, int bpc) throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        PsdDecoder decoder = new PsdDecoder(stream);
        return decoder.InternalDecode(requiredComponents, bpc);
    }

    public static ImageResult Decode(byte[] data, ColorComponents requiredComponents) throws IOException {
        return PsdDecoder.Decode(data, requiredComponents, 8);
    }

    public static ImageResult Decode(byte[] data) throws IOException {
        return PsdDecoder.Decode(data, null);
    }
}

