/*
 * Decompiled with CFR 0.152.
 */
package org.nothings.stb.image.decoding;

import java.io.IOException;
import java.io.InputStream;
import org.nothings.stb.image.decoding.Decoder;
import org.nothings.stb.image.decoding.FakePtrByte;

public class Utility {
    public static int stbi__bitreverse16(int n) {
        n = (n & 0xAAAA) >> 1 | (n & 0x5555) << 1;
        n = (n & 0xCCCC) >> 2 | (n & 0x3333) << 2;
        n = (n & 0xF0F0) >> 4 | (n & 0xF0F) << 4;
        n = (n & 0xFF00) >> 8 | (n & 0xFF) << 8;
        return n;
    }

    public static int stbi__bit_reverse(int v, int bits) {
        return Utility.stbi__bitreverse16(v) >> 16 - bits;
    }

    public static long _lrotl(long x, int y) {
        return x << y | x >> 32 - y;
    }

    protected static void stbi__skip(InputStream s, int count) throws IOException {
        s.skip(count);
    }

    public static short stbi__get8(InputStream s) throws IOException {
        int b = s.read();
        if (b == -1) {
            throw new IOException("EOF");
        }
        return (short)b;
    }

    public static int stbi__get16be(InputStream s) throws IOException {
        short z = Utility.stbi__get8(s);
        return (z << 8) + Utility.stbi__get8(s);
    }

    public static long stbi__get32be(InputStream s) throws IOException {
        long z = Utility.stbi__get16be(s);
        return (z << 16) + (long)Utility.stbi__get16be(s);
    }

    public static int stbi__get16le(InputStream s) throws IOException {
        short z = Utility.stbi__get8(s);
        return z + (Utility.stbi__get8(s) << 8);
    }

    public static long stbi__get32le(InputStream s) throws IOException {
        long z = Utility.stbi__get16le(s);
        return z + (long)(Utility.stbi__get16le(s) << 16);
    }

    public static short stbi__compute_y(int r, int g, int b) {
        return (short)(r * 77 + g * 150 + 29 * b >> 8);
    }

    public static int stbi__compute_y_16(int r, int g, int b) {
        return r * 77 + g * 150 + 29 * b >> 8;
    }

    public static byte[] stbi__convert_format16(byte[] data, int img_n, int req_comp, long x, long y) throws IOException {
        int xi = (int)x;
        int yi = (int)y;
        if (req_comp == img_n) {
            return data;
        }
        int inStep = img_n * 2;
        int outStep = req_comp * 2;
        byte[] out = new byte[yi * xi * outStep];
        block14: for (int j = 0; j < yi; ++j) {
            int srcRow = j * xi * inStep;
            int dstRow = j * xi * outStep;
            switch (img_n * 8 + req_comp) {
                case 10: {
                    int d;
                    int s;
                    int i;
                    for (i = xi - 1; i >= 0; --i) {
                        s = srcRow + i * inStep;
                        d = dstRow + i * outStep;
                        out[d] = data[s];
                        out[d + 1] = data[s + 1];
                        out[d + 2] = -1;
                        out[d + 3] = -1;
                    }
                    continue block14;
                }
                case 11: {
                    byte gl;
                    byte gh;
                    int d;
                    int s;
                    int i;
                    for (i = xi - 1; i >= 0; --i) {
                        s = srcRow + i * inStep;
                        d = dstRow + i * outStep;
                        gh = data[s];
                        gl = data[s + 1];
                        out[d] = gh;
                        out[d + 1] = gl;
                        out[d + 2] = gh;
                        out[d + 3] = gl;
                        out[d + 4] = gh;
                        out[d + 5] = gl;
                    }
                    continue block14;
                }
                case 12: {
                    byte gl;
                    byte gh;
                    int d;
                    int s;
                    int i;
                    for (i = xi - 1; i >= 0; --i) {
                        s = srcRow + i * inStep;
                        d = dstRow + i * outStep;
                        gh = data[s];
                        gl = data[s + 1];
                        out[d] = gh;
                        out[d + 1] = gl;
                        out[d + 2] = gh;
                        out[d + 3] = gl;
                        out[d + 4] = gh;
                        out[d + 5] = gl;
                        out[d + 6] = -1;
                        out[d + 7] = -1;
                    }
                    continue block14;
                }
                case 17: {
                    int d;
                    int s;
                    int i;
                    for (i = xi - 1; i >= 0; --i) {
                        s = srcRow + i * inStep;
                        d = dstRow + i * outStep;
                        out[d] = data[s];
                        out[d + 1] = data[s + 1];
                    }
                    continue block14;
                }
                case 19: {
                    byte gl;
                    byte gh;
                    int d;
                    int s;
                    int i;
                    for (i = xi - 1; i >= 0; --i) {
                        s = srcRow + i * inStep;
                        d = dstRow + i * outStep;
                        gh = data[s];
                        gl = data[s + 1];
                        out[d] = gh;
                        out[d + 1] = gl;
                        out[d + 2] = gh;
                        out[d + 3] = gl;
                        out[d + 4] = gh;
                        out[d + 5] = gl;
                    }
                    continue block14;
                }
                case 20: {
                    byte gl;
                    byte gh;
                    int d;
                    int s;
                    int i;
                    for (i = xi - 1; i >= 0; --i) {
                        s = srcRow + i * inStep;
                        d = dstRow + i * outStep;
                        gh = data[s];
                        gl = data[s + 1];
                        out[d] = gh;
                        out[d + 1] = gl;
                        out[d + 2] = gh;
                        out[d + 3] = gl;
                        out[d + 4] = gh;
                        out[d + 5] = gl;
                        out[d + 6] = data[s + 2];
                        out[d + 7] = data[s + 3];
                    }
                    continue block14;
                }
                case 28: {
                    int d;
                    int s;
                    int i;
                    for (i = xi - 1; i >= 0; --i) {
                        s = srcRow + i * inStep;
                        d = dstRow + i * outStep;
                        out[d] = data[s];
                        out[d + 1] = data[s + 1];
                        out[d + 2] = data[s + 2];
                        out[d + 3] = data[s + 3];
                        out[d + 4] = data[s + 4];
                        out[d + 5] = data[s + 5];
                        out[d + 6] = -1;
                        out[d + 7] = -1;
                    }
                    continue block14;
                }
                case 25: {
                    int y16;
                    int b;
                    int g;
                    int r;
                    int d;
                    int s;
                    int i;
                    for (i = xi - 1; i >= 0; --i) {
                        s = srcRow + i * inStep;
                        d = dstRow + i * outStep;
                        r = (data[s] & 0xFF) << 8 | data[s + 1] & 0xFF;
                        g = (data[s + 2] & 0xFF) << 8 | data[s + 3] & 0xFF;
                        b = (data[s + 4] & 0xFF) << 8 | data[s + 5] & 0xFF;
                        y16 = Utility.stbi__compute_y_16(r, g, b) & 0xFFFF;
                        out[d] = (byte)(y16 >> 8 & 0xFF);
                        out[d + 1] = (byte)(y16 & 0xFF);
                    }
                    continue block14;
                }
                case 26: {
                    int y16;
                    int b;
                    int g;
                    int r;
                    int d;
                    int s;
                    int i;
                    for (i = xi - 1; i >= 0; --i) {
                        s = srcRow + i * inStep;
                        d = dstRow + i * outStep;
                        r = (data[s] & 0xFF) << 8 | data[s + 1] & 0xFF;
                        g = (data[s + 2] & 0xFF) << 8 | data[s + 3] & 0xFF;
                        b = (data[s + 4] & 0xFF) << 8 | data[s + 5] & 0xFF;
                        y16 = Utility.stbi__compute_y_16(r, g, b) & 0xFFFF;
                        out[d] = (byte)(y16 >> 8 & 0xFF);
                        out[d + 1] = (byte)(y16 & 0xFF);
                        out[d + 2] = -1;
                        out[d + 3] = -1;
                    }
                    continue block14;
                }
                case 33: {
                    int y16;
                    int b;
                    int g;
                    int r;
                    int d;
                    int s;
                    int i;
                    for (i = xi - 1; i >= 0; --i) {
                        s = srcRow + i * inStep;
                        d = dstRow + i * outStep;
                        r = (data[s] & 0xFF) << 8 | data[s + 1] & 0xFF;
                        g = (data[s + 2] & 0xFF) << 8 | data[s + 3] & 0xFF;
                        b = (data[s + 4] & 0xFF) << 8 | data[s + 5] & 0xFF;
                        y16 = Utility.stbi__compute_y_16(r, g, b) & 0xFFFF;
                        out[d] = (byte)(y16 >> 8 & 0xFF);
                        out[d + 1] = (byte)(y16 & 0xFF);
                    }
                    continue block14;
                }
                case 34: {
                    int y16;
                    int b;
                    int g;
                    int r;
                    int d;
                    int s;
                    int i;
                    for (i = xi - 1; i >= 0; --i) {
                        s = srcRow + i * inStep;
                        d = dstRow + i * outStep;
                        r = (data[s] & 0xFF) << 8 | data[s + 1] & 0xFF;
                        g = (data[s + 2] & 0xFF) << 8 | data[s + 3] & 0xFF;
                        b = (data[s + 4] & 0xFF) << 8 | data[s + 5] & 0xFF;
                        y16 = Utility.stbi__compute_y_16(r, g, b) & 0xFFFF;
                        out[d] = (byte)(y16 >> 8 & 0xFF);
                        out[d + 1] = (byte)(y16 & 0xFF);
                        out[d + 2] = data[s + 6];
                        out[d + 3] = data[s + 7];
                    }
                    continue block14;
                }
                case 35: {
                    int d;
                    int s;
                    int i;
                    for (i = xi - 1; i >= 0; --i) {
                        s = srcRow + i * inStep;
                        d = dstRow + i * outStep;
                        out[d] = data[s];
                        out[d + 1] = data[s + 1];
                        out[d + 2] = data[s + 2];
                        out[d + 3] = data[s + 3];
                        out[d + 4] = data[s + 4];
                        out[d + 5] = data[s + 5];
                    }
                    continue block14;
                }
                default: {
                    Decoder.stbi__err("0");
                }
            }
        }
        return out;
    }

    public static byte[] stbi__convert_format(byte[] data, int img_n, int req_comp, int x, int y) throws IOException {
        int i = 0;
        int j = 0;
        if (req_comp == img_n) {
            return data;
        }
        byte[] good = new byte[req_comp * x * y];
        block14: for (j = 0; j < y; ++j) {
            FakePtrByte src = new FakePtrByte(data, j * x * img_n);
            FakePtrByte dest = new FakePtrByte(good, j * x * req_comp);
            switch (img_n * 8 + req_comp) {
                case 10: {
                    for (i = x - 1; i >= 0; --i) {
                        dest.setAt(0, src.getAt(0));
                        dest.setAt(1, 255);
                        src.increase();
                        dest.move(2);
                    }
                    continue block14;
                }
                case 11: {
                    int val;
                    for (i = x - 1; i >= 0; --i) {
                        val = src.getAt(0);
                        dest.setAt(0, val);
                        dest.setAt(1, val);
                        dest.setAt(2, val);
                        src.increase();
                        dest.move(3);
                    }
                    continue block14;
                }
                case 12: {
                    int val;
                    for (i = x - 1; i >= 0; --i) {
                        val = src.getAt(0);
                        dest.setAt(0, val);
                        dest.setAt(1, val);
                        dest.setAt(2, val);
                        dest.setAt(3, 255);
                        src.increase();
                        dest.move(4);
                    }
                    continue block14;
                }
                case 17: {
                    int val;
                    for (i = x - 1; i >= 0; --i) {
                        val = src.getAt(0);
                        dest.setAt(0, val);
                        src.move(2);
                        dest.move(1);
                    }
                    continue block14;
                }
                case 19: {
                    int val;
                    for (i = x - 1; i >= 0; --i) {
                        val = src.getAt(0);
                        dest.setAt(0, val);
                        dest.setAt(1, val);
                        dest.setAt(2, val);
                        src.move(2);
                        dest.move(3);
                    }
                    continue block14;
                }
                case 20: {
                    int val;
                    for (i = x - 1; i >= 0; --i) {
                        val = src.getAt(0);
                        dest.setAt(0, val);
                        dest.setAt(1, val);
                        dest.setAt(2, val);
                        dest.setAt(3, src.getAt(1));
                        src.move(2);
                        dest.move(4);
                    }
                    continue block14;
                }
                case 28: {
                    for (i = x - 1; i >= 0; --i) {
                        dest.setAt(0, src.getAt(0));
                        dest.setAt(1, src.getAt(1));
                        dest.setAt(2, src.getAt(2));
                        dest.setAt(3, 255);
                        src.move(3);
                        dest.move(4);
                    }
                    continue block14;
                }
                case 25: {
                    for (i = x - 1; i >= 0; --i) {
                        dest.setAt(0, Utility.stbi__compute_y(src.getAt(0), src.getAt(1), src.getAt(2)));
                        src.move(3);
                        dest.move(1);
                    }
                    continue block14;
                }
                case 26: {
                    for (i = x - 1; i >= 0; --i) {
                        dest.setAt(0, Utility.stbi__compute_y(src.getAt(0), src.getAt(1), src.getAt(2)));
                        dest.setAt(1, 255);
                        src.move(3);
                        dest.move(2);
                    }
                    continue block14;
                }
                case 33: {
                    for (i = x - 1; i >= 0; --i) {
                        dest.setAt(0, Utility.stbi__compute_y(src.getAt(0), src.getAt(1), src.getAt(2)));
                        src.move(4);
                        dest.move(1);
                    }
                    continue block14;
                }
                case 34: {
                    for (i = x - 1; i >= 0; --i) {
                        dest.setAt(0, Utility.stbi__compute_y(src.getAt(0), src.getAt(1), src.getAt(2)));
                        dest.setAt(1, src.getAt(3));
                        src.move(4);
                        dest.move(2);
                    }
                    continue block14;
                }
                case 35: {
                    for (i = x - 1; i >= 0; --i) {
                        dest.setAt(0, src.getAt(0));
                        dest.setAt(1, src.getAt(1));
                        dest.setAt(2, src.getAt(2));
                        src.move(4);
                        dest.move(3);
                    }
                    continue block14;
                }
                default: {
                    Decoder.stbi__err("0");
                }
            }
        }
        return good;
    }

    public static byte[] stbi__convert_16_to_8(byte[] data16be) {
        int nSamples = data16be.length / 2;
        byte[] out = new byte[nSamples];
        int i = 0;
        int s = 0;
        while (i < nSamples) {
            out[i] = data16be[s];
            ++i;
            s += 2;
        }
        return out;
    }

    public static byte[] stbi__convert_16_to_8(byte[] orig, int w, int h, int channels) {
        int expected = w * h * channels * 2;
        if (orig.length != expected) {
            return Utility.stbi__convert_16_to_8(orig);
        }
        byte[] out = new byte[w * h * channels];
        int i = 0;
        int s = 0;
        while (i < out.length) {
            out[i] = orig[s];
            ++i;
            s += 2;
        }
        return out;
    }
}

