/*
 * Decompiled with CFR 0.152.
 */
package org.nothings.stb.image.decoding;

import java.io.IOException;
import java.util.Arrays;
import org.nothings.stb.image.decoding.Decoder;
import org.nothings.stb.image.decoding.FakePtrByte;
import org.nothings.stb.image.decoding.FakePtrShort;
import org.nothings.stb.image.decoding.Pair;
import org.nothings.stb.image.decoding.Utility;

class ZLib {
    private static final int[] stbi__zlength_base = new int[]{3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31, 35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258, 0, 0};
    private static final int[] stbi__zlength_extra = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0, 0, 0};
    private static final int[] stbi__zdist_base = new int[]{1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193, 257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145, 8193, 12289, 16385, 24577, 0, 0};
    private static final int[] stbi__zdist_extra = new int[]{0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13};
    private static final short[] stbi__zdefault_length = new short[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8};
    private static final short[] stbi__zdefault_distance = new short[]{5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5};
    private static final short[] length_dezigzag = new short[]{16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15};
    private long code_buffer;
    private int num_bits;
    private final stbi__zhuffman z_distance = new stbi__zhuffman();
    private int z_expandable;
    private final stbi__zhuffman z_length = new stbi__zhuffman();
    private FakePtrByte zbuffer;
    private FakePtrByte zbuffer_end;
    private FakePtrByte zout;
    private FakePtrByte zout_end;
    private byte[] zout_start;

    ZLib() {
    }

    private int stbi__zget8() {
        if (this.zbuffer.offset >= this.zbuffer_end.offset) {
            return 0;
        }
        return this.zbuffer.getAndIncrease();
    }

    private void stbi__fill_bits() {
        do {
            this.code_buffer |= (long)this.stbi__zget8() << this.num_bits;
            this.num_bits += 8;
        } while (this.num_bits <= 24);
    }

    private long stbi__zreceive(int n) {
        long k = 0L;
        if (this.num_bits < n) {
            this.stbi__fill_bits();
        }
        k = this.code_buffer & (long)((1 << n) - 1);
        this.code_buffer >>= n;
        this.num_bits -= n;
        return k;
    }

    private int stbi__zhuffman_decode_slowpath(stbi__zhuffman z) {
        int b = 0;
        int s = 0;
        int k = 0;
        k = Utility.stbi__bit_reverse((int)this.code_buffer, 16);
        s = 10;
        while (k >= z.maxcode[s]) {
            ++s;
        }
        if (s == 16) {
            return -1;
        }
        b = (k >> 16 - s) - z.firstcode[s] + z.firstsymbol[s];
        this.code_buffer >>= s;
        this.num_bits -= s;
        return z.value[b];
    }

    private int stbi__zhuffman_decode(stbi__zhuffman z) {
        int b = 0;
        int s = 0;
        if (this.num_bits < 16) {
            this.stbi__fill_bits();
        }
        if ((b = z.fast[(int)this.code_buffer & 0x1FF]) != 0) {
            s = b >> 9;
            this.code_buffer >>= s;
            this.num_bits -= s;
            return b & 0x1FF;
        }
        return this.stbi__zhuffman_decode_slowpath(z);
    }

    private int stbi__zexpand(FakePtrByte zout, int n) throws IOException {
        int cur = 0;
        int limit = 0;
        int old_limit = 0;
        this.zout = zout.clone();
        if (this.z_expandable == 0) {
            Decoder.stbi__err("output buffer limit");
        }
        cur = this.zout.offset;
        for (limit = old_limit = this.zout_end.offset; cur + n > limit; limit *= 2) {
        }
        this.zout_start = Arrays.copyOf(this.zout_start, limit);
        this.zout = new FakePtrByte(this.zout_start, cur);
        this.zout_end = new FakePtrByte(this.zout_start, limit);
        return 1;
    }

    private int stbi__parse_huffman_block() throws IOException {
        FakePtrByte zout = this.zout.clone();
        while (true) {
            int z;
            if ((z = this.stbi__zhuffman_decode(this.z_length)) < 256) {
                if (z < 0) {
                    Decoder.stbi__err("bad huffman code");
                }
                if (zout.offset >= this.zout_end.offset) {
                    if (this.stbi__zexpand(zout, 1) == 0) {
                        return 0;
                    }
                    zout = this.zout.clone();
                }
                zout.setAndIncrease((short)z);
                continue;
            }
            int len = 0;
            int dist = 0;
            if (z == 256) {
                this.zout = zout;
                return 1;
            }
            len = stbi__zlength_base[z -= 257];
            if (stbi__zlength_extra[z] != 0) {
                len += (int)this.stbi__zreceive(stbi__zlength_extra[z]);
            }
            if ((z = this.stbi__zhuffman_decode(this.z_distance)) < 0) {
                Decoder.stbi__err("bad huffman code");
            }
            dist = stbi__zdist_base[z];
            if (stbi__zdist_extra[z] != 0) {
                dist += (int)this.stbi__zreceive(stbi__zdist_extra[z]);
            }
            if (zout.offset < dist) {
                Decoder.stbi__err("bad dist");
            }
            if (zout.offset + len > this.zout_end.offset) {
                if (this.stbi__zexpand(zout, len) == 0) {
                    return 0;
                }
                zout = this.zout.clone();
            }
            if (dist == 1) {
                if (len <= 0) continue;
                int v = zout.getAt(-dist);
                zout.fillAndIncrease(v, len);
                continue;
            }
            if (len <= 0) continue;
            FakePtrByte p = new FakePtrByte(zout, -dist);
            do {
                zout.setAndIncrease(p.getAndIncrease());
            } while (--len != 0);
        }
    }

    private static int stbi__zbuild_huffman(stbi__zhuffman z, FakePtrShort sizelist, int num) throws IOException {
        int i = 0;
        int k = 0;
        int code = 0;
        int[] next_code = new int[16];
        int[] sizes = new int[17];
        Arrays.fill(sizes, 0);
        Arrays.fill(z.fast, 0);
        for (i = 0; i < num; ++i) {
            short s = sizelist.getAt(i);
            sizes[s] = sizes[s] + 1;
        }
        sizes[0] = 0;
        for (i = 1; i < 16; ++i) {
            if (sizes[i] <= 1 << i) continue;
            Decoder.stbi__err("bad sizes");
        }
        code = 0;
        for (i = 1; i < 16; ++i) {
            next_code[i] = code;
            z.firstcode[i] = code;
            z.firstsymbol[i] = k;
            if (sizes[i] != 0 && (code += sizes[i]) - 1 >= 1 << i) {
                Decoder.stbi__err("bad codelengths");
            }
            z.maxcode[i] = code << 16 - i;
            code <<= 1;
            k += sizes[i];
        }
        z.maxcode[16] = 65536;
        for (i = 0; i < num; ++i) {
            short s = sizelist.getAt(i);
            if (s == 0) continue;
            int c = next_code[s] - z.firstcode[s] + z.firstsymbol[s];
            int fastv = s << 9 | i;
            z.size[c] = s;
            z.value[c] = i;
            if (s <= 9) {
                for (int j = Utility.stbi__bit_reverse(next_code[s], s); j < 512; j += 1 << s) {
                    z.fast[j] = fastv;
                }
            }
            short s2 = s;
            next_code[s2] = next_code[s2] + 1;
        }
        return 1;
    }

    private int stbi__compute_huffman_codes() throws IOException {
        stbi__zhuffman z_codelength = new stbi__zhuffman();
        short[] lencodes = new short[455];
        short[] codelength_sizes = new short[19];
        int i = 0;
        int n = 0;
        int hlit = (int)(this.stbi__zreceive(5) + 257L);
        int hdist = (int)(this.stbi__zreceive(5) + 1L);
        int hclen = (int)(this.stbi__zreceive(4) + 4L);
        int ntot = hlit + hdist;
        Arrays.fill(codelength_sizes, (short)0);
        for (i = 0; i < hclen; ++i) {
            int s = (int)this.stbi__zreceive(3);
            codelength_sizes[ZLib.length_dezigzag[i]] = (short)s;
        }
        if (ZLib.stbi__zbuild_huffman(z_codelength, new FakePtrShort(codelength_sizes), 19) == 0) {
            return 0;
        }
        n = 0;
        while (n < ntot) {
            int c = this.stbi__zhuffman_decode(z_codelength);
            if (c < 0 || c >= 19) {
                Decoder.stbi__err("bad codelengths");
            }
            if (c < 16) {
                lencodes[n++] = (short)c;
                continue;
            }
            short fill = 0;
            if (c == 16) {
                c = (int)(this.stbi__zreceive(2) + 3L);
                if (n == 0) {
                    Decoder.stbi__err("bad codelengths");
                }
                fill = lencodes[n - 1];
            } else {
                c = c == 17 ? (int)(this.stbi__zreceive(3) + 3L) : (int)(this.stbi__zreceive(7) + 11L);
            }
            if (ntot - n < c) {
                Decoder.stbi__err("bad codelengths");
            }
            Arrays.fill(lencodes, n, n + c, fill);
            n += c;
        }
        if (n != ntot) {
            Decoder.stbi__err("bad codelengths");
        }
        if (ZLib.stbi__zbuild_huffman(this.z_length, new FakePtrShort(lencodes), hlit) == 0) {
            return 0;
        }
        if (ZLib.stbi__zbuild_huffman(this.z_distance, new FakePtrShort(lencodes, hlit), hdist) == 0) {
            return 0;
        }
        return 1;
    }

    private int stbi__parse_uncompressed_block() throws IOException {
        int[] header = new int[4];
        int len = 0;
        int nlen = 0;
        int k = 0;
        if ((this.num_bits & 7) != 0) {
            this.stbi__zreceive(this.num_bits & 7);
        }
        k = 0;
        while (this.num_bits > 0) {
            header[k++] = (short)(this.code_buffer & 0xFFL);
            this.code_buffer >>= 8;
            this.num_bits -= 8;
        }
        while (k < 4) {
            header[k++] = this.stbi__zget8();
        }
        nlen = header[3] * 256 + header[2];
        len = header[1] * 256 + header[0];
        if (nlen != (len ^ 0xFFFF)) {
            Decoder.stbi__err("zlib corrupt");
        }
        if (this.zbuffer.offset + len > this.zbuffer_end.offset) {
            Decoder.stbi__err("read past buffer");
        }
        if (this.zout.offset + len > this.zout_end.offset && this.stbi__zexpand(this.zout, len) == 0) {
            return 0;
        }
        for (int i = 0; i < len; ++i) {
            this.zout.setAt(i, this.zbuffer.getAt(i));
        }
        this.zbuffer.move(len);
        this.zout.move(len);
        return 1;
    }

    private int stbi__parse_zlib_header() throws IOException {
        int cmf = this.stbi__zget8();
        int cm = cmf & 0xF;
        int flg = this.stbi__zget8();
        if ((cmf * 256 + flg) % 31 != 0) {
            Decoder.stbi__err("bad zlib header");
        }
        if ((flg & 0x20) != 0) {
            Decoder.stbi__err("no preset dict");
        }
        if (cm != 8) {
            Decoder.stbi__err("bad compression");
        }
        return 1;
    }

    private int stbi__parse_zlib(int parse_header) throws IOException {
        int _final_ = 0;
        int type = 0;
        if (parse_header != 0 && this.stbi__parse_zlib_header() == 0) {
            return 0;
        }
        this.num_bits = 0;
        this.code_buffer = 0L;
        do {
            _final_ = (int)this.stbi__zreceive(1);
            type = (int)this.stbi__zreceive(2);
            if (type == 0) {
                if (this.stbi__parse_uncompressed_block() != 0) continue;
                return 0;
            }
            if (type == 3) {
                return 0;
            }
            if (type == 1) {
                if (ZLib.stbi__zbuild_huffman(this.z_length, new FakePtrShort(stbi__zdefault_length), 288) == 0) {
                    return 0;
                }
                if (ZLib.stbi__zbuild_huffman(this.z_distance, new FakePtrShort(stbi__zdefault_distance), 32) == 0) {
                    return 0;
                }
            } else if (this.stbi__compute_huffman_codes() == 0) {
                return 0;
            }
            if (this.stbi__parse_huffman_block() != 0) continue;
            return 0;
        } while (_final_ == 0);
        return 1;
    }

    private int stbi__do_zlib(byte[] obuf, int olen, int exp, int parse_header) throws IOException {
        this.zout_start = obuf;
        this.zout = new FakePtrByte(obuf);
        this.zout_end = new FakePtrByte(obuf, olen);
        this.z_expandable = exp;
        return this.stbi__parse_zlib(parse_header);
    }

    public static Pair<byte[], Integer> stbi_zlib_decode_malloc_guesssize_headerflag(byte[] buffer, int len, int initial_size, int parse_header) throws IOException {
        ZLib a = new ZLib();
        byte[] p = new byte[initial_size];
        a.zbuffer = new FakePtrByte(buffer);
        a.zbuffer_end = new FakePtrByte(buffer, len);
        if (a.stbi__do_zlib(p, initial_size, 1, parse_header) != 0) {
            return new Pair<byte[], Integer>(a.zout_start, a.zout.offset);
        }
        return null;
    }

    private static class stbi__zhuffman {
        public final int[] fast = new int[512];
        public final int[] firstcode = new int[16];
        public final int[] firstsymbol = new int[16];
        public final int[] maxcode = new int[17];
        public final short[] size = new short[288];
        public final int[] value = new int[288];

        private stbi__zhuffman() {
        }
    }
}

