/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.advancements.critereon.DataComponentMatchers;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IMaterial;

public record CriterionConditionItem(Optional<HolderSet<Item>> items, CriterionConditionValue.IntegerRange count, DataComponentMatchers components) implements Predicate<ItemStack>
{
    public static final Codec<CriterionConditionItem> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)RegistryCodecs.homogeneousList(Registries.ITEM).optionalFieldOf("items").forGetter(CriterionConditionItem::items), (App)CriterionConditionValue.IntegerRange.CODEC.optionalFieldOf("count", (Object)CriterionConditionValue.IntegerRange.ANY).forGetter(CriterionConditionItem::count), (App)DataComponentMatchers.CODEC.forGetter(CriterionConditionItem::components)).apply((Applicative)var0, CriterionConditionItem::new));

    @Override
    public boolean test(ItemStack var0) {
        if (this.items.isPresent() && !var0.is(this.items.get())) {
            return false;
        }
        if (!this.count.matches(var0.getCount())) {
            return false;
        }
        return this.components.test(var0);
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((ItemStack)object);
    }

    public static class a {
        private Optional<HolderSet<Item>> items = Optional.empty();
        private CriterionConditionValue.IntegerRange count = CriterionConditionValue.IntegerRange.ANY;
        private DataComponentMatchers components = DataComponentMatchers.ANY;

        public static a item() {
            return new a();
        }

        public a of(HolderGetter<Item> var02, IMaterial ... var1) {
            this.items = Optional.of(HolderSet.direct(var0 -> var0.asItem().builtInRegistryHolder(), var1));
            return this;
        }

        public a of(HolderGetter<Item> var0, TagKey<Item> var1) {
            this.items = Optional.of(var0.getOrThrow(var1));
            return this;
        }

        public a withCount(CriterionConditionValue.IntegerRange var0) {
            this.count = var0;
            return this;
        }

        public a withComponents(DataComponentMatchers var0) {
            this.components = var0;
            return this;
        }

        public CriterionConditionItem build() {
            return new CriterionConditionItem(this.items, this.count, this.components);
        }
    }
}

