/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.item;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTBase;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Unit;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.mutable.MutableObject;

public class ArgumentParserItemStack {
    static final DynamicCommandExceptionType ERROR_UNKNOWN_ITEM = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("argument.item.id.invalid", var0));
    static final DynamicCommandExceptionType ERROR_UNKNOWN_COMPONENT = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("arguments.item.component.unknown", var0));
    static final Dynamic2CommandExceptionType ERROR_MALFORMED_COMPONENT = new Dynamic2CommandExceptionType((var0, var1) -> IChatBaseComponent.translatableEscape("arguments.item.component.malformed", var0, var1));
    static final SimpleCommandExceptionType ERROR_EXPECTED_COMPONENT = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("arguments.item.component.expected"));
    static final DynamicCommandExceptionType ERROR_REPEATED_COMPONENT = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("arguments.item.component.repeated", var0));
    private static final DynamicCommandExceptionType ERROR_MALFORMED_ITEM = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("arguments.item.malformed", var0));
    public static final char SYNTAX_START_COMPONENTS = '[';
    public static final char SYNTAX_END_COMPONENTS = ']';
    public static final char SYNTAX_COMPONENT_SEPARATOR = ',';
    public static final char SYNTAX_COMPONENT_ASSIGNMENT = '=';
    public static final char SYNTAX_REMOVED_COMPONENT = '!';
    static final Function<SuggestionsBuilder, CompletableFuture<Suggestions>> SUGGEST_NOTHING = SuggestionsBuilder::buildFuture;
    final HolderLookup.b<Item> items;
    final RegistryOps<NBTBase> registryOps;
    final MojangsonParser<NBTBase> tagParser;

    public ArgumentParserItemStack(HolderLookup.a var0) {
        this.items = var0.lookupOrThrow(Registries.ITEM);
        this.registryOps = var0.createSerializationContext(DynamicOpsNBT.INSTANCE);
        this.tagParser = MojangsonParser.create(this.registryOps);
    }

    public a parse(StringReader var0) throws CommandSyntaxException {
        final MutableObject var1 = new MutableObject();
        final DataComponentPatch.a var2 = DataComponentPatch.builder();
        this.parse(var0, new d(this){

            @Override
            public void visitItem(Holder<Item> var0) {
                var1.setValue(var0);
            }

            @Override
            public <T> void visitComponent(DataComponentType<T> var0, T var12) {
                var2.set(var0, var12);
            }

            @Override
            public <T> void visitRemovedComponent(DataComponentType<T> var0) {
                var2.remove(var0);
            }
        });
        Holder var3 = Objects.requireNonNull((Holder)var1.getValue(), "Parser gave no item");
        DataComponentPatch var4 = var2.build();
        ArgumentParserItemStack.validateComponents(var0, var3, var4);
        return new a(var3, var4);
    }

    private static void validateComponents(StringReader var0, Holder<Item> var12, DataComponentPatch var2) throws CommandSyntaxException {
        PatchedDataComponentMap var3 = PatchedDataComponentMap.fromPatch(var12.value().components(), var2);
        DataResult<Unit> var4 = ItemStack.validateComponents(var3);
        var4.getOrThrow(var1 -> ERROR_MALFORMED_ITEM.createWithContext((ImmutableStringReader)var0, var1));
    }

    public void parse(StringReader var0, d var1) throws CommandSyntaxException {
        int var2 = var0.getCursor();
        try {
            new b(var0, var1).parse();
        }
        catch (CommandSyntaxException var3) {
            var0.setCursor(var2);
            throw var3;
        }
    }

    public CompletableFuture<Suggestions> fillSuggestions(SuggestionsBuilder var0) {
        StringReader var1 = new StringReader(var0.getInput());
        var1.setCursor(var0.getStart());
        c var2 = new c();
        b var3 = new b(var1, var2);
        try {
            var3.parse();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return var2.resolveSuggestions(var0, var1);
    }

    public static interface d {
        default public void visitItem(Holder<Item> var0) {
        }

        default public <T> void visitComponent(DataComponentType<T> var0, T var1) {
        }

        default public <T> void visitRemovedComponent(DataComponentType<T> var0) {
        }

        default public void visitSuggestions(Function<SuggestionsBuilder, CompletableFuture<Suggestions>> var0) {
        }
    }

    public record a(Holder<Item> item, DataComponentPatch components) {
    }

    class b {
        private final StringReader reader;
        private final d visitor;

        b(StringReader var1, d var2) {
            this.reader = var1;
            this.visitor = var2;
        }

        public void parse() throws CommandSyntaxException {
            this.visitor.visitSuggestions(this::suggestItem);
            this.readItem();
            this.visitor.visitSuggestions(this::suggestStartComponents);
            if (this.reader.canRead() && this.reader.peek() == '[') {
                this.visitor.visitSuggestions(SUGGEST_NOTHING);
                this.readComponents();
            }
        }

        private void readItem() throws CommandSyntaxException {
            int var0 = this.reader.getCursor();
            MinecraftKey var1 = MinecraftKey.read(this.reader);
            this.visitor.visitItem((Holder<Item>)ArgumentParserItemStack.this.items.get(ResourceKey.create(Registries.ITEM, var1)).orElseThrow(() -> {
                this.reader.setCursor(var0);
                return ERROR_UNKNOWN_ITEM.createWithContext((ImmutableStringReader)this.reader, (Object)var1);
            }));
        }

        private void readComponents() throws CommandSyntaxException {
            this.reader.expect('[');
            this.visitor.visitSuggestions(this::suggestComponentAssignmentOrRemoval);
            ReferenceArraySet var0 = new ReferenceArraySet();
            while (this.reader.canRead() && this.reader.peek() != ']') {
                this.reader.skipWhitespace();
                if (this.reader.canRead() && this.reader.peek() == '!') {
                    this.reader.skip();
                    this.visitor.visitSuggestions(this::suggestComponent);
                    var1 = b.readComponentType(this.reader);
                    if (!var0.add(var1)) {
                        throw ERROR_REPEATED_COMPONENT.create(var1);
                    }
                    this.visitor.visitRemovedComponent(var1);
                    this.visitor.visitSuggestions(SUGGEST_NOTHING);
                    this.reader.skipWhitespace();
                } else {
                    var1 = b.readComponentType(this.reader);
                    if (!var0.add(var1)) {
                        throw ERROR_REPEATED_COMPONENT.create(var1);
                    }
                    this.visitor.visitSuggestions(this::suggestAssignment);
                    this.reader.skipWhitespace();
                    this.reader.expect('=');
                    this.visitor.visitSuggestions(SUGGEST_NOTHING);
                    this.reader.skipWhitespace();
                    this.readComponent(ArgumentParserItemStack.this.tagParser, ArgumentParserItemStack.this.registryOps, var1);
                    this.reader.skipWhitespace();
                }
                this.visitor.visitSuggestions(this::suggestNextOrEndComponents);
                if (!this.reader.canRead() || this.reader.peek() != ',') break;
                this.reader.skip();
                this.reader.skipWhitespace();
                this.visitor.visitSuggestions(this::suggestComponentAssignmentOrRemoval);
                if (this.reader.canRead()) continue;
                throw ERROR_EXPECTED_COMPONENT.createWithContext((ImmutableStringReader)this.reader);
            }
            this.reader.expect(']');
            this.visitor.visitSuggestions(SUGGEST_NOTHING);
        }

        public static DataComponentType<?> readComponentType(StringReader var0) throws CommandSyntaxException {
            if (!var0.canRead()) {
                throw ERROR_EXPECTED_COMPONENT.createWithContext((ImmutableStringReader)var0);
            }
            int var1 = var0.getCursor();
            MinecraftKey var2 = MinecraftKey.read(var0);
            DataComponentType<?> var3 = BuiltInRegistries.DATA_COMPONENT_TYPE.getValue(var2);
            if (var3 == null || var3.isTransient()) {
                var0.setCursor(var1);
                throw ERROR_UNKNOWN_COMPONENT.createWithContext((ImmutableStringReader)var0, (Object)var2);
            }
            return var3;
        }

        private <T, O> void readComponent(MojangsonParser<O> var0, RegistryOps<O> var1, DataComponentType<T> var22) throws CommandSyntaxException {
            int var3 = this.reader.getCursor();
            O var4 = var0.parseAsArgument(this.reader);
            DataResult var5 = var22.codecOrThrow().parse(var1, var4);
            this.visitor.visitComponent(var22, var5.getOrThrow(var2 -> {
                this.reader.setCursor(var3);
                return ERROR_MALFORMED_COMPONENT.createWithContext((ImmutableStringReader)this.reader, (Object)var22.toString(), var2);
            }));
        }

        private CompletableFuture<Suggestions> suggestStartComponents(SuggestionsBuilder var0) {
            if (var0.getRemaining().isEmpty()) {
                var0.suggest(String.valueOf('['));
            }
            return var0.buildFuture();
        }

        private CompletableFuture<Suggestions> suggestNextOrEndComponents(SuggestionsBuilder var0) {
            if (var0.getRemaining().isEmpty()) {
                var0.suggest(String.valueOf(','));
                var0.suggest(String.valueOf(']'));
            }
            return var0.buildFuture();
        }

        private CompletableFuture<Suggestions> suggestAssignment(SuggestionsBuilder var0) {
            if (var0.getRemaining().isEmpty()) {
                var0.suggest(String.valueOf('='));
            }
            return var0.buildFuture();
        }

        private CompletableFuture<Suggestions> suggestItem(SuggestionsBuilder var0) {
            return ICompletionProvider.suggestResource(ArgumentParserItemStack.this.items.listElementIds().map(ResourceKey::location), var0);
        }

        private CompletableFuture<Suggestions> suggestComponentAssignmentOrRemoval(SuggestionsBuilder var0) {
            var0.suggest(String.valueOf('!'));
            return this.suggestComponent(var0, String.valueOf('='));
        }

        private CompletableFuture<Suggestions> suggestComponent(SuggestionsBuilder var0) {
            return this.suggestComponent(var0, "");
        }

        private CompletableFuture<Suggestions> suggestComponent(SuggestionsBuilder var02, String var1) {
            String var22 = var02.getRemaining().toLowerCase(Locale.ROOT);
            ICompletionProvider.filterResources(BuiltInRegistries.DATA_COMPONENT_TYPE.entrySet(), var22, var0 -> ((ResourceKey)var0.getKey()).location(), var2 -> {
                DataComponentType var3 = (DataComponentType)var2.getValue();
                if (var3.codec() != null) {
                    MinecraftKey var4 = ((ResourceKey)var2.getKey()).location();
                    var02.suggest(String.valueOf(var4) + var1);
                }
            });
            return var02.buildFuture();
        }
    }

    static class c
    implements d {
        private Function<SuggestionsBuilder, CompletableFuture<Suggestions>> suggestions = SUGGEST_NOTHING;

        c() {
        }

        @Override
        public void visitSuggestions(Function<SuggestionsBuilder, CompletableFuture<Suggestions>> var0) {
            this.suggestions = var0;
        }

        public CompletableFuture<Suggestions> resolveSuggestions(SuggestionsBuilder var0, StringReader var1) {
            return this.suggestions.apply(var0.createOffset(var1.getCursor()));
        }
    }
}

