/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.GameTestHarnessHelper;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.gametest.framework.TestData;
import net.minecraft.gametest.framework.TestEnvironmentDefinition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.ResourceKey;

public class FunctionGameTestInstance
extends GameTestInstance {
    public static final MapCodec<FunctionGameTestInstance> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)ResourceKey.codec(Registries.TEST_FUNCTION).fieldOf("function").forGetter(FunctionGameTestInstance::function), (App)TestData.CODEC.forGetter(GameTestInstance::info)).apply((Applicative)var0, FunctionGameTestInstance::new));
    private final ResourceKey<Consumer<GameTestHarnessHelper>> function;

    public FunctionGameTestInstance(ResourceKey<Consumer<GameTestHarnessHelper>> var0, TestData<Holder<TestEnvironmentDefinition>> var1) {
        super(var1);
        this.function = var0;
    }

    @Override
    public void run(GameTestHarnessHelper var0) {
        var0.getLevel().registryAccess().get(this.function).map(Holder.c::value).orElseThrow(() -> new IllegalStateException("Trying to access missing test function: " + String.valueOf(this.function.location()))).accept(var0);
    }

    private ResourceKey<Consumer<GameTestHarnessHelper>> function() {
        return this.function;
    }

    public MapCodec<FunctionGameTestInstance> codec() {
        return CODEC;
    }

    @Override
    protected IChatMutableComponent typeDescription() {
        return IChatBaseComponent.translatable("test_instance.type.function");
    }

    @Override
    public IChatBaseComponent describe() {
        return this.describeType().append(this.descriptionRow("test_instance.description.function", this.function.location().toString())).append(this.describeInfo());
    }
}

