/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.server.CustomFunctionData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.INamable;
import net.minecraft.world.level.GameRules;
import org.slf4j.Logger;

public interface TestEnvironmentDefinition {
    public static final Codec<TestEnvironmentDefinition> DIRECT_CODEC = BuiltInRegistries.TEST_ENVIRONMENT_DEFINITION_TYPE.byNameCodec().dispatch(TestEnvironmentDefinition::codec, var0 -> var0);
    public static final Codec<Holder<TestEnvironmentDefinition>> CODEC = RegistryFileCodec.create(Registries.TEST_ENVIRONMENT, DIRECT_CODEC);

    public static MapCodec<? extends TestEnvironmentDefinition> bootstrap(IRegistry<MapCodec<? extends TestEnvironmentDefinition>> var0) {
        IRegistry.register(var0, "all_of", a.CODEC);
        IRegistry.register(var0, "game_rules", c.CODEC);
        IRegistry.register(var0, "time_of_day", d.CODEC);
        IRegistry.register(var0, "weather", e.CODEC);
        return IRegistry.register(var0, "function", b.CODEC);
    }

    public void setup(WorldServer var1);

    default public void teardown(WorldServer var0) {
    }

    public MapCodec<? extends TestEnvironmentDefinition> codec();

    public record a(List<Holder<TestEnvironmentDefinition>> definitions) implements TestEnvironmentDefinition
    {
        public static final MapCodec<a> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)CODEC.listOf().fieldOf("definitions").forGetter(a::definitions)).apply((Applicative)var0, a::new));

        public a(TestEnvironmentDefinition ... var0) {
            this(Arrays.stream(var0).map(Holder::direct).toList());
        }

        @Override
        public void setup(WorldServer var0) {
            this.definitions.forEach(var1 -> ((TestEnvironmentDefinition)var1.value()).setup(var0));
        }

        @Override
        public void teardown(WorldServer var0) {
            this.definitions.forEach(var1 -> ((TestEnvironmentDefinition)var1.value()).teardown(var0));
        }

        public MapCodec<a> codec() {
            return CODEC;
        }
    }

    public record c(List<a<Boolean, GameRules.GameRuleBoolean>> boolRules, List<a<Integer, GameRules.GameRuleInt>> intRules) implements TestEnvironmentDefinition
    {
        public static final MapCodec<c> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)a.codec(GameRules.GameRuleBoolean.class, Codec.BOOL).listOf().fieldOf("bool_rules").forGetter(c::boolRules), (App)a.codec(GameRules.GameRuleInt.class, Codec.INT).listOf().fieldOf("int_rules").forGetter(c::intRules)).apply((Applicative)var0, c::new));

        @Override
        public void setup(WorldServer var0) {
            GameRules var1 = var0.getGameRules();
            MinecraftServer var2 = var0.getServer();
            for (a<Boolean, GameRules.GameRuleBoolean> a2 : this.boolRules) {
                var1.getRule(a2.key()).set(a2.value(), var2);
            }
            for (a<Comparable<Boolean>, GameRules.GameRuleValue> a3 : this.intRules) {
                ((GameRules.GameRuleInt)var1.getRule(a3.key())).set((Integer)a3.value(), var2);
            }
        }

        @Override
        public void teardown(WorldServer var0) {
            GameRules var1 = var0.getGameRules();
            MinecraftServer var2 = var0.getServer();
            for (a<Boolean, GameRules.GameRuleBoolean> a2 : this.boolRules) {
                var1.getRule(a2.key()).setFrom(GameRules.getType(a2.key()).createRule(), var2);
            }
            for (a<Comparable<Boolean>, GameRules.GameRuleValue> a3 : this.intRules) {
                ((GameRules.GameRuleInt)var1.getRule(a3.key())).setFrom((GameRules.GameRuleInt)GameRules.getType(a3.key()).createRule(), var2);
            }
        }

        public MapCodec<c> codec() {
            return CODEC;
        }

        public static <S, T extends GameRules.GameRuleValue<T>> a<S, T> entry(GameRules.GameRuleKey<T> var0, S var1) {
            return new a<S, T>(var0, var1);
        }

        public record a<S, T extends GameRules.GameRuleValue<T>>(GameRules.GameRuleKey<T> key, S value) {
            public static <S, T extends GameRules.GameRuleValue<T>> Codec<a<S, T>> codec(Class<T> var0, Codec<S> var1) {
                return RecordCodecBuilder.create(var2 -> var2.group((App)GameRules.keyCodec(var0).fieldOf("rule").forGetter(a::key), (App)var1.fieldOf("value").forGetter(a::value)).apply((Applicative)var2, a::new));
            }
        }
    }

    public record d(int time) implements TestEnvironmentDefinition
    {
        public static final MapCodec<d> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("time").forGetter(d::time)).apply((Applicative)var0, d::new));

        @Override
        public void setup(WorldServer var0) {
            var0.setDayTime(this.time);
        }

        public MapCodec<d> codec() {
            return CODEC;
        }
    }

    public record e(a weather) implements TestEnvironmentDefinition
    {
        public static final MapCodec<e> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)a.CODEC.fieldOf("weather").forGetter(e::weather)).apply((Applicative)var0, e::new));

        @Override
        public void setup(WorldServer var0) {
            this.weather.apply(var0);
        }

        @Override
        public void teardown(WorldServer var0) {
            var0.resetWeatherCycle();
        }

        public MapCodec<e> codec() {
            return CODEC;
        }

        public static final class a
        extends Enum<a>
        implements INamable {
            public static final /* enum */ a CLEAR = new a("clear", 100000, 0, false, false);
            public static final /* enum */ a RAIN = new a("rain", 0, 100000, true, false);
            public static final /* enum */ a THUNDER = new a("thunder", 0, 100000, true, true);
            public static final Codec<a> CODEC;
            private final String id;
            private final int clearTime;
            private final int rainTime;
            private final boolean raining;
            private final boolean thundering;
            private static final /* synthetic */ a[] j;

            public static a[] values() {
                return (a[])j.clone();
            }

            public static a valueOf(String var0) {
                return Enum.valueOf(a.class, var0);
            }

            private a(String var2, int var3, int var4, boolean var5, boolean var6) {
                this.id = var2;
                this.clearTime = var3;
                this.rainTime = var4;
                this.raining = var5;
                this.thundering = var6;
            }

            void apply(WorldServer var0) {
                var0.setWeatherParameters(this.clearTime, this.rainTime, this.raining, this.thundering);
            }

            @Override
            public String getSerializedName() {
                return this.id;
            }

            private static /* synthetic */ a[] a() {
                return new a[]{CLEAR, RAIN, THUNDER};
            }

            static {
                j = a.a();
                CODEC = INamable.fromEnum(a::values);
            }
        }
    }

    public record b(Optional<MinecraftKey> setupFunction, Optional<MinecraftKey> teardownFunction) implements TestEnvironmentDefinition
    {
        private static final Logger LOGGER = LogUtils.getLogger();
        public static final MapCodec<b> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)MinecraftKey.CODEC.optionalFieldOf("setup").forGetter(b::setupFunction), (App)MinecraftKey.CODEC.optionalFieldOf("teardown").forGetter(b::teardownFunction)).apply((Applicative)var0, b::new));

        @Override
        public void setup(WorldServer var0) {
            this.setupFunction.ifPresent(var1 -> b.run(var0, var1));
        }

        @Override
        public void teardown(WorldServer var0) {
            this.teardownFunction.ifPresent(var1 -> b.run(var0, var1));
        }

        private static void run(WorldServer var0, MinecraftKey var1) {
            MinecraftServer var2 = var0.getServer();
            CustomFunctionData var3 = var2.getFunctions();
            Optional<CommandFunction<CommandListenerWrapper>> var4 = var3.get(var1);
            if (var4.isPresent()) {
                CommandListenerWrapper var5 = var2.createCommandSourceStack().withPermission(2).withSuppressedOutput().withLevel(var0);
                var3.execute(var4.get(), var5);
            } else {
                LOGGER.error("Test Batch failed for non-existent function {}", (Object)var1);
            }
        }

        public MapCodec<b> codec() {
            return CODEC;
        }
    }
}

