/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.gametest.framework.FailedTestTracker;
import net.minecraft.gametest.framework.GameTestHarnessStructures;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.gametest.framework.TestInstanceFinder;
import net.minecraft.gametest.framework.TestPosFinder;

public class TestFinder
implements TestInstanceFinder,
TestPosFinder {
    static final TestInstanceFinder NO_FUNCTIONS = Stream::empty;
    static final TestPosFinder NO_STRUCTURES = Stream::empty;
    private final TestInstanceFinder testInstanceFinder;
    private final TestPosFinder testPosFinder;
    private final CommandListenerWrapper source;

    @Override
    public Stream<BlockPosition> findTestPos() {
        return this.testPosFinder.findTestPos();
    }

    public static a builder() {
        return new a();
    }

    TestFinder(CommandListenerWrapper var0, TestInstanceFinder var1, TestPosFinder var2) {
        this.source = var0;
        this.testInstanceFinder = var1;
        this.testPosFinder = var2;
    }

    public CommandListenerWrapper source() {
        return this.source;
    }

    @Override
    public Stream<Holder.c<GameTestInstance>> findTests() {
        return this.testInstanceFinder.findTests();
    }

    public static class a {
        private final UnaryOperator<Supplier<Stream<Holder.c<GameTestInstance>>>> testFinderWrapper;
        private final UnaryOperator<Supplier<Stream<BlockPosition>>> structureBlockPosFinderWrapper;

        public a() {
            this.testFinderWrapper = var0 -> var0;
            this.structureBlockPosFinderWrapper = var0 -> var0;
        }

        private a(UnaryOperator<Supplier<Stream<Holder.c<GameTestInstance>>>> var0, UnaryOperator<Supplier<Stream<BlockPosition>>> var1) {
            this.testFinderWrapper = var0;
            this.structureBlockPosFinderWrapper = var1;
        }

        public a createMultipleCopies(int var0) {
            return new a(a.createCopies(var0), a.createCopies(var0));
        }

        private static <Q> UnaryOperator<Supplier<Stream<Q>>> createCopies(int var0) {
            return var1 -> {
                LinkedList var2 = new LinkedList();
                List var3 = ((Stream)var1.get()).toList();
                for (int var4 = 0; var4 < var0; ++var4) {
                    var2.addAll(var3);
                }
                return var2::stream;
            };
        }

        private TestFinder build(CommandListenerWrapper var0, TestInstanceFinder var1, TestPosFinder var2) {
            return new TestFinder(var0, ((Supplier)((Supplier)this.testFinderWrapper.apply(var1::findTests)))::get, ((Supplier)((Supplier)this.structureBlockPosFinderWrapper.apply(var2::findTestPos)))::get);
        }

        public TestFinder radius(CommandContext<CommandListenerWrapper> var0, int var1) {
            CommandListenerWrapper var2 = (CommandListenerWrapper)var0.getSource();
            BlockPosition var3 = BlockPosition.containing(var2.getPosition());
            return this.build(var2, NO_FUNCTIONS, () -> GameTestHarnessStructures.findTestBlocks(var3, var1, var2.getLevel()));
        }

        public TestFinder nearest(CommandContext<CommandListenerWrapper> var0) {
            CommandListenerWrapper var1 = (CommandListenerWrapper)var0.getSource();
            BlockPosition var2 = BlockPosition.containing(var1.getPosition());
            return this.build(var1, NO_FUNCTIONS, () -> GameTestHarnessStructures.findNearestTest(var2, 15, var1.getLevel()).stream());
        }

        public TestFinder allNearby(CommandContext<CommandListenerWrapper> var0) {
            CommandListenerWrapper var1 = (CommandListenerWrapper)var0.getSource();
            BlockPosition var2 = BlockPosition.containing(var1.getPosition());
            return this.build(var1, NO_FUNCTIONS, () -> GameTestHarnessStructures.findTestBlocks(var2, 250, var1.getLevel()));
        }

        public TestFinder lookedAt(CommandContext<CommandListenerWrapper> var0) {
            CommandListenerWrapper var1 = (CommandListenerWrapper)var0.getSource();
            return this.build(var1, NO_FUNCTIONS, () -> GameTestHarnessStructures.lookedAtTestPos(BlockPosition.containing(var1.getPosition()), var1.getPlayer().getCamera(), var1.getLevel()));
        }

        public TestFinder failedTests(CommandContext<CommandListenerWrapper> var0, boolean var1) {
            return this.build((CommandListenerWrapper)var0.getSource(), () -> FailedTestTracker.getLastFailedTests().filter(var1 -> !var1 || ((GameTestInstance)var1.value()).required()), NO_STRUCTURES);
        }

        public TestFinder byResourceSelection(CommandContext<CommandListenerWrapper> var0, Collection<Holder.c<GameTestInstance>> var1) {
            return this.build((CommandListenerWrapper)var0.getSource(), var1::stream, NO_STRUCTURES);
        }

        public TestFinder failedTests(CommandContext<CommandListenerWrapper> var0) {
            return this.failedTests(var0, false);
        }
    }
}

