/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.SnbtGrammar;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.parsing.packrat.commands.Grammar;

public class MojangsonParser<T> {
    public static final SimpleCommandExceptionType ERROR_TRAILING_DATA = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("argument.nbt.trailing"));
    public static final SimpleCommandExceptionType ERROR_EXPECTED_COMPOUND = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("argument.nbt.expected.compound"));
    public static final char ELEMENT_SEPARATOR = ',';
    public static final char NAME_VALUE_SEPARATOR = ':';
    private static final MojangsonParser<NBTBase> NBT_OPS_PARSER = MojangsonParser.create(DynamicOpsNBT.INSTANCE);
    public static final Codec<NBTTagCompound> FLATTENED_CODEC = Codec.STRING.comapFlatMap(var0 -> {
        try {
            NBTBase var1 = NBT_OPS_PARSER.parseFully((String)var0);
            if (var1 instanceof NBTTagCompound) {
                NBTTagCompound var2 = (NBTTagCompound)var1;
                return DataResult.success((Object)var2, (Lifecycle)Lifecycle.stable());
            }
            return DataResult.error(() -> "Expected compound tag, got " + String.valueOf(var1));
        }
        catch (CommandSyntaxException var1) {
            return DataResult.error(() -> ((CommandSyntaxException)var1).getMessage());
        }
    }, NBTTagCompound::toString);
    public static final Codec<NBTTagCompound> LENIENT_CODEC = Codec.withAlternative(FLATTENED_CODEC, NBTTagCompound.CODEC);
    private final DynamicOps<T> ops;
    private final Grammar<T> grammar;

    private MojangsonParser(DynamicOps<T> var0, Grammar<T> var1) {
        this.ops = var0;
        this.grammar = var1;
    }

    public DynamicOps<T> getOps() {
        return this.ops;
    }

    public static <T> MojangsonParser<T> create(DynamicOps<T> var0) {
        return new MojangsonParser<T>(var0, SnbtGrammar.createParser(var0));
    }

    private static NBTTagCompound castToCompoundOrThrow(StringReader var0, NBTBase var1) throws CommandSyntaxException {
        if (var1 instanceof NBTTagCompound) {
            NBTTagCompound var2 = (NBTTagCompound)var1;
            return var2;
        }
        throw ERROR_EXPECTED_COMPOUND.createWithContext((ImmutableStringReader)var0);
    }

    public static NBTTagCompound parseCompoundFully(String var0) throws CommandSyntaxException {
        StringReader var1 = new StringReader(var0);
        return MojangsonParser.castToCompoundOrThrow(var1, NBT_OPS_PARSER.parseFully(var1));
    }

    public T parseFully(String var0) throws CommandSyntaxException {
        return this.parseFully(new StringReader(var0));
    }

    public T parseFully(StringReader var0) throws CommandSyntaxException {
        T var1 = this.grammar.parseForCommands(var0);
        var0.skipWhitespace();
        if (var0.canRead()) {
            throw ERROR_TRAILING_DATA.createWithContext((ImmutableStringReader)var0);
        }
        return var1;
    }

    public T parseAsArgument(StringReader var0) throws CommandSyntaxException {
        return this.grammar.parseForCommands(var0);
    }

    public static NBTTagCompound parseCompoundAsArgument(StringReader var0) throws CommandSyntaxException {
        NBTBase var1 = NBT_OPS_PARSER.parseAsArgument(var0);
        return MojangsonParser.castToCompoundOrThrow(var0, var1);
    }
}

