/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTagVisitor;
import net.minecraft.nbt.TagVisitor;

public record NBTTagByte(byte value) implements NBTNumber
{
    private static final int SELF_SIZE_IN_BYTES = 9;
    public static final NBTTagType<NBTTagByte> TYPE = new NBTTagType.a<NBTTagByte>(){

        @Override
        public NBTTagByte load(DataInput var0, NBTReadLimiter var1) throws IOException {
            return NBTTagByte.valueOf(1.readAccounted(var0, var1));
        }

        @Override
        public StreamTagVisitor.b parse(DataInput var0, StreamTagVisitor var1, NBTReadLimiter var2) throws IOException {
            return var1.visit(1.readAccounted(var0, var2));
        }

        private static byte readAccounted(DataInput var0, NBTReadLimiter var1) throws IOException {
            var1.accountBytes(9L);
            return var0.readByte();
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public String getName() {
            return "BYTE";
        }

        @Override
        public String getPrettyName() {
            return "TAG_Byte";
        }

        @Override
        public /* synthetic */ NBTBase load(DataInput dataInput, NBTReadLimiter nBTReadLimiter) throws IOException {
            return this.load(dataInput, nBTReadLimiter);
        }
    };
    public static final NBTTagByte ZERO = NBTTagByte.valueOf((byte)0);
    public static final NBTTagByte ONE = NBTTagByte.valueOf((byte)1);

    public static NBTTagByte valueOf(byte var0) {
        return a.cache[128 + var0];
    }

    public static NBTTagByte valueOf(boolean var0) {
        return var0 ? ONE : ZERO;
    }

    @Override
    public void write(DataOutput var0) throws IOException {
        var0.writeByte(this.value);
    }

    @Override
    public int sizeInBytes() {
        return 9;
    }

    @Override
    public byte getId() {
        return 1;
    }

    public NBTTagType<NBTTagByte> getType() {
        return TYPE;
    }

    @Override
    public NBTTagByte copy() {
        return this;
    }

    @Override
    public void accept(TagVisitor var0) {
        var0.visitByte(this);
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public short shortValue() {
        return this.value;
    }

    @Override
    public byte byteValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public Number box() {
        return this.value;
    }

    @Override
    public StreamTagVisitor.b accept(StreamTagVisitor var0) {
        return var0.visit(this.value);
    }

    @Override
    public String toString() {
        StringTagVisitor var0 = new StringTagVisitor();
        var0.visitByte(this);
        return var0.build();
    }

    @Override
    public /* synthetic */ NBTBase copy() {
        return this.copy();
    }

    static class a {
        static final NBTTagByte[] cache = new NBTTagByte[256];

        private a() {
        }

        static {
            for (int var0 = 0; var0 < cache.length; ++var0) {
                a.cache[var0] = new NBTTagByte((byte)(var0 - 128));
            }
        }
    }
}

