/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTList;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTagVisitor;
import net.minecraft.nbt.TagVisitor;
import org.apache.commons.lang3.ArrayUtils;

public final class NBTTagIntArray
implements NBTList {
    private static final int SELF_SIZE_IN_BYTES = 24;
    public static final NBTTagType<NBTTagIntArray> TYPE = new NBTTagType.b<NBTTagIntArray>(){

        @Override
        public NBTTagIntArray load(DataInput var0, NBTReadLimiter var1) throws IOException {
            return new NBTTagIntArray(1.readAccounted(var0, var1));
        }

        @Override
        public StreamTagVisitor.b parse(DataInput var0, StreamTagVisitor var1, NBTReadLimiter var2) throws IOException {
            return var1.visit(1.readAccounted(var0, var2));
        }

        private static int[] readAccounted(DataInput var0, NBTReadLimiter var1) throws IOException {
            var1.accountBytes(24L);
            int var2 = var0.readInt();
            var1.accountBytes(4L, var2);
            int[] var3 = new int[var2];
            for (int var4 = 0; var4 < var2; ++var4) {
                var3[var4] = var0.readInt();
            }
            return var3;
        }

        @Override
        public void skip(DataInput var0, NBTReadLimiter var1) throws IOException {
            var0.skipBytes(var0.readInt() * 4);
        }

        @Override
        public String getName() {
            return "INT[]";
        }

        @Override
        public String getPrettyName() {
            return "TAG_Int_Array";
        }

        @Override
        public /* synthetic */ NBTBase load(DataInput dataInput, NBTReadLimiter nBTReadLimiter) throws IOException {
            return this.load(dataInput, nBTReadLimiter);
        }
    };
    private int[] data;

    public NBTTagIntArray(int[] var0) {
        this.data = var0;
    }

    @Override
    public void write(DataOutput var0) throws IOException {
        var0.writeInt(this.data.length);
        for (int var4 : this.data) {
            var0.writeInt(var4);
        }
    }

    @Override
    public int sizeInBytes() {
        return 24 + 4 * this.data.length;
    }

    @Override
    public byte getId() {
        return 11;
    }

    public NBTTagType<NBTTagIntArray> getType() {
        return TYPE;
    }

    @Override
    public String toString() {
        StringTagVisitor var0 = new StringTagVisitor();
        var0.visitIntArray(this);
        return var0.build();
    }

    @Override
    public NBTTagIntArray copy() {
        int[] var0 = new int[this.data.length];
        System.arraycopy(this.data, 0, var0, 0, this.data.length);
        return new NBTTagIntArray(var0);
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        return var0 instanceof NBTTagIntArray && Arrays.equals(this.data, ((NBTTagIntArray)var0).data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public int[] getAsIntArray() {
        return this.data;
    }

    @Override
    public void accept(TagVisitor var0) {
        var0.visitIntArray(this);
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public NBTTagInt get(int var0) {
        return NBTTagInt.valueOf(this.data[var0]);
    }

    @Override
    public boolean setTag(int var0, NBTBase var1) {
        if (var1 instanceof NBTNumber) {
            NBTNumber var2 = (NBTNumber)var1;
            this.data[var0] = var2.intValue();
            return true;
        }
        return false;
    }

    @Override
    public boolean addTag(int var0, NBTBase var1) {
        if (var1 instanceof NBTNumber) {
            NBTNumber var2 = (NBTNumber)var1;
            this.data = ArrayUtils.add((int[])this.data, (int)var0, (int)var2.intValue());
            return true;
        }
        return false;
    }

    @Override
    public NBTTagInt remove(int var0) {
        int var1 = this.data[var0];
        this.data = ArrayUtils.remove((int[])this.data, (int)var0);
        return NBTTagInt.valueOf(var1);
    }

    @Override
    public void clear() {
        this.data = new int[0];
    }

    @Override
    public Optional<int[]> asIntArray() {
        return Optional.of(this.data);
    }

    @Override
    public StreamTagVisitor.b accept(StreamTagVisitor var0) {
        return var0.visit(this.data);
    }

    @Override
    public /* synthetic */ NBTBase get(int n2) {
        return this.get(n2);
    }

    @Override
    public /* synthetic */ NBTBase remove(int n2) {
        return this.remove(n2);
    }

    @Override
    public /* synthetic */ NBTBase copy() {
        return this.copy();
    }
}

