/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.regex.Pattern;
import net.minecraft.EnumChatFormat;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.TagVisitor;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import org.slf4j.Logger;

public class TextComponentTagVisitor
implements TagVisitor {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int INLINE_LIST_THRESHOLD = 8;
    private static final int MAX_DEPTH = 64;
    private static final int MAX_LENGTH = 128;
    private static final EnumChatFormat SYNTAX_HIGHLIGHTING_KEY = EnumChatFormat.AQUA;
    private static final EnumChatFormat SYNTAX_HIGHLIGHTING_STRING = EnumChatFormat.GREEN;
    private static final EnumChatFormat SYNTAX_HIGHLIGHTING_NUMBER = EnumChatFormat.GOLD;
    private static final EnumChatFormat SYNTAX_HIGHLIGHTING_NUMBER_TYPE = EnumChatFormat.RED;
    private static final Pattern SIMPLE_VALUE = Pattern.compile("[A-Za-z0-9._+-]+");
    private static final String LIST_OPEN = "[";
    private static final String LIST_CLOSE = "]";
    private static final String LIST_TYPE_SEPARATOR = ";";
    private static final String ELEMENT_SPACING = " ";
    private static final String STRUCT_OPEN = "{";
    private static final String STRUCT_CLOSE = "}";
    private static final String NEWLINE = "\n";
    private static final String NAME_VALUE_SEPARATOR = ": ";
    private static final String ELEMENT_SEPARATOR = String.valueOf(',');
    private static final String WRAPPED_ELEMENT_SEPARATOR = ELEMENT_SEPARATOR + "\n";
    private static final String SPACED_ELEMENT_SEPARATOR = ELEMENT_SEPARATOR + " ";
    private static final IChatBaseComponent FOLDED = IChatBaseComponent.literal("<...>").withStyle(EnumChatFormat.GRAY);
    private static final IChatBaseComponent BYTE_TYPE = IChatBaseComponent.literal("b").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
    private static final IChatBaseComponent SHORT_TYPE = IChatBaseComponent.literal("s").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
    private static final IChatBaseComponent INT_TYPE = IChatBaseComponent.literal("I").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
    private static final IChatBaseComponent LONG_TYPE = IChatBaseComponent.literal("L").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
    private static final IChatBaseComponent FLOAT_TYPE = IChatBaseComponent.literal("f").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
    private static final IChatBaseComponent DOUBLE_TYPE = IChatBaseComponent.literal("d").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
    private static final IChatBaseComponent BYTE_ARRAY_TYPE = IChatBaseComponent.literal("B").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
    private final String indentation;
    private int indentDepth;
    private int depth;
    private final IChatMutableComponent result = IChatBaseComponent.empty();

    public TextComponentTagVisitor(String var0) {
        this.indentation = var0;
    }

    public IChatBaseComponent visit(NBTBase var0) {
        var0.accept(this);
        return this.result;
    }

    @Override
    public void visitString(NBTTagString var0) {
        String var1 = NBTTagString.quoteAndEscape(var0.value());
        String var2 = var1.substring(0, 1);
        IChatMutableComponent var3 = IChatBaseComponent.literal(var1.substring(1, var1.length() - 1)).withStyle(SYNTAX_HIGHLIGHTING_STRING);
        this.result.append(var2).append(var3).append(var2);
    }

    @Override
    public void visitByte(NBTTagByte var0) {
        this.result.append(IChatBaseComponent.literal(String.valueOf(var0.value())).withStyle(SYNTAX_HIGHLIGHTING_NUMBER)).append(BYTE_TYPE);
    }

    @Override
    public void visitShort(NBTTagShort var0) {
        this.result.append(IChatBaseComponent.literal(String.valueOf(var0.value())).withStyle(SYNTAX_HIGHLIGHTING_NUMBER)).append(SHORT_TYPE);
    }

    @Override
    public void visitInt(NBTTagInt var0) {
        this.result.append(IChatBaseComponent.literal(String.valueOf(var0.value())).withStyle(SYNTAX_HIGHLIGHTING_NUMBER));
    }

    @Override
    public void visitLong(NBTTagLong var0) {
        this.result.append(IChatBaseComponent.literal(String.valueOf(var0.value())).withStyle(SYNTAX_HIGHLIGHTING_NUMBER)).append(LONG_TYPE);
    }

    @Override
    public void visitFloat(NBTTagFloat var0) {
        this.result.append(IChatBaseComponent.literal(String.valueOf(var0.value())).withStyle(SYNTAX_HIGHLIGHTING_NUMBER)).append(FLOAT_TYPE);
    }

    @Override
    public void visitDouble(NBTTagDouble var0) {
        this.result.append(IChatBaseComponent.literal(String.valueOf(var0.value())).withStyle(SYNTAX_HIGHLIGHTING_NUMBER)).append(DOUBLE_TYPE);
    }

    @Override
    public void visitByteArray(NBTTagByteArray var0) {
        this.result.append(LIST_OPEN).append(BYTE_ARRAY_TYPE).append(LIST_TYPE_SEPARATOR);
        byte[] var1 = var0.getAsByteArray();
        for (int var2 = 0; var2 < var1.length && var2 < 128; ++var2) {
            IChatMutableComponent var3 = IChatBaseComponent.literal(String.valueOf(var1[var2])).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
            this.result.append(ELEMENT_SPACING).append(var3).append(BYTE_ARRAY_TYPE);
            if (var2 == var1.length - 1) continue;
            this.result.append(ELEMENT_SEPARATOR);
        }
        if (var1.length > 128) {
            this.result.append(FOLDED);
        }
        this.result.append(LIST_CLOSE);
    }

    @Override
    public void visitIntArray(NBTTagIntArray var0) {
        this.result.append(LIST_OPEN).append(INT_TYPE).append(LIST_TYPE_SEPARATOR);
        int[] var1 = var0.getAsIntArray();
        for (int var2 = 0; var2 < var1.length && var2 < 128; ++var2) {
            this.result.append(ELEMENT_SPACING).append(IChatBaseComponent.literal(String.valueOf(var1[var2])).withStyle(SYNTAX_HIGHLIGHTING_NUMBER));
            if (var2 == var1.length - 1) continue;
            this.result.append(ELEMENT_SEPARATOR);
        }
        if (var1.length > 128) {
            this.result.append(FOLDED);
        }
        this.result.append(LIST_CLOSE);
    }

    @Override
    public void visitLongArray(NBTTagLongArray var0) {
        this.result.append(LIST_OPEN).append(LONG_TYPE).append(LIST_TYPE_SEPARATOR);
        long[] var1 = var0.getAsLongArray();
        for (int var2 = 0; var2 < var1.length && var2 < 128; ++var2) {
            IChatMutableComponent var3 = IChatBaseComponent.literal(String.valueOf(var1[var2])).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
            this.result.append(ELEMENT_SPACING).append(var3).append(LONG_TYPE);
            if (var2 == var1.length - 1) continue;
            this.result.append(ELEMENT_SEPARATOR);
        }
        if (var1.length > 128) {
            this.result.append(FOLDED);
        }
        this.result.append(LIST_CLOSE);
    }

    private static boolean shouldWrapListElements(NBTTagList var0) {
        if (var0.size() >= 8) {
            return false;
        }
        for (NBTBase var2 : var0) {
            if (var2 instanceof NBTNumber) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visitList(NBTTagList var0) {
        if (var0.isEmpty()) {
            this.result.append("[]");
            return;
        }
        if (this.depth >= 64) {
            this.result.append(LIST_OPEN).append(FOLDED).append(LIST_CLOSE);
            return;
        }
        if (!TextComponentTagVisitor.shouldWrapListElements(var0)) {
            this.result.append(LIST_OPEN);
            for (int var1 = 0; var1 < var0.size(); ++var1) {
                if (var1 != 0) {
                    this.result.append(SPACED_ELEMENT_SEPARATOR);
                }
                this.appendSubTag(var0.get(var1), false);
            }
            this.result.append(LIST_CLOSE);
            return;
        }
        this.result.append(LIST_OPEN);
        if (!this.indentation.isEmpty()) {
            this.result.append(NEWLINE);
        }
        String var1 = Strings.repeat((String)this.indentation, (int)(this.indentDepth + 1));
        for (int var2 = 0; var2 < var0.size() && var2 < 128; ++var2) {
            this.result.append(var1);
            this.appendSubTag(var0.get(var2), true);
            if (var2 == var0.size() - 1) continue;
            this.result.append(this.indentation.isEmpty() ? SPACED_ELEMENT_SEPARATOR : WRAPPED_ELEMENT_SEPARATOR);
        }
        if (var0.size() > 128) {
            this.result.append(var1).append(FOLDED);
        }
        if (!this.indentation.isEmpty()) {
            this.result.append(NEWLINE + Strings.repeat((String)this.indentation, (int)this.indentDepth));
        }
        this.result.append(LIST_CLOSE);
    }

    @Override
    public void visitCompound(NBTTagCompound var0) {
        Object var2;
        if (var0.isEmpty()) {
            this.result.append("{}");
            return;
        }
        if (this.depth >= 64) {
            this.result.append(STRUCT_OPEN).append(FOLDED).append(STRUCT_CLOSE);
            return;
        }
        this.result.append(STRUCT_OPEN);
        Collection<String> var1 = var0.keySet();
        if (LOGGER.isDebugEnabled()) {
            var2 = Lists.newArrayList(var0.keySet());
            Collections.sort(var2);
            var1 = var2;
        }
        if (!this.indentation.isEmpty()) {
            this.result.append(NEWLINE);
        }
        var2 = Strings.repeat((String)this.indentation, (int)(this.indentDepth + 1));
        Iterator<String> var3 = var1.iterator();
        while (var3.hasNext()) {
            String var4 = var3.next();
            this.result.append((String)var2).append(TextComponentTagVisitor.handleEscapePretty(var4)).append(NAME_VALUE_SEPARATOR);
            this.appendSubTag(var0.get(var4), true);
            if (!var3.hasNext()) continue;
            this.result.append(this.indentation.isEmpty() ? SPACED_ELEMENT_SEPARATOR : WRAPPED_ELEMENT_SEPARATOR);
        }
        if (!this.indentation.isEmpty()) {
            this.result.append(NEWLINE + Strings.repeat((String)this.indentation, (int)this.indentDepth));
        }
        this.result.append(STRUCT_CLOSE);
    }

    private void appendSubTag(NBTBase var0, boolean var1) {
        if (var1) {
            ++this.indentDepth;
        }
        ++this.depth;
        try {
            var0.accept(this);
        }
        finally {
            if (var1) {
                --this.indentDepth;
            }
            --this.depth;
        }
    }

    protected static IChatBaseComponent handleEscapePretty(String var0) {
        if (SIMPLE_VALUE.matcher(var0).matches()) {
            return IChatBaseComponent.literal(var0).withStyle(SYNTAX_HIGHLIGHTING_KEY);
        }
        String var1 = NBTTagString.quoteAndEscape(var0);
        String var2 = var1.substring(0, 1);
        IChatMutableComponent var3 = IChatBaseComponent.literal(var1.substring(1, var1.length() - 1)).withStyle(SYNTAX_HIGHLIGHTING_KEY);
        return IChatBaseComponent.literal(var2).append(var3).append(var2);
    }

    @Override
    public void visitEnd(NBTTagEnd var0) {
    }
}

