/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.nbt.NBTBase;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.INamable;

public interface ChatClickable {
    public static final Codec<ChatClickable> CODEC = EnumClickAction.CODEC.dispatch("action", ChatClickable::action, var0 -> var0.codec);

    public EnumClickAction action();

    public static final class EnumClickAction
    extends Enum<EnumClickAction>
    implements INamable {
        public static final /* enum */ EnumClickAction OPEN_URL = new EnumClickAction("open_url", true, OpenUrl.CODEC);
        public static final /* enum */ EnumClickAction OPEN_FILE = new EnumClickAction("open_file", false, OpenFile.CODEC);
        public static final /* enum */ EnumClickAction RUN_COMMAND = new EnumClickAction("run_command", true, RunCommand.CODEC);
        public static final /* enum */ EnumClickAction SUGGEST_COMMAND = new EnumClickAction("suggest_command", true, SuggestCommand.CODEC);
        public static final /* enum */ EnumClickAction SHOW_DIALOG = new EnumClickAction("show_dialog", true, h.CODEC);
        public static final /* enum */ EnumClickAction CHANGE_PAGE = new EnumClickAction("change_page", true, ChangePage.CODEC);
        public static final /* enum */ EnumClickAction COPY_TO_CLIPBOARD = new EnumClickAction("copy_to_clipboard", true, CopyToClipboard.CODEC);
        public static final /* enum */ EnumClickAction CUSTOM = new EnumClickAction("custom", true, d.CODEC);
        public static final Codec<EnumClickAction> UNSAFE_CODEC;
        public static final Codec<EnumClickAction> CODEC;
        private final boolean allowFromServer;
        private final String name;
        final MapCodec<? extends ChatClickable> codec;
        private static final /* synthetic */ EnumClickAction[] n;

        public static EnumClickAction[] values() {
            return (EnumClickAction[])n.clone();
        }

        public static EnumClickAction valueOf(String var0) {
            return Enum.valueOf(EnumClickAction.class, var0);
        }

        private EnumClickAction(String var2, boolean var3, MapCodec var4) {
            this.name = var2;
            this.allowFromServer = var3;
            this.codec = var4;
        }

        public boolean isAllowedFromServer() {
            return this.allowFromServer;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        public MapCodec<? extends ChatClickable> valueCodec() {
            return this.codec;
        }

        public static DataResult<EnumClickAction> filterForSerialization(EnumClickAction var0) {
            if (!var0.isAllowedFromServer()) {
                return DataResult.error(() -> "Click event type not allowed: " + String.valueOf(var0));
            }
            return DataResult.success((Object)var0, (Lifecycle)Lifecycle.stable());
        }

        private static /* synthetic */ EnumClickAction[] d() {
            return new EnumClickAction[]{OPEN_URL, OPEN_FILE, RUN_COMMAND, SUGGEST_COMMAND, SHOW_DIALOG, CHANGE_PAGE, COPY_TO_CLIPBOARD, CUSTOM};
        }

        static {
            n = EnumClickAction.d();
            UNSAFE_CODEC = INamable.fromEnum(EnumClickAction::values);
            CODEC = UNSAFE_CODEC.validate(EnumClickAction::filterForSerialization);
        }
    }

    public record d(MinecraftKey id, Optional<NBTBase> payload) implements ChatClickable
    {
        public static final MapCodec<d> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)MinecraftKey.CODEC.fieldOf("id").forGetter(d::id), (App)ExtraCodecs.NBT.optionalFieldOf("payload").forGetter(d::payload)).apply((Applicative)var0, d::new));

        @Override
        public EnumClickAction action() {
            return EnumClickAction.CUSTOM;
        }
    }

    public record CopyToClipboard(String value) implements ChatClickable
    {
        public static final MapCodec<CopyToClipboard> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.STRING.fieldOf("value").forGetter(CopyToClipboard::value)).apply((Applicative)var0, CopyToClipboard::new));

        @Override
        public EnumClickAction action() {
            return EnumClickAction.COPY_TO_CLIPBOARD;
        }
    }

    public record ChangePage(int page) implements ChatClickable
    {
        public static final MapCodec<ChangePage> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)ExtraCodecs.POSITIVE_INT.fieldOf("page").forGetter(ChangePage::page)).apply((Applicative)var0, ChangePage::new));

        @Override
        public EnumClickAction action() {
            return EnumClickAction.CHANGE_PAGE;
        }
    }

    public record h(Holder<Dialog> dialog) implements ChatClickable
    {
        public static final MapCodec<h> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Dialog.CODEC.fieldOf("dialog").forGetter(h::dialog)).apply((Applicative)var0, h::new));

        @Override
        public EnumClickAction action() {
            return EnumClickAction.SHOW_DIALOG;
        }
    }

    public record SuggestCommand(String command) implements ChatClickable
    {
        public static final MapCodec<SuggestCommand> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)ExtraCodecs.CHAT_STRING.fieldOf("command").forGetter(SuggestCommand::command)).apply((Applicative)var0, SuggestCommand::new));

        @Override
        public EnumClickAction action() {
            return EnumClickAction.SUGGEST_COMMAND;
        }
    }

    public record RunCommand(String command) implements ChatClickable
    {
        public static final MapCodec<RunCommand> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)ExtraCodecs.CHAT_STRING.fieldOf("command").forGetter(RunCommand::command)).apply((Applicative)var0, RunCommand::new));

        @Override
        public EnumClickAction action() {
            return EnumClickAction.RUN_COMMAND;
        }
    }

    public record OpenFile(String path) implements ChatClickable
    {
        public static final MapCodec<OpenFile> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.STRING.fieldOf("path").forGetter(OpenFile::path)).apply((Applicative)var0, OpenFile::new));

        public OpenFile(File var0) {
            this(var0.toString());
        }

        public OpenFile(Path var0) {
            this(var0.toFile());
        }

        public File file() {
            return new File(this.path);
        }

        @Override
        public EnumClickAction action() {
            return EnumClickAction.OPEN_FILE;
        }
    }

    public record OpenUrl(URI uri) implements ChatClickable
    {
        public static final MapCodec<OpenUrl> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)ExtraCodecs.UNTRUSTED_URI.fieldOf("url").forGetter(OpenUrl::uri)).apply((Applicative)var0, OpenUrl::new));

        @Override
        public EnumClickAction action() {
            return EnumClickAction.OPEN_URL;
        }
    }
}

