/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.primitives.Ints;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.security.SignatureException;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.FilterMask;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.SignedMessageBody;
import net.minecraft.network.chat.SignedMessageLink;
import net.minecraft.util.SignatureUpdater;
import net.minecraft.util.SignatureValidator;

public record PlayerChatMessage(SignedMessageLink link, @Nullable MessageSignature signature, SignedMessageBody signedBody, @Nullable IChatBaseComponent unsignedContent, FilterMask filterMask) {
    public static final MapCodec<PlayerChatMessage> MAP_CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)SignedMessageLink.CODEC.fieldOf("link").forGetter(PlayerChatMessage::link), (App)MessageSignature.CODEC.optionalFieldOf("signature").forGetter(var0 -> Optional.ofNullable(var0.signature)), (App)SignedMessageBody.MAP_CODEC.forGetter(PlayerChatMessage::signedBody), (App)ComponentSerialization.CODEC.optionalFieldOf("unsigned_content").forGetter(var0 -> Optional.ofNullable(var0.unsignedContent)), (App)FilterMask.CODEC.optionalFieldOf("filter_mask", (Object)FilterMask.PASS_THROUGH).forGetter(PlayerChatMessage::filterMask)).apply((Applicative)var02, (var0, var1, var2, var3, var4) -> new PlayerChatMessage((SignedMessageLink)var0, var1.orElse(null), (SignedMessageBody)var2, var3.orElse(null), (FilterMask)var4)));
    private static final UUID SYSTEM_SENDER = SystemUtils.NIL_UUID;
    public static final Duration MESSAGE_EXPIRES_AFTER_SERVER = Duration.ofMinutes(5L);
    public static final Duration MESSAGE_EXPIRES_AFTER_CLIENT = MESSAGE_EXPIRES_AFTER_SERVER.plus(Duration.ofMinutes(2L));

    public static PlayerChatMessage system(String var0) {
        return PlayerChatMessage.unsigned(SYSTEM_SENDER, var0);
    }

    public static PlayerChatMessage unsigned(UUID var0, String var1) {
        SignedMessageBody var2 = SignedMessageBody.unsigned(var1);
        SignedMessageLink var3 = SignedMessageLink.unsigned(var0);
        return new PlayerChatMessage(var3, null, var2, null, FilterMask.PASS_THROUGH);
    }

    public PlayerChatMessage withUnsignedContent(IChatBaseComponent var0) {
        IChatBaseComponent var1 = !var0.equals(IChatBaseComponent.literal(this.signedContent())) ? var0 : null;
        return new PlayerChatMessage(this.link, this.signature, this.signedBody, var1, this.filterMask);
    }

    public PlayerChatMessage removeUnsignedContent() {
        if (this.unsignedContent != null) {
            return new PlayerChatMessage(this.link, this.signature, this.signedBody, null, this.filterMask);
        }
        return this;
    }

    public PlayerChatMessage filter(FilterMask var0) {
        if (this.filterMask.equals(var0)) {
            return this;
        }
        return new PlayerChatMessage(this.link, this.signature, this.signedBody, this.unsignedContent, var0);
    }

    public PlayerChatMessage filter(boolean var0) {
        return this.filter(var0 ? this.filterMask : FilterMask.PASS_THROUGH);
    }

    public PlayerChatMessage removeSignature() {
        SignedMessageBody var0 = SignedMessageBody.unsigned(this.signedContent());
        SignedMessageLink var1 = SignedMessageLink.unsigned(this.sender());
        return new PlayerChatMessage(var1, null, var0, this.unsignedContent, this.filterMask);
    }

    public static void updateSignature(SignatureUpdater.a var0, SignedMessageLink var1, SignedMessageBody var2) throws SignatureException {
        var0.update(Ints.toByteArray((int)1));
        var1.updateSignature(var0);
        var2.updateSignature(var0);
    }

    public boolean verify(SignatureValidator var02) {
        return this.signature != null && this.signature.verify(var02, var0 -> PlayerChatMessage.updateSignature(var0, this.link, this.signedBody));
    }

    public String signedContent() {
        return this.signedBody.content();
    }

    public IChatBaseComponent decoratedContent() {
        return Objects.requireNonNullElseGet(this.unsignedContent, () -> IChatBaseComponent.literal(this.signedContent()));
    }

    public Instant timeStamp() {
        return this.signedBody.timeStamp();
    }

    public long salt() {
        return this.signedBody.salt();
    }

    public boolean hasExpiredServer(Instant var0) {
        return var0.isAfter(this.timeStamp().plus(MESSAGE_EXPIRES_AFTER_SERVER));
    }

    public boolean hasExpiredClient(Instant var0) {
        return var0.isAfter(this.timeStamp().plus(MESSAGE_EXPIRES_AFTER_CLIENT));
    }

    public UUID sender() {
        return this.link.sender();
    }

    public boolean isSystem() {
        return this.sender().equals(SYSTEM_SENDER);
    }

    public boolean hasSignature() {
        return this.signature != null;
    }

    public boolean hasSignatureFrom(UUID var0) {
        return this.hasSignature() && this.link.sender().equals(var0);
    }

    public boolean isFullyFiltered() {
        return this.filterMask.isFullyFiltered();
    }

    public static String describeSigned(PlayerChatMessage var02) {
        return "'" + var02.signedBody.content() + "' @ " + String.valueOf(var02.signedBody.timeStamp()) + "\n - From: " + String.valueOf(var02.link.sender()) + "/" + String.valueOf(var02.link.sessionId()) + ", message #" + var02.link.index() + "\n - Salt: " + var02.signedBody.salt() + "\n - Signature: " + MessageSignature.describe(var02.signature) + "\n - Last Seen: [\n" + var02.signedBody.lastSeen().entries().stream().map(var0 -> "     " + MessageSignature.describe(var0) + "\n").collect(Collectors.joining()) + " ]\n";
    }
}

