/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.core.BlockPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;
import net.minecraft.world.level.block.entity.TileEntityCommand;

public class PacketPlayInSetCommandBlock
implements Packet<PacketListenerPlayIn> {
    public static final StreamCodec<PacketDataSerializer, PacketPlayInSetCommandBlock> STREAM_CODEC = Packet.codec(PacketPlayInSetCommandBlock::write, PacketPlayInSetCommandBlock::new);
    private static final int FLAG_TRACK_OUTPUT = 1;
    private static final int FLAG_CONDITIONAL = 2;
    private static final int FLAG_AUTOMATIC = 4;
    private final BlockPosition pos;
    private final String command;
    private final boolean trackOutput;
    private final boolean conditional;
    private final boolean automatic;
    private final TileEntityCommand.Type mode;

    public PacketPlayInSetCommandBlock(BlockPosition var0, String var1, TileEntityCommand.Type var2, boolean var3, boolean var4, boolean var5) {
        this.pos = var0;
        this.command = var1;
        this.trackOutput = var3;
        this.conditional = var4;
        this.automatic = var5;
        this.mode = var2;
    }

    private PacketPlayInSetCommandBlock(PacketDataSerializer var0) {
        this.pos = var0.readBlockPos();
        this.command = var0.readUtf();
        this.mode = var0.readEnum(TileEntityCommand.Type.class);
        byte var1 = var0.readByte();
        this.trackOutput = (var1 & 1) != 0;
        this.conditional = (var1 & 2) != 0;
        this.automatic = (var1 & 4) != 0;
    }

    private void write(PacketDataSerializer var0) {
        var0.writeBlockPos(this.pos);
        var0.writeUtf(this.command);
        var0.writeEnum(this.mode);
        int var1 = 0;
        if (this.trackOutput) {
            var1 |= 1;
        }
        if (this.conditional) {
            var1 |= 2;
        }
        if (this.automatic) {
            var1 |= 4;
        }
        var0.writeByte(var1);
    }

    @Override
    public PacketType<PacketPlayInSetCommandBlock> type() {
        return GamePacketTypes.SERVERBOUND_SET_COMMAND_BLOCK;
    }

    @Override
    public void handle(PacketListenerPlayIn var0) {
        var0.handleSetCommandBlock(this);
    }

    public BlockPosition getPos() {
        return this.pos;
    }

    public String getCommand() {
        return this.command;
    }

    public boolean isTrackOutput() {
        return this.trackOutput;
    }

    public boolean isConditional() {
        return this.conditional;
    }

    public boolean isAutomatic() {
        return this.automatic;
    }

    public TileEntityCommand.Type getMode() {
        return this.mode;
    }
}

