/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;

public class PacketPlayOutExperience
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<PacketDataSerializer, PacketPlayOutExperience> STREAM_CODEC = Packet.codec(PacketPlayOutExperience::write, PacketPlayOutExperience::new);
    private final float experienceProgress;
    private final int totalExperience;
    private final int experienceLevel;

    public PacketPlayOutExperience(float var0, int var1, int var2) {
        this.experienceProgress = var0;
        this.totalExperience = var1;
        this.experienceLevel = var2;
    }

    private PacketPlayOutExperience(PacketDataSerializer var0) {
        this.experienceProgress = var0.readFloat();
        this.experienceLevel = var0.readVarInt();
        this.totalExperience = var0.readVarInt();
    }

    private void write(PacketDataSerializer var0) {
        var0.writeFloat(this.experienceProgress);
        var0.writeVarInt(this.experienceLevel);
        var0.writeVarInt(this.totalExperience);
    }

    @Override
    public PacketType<PacketPlayOutExperience> type() {
        return GamePacketTypes.CLIENTBOUND_SET_EXPERIENCE;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleSetExperience(this);
    }

    public float getExperienceProgress() {
        return this.experienceProgress;
    }

    public int getTotalExperience() {
        return this.totalExperience;
    }

    public int getExperienceLevel() {
        return this.experienceLevel;
    }
}

