/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentTime;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.WorldServer;

public class CommandTime {
    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("time").requires(net.minecraft.commands.CommandDispatcher.hasPermission(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("set").then(net.minecraft.commands.CommandDispatcher.literal("day").executes(var0 -> CommandTime.setTime((CommandListenerWrapper)var0.getSource(), 1000)))).then(net.minecraft.commands.CommandDispatcher.literal("noon").executes(var0 -> CommandTime.setTime((CommandListenerWrapper)var0.getSource(), 6000)))).then(net.minecraft.commands.CommandDispatcher.literal("night").executes(var0 -> CommandTime.setTime((CommandListenerWrapper)var0.getSource(), 13000)))).then(net.minecraft.commands.CommandDispatcher.literal("midnight").executes(var0 -> CommandTime.setTime((CommandListenerWrapper)var0.getSource(), 18000)))).then(net.minecraft.commands.CommandDispatcher.argument("time", ArgumentTime.time()).executes(var0 -> CommandTime.setTime((CommandListenerWrapper)var0.getSource(), IntegerArgumentType.getInteger((CommandContext)var0, (String)"time")))))).then(net.minecraft.commands.CommandDispatcher.literal("add").then(net.minecraft.commands.CommandDispatcher.argument("time", ArgumentTime.time()).executes(var0 -> CommandTime.addTime((CommandListenerWrapper)var0.getSource(), IntegerArgumentType.getInteger((CommandContext)var0, (String)"time")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("query").then(net.minecraft.commands.CommandDispatcher.literal("daytime").executes(var0 -> CommandTime.queryTime((CommandListenerWrapper)var0.getSource(), CommandTime.getDayTime(((CommandListenerWrapper)var0.getSource()).getLevel()))))).then(net.minecraft.commands.CommandDispatcher.literal("gametime").executes(var0 -> CommandTime.queryTime((CommandListenerWrapper)var0.getSource(), (int)(((CommandListenerWrapper)var0.getSource()).getLevel().getGameTime() % Integer.MAX_VALUE))))).then(net.minecraft.commands.CommandDispatcher.literal("day").executes(var0 -> CommandTime.queryTime((CommandListenerWrapper)var0.getSource(), (int)(((CommandListenerWrapper)var0.getSource()).getLevel().getDayTime() / 24000L % Integer.MAX_VALUE))))));
    }

    private static int getDayTime(WorldServer var0) {
        return (int)(var0.getDayTime() % 24000L);
    }

    private static int queryTime(CommandListenerWrapper var0, int var1) {
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.time.query", var1), false);
        return var1;
    }

    public static int setTime(CommandListenerWrapper var0, int var1) {
        for (WorldServer var3 : var0.getServer().getAllLevels()) {
            var3.setDayTime(var1);
        }
        var0.getServer().forceTimeSynchronization();
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.time.set", var1), true);
        return CommandTime.getDayTime(var0.getLevel());
    }

    public static int addTime(CommandListenerWrapper var0, int var1) {
        for (WorldServer var3 : var0.getServer().getAllLevels()) {
            var3.setDayTime(var3.getDayTime() + (long)var1);
        }
        var0.getServer().forceTimeSynchronization();
        int var2 = CommandTime.getDayTime(var0.getLevel());
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.time.set", var2), true);
        return var2;
    }
}

