/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Locale;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.jsonrpc.api.MethodInfo;
import net.minecraft.server.jsonrpc.api.ParamInfo;
import net.minecraft.server.jsonrpc.api.ResultInfo;
import net.minecraft.server.jsonrpc.internalapi.MinecraftApi;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.server.jsonrpc.methods.EncodeJsonRpcException;
import net.minecraft.server.jsonrpc.methods.IllegalMethodDefinitionException;
import net.minecraft.server.jsonrpc.methods.InvalidParameterJsonRpcException;

public interface IncomingRpcMethod {
    public MethodInfo info();

    public a attributes();

    public JsonElement apply(MinecraftApi var1, @Nullable JsonElement var2, ClientInfo var3);

    public static <Result> c<e<Result>> method(f<Result> var0, Codec<Result> var1) {
        return new c<e<Result>>((var2, var3) -> {
            if (var2.params().isPresent()) {
                throw new IllegalMethodDefinitionException("Method defined as not having parameters but is describing them");
            }
            if (var2.result().isEmpty()) {
                throw new IllegalMethodDefinitionException("Method lacks result");
            }
            return new e(var2, var3, var1, var0);
        });
    }

    public static <Params, Result> c<d<Params, Result>> method(g<Params, Result> var0, Codec<Params> var1, Codec<Result> var2) {
        return new c<d<Params, Result>>((var3, var4) -> {
            if (var3.params().isEmpty()) {
                throw new IllegalMethodDefinitionException("Method defined as having parameters without describing them");
            }
            if (var3.result().isEmpty()) {
                throw new IllegalMethodDefinitionException("Method lacks result");
            }
            return new d(var3, var4, var1, var2, var0);
        });
    }

    public static <Result> c<e<Result>> method(Function<MinecraftApi, Result> var0, Codec<Result> var1) {
        return new c<e<Result>>((var22, var3) -> {
            if (var22.params().isPresent()) {
                throw new IllegalMethodDefinitionException("Method defined as not having parameters but is describing them");
            }
            if (var22.result().isEmpty()) {
                throw new IllegalMethodDefinitionException("Method lacks result");
            }
            return new e<Object>(var22, var3, var1, (var1, var2) -> var0.apply(var1));
        });
    }

    public static class c<T extends IncomingRpcMethod> {
        private final b<T> method;
        private String description = "";
        @Nullable
        private ParamInfo paramInfo;
        @Nullable
        private ResultInfo resultInfo;
        private boolean discoverable = true;
        private boolean runOnMainThread = true;

        public c(b<T> var0) {
            this.method = var0;
        }

        public c<T> description(String var0) {
            this.description = var0;
            return this;
        }

        public c<T> response(ResultInfo var0) {
            this.resultInfo = var0;
            return this;
        }

        public c<T> param(ParamInfo var0) {
            this.paramInfo = var0;
            return this;
        }

        public c<T> undiscoverable() {
            this.discoverable = false;
            return this;
        }

        public c<T> notOnMainThread() {
            this.runOnMainThread = false;
            return this;
        }

        public T build() {
            MethodInfo var0 = new MethodInfo(this.description, this.paramInfo, this.resultInfo);
            return this.method.create(var0, new a(this.runOnMainThread, this.discoverable));
        }

        public T register(IRegistry<IncomingRpcMethod> var0, String var1) {
            return this.register(var0, MinecraftKey.withDefaultNamespace(var1));
        }

        private T register(IRegistry<IncomingRpcMethod> var0, MinecraftKey var1) {
            return (T)((IncomingRpcMethod)IRegistry.register(var0, var1, this.build()));
        }
    }

    @FunctionalInterface
    public static interface f<Result> {
        public Result apply(MinecraftApi var1, ClientInfo var2);
    }

    @FunctionalInterface
    public static interface b<T extends IncomingRpcMethod> {
        public T create(MethodInfo var1, a var2);
    }

    @FunctionalInterface
    public static interface g<Params, Result> {
        public Result apply(MinecraftApi var1, Params var2, ClientInfo var3);
    }

    public record e<Result>(MethodInfo info, a attributes, Codec<Result> resultCodec, f<Result> supplier) implements IncomingRpcMethod
    {
        @Override
        public JsonElement apply(MinecraftApi var0, @Nullable JsonElement var1, ClientInfo var2) {
            if (!(var1 == null || var1.isJsonArray() && var1.getAsJsonArray().isEmpty())) {
                throw new InvalidParameterJsonRpcException("Expected no params, or an empty array");
            }
            if (this.info.params().isPresent()) {
                throw new IllegalArgumentException("Method defined as not having parameters but is describing them");
            }
            Result var3 = this.supplier.apply(var0, var2);
            return (JsonElement)this.resultCodec.encodeStart((DynamicOps)JsonOps.INSTANCE, var3).getOrThrow(InvalidParameterJsonRpcException::new);
        }
    }

    public record a(boolean runOnMainThread, boolean discoverable) {
    }

    public record d<Params, Result>(MethodInfo info, a attributes, Codec<Params> paramsCodec, Codec<Result> resultCodec, g<Params, Result> function) implements IncomingRpcMethod
    {
        @Override
        public JsonElement apply(MinecraftApi var0, @Nullable JsonElement var1, ClientInfo var2) {
            JsonElement var3;
            Object var5;
            Object var4;
            if (var1 == null || !var1.isJsonArray() && !var1.isJsonObject()) {
                throw new InvalidParameterJsonRpcException("Expected params as array or named");
            }
            if (this.info.params().isEmpty()) {
                throw new IllegalArgumentException("Method defined as having parameters without describing them");
            }
            if (var1.isJsonObject()) {
                var4 = this.info.params().get().name();
                var5 = var1.getAsJsonObject().get((String)var4);
                if (var5 == null) {
                    throw new InvalidParameterJsonRpcException(String.format(Locale.ROOT, "Params passed by-name, but expected param [%s] does not exist", var4));
                }
                var3 = var5;
            } else {
                var4 = var1.getAsJsonArray();
                if (var4.isEmpty() || var4.size() > 1) {
                    throw new InvalidParameterJsonRpcException("Expected exactly one element in the params array");
                }
                var3 = var4.get(0);
            }
            var4 = this.paramsCodec.parse((DynamicOps)JsonOps.INSTANCE, (Object)var3).getOrThrow(InvalidParameterJsonRpcException::new);
            var5 = this.function.apply(var0, (JsonArray)var4, var2);
            return (JsonElement)this.resultCodec.encodeStart((DynamicOps)JsonOps.INSTANCE, var5).getOrThrow(EncodeJsonRpcException::new);
        }
    }
}

