/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.annotations.VisibleForTesting;
import java.util.function.Consumer;
import net.minecraft.world.level.ChunkCoordIntPair;

public interface ChunkTrackingView {
    public static final ChunkTrackingView EMPTY = new ChunkTrackingView(){

        @Override
        public boolean contains(int var0, int var1, boolean var2) {
            return false;
        }

        @Override
        public void forEach(Consumer<ChunkCoordIntPair> var0) {
        }
    };

    public static ChunkTrackingView of(ChunkCoordIntPair var0, int var1) {
        return new a(var0, var1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void difference(ChunkTrackingView var0, ChunkTrackingView var1, Consumer<ChunkCoordIntPair> var2, Consumer<ChunkCoordIntPair> var3) {
        a var5;
        a var4;
        block8: {
            block7: {
                if (var0.equals(var1)) {
                    return;
                }
                if (!(var0 instanceof a)) break block7;
                var4 = (a)var0;
                if (var1 instanceof a && var4.squareIntersects(var5 = (a)var1)) break block8;
            }
            var0.forEach(var3);
            var1.forEach(var2);
            return;
        }
        int var6 = Math.min(var4.minX(), var5.minX());
        int var7 = Math.min(var4.minZ(), var5.minZ());
        int var8 = Math.max(var4.maxX(), var5.maxX());
        int var9 = Math.max(var4.maxZ(), var5.maxZ());
        int var10 = var6;
        while (var10 <= var8) {
            for (int var11 = var7; var11 <= var9; ++var11) {
                boolean var13;
                boolean var12 = var4.contains(var10, var11);
                if (var12 == (var13 = var5.contains(var10, var11))) continue;
                if (var13) {
                    var2.accept(new ChunkCoordIntPair(var10, var11));
                    continue;
                }
                var3.accept(new ChunkCoordIntPair(var10, var11));
            }
            ++var10;
        }
        return;
    }

    default public boolean contains(ChunkCoordIntPair var0) {
        return this.contains(var0.x, var0.z);
    }

    default public boolean contains(int var0, int var1) {
        return this.contains(var0, var1, true);
    }

    public boolean contains(int var1, int var2, boolean var3);

    public void forEach(Consumer<ChunkCoordIntPair> var1);

    default public boolean isInViewDistance(int var0, int var1) {
        return this.contains(var0, var1, false);
    }

    public static boolean isInViewDistance(int var0, int var1, int var2, int var3, int var4) {
        return ChunkTrackingView.isWithinDistance(var0, var1, var2, var3, var4, false);
    }

    public static boolean isWithinDistance(int var0, int var1, int var2, int var3, int var4, boolean var5) {
        int var6 = var5 ? 2 : 1;
        long var7 = Math.max(0, Math.abs(var3 - var0) - var6);
        long var9 = Math.max(0, Math.abs(var4 - var1) - var6);
        long var11 = var7 * var7 + var9 * var9;
        int var13 = var2 * var2;
        return var11 < (long)var13;
    }

    public record a(ChunkCoordIntPair center, int viewDistance) implements ChunkTrackingView
    {
        int minX() {
            return this.center.x - this.viewDistance - 1;
        }

        int minZ() {
            return this.center.z - this.viewDistance - 1;
        }

        int maxX() {
            return this.center.x + this.viewDistance + 1;
        }

        int maxZ() {
            return this.center.z + this.viewDistance + 1;
        }

        @VisibleForTesting
        protected boolean squareIntersects(a var0) {
            return this.minX() <= var0.maxX() && this.maxX() >= var0.minX() && this.minZ() <= var0.maxZ() && this.maxZ() >= var0.minZ();
        }

        @Override
        public boolean contains(int var0, int var1, boolean var2) {
            return ChunkTrackingView.isWithinDistance(this.center.x, this.center.z, this.viewDistance, var0, var1, var2);
        }

        @Override
        public void forEach(Consumer<ChunkCoordIntPair> var0) {
            for (int var1 = this.minX(); var1 <= this.maxX(); ++var1) {
                for (int var2 = this.minZ(); var2 <= this.maxZ(); ++var2) {
                    if (!this.contains(var1, var2)) continue;
                    var0.accept(new ChunkCoordIntPair(var1, var2));
                }
            }
        }
    }
}

