/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundEntityPositionSyncPacket;
import net.minecraft.network.protocol.game.ClientboundMoveMinecartPacket;
import net.minecraft.network.protocol.game.ClientboundProjectilePowerPacket;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityHeadRotation;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateAttributes;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityFireball;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.entity.vehicle.MinecartBehavior;
import net.minecraft.world.entity.vehicle.NewMinecartBehavior;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.level.World;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class EntityTrackerEntry {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int TOLERANCE_LEVEL_ROTATION = 1;
    private static final double TOLERANCE_LEVEL_POSITION = 7.62939453125E-6;
    public static final int FORCED_POS_UPDATE_PERIOD = 60;
    private static final int FORCED_TELEPORT_PERIOD = 400;
    private final WorldServer level;
    private final Entity entity;
    private final int updateInterval;
    private final boolean trackDelta;
    private final a synchronizer;
    private final VecDeltaCodec positionCodec = new VecDeltaCodec();
    private byte lastSentYRot;
    private byte lastSentXRot;
    private byte lastSentYHeadRot;
    private Vec3D lastSentMovement;
    private int tickCount;
    private int teleportDelay;
    private List<Entity> lastPassengers = Collections.emptyList();
    private boolean wasRiding;
    private boolean wasOnGround;
    @Nullable
    private List<DataWatcher.c<?>> trackedDataValues;

    public EntityTrackerEntry(WorldServer var0, Entity var1, int var2, boolean var3, a var4) {
        this.level = var0;
        this.synchronizer = var4;
        this.entity = var1;
        this.updateInterval = var2;
        this.trackDelta = var3;
        this.positionCodec.setBase(var1.trackingPosition());
        this.lastSentMovement = var1.getDeltaMovement();
        this.lastSentYRot = MathHelper.packDegrees(var1.getYRot());
        this.lastSentXRot = MathHelper.packDegrees(var1.getXRot());
        this.lastSentYHeadRot = MathHelper.packDegrees(var1.getYHeadRot());
        this.wasOnGround = var1.onGround();
        this.trackedDataValues = var1.getEntityData().getNonDefaultValues();
    }

    public void sendChanges() {
        Object var4;
        Entity entity;
        List<Entity> var0 = this.entity.getPassengers();
        if (!var0.equals(this.lastPassengers)) {
            this.synchronizer.sendToTrackingPlayersFiltered(new PacketPlayOutMount(this.entity), var1 -> var0.contains(var1) == this.lastPassengers.contains(var1));
            this.lastPassengers = var0;
        }
        if ((entity = this.entity) instanceof EntityItemFrame) {
            EntityItemFrame var12 = (EntityItemFrame)entity;
            if (this.tickCount % 10 == 0) {
                MapId var3;
                ItemStack var2 = var12.getItem();
                if (var2.getItem() instanceof ItemWorldMap && (var4 = ItemWorldMap.getSavedData(var3 = var2.get(DataComponents.MAP_ID), (World)this.level)) != null) {
                    for (EntityPlayer entityPlayer : this.level.players()) {
                        ((WorldMap)var4).tickCarriedBy(entityPlayer, var2);
                        Packet<?> var7 = ((WorldMap)var4).getUpdatePacket(var3, entityPlayer);
                        if (var7 == null) continue;
                        entityPlayer.connection.send(var7);
                    }
                }
                this.sendDirtyEntityData();
            }
        }
        if (this.tickCount % this.updateInterval == 0 || this.entity.hasImpulse || this.entity.getEntityData().isDirty()) {
            boolean var3;
            byte var13 = MathHelper.packDegrees(this.entity.getYRot());
            byte var2 = MathHelper.packDegrees(this.entity.getXRot());
            boolean bl = var3 = Math.abs(var13 - this.lastSentYRot) >= 1 || Math.abs(var2 - this.lastSentXRot) >= 1;
            if (this.entity.isPassenger()) {
                if (var3) {
                    this.synchronizer.sendToTrackingPlayers(new PacketPlayOutEntity.PacketPlayOutEntityLook(this.entity.getId(), var13, var2, this.entity.onGround()));
                    this.lastSentYRot = var13;
                    this.lastSentXRot = var2;
                }
                this.positionCodec.setBase(this.entity.trackingPosition());
                this.sendDirtyEntityData();
                this.wasRiding = true;
            } else {
                MinecartBehavior minecartBehavior;
                Entity entity2 = this.entity;
                if (entity2 instanceof EntityMinecartAbstract && (minecartBehavior = ((EntityMinecartAbstract)(var4 = (EntityMinecartAbstract)entity2)).getBehavior()) instanceof NewMinecartBehavior) {
                    NewMinecartBehavior var5 = (NewMinecartBehavior)minecartBehavior;
                    this.handleMinecartPosRot(var5, var13, var2, var3);
                } else {
                    Vec3D var19;
                    double var20;
                    boolean var18;
                    ++this.teleportDelay;
                    Vec3D vec3D = this.entity.trackingPosition();
                    boolean var7 = this.positionCodec.delta(vec3D).lengthSqr() >= 7.62939453125E-6;
                    Packet<PacketListenerPlayOut> var8 = null;
                    boolean var9 = var7 || this.tickCount % 60 == 0;
                    boolean var10 = false;
                    boolean var11 = false;
                    long var12 = this.positionCodec.encodeX(vec3D);
                    long var14 = this.positionCodec.encodeY(vec3D);
                    long var16 = this.positionCodec.encodeZ(vec3D);
                    boolean bl2 = var18 = var12 < -32768L || var12 > 32767L || var14 < -32768L || var14 > 32767L || var16 < -32768L || var16 > 32767L;
                    if (this.entity.getRequiresPrecisePosition() || var18 || this.teleportDelay > 400 || this.wasRiding || this.wasOnGround != this.entity.onGround()) {
                        this.wasOnGround = this.entity.onGround();
                        this.teleportDelay = 0;
                        var8 = ClientboundEntityPositionSyncPacket.of(this.entity);
                        var10 = true;
                        var11 = true;
                    } else if (var9 && var3 || this.entity instanceof EntityArrow) {
                        var8 = new PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook(this.entity.getId(), (short)var12, (short)var14, (short)var16, var13, var2, this.entity.onGround());
                        var10 = true;
                        var11 = true;
                    } else if (var9) {
                        var8 = new PacketPlayOutEntity.PacketPlayOutRelEntityMove(this.entity.getId(), (short)var12, (short)var14, (short)var16, this.entity.onGround());
                        var10 = true;
                    } else if (var3) {
                        var8 = new PacketPlayOutEntity.PacketPlayOutEntityLook(this.entity.getId(), var13, var2, this.entity.onGround());
                        var11 = true;
                    }
                    if ((this.entity.hasImpulse || this.trackDelta || this.entity instanceof EntityLiving && ((EntityLiving)this.entity).isFallFlying()) && ((var20 = (var19 = this.entity.getDeltaMovement()).distanceToSqr(this.lastSentMovement)) > 1.0E-7 || var20 > 0.0 && var19.lengthSqr() == 0.0)) {
                        this.lastSentMovement = var19;
                        Entity entity3 = this.entity;
                        if (entity3 instanceof EntityFireball) {
                            EntityFireball var22 = (EntityFireball)entity3;
                            this.synchronizer.sendToTrackingPlayers(new ClientboundBundlePacket((Iterable<Packet<? super PacketListenerPlayOut>>)List.of(new PacketPlayOutEntityVelocity(this.entity.getId(), this.lastSentMovement), new ClientboundProjectilePowerPacket(var22.getId(), var22.accelerationPower))));
                        } else {
                            this.synchronizer.sendToTrackingPlayers(new PacketPlayOutEntityVelocity(this.entity.getId(), this.lastSentMovement));
                        }
                    }
                    if (var8 != null) {
                        this.synchronizer.sendToTrackingPlayers(var8);
                    }
                    this.sendDirtyEntityData();
                    if (var10) {
                        this.positionCodec.setBase(vec3D);
                    }
                    if (var11) {
                        this.lastSentYRot = var13;
                        this.lastSentXRot = var2;
                    }
                    this.wasRiding = false;
                }
            }
            byte var42 = MathHelper.packDegrees(this.entity.getYHeadRot());
            if (Math.abs(var42 - this.lastSentYHeadRot) >= 1) {
                this.synchronizer.sendToTrackingPlayers(new PacketPlayOutEntityHeadRotation(this.entity, var42));
                this.lastSentYHeadRot = var42;
            }
            this.entity.hasImpulse = false;
        }
        ++this.tickCount;
        if (this.entity.hurtMarked) {
            this.entity.hurtMarked = false;
            this.synchronizer.sendToTrackingPlayersAndSelf(new PacketPlayOutEntityVelocity(this.entity));
        }
    }

    private void handleMinecartPosRot(NewMinecartBehavior var0, byte var1, byte var2, boolean var3) {
        this.sendDirtyEntityData();
        if (var0.lerpSteps.isEmpty()) {
            boolean var9;
            Vec3D var4 = this.entity.getDeltaMovement();
            double var5 = var4.distanceToSqr(this.lastSentMovement);
            Vec3D var7 = this.entity.trackingPosition();
            boolean var8 = this.positionCodec.delta(var7).lengthSqr() >= 7.62939453125E-6;
            boolean bl = var9 = var8 || this.tickCount % 60 == 0;
            if (var9 || var3 || var5 > 1.0E-7) {
                this.synchronizer.sendToTrackingPlayers(new ClientboundMoveMinecartPacket(this.entity.getId(), List.of(new NewMinecartBehavior.a(this.entity.position(), this.entity.getDeltaMovement(), this.entity.getYRot(), this.entity.getXRot(), 1.0f))));
            }
        } else {
            this.synchronizer.sendToTrackingPlayers(new ClientboundMoveMinecartPacket(this.entity.getId(), List.copyOf(var0.lerpSteps)));
            var0.lerpSteps.clear();
        }
        this.lastSentYRot = var1;
        this.lastSentXRot = var2;
        this.positionCodec.setBase(this.entity.position());
    }

    public void removePairing(EntityPlayer var0) {
        this.entity.stopSeenByPlayer(var0);
        var0.connection.send(new PacketPlayOutEntityDestroy(this.entity.getId()));
    }

    public void addPairing(EntityPlayer var0) {
        ArrayList<Packet<? super PacketListenerPlayOut>> var1 = new ArrayList<Packet<? super PacketListenerPlayOut>>();
        this.sendPairingData(var0, var1::add);
        var0.connection.send(new ClientboundBundlePacket((Iterable<Packet<? super PacketListenerPlayOut>>)var1));
        this.entity.startSeenByPlayer(var0);
    }

    public void sendPairingData(EntityPlayer var0, Consumer<Packet<PacketListenerPlayOut>> var1) {
        Object var3;
        Object var4;
        Entity entity;
        if (this.entity.isRemoved()) {
            LOGGER.warn("Fetching packet for removed entity {}", (Object)this.entity);
        }
        Packet<PacketListenerPlayOut> var2 = this.entity.getAddEntityPacket(this);
        var1.accept(var2);
        if (this.trackedDataValues != null) {
            var1.accept(new PacketPlayOutEntityMetadata(this.entity.getId(), this.trackedDataValues));
        }
        if ((entity = this.entity) instanceof EntityLiving && !(var4 = ((EntityLiving)(var3 = (EntityLiving)entity)).getAttributes().getSyncableAttributes()).isEmpty()) {
            var1.accept(new PacketPlayOutUpdateAttributes(this.entity.getId(), (Collection<AttributeModifiable>)var4));
        }
        if ((var4 = this.entity) instanceof EntityLiving) {
            var3 = (EntityLiving)var4;
            var4 = Lists.newArrayList();
            for (EnumItemSlot var6 : EnumItemSlot.VALUES) {
                ItemStack var7 = ((EntityLiving)var3).getItemBySlot(var6);
                if (var7.isEmpty()) continue;
                var4.add(Pair.of((Object)var6, (Object)var7.copy()));
            }
            if (!var4.isEmpty()) {
                var1.accept(new PacketPlayOutEntityEquipment(this.entity.getId(), (List<Pair<EnumItemSlot, ItemStack>>)var4));
            }
        }
        if (!this.entity.getPassengers().isEmpty()) {
            var1.accept(new PacketPlayOutMount(this.entity));
        }
        if (this.entity.isPassenger()) {
            var1.accept(new PacketPlayOutMount(this.entity.getVehicle()));
        }
        if ((entity = this.entity) instanceof Leashable && (var3 = (Leashable)((Object)entity)).isLeashed()) {
            var1.accept(new PacketPlayOutAttachEntity(this.entity, var3.getLeashHolder()));
        }
    }

    public Vec3D getPositionBase() {
        return this.positionCodec.getBase();
    }

    public Vec3D getLastSentMovement() {
        return this.lastSentMovement;
    }

    public float getLastSentXRot() {
        return MathHelper.unpackDegrees(this.lastSentXRot);
    }

    public float getLastSentYRot() {
        return MathHelper.unpackDegrees(this.lastSentYRot);
    }

    public float getLastSentYHeadRot() {
        return MathHelper.unpackDegrees(this.lastSentYHeadRot);
    }

    private void sendDirtyEntityData() {
        DataWatcher var0 = this.entity.getEntityData();
        List<DataWatcher.c<?>> var1 = var0.packDirty();
        if (var1 != null) {
            this.trackedDataValues = var0.getNonDefaultValues();
            this.synchronizer.sendToTrackingPlayersAndSelf(new PacketPlayOutEntityMetadata(this.entity.getId(), var1));
        }
        if (this.entity instanceof EntityLiving) {
            Set<AttributeModifiable> var2 = ((EntityLiving)this.entity).getAttributes().getAttributesToSync();
            if (!var2.isEmpty()) {
                this.synchronizer.sendToTrackingPlayersAndSelf(new PacketPlayOutUpdateAttributes(this.entity.getId(), var2));
            }
            var2.clear();
        }
    }

    public static interface a {
        public void sendToTrackingPlayers(Packet<? super PacketListenerPlayOut> var1);

        public void sendToTrackingPlayersAndSelf(Packet<? super PacketListenerPlayOut> var1);

        public void sendToTrackingPlayersFiltered(Packet<? super PacketListenerPlayOut> var1, Predicate<EntityPlayer> var2);
    }
}

