/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;

public abstract class AbstractBlockPropertyFix
extends DataFix {
    private final String name;

    public AbstractBlockPropertyFix(Schema var0, String var1) {
        super(var0, false);
        this.name = var1;
    }

    protected TypeRewriteRule makeRule() {
        return this.fixTypeEverywhereTyped(this.name, this.getInputSchema().getType(DataConverterTypes.BLOCK_STATE), var0 -> var0.update(DSL.remainderFinder(), this::fixBlockState));
    }

    private Dynamic<?> fixBlockState(Dynamic<?> var0) {
        Optional<String> var12 = var0.get("Name").asString().result().map(DataConverterSchemaNamed::ensureNamespaced);
        if (var12.isPresent() && this.shouldFix(var12.get())) {
            return var0.update("Properties", var1 -> this.fixProperties((String)var12.get(), (Dynamic)var1));
        }
        return var0;
    }

    protected abstract boolean shouldFix(String var1);

    protected abstract <T> Dynamic<T> fixProperties(String var1, Dynamic<T> var2);
}

