/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;

public class MobEffectIdFix
extends DataFix {
    private static final Int2ObjectMap<String> ID_MAP = (Int2ObjectMap)SystemUtils.make(new Int2ObjectOpenHashMap(), var0 -> {
        var0.put(1, (Object)"minecraft:speed");
        var0.put(2, (Object)"minecraft:slowness");
        var0.put(3, (Object)"minecraft:haste");
        var0.put(4, (Object)"minecraft:mining_fatigue");
        var0.put(5, (Object)"minecraft:strength");
        var0.put(6, (Object)"minecraft:instant_health");
        var0.put(7, (Object)"minecraft:instant_damage");
        var0.put(8, (Object)"minecraft:jump_boost");
        var0.put(9, (Object)"minecraft:nausea");
        var0.put(10, (Object)"minecraft:regeneration");
        var0.put(11, (Object)"minecraft:resistance");
        var0.put(12, (Object)"minecraft:fire_resistance");
        var0.put(13, (Object)"minecraft:water_breathing");
        var0.put(14, (Object)"minecraft:invisibility");
        var0.put(15, (Object)"minecraft:blindness");
        var0.put(16, (Object)"minecraft:night_vision");
        var0.put(17, (Object)"minecraft:hunger");
        var0.put(18, (Object)"minecraft:weakness");
        var0.put(19, (Object)"minecraft:poison");
        var0.put(20, (Object)"minecraft:wither");
        var0.put(21, (Object)"minecraft:health_boost");
        var0.put(22, (Object)"minecraft:absorption");
        var0.put(23, (Object)"minecraft:saturation");
        var0.put(24, (Object)"minecraft:glowing");
        var0.put(25, (Object)"minecraft:levitation");
        var0.put(26, (Object)"minecraft:luck");
        var0.put(27, (Object)"minecraft:unluck");
        var0.put(28, (Object)"minecraft:slow_falling");
        var0.put(29, (Object)"minecraft:conduit_power");
        var0.put(30, (Object)"minecraft:dolphins_grace");
        var0.put(31, (Object)"minecraft:bad_omen");
        var0.put(32, (Object)"minecraft:hero_of_the_village");
        var0.put(33, (Object)"minecraft:darkness");
    });
    private static final Set<String> MOB_EFFECT_INSTANCE_CARRIER_ITEMS = Set.of("minecraft:potion", "minecraft:splash_potion", "minecraft:lingering_potion", "minecraft:tipped_arrow");

    public MobEffectIdFix(Schema var0) {
        super(var0, false);
    }

    private static <T> Optional<Dynamic<T>> getAndConvertMobEffectId(Dynamic<T> var02, String var1) {
        return var02.get(var1).asNumber().result().map(var0 -> (String)ID_MAP.get(var0.intValue())).map(arg_0 -> var02.createString(arg_0));
    }

    private static <T> Dynamic<T> updateMobEffectIdField(Dynamic<T> var0, String var1, Dynamic<T> var2, String var3) {
        Optional<Dynamic<T>> var4 = MobEffectIdFix.getAndConvertMobEffectId(var0, var1);
        return var2.replaceField(var1, var3, var4);
    }

    private static <T> Dynamic<T> updateMobEffectIdField(Dynamic<T> var0, String var1, String var2) {
        return MobEffectIdFix.updateMobEffectIdField(var0, var1, var0, var2);
    }

    private static <T> Dynamic<T> updateMobEffectInstance(Dynamic<T> var0) {
        var0 = MobEffectIdFix.updateMobEffectIdField(var0, "Id", "id");
        var0 = var0.renameField("Ambient", "ambient");
        var0 = var0.renameField("Amplifier", "amplifier");
        var0 = var0.renameField("Duration", "duration");
        var0 = var0.renameField("ShowParticles", "show_particles");
        var0 = var0.renameField("ShowIcon", "show_icon");
        Optional<Dynamic> var1 = var0.get("HiddenEffect").result().map(MobEffectIdFix::updateMobEffectInstance);
        return var0.replaceField("HiddenEffect", "hidden_effect", var1);
    }

    private static <T> Dynamic<T> updateMobEffectInstanceList(Dynamic<T> var0, String var12, String var2) {
        Optional<Dynamic> var3 = var0.get(var12).asStreamOpt().result().map(var1 -> var0.createList(var1.map(MobEffectIdFix::updateMobEffectInstance)));
        return var0.replaceField(var12, var2, var3);
    }

    private static <T> Dynamic<T> updateSuspiciousStewEntry(Dynamic<T> var0, Dynamic<T> var1) {
        var1 = MobEffectIdFix.updateMobEffectIdField(var0, "EffectId", var1, "id");
        Optional var2 = var0.get("EffectDuration").result();
        return var1.replaceField("EffectDuration", "duration", var2);
    }

    private static <T> Dynamic<T> updateSuspiciousStewEntry(Dynamic<T> var0) {
        return MobEffectIdFix.updateSuspiciousStewEntry(var0, var0);
    }

    private Typed<?> updateNamedChoice(Typed<?> var0, DSL.TypeReference var12, String var2, Function<Dynamic<?>, Dynamic<?>> var3) {
        Type var4 = this.getInputSchema().getChoiceType(var12, var2);
        Type var5 = this.getOutputSchema().getChoiceType(var12, var2);
        return var0.updateTyped(DSL.namedChoice((String)var2, (Type)var4), var5, var1 -> var1.update(DSL.remainderFinder(), var3));
    }

    private TypeRewriteRule blockEntityFixer() {
        Type var0 = this.getInputSchema().getType(DataConverterTypes.BLOCK_ENTITY);
        return this.fixTypeEverywhereTyped("BlockEntityMobEffectIdFix", var0, var02 -> {
            var02 = this.updateNamedChoice((Typed<?>)var02, DataConverterTypes.BLOCK_ENTITY, "minecraft:beacon", var0 -> {
                var0 = MobEffectIdFix.updateMobEffectIdField(var0, "Primary", "primary_effect");
                return MobEffectIdFix.updateMobEffectIdField(var0, "Secondary", "secondary_effect");
            });
            return var02;
        });
    }

    private static <T> Dynamic<T> fixMooshroomTag(Dynamic<T> var0) {
        Dynamic var1 = var0.emptyMap();
        Dynamic<T> var2 = MobEffectIdFix.updateSuspiciousStewEntry(var0, var1);
        if (!var2.equals((Object)var1)) {
            var0 = var0.set("stew_effects", var0.createList(Stream.of(var2)));
        }
        return var0.remove("EffectId").remove("EffectDuration");
    }

    private static <T> Dynamic<T> fixArrowTag(Dynamic<T> var0) {
        return MobEffectIdFix.updateMobEffectInstanceList(var0, "CustomPotionEffects", "custom_potion_effects");
    }

    private static <T> Dynamic<T> fixAreaEffectCloudTag(Dynamic<T> var0) {
        return MobEffectIdFix.updateMobEffectInstanceList(var0, "Effects", "effects");
    }

    private static Dynamic<?> updateLivingEntityTag(Dynamic<?> var0) {
        return MobEffectIdFix.updateMobEffectInstanceList(var0, "ActiveEffects", "active_effects");
    }

    private TypeRewriteRule entityFixer() {
        Type var02 = this.getInputSchema().getType(DataConverterTypes.ENTITY);
        return this.fixTypeEverywhereTyped("EntityMobEffectIdFix", var02, var0 -> {
            var0 = this.updateNamedChoice((Typed<?>)var0, DataConverterTypes.ENTITY, "minecraft:mooshroom", MobEffectIdFix::fixMooshroomTag);
            var0 = this.updateNamedChoice((Typed<?>)var0, DataConverterTypes.ENTITY, "minecraft:arrow", MobEffectIdFix::fixArrowTag);
            var0 = this.updateNamedChoice((Typed<?>)var0, DataConverterTypes.ENTITY, "minecraft:area_effect_cloud", MobEffectIdFix::fixAreaEffectCloudTag);
            var0 = var0.update(DSL.remainderFinder(), MobEffectIdFix::updateLivingEntityTag);
            return var0;
        });
    }

    private TypeRewriteRule playerFixer() {
        Type var02 = this.getInputSchema().getType(DataConverterTypes.PLAYER);
        return this.fixTypeEverywhereTyped("PlayerMobEffectIdFix", var02, var0 -> var0.update(DSL.remainderFinder(), MobEffectIdFix::updateLivingEntityTag));
    }

    private static <T> Dynamic<T> fixSuspiciousStewTag(Dynamic<T> var0) {
        Optional<Dynamic> var12 = var0.get("Effects").asStreamOpt().result().map(var1 -> var0.createList(var1.map(MobEffectIdFix::updateSuspiciousStewEntry)));
        return var0.replaceField("Effects", "effects", var12);
    }

    private TypeRewriteRule itemStackFixer() {
        OpticFinder var0 = DSL.fieldFinder((String)"id", (Type)DSL.named((String)DataConverterTypes.ITEM_NAME.typeName(), DataConverterSchemaNamed.namespacedString()));
        Type var1 = this.getInputSchema().getType(DataConverterTypes.ITEM_STACK);
        OpticFinder var22 = var1.findField("tag");
        return this.fixTypeEverywhereTyped("ItemStackMobEffectIdFix", var1, var2 -> {
            Optional var3 = var2.getOptional(var0);
            if (var3.isPresent()) {
                String var4 = (String)((Pair)var3.get()).getSecond();
                if (var4.equals("minecraft:suspicious_stew")) {
                    return var2.updateTyped(var22, var0 -> var0.update(DSL.remainderFinder(), MobEffectIdFix::fixSuspiciousStewTag));
                }
                if (MOB_EFFECT_INSTANCE_CARRIER_ITEMS.contains(var4)) {
                    return var2.updateTyped(var22, var02 -> var02.update(DSL.remainderFinder(), var0 -> MobEffectIdFix.updateMobEffectInstanceList(var0, "CustomPotionEffects", "custom_potion_effects")));
                }
            }
            return var2;
        });
    }

    protected TypeRewriteRule makeRule() {
        return TypeRewriteRule.seq((TypeRewriteRule)this.blockEntityFixer(), (TypeRewriteRule[])new TypeRewriteRule[]{this.entityFixer(), this.playerFixer(), this.itemStackFixer()});
    }
}

