/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.debug;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundDebugBlockValuePacket;
import net.minecraft.network.protocol.game.ClientboundDebugEntityValuePacket;
import net.minecraft.network.protocol.game.ClientboundDebugEventPacket;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.debug.DebugSubscription;
import net.minecraft.util.debug.DebugValueSource;
import net.minecraft.util.debug.ServerDebugSubscribers;
import net.minecraft.util.debug.TrackingDebugSynchronizer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.chunk.Chunk;

public class LevelDebugSynchronizers {
    private final WorldServer level;
    private final List<TrackingDebugSynchronizer<?>> allSynchronizers = new ArrayList();
    private final Map<DebugSubscription<?>, TrackingDebugSynchronizer.b<?>> sourceSynchronizers = new HashMap();
    private final TrackingDebugSynchronizer.a poiSynchronizer = new TrackingDebugSynchronizer.a();
    private final TrackingDebugSynchronizer.d villageSectionSynchronizer = new TrackingDebugSynchronizer.d();
    private boolean sleeping = true;
    private Set<DebugSubscription<?>> enabledSubscriptions = Set.of();

    public LevelDebugSynchronizers(WorldServer var0) {
        this.level = var0;
        for (DebugSubscription debugSubscription : BuiltInRegistries.DEBUG_SUBSCRIPTION) {
            if (debugSubscription.valueStreamCodec() == null) continue;
            this.sourceSynchronizers.put(debugSubscription, new TrackingDebugSynchronizer.b(debugSubscription));
        }
        this.allSynchronizers.addAll(this.sourceSynchronizers.values());
        this.allSynchronizers.add(this.poiSynchronizer);
        this.allSynchronizers.add(this.villageSectionSynchronizer);
    }

    public void tick(ServerDebugSubscribers var0) {
        this.enabledSubscriptions = var0.enabledSubscriptions();
        boolean var1 = this.enabledSubscriptions.isEmpty();
        if (this.sleeping != var1) {
            if (var1) {
                for (TrackingDebugSynchronizer<?> var3 : this.allSynchronizers) {
                    var3.clear();
                }
            } else {
                this.wakeUp();
            }
            this.sleeping = var1;
        }
        if (!this.sleeping) {
            for (TrackingDebugSynchronizer<?> var3 : this.allSynchronizers) {
                var3.tick(this.level);
            }
        }
    }

    private void wakeUp() {
        PlayerChunkMap var0 = this.level.getChunkSource().chunkMap;
        var0.forEachReadyToSendChunk(this::registerChunk);
        for (Entity var2 : this.level.getAllEntities()) {
            if (!var0.isTrackedByAnyPlayer(var2)) continue;
            this.registerEntity(var2);
        }
    }

    <T> TrackingDebugSynchronizer.b<T> getSourceSynchronizer(DebugSubscription<T> var0) {
        return this.sourceSynchronizers.get(var0);
    }

    public void registerChunk(final Chunk var0) {
        if (this.sleeping) {
            return;
        }
        var0.registerDebugValues(this.level, new DebugValueSource.a(){

            @Override
            public <T> void register(DebugSubscription<T> var02, DebugValueSource.b<T> var1) {
                LevelDebugSynchronizers.this.getSourceSynchronizer(var02).registerChunk(var0.getPos(), var1);
            }
        });
        var0.getBlockEntities().values().forEach(this::registerBlockEntity);
    }

    public void dropChunk(ChunkCoordIntPair var0) {
        if (this.sleeping) {
            return;
        }
        for (TrackingDebugSynchronizer.b<?> var2 : this.sourceSynchronizers.values()) {
            var2.dropChunk(var0);
        }
    }

    public void registerBlockEntity(final TileEntity var0) {
        if (this.sleeping) {
            return;
        }
        var0.registerDebugValues(this.level, new DebugValueSource.a(){

            @Override
            public <T> void register(DebugSubscription<T> var02, DebugValueSource.b<T> var1) {
                LevelDebugSynchronizers.this.getSourceSynchronizer(var02).registerBlockEntity(var0.getBlockPos(), var1);
            }
        });
    }

    public void dropBlockEntity(BlockPosition var0) {
        if (this.sleeping) {
            return;
        }
        for (TrackingDebugSynchronizer.b<?> var2 : this.sourceSynchronizers.values()) {
            var2.dropBlockEntity(this.level, var0);
        }
    }

    public void registerEntity(final Entity var0) {
        if (this.sleeping) {
            return;
        }
        var0.registerDebugValues(this.level, new DebugValueSource.a(){

            @Override
            public <T> void register(DebugSubscription<T> var02, DebugValueSource.b<T> var1) {
                LevelDebugSynchronizers.this.getSourceSynchronizer(var02).registerEntity(var0.getUUID(), var1);
            }
        });
    }

    public void dropEntity(Entity var0) {
        if (this.sleeping) {
            return;
        }
        for (TrackingDebugSynchronizer.b<?> var2 : this.sourceSynchronizers.values()) {
            var2.dropEntity(var0);
        }
    }

    public void startTrackingChunk(EntityPlayer var0, ChunkCoordIntPair var1) {
        if (this.sleeping) {
            return;
        }
        for (TrackingDebugSynchronizer<?> var3 : this.allSynchronizers) {
            var3.startTrackingChunk(var0, var1);
        }
    }

    public void startTrackingEntity(EntityPlayer var0, Entity var1) {
        if (this.sleeping) {
            return;
        }
        for (TrackingDebugSynchronizer<?> var3 : this.allSynchronizers) {
            var3.startTrackingEntity(var0, var1);
        }
    }

    public void registerPoi(VillagePlaceRecord var0) {
        if (this.sleeping) {
            return;
        }
        this.poiSynchronizer.onPoiAdded(this.level, var0);
        this.villageSectionSynchronizer.onPoiAdded(this.level, var0);
    }

    public void updatePoi(BlockPosition var0) {
        if (this.sleeping) {
            return;
        }
        this.poiSynchronizer.onPoiTicketCountChanged(this.level, var0);
    }

    public void dropPoi(BlockPosition var0) {
        if (this.sleeping) {
            return;
        }
        this.poiSynchronizer.onPoiRemoved(this.level, var0);
        this.villageSectionSynchronizer.onPoiRemoved(this.level, var0);
    }

    public boolean hasAnySubscriberFor(DebugSubscription<?> var0) {
        return this.enabledSubscriptions.contains(var0);
    }

    public <T> void sendBlockValue(BlockPosition var0, DebugSubscription<T> var1, T var2) {
        if (this.hasAnySubscriberFor(var1)) {
            this.broadcastToTracking(new ChunkCoordIntPair(var0), var1, (Packet<? super PacketListenerPlayOut>)new ClientboundDebugBlockValuePacket(var0, var1.packUpdate(var2)));
        }
    }

    public <T> void clearBlockValue(BlockPosition var0, DebugSubscription<T> var1) {
        if (this.hasAnySubscriberFor(var1)) {
            this.broadcastToTracking(new ChunkCoordIntPair(var0), var1, (Packet<? super PacketListenerPlayOut>)new ClientboundDebugBlockValuePacket(var0, var1.emptyUpdate()));
        }
    }

    public <T> void sendEntityValue(Entity var0, DebugSubscription<T> var1, T var2) {
        if (this.hasAnySubscriberFor(var1)) {
            this.broadcastToTracking(var0, var1, (Packet<? super PacketListenerPlayOut>)new ClientboundDebugEntityValuePacket(var0.getId(), var1.packUpdate(var2)));
        }
    }

    public <T> void clearEntityValue(Entity var0, DebugSubscription<T> var1) {
        if (this.hasAnySubscriberFor(var1)) {
            this.broadcastToTracking(var0, var1, (Packet<? super PacketListenerPlayOut>)new ClientboundDebugEntityValuePacket(var0.getId(), var1.emptyUpdate()));
        }
    }

    public <T> void broadcastEventToTracking(BlockPosition var0, DebugSubscription<T> var1, T var2) {
        if (this.hasAnySubscriberFor(var1)) {
            this.broadcastToTracking(new ChunkCoordIntPair(var0), var1, (Packet<? super PacketListenerPlayOut>)new ClientboundDebugEventPacket(var1.packEvent(var2)));
        }
    }

    private void broadcastToTracking(ChunkCoordIntPair var0, DebugSubscription<?> var1, Packet<? super PacketListenerPlayOut> var2) {
        PlayerChunkMap var3 = this.level.getChunkSource().chunkMap;
        for (EntityPlayer var5 : var3.getPlayers(var0, false)) {
            if (!var5.debugSubscriptions().contains(var1)) continue;
            var5.connection.send(var2);
        }
    }

    private void broadcastToTracking(Entity var0, DebugSubscription<?> var12, Packet<? super PacketListenerPlayOut> var2) {
        PlayerChunkMap var3 = this.level.getChunkSource().chunkMap;
        var3.sendToTrackingPlayersFiltered(var0, var2, var1 -> var1.debugSubscriptions().contains(var12));
    }
}

