/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import net.minecraft.world.IInventory;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;

public class InventoryLargeChest
implements IInventory {
    public final IInventory container1;
    public final IInventory container2;

    public InventoryLargeChest(IInventory var0, IInventory var1) {
        this.container1 = var0;
        this.container2 = var1;
    }

    @Override
    public int getContainerSize() {
        return this.container1.getContainerSize() + this.container2.getContainerSize();
    }

    @Override
    public boolean isEmpty() {
        return this.container1.isEmpty() && this.container2.isEmpty();
    }

    public boolean contains(IInventory var0) {
        return this.container1 == var0 || this.container2 == var0;
    }

    @Override
    public ItemStack getItem(int var0) {
        if (var0 >= this.container1.getContainerSize()) {
            return this.container2.getItem(var0 - this.container1.getContainerSize());
        }
        return this.container1.getItem(var0);
    }

    @Override
    public ItemStack removeItem(int var0, int var1) {
        if (var0 >= this.container1.getContainerSize()) {
            return this.container2.removeItem(var0 - this.container1.getContainerSize(), var1);
        }
        return this.container1.removeItem(var0, var1);
    }

    @Override
    public ItemStack removeItemNoUpdate(int var0) {
        if (var0 >= this.container1.getContainerSize()) {
            return this.container2.removeItemNoUpdate(var0 - this.container1.getContainerSize());
        }
        return this.container1.removeItemNoUpdate(var0);
    }

    @Override
    public void setItem(int var0, ItemStack var1) {
        if (var0 >= this.container1.getContainerSize()) {
            this.container2.setItem(var0 - this.container1.getContainerSize(), var1);
        } else {
            this.container1.setItem(var0, var1);
        }
    }

    @Override
    public int getMaxStackSize() {
        return this.container1.getMaxStackSize();
    }

    @Override
    public void setChanged() {
        this.container1.setChanged();
        this.container2.setChanged();
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        return this.container1.stillValid(var0) && this.container2.stillValid(var0);
    }

    @Override
    public void startOpen(ContainerUser var0) {
        this.container1.startOpen(var0);
        this.container2.startOpen(var0);
    }

    @Override
    public void stopOpen(ContainerUser var0) {
        this.container1.stopOpen(var0);
        this.container2.stopOpen(var0);
    }

    @Override
    public boolean canPlaceItem(int var0, ItemStack var1) {
        if (var0 >= this.container1.getContainerSize()) {
            return this.container2.canPlaceItem(var0 - this.container1.getContainerSize(), var1);
        }
        return this.container1.canPlaceItem(var0, var1);
    }

    @Override
    public void clearContent() {
        this.container1.clearContent();
        this.container2.clearContent();
    }
}

