/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class EntityExperienceOrb
extends Entity {
    protected static final DataWatcherObject<Integer> DATA_VALUE = DataWatcher.defineId(EntityExperienceOrb.class, DataWatcherRegistry.INT);
    private static final int LIFETIME = 6000;
    private static final int ENTITY_SCAN_PERIOD = 20;
    private static final int MAX_FOLLOW_DIST = 8;
    private static final int ORB_GROUPS_PER_AREA = 40;
    private static final double ORB_MERGE_DISTANCE = 0.5;
    private static final short DEFAULT_HEALTH = 5;
    private static final short DEFAULT_AGE = 0;
    private static final short DEFAULT_VALUE = 0;
    private static final int DEFAULT_COUNT = 1;
    private int age = 0;
    private int health = 5;
    private int count = 1;
    @Nullable
    private EntityHuman followingPlayer;
    private final InterpolationHandler interpolation = new InterpolationHandler(this);

    public EntityExperienceOrb(World var0, double var1, double var3, double var5, int var7) {
        this(var0, new Vec3D(var1, var3, var5), Vec3D.ZERO, var7);
    }

    public EntityExperienceOrb(World var0, Vec3D var1, Vec3D var2, int var3) {
        this((EntityTypes<? extends EntityExperienceOrb>)EntityTypes.EXPERIENCE_ORB, var0);
        this.setPos(var1);
        if (!var0.isClientSide()) {
            this.setYRot(this.random.nextFloat() * 360.0f);
            Vec3D var4 = new Vec3D((this.random.nextDouble() * 0.2 - 0.1) * 2.0, this.random.nextDouble() * 0.2 * 2.0, (this.random.nextDouble() * 0.2 - 0.1) * 2.0);
            if (var2.lengthSqr() > 0.0 && var2.dot(var4) < 0.0) {
                var4 = var4.scale(-1.0);
            }
            double var5 = this.getBoundingBox().getSize();
            this.setPos(var1.add(var2.normalize().scale(var5 * 0.5)));
            this.setDeltaMovement(var4);
            if (!var0.noCollision(this.getBoundingBox())) {
                this.unstuckIfPossible(var5);
            }
        }
        this.setValue(var3);
    }

    public EntityExperienceOrb(EntityTypes<? extends EntityExperienceOrb> var0, World var1) {
        super(var0, var1);
    }

    protected void unstuckIfPossible(double var02) {
        Vec3D var2 = this.position().add(0.0, (double)this.getBbHeight() / 2.0, 0.0);
        VoxelShape var3 = VoxelShapes.create(AxisAlignedBB.ofSize(var2, var02, var02, var02));
        this.level().findFreePosition(this, var3, var2, this.getBbWidth(), this.getBbHeight(), this.getBbWidth()).ifPresent(var0 -> this.setPos(var0.add(0.0, (double)(-this.getBbHeight()) / 2.0, 0.0)));
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        var0.define(DATA_VALUE, 0);
    }

    @Override
    protected double getDefaultGravity() {
        return 0.03;
    }

    @Override
    public void tick() {
        boolean var0;
        this.interpolation.interpolate();
        if (this.firstTick && this.level().isClientSide()) {
            this.firstTick = false;
            return;
        }
        super.tick();
        boolean bl = var0 = !this.level().noCollision(this.getBoundingBox());
        if (this.isEyeInFluid(TagsFluid.WATER)) {
            this.setUnderwaterMovement();
        } else if (!var0) {
            this.applyGravity();
        }
        if (this.level().getFluidState(this.blockPosition()).is(TagsFluid.LAVA)) {
            this.setDeltaMovement((this.random.nextFloat() - this.random.nextFloat()) * 0.2f, 0.2f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
        }
        if (this.tickCount % 20 == 1) {
            this.scanForMerges();
        }
        this.followNearbyPlayer();
        if (this.followingPlayer == null && !this.level().isClientSide() && var0) {
            boolean var1;
            boolean bl2 = var1 = !this.level().noCollision(this.getBoundingBox().move(this.getDeltaMovement()));
            if (var1) {
                this.moveTowardsClosestSpace(this.getX(), (this.getBoundingBox().minY + this.getBoundingBox().maxY) / 2.0, this.getZ());
                this.hasImpulse = true;
            }
        }
        double var1 = this.getDeltaMovement().y;
        this.move(EnumMoveType.SELF, this.getDeltaMovement());
        this.applyEffectsFromBlocks();
        float var3 = 0.98f;
        if (this.onGround()) {
            var3 = this.level().getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).getBlock().getFriction() * 0.98f;
        }
        this.setDeltaMovement(this.getDeltaMovement().scale(var3));
        if (this.verticalCollisionBelow && var1 < -this.getGravity()) {
            this.setDeltaMovement(new Vec3D(this.getDeltaMovement().x, -var1 * 0.4, this.getDeltaMovement().z));
        }
        ++this.age;
        if (this.age >= 6000) {
            this.discard();
        }
    }

    private void followNearbyPlayer() {
        Object var0;
        if (this.followingPlayer == null || this.followingPlayer.isSpectator() || this.followingPlayer.distanceToSqr(this) > 64.0) {
            var0 = this.level().getNearestPlayer(this, 8.0);
            this.followingPlayer = var0 != null && !((EntityHuman)var0).isSpectator() && !((EntityLiving)var0).isDeadOrDying() ? var0 : null;
        }
        if (this.followingPlayer != null) {
            var0 = new Vec3D(this.followingPlayer.getX() - this.getX(), this.followingPlayer.getY() + (double)this.followingPlayer.getEyeHeight() / 2.0 - this.getY(), this.followingPlayer.getZ() - this.getZ());
            double var1 = ((Vec3D)var0).lengthSqr();
            double var3 = 1.0 - Math.sqrt(var1) / 8.0;
            this.setDeltaMovement(this.getDeltaMovement().add(((Vec3D)var0).normalize().scale(var3 * var3 * 0.1)));
        }
    }

    @Override
    public BlockPosition getBlockPosBelowThatAffectsMyMovement() {
        return this.getOnPos(0.999999f);
    }

    private void scanForMerges() {
        if (this.level() instanceof WorldServer) {
            List<EntityExperienceOrb> var0 = this.level().getEntities(EntityTypeTest.forClass(EntityExperienceOrb.class), this.getBoundingBox().inflate(0.5), this::canMerge);
            for (EntityExperienceOrb var2 : var0) {
                this.merge(var2);
            }
        }
    }

    public static void award(WorldServer var0, Vec3D var1, int var2) {
        EntityExperienceOrb.awardWithDirection(var0, var1, Vec3D.ZERO, var2);
    }

    public static void awardWithDirection(WorldServer var0, Vec3D var1, Vec3D var2, int var3) {
        while (var3 > 0) {
            int var4 = EntityExperienceOrb.getExperienceValue(var3);
            var3 -= var4;
            if (EntityExperienceOrb.tryMergeToExisting(var0, var1, var4)) continue;
            var0.addFreshEntity(new EntityExperienceOrb(var0, var1, var2, var4));
        }
    }

    private static boolean tryMergeToExisting(WorldServer var0, Vec3D var1, int var22) {
        AxisAlignedBB var3 = AxisAlignedBB.ofSize(var1, 1.0, 1.0, 1.0);
        int var4 = var0.getRandom().nextInt(40);
        List<EntityExperienceOrb> var5 = var0.getEntities(EntityTypeTest.forClass(EntityExperienceOrb.class), var3, var2 -> EntityExperienceOrb.canMerge(var2, var4, var22));
        if (!var5.isEmpty()) {
            EntityExperienceOrb var6 = var5.get(0);
            ++var6.count;
            var6.age = 0;
            return true;
        }
        return false;
    }

    private boolean canMerge(EntityExperienceOrb var0) {
        return var0 != this && EntityExperienceOrb.canMerge(var0, this.getId(), this.getValue());
    }

    private static boolean canMerge(EntityExperienceOrb var0, int var1, int var2) {
        return !var0.isRemoved() && (var0.getId() - var1) % 40 == 0 && var0.getValue() == var2;
    }

    private void merge(EntityExperienceOrb var0) {
        this.count += var0.count;
        this.age = Math.min(this.age, var0.age);
        var0.discard();
    }

    private void setUnderwaterMovement() {
        Vec3D var0 = this.getDeltaMovement();
        this.setDeltaMovement(var0.x * (double)0.99f, Math.min(var0.y + (double)5.0E-4f, (double)0.06f), var0.z * (double)0.99f);
    }

    @Override
    protected void doWaterSplashEffect() {
    }

    @Override
    public final boolean hurtClient(DamageSource var0) {
        return !this.isInvulnerableToBase(var0);
    }

    @Override
    public final boolean hurtServer(WorldServer var0, DamageSource var1, float var2) {
        if (this.isInvulnerableToBase(var1)) {
            return false;
        }
        this.markHurt();
        this.health = (int)((float)this.health - var2);
        if (this.health <= 0) {
            this.discard();
        }
        return true;
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        var0.putShort("Health", (short)this.health);
        var0.putShort("Age", (short)this.age);
        var0.putShort("Value", (short)this.getValue());
        var0.putInt("Count", this.count);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        this.health = var0.getShortOr("Health", (short)5);
        this.age = var0.getShortOr("Age", (short)0);
        this.setValue(var0.getShortOr("Value", (short)0));
        this.count = var0.read("Count", ExtraCodecs.POSITIVE_INT).orElse(1);
    }

    @Override
    public void playerTouch(EntityHuman var0) {
        if (!(var0 instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer var1 = (EntityPlayer)var0;
        if (var0.takeXpDelay == 0) {
            var0.takeXpDelay = 2;
            var0.take(this, 1);
            int var2 = this.repairPlayerItems(var1, this.getValue());
            if (var2 > 0) {
                var0.giveExperiencePoints(var2);
            }
            --this.count;
            if (this.count == 0) {
                this.discard();
            }
        }
    }

    private int repairPlayerItems(EntityPlayer var0, int var1) {
        Optional<EnchantedItemInUse> var2 = EnchantmentManager.getRandomItemWith(EnchantmentEffectComponents.REPAIR_WITH_XP, var0, ItemStack::isDamaged);
        if (var2.isPresent()) {
            int var6;
            ItemStack var3 = var2.get().itemStack();
            int var4 = EnchantmentManager.modifyDurabilityToRepairFromXp(var0.level(), var3, var1);
            int var5 = Math.min(var4, var3.getDamageValue());
            var3.setDamageValue(var3.getDamageValue() - var5);
            if (var5 > 0 && (var6 = var1 - var5 * var1 / var4) > 0) {
                return this.repairPlayerItems(var0, var6);
            }
            return 0;
        }
        return var1;
    }

    public int getValue() {
        return this.entityData.get(DATA_VALUE);
    }

    public void setValue(int var0) {
        this.entityData.set(DATA_VALUE, var0);
    }

    public int getIcon() {
        int var0 = this.getValue();
        if (var0 >= 2477) {
            return 10;
        }
        if (var0 >= 1237) {
            return 9;
        }
        if (var0 >= 617) {
            return 8;
        }
        if (var0 >= 307) {
            return 7;
        }
        if (var0 >= 149) {
            return 6;
        }
        if (var0 >= 73) {
            return 5;
        }
        if (var0 >= 37) {
            return 4;
        }
        if (var0 >= 17) {
            return 3;
        }
        if (var0 >= 7) {
            return 2;
        }
        if (var0 >= 3) {
            return 1;
        }
        return 0;
    }

    public static int getExperienceValue(int var0) {
        if (var0 >= 2477) {
            return 2477;
        }
        if (var0 >= 1237) {
            return 1237;
        }
        if (var0 >= 617) {
            return 617;
        }
        if (var0 >= 307) {
            return 307;
        }
        if (var0 >= 149) {
            return 149;
        }
        if (var0 >= 73) {
            return 73;
        }
        if (var0 >= 37) {
            return 37;
        }
        if (var0 >= 17) {
            return 17;
        }
        if (var0 >= 7) {
            return 7;
        }
        if (var0 >= 3) {
            return 3;
        }
        return 1;
    }

    @Override
    public boolean isAttackable() {
        return false;
    }

    @Override
    public SoundCategory getSoundSource() {
        return SoundCategory.AMBIENT;
    }

    @Override
    public InterpolationHandler getInterpolation() {
        return this.interpolation;
    }
}

