/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;

public class BehaviorBedJump
extends Behavior<EntityInsentient> {
    private static final int MAX_TIME_TO_REACH_BED = 100;
    private static final int MIN_JUMPS = 3;
    private static final int MAX_JUMPS = 6;
    private static final int COOLDOWN_BETWEEN_JUMPS = 5;
    private final float speedModifier;
    @Nullable
    private BlockPosition targetBed;
    private int remainingTimeToReachBed;
    private int remainingJumps;
    private int remainingCooldownUntilNextJump;

    public BehaviorBedJump(float var0) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.NEAREST_BED, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT)));
        this.speedModifier = var0;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityInsentient var1) {
        return var1.isBaby() && this.nearBed(var0, var1);
    }

    @Override
    protected void start(WorldServer var0, EntityInsentient var1, long var22) {
        super.start(var0, var1, var22);
        this.getNearestBed(var1).ifPresent(var2 -> {
            this.targetBed = var2;
            this.remainingTimeToReachBed = 100;
            this.remainingJumps = 3 + var0.random.nextInt(4);
            this.remainingCooldownUntilNextJump = 0;
            this.startWalkingTowardsBed(var1, (BlockPosition)var2);
        });
    }

    @Override
    protected void stop(WorldServer var0, EntityInsentient var1, long var2) {
        super.stop(var0, var1, var2);
        this.targetBed = null;
        this.remainingTimeToReachBed = 0;
        this.remainingJumps = 0;
        this.remainingCooldownUntilNextJump = 0;
    }

    @Override
    protected boolean canStillUse(WorldServer var0, EntityInsentient var1, long var2) {
        return var1.isBaby() && this.targetBed != null && this.isBed(var0, this.targetBed) && !this.tiredOfWalking(var0, var1) && !this.tiredOfJumping(var0, var1);
    }

    @Override
    protected boolean timedOut(long var0) {
        return false;
    }

    @Override
    protected void tick(WorldServer var0, EntityInsentient var1, long var2) {
        if (!this.onOrOverBed(var0, var1)) {
            --this.remainingTimeToReachBed;
            return;
        }
        if (this.remainingCooldownUntilNextJump > 0) {
            --this.remainingCooldownUntilNextJump;
            return;
        }
        if (this.onBedSurface(var0, var1)) {
            var1.getJumpControl().jump();
            --this.remainingJumps;
            this.remainingCooldownUntilNextJump = 5;
        }
    }

    private void startWalkingTowardsBed(EntityInsentient var0, BlockPosition var1) {
        var0.getBrain().setMemory(MemoryModuleType.WALK_TARGET, new MemoryTarget(var1, this.speedModifier, 0));
    }

    private boolean nearBed(WorldServer var0, EntityInsentient var1) {
        return this.onOrOverBed(var0, var1) || this.getNearestBed(var1).isPresent();
    }

    private boolean onOrOverBed(WorldServer var0, EntityInsentient var1) {
        BlockPosition var2 = var1.blockPosition();
        BlockPosition var3 = var2.below();
        return this.isBed(var0, var2) || this.isBed(var0, var3);
    }

    private boolean onBedSurface(WorldServer var0, EntityInsentient var1) {
        return this.isBed(var0, var1.blockPosition());
    }

    private boolean isBed(WorldServer var0, BlockPosition var1) {
        return var0.getBlockState(var1).is(TagsBlock.BEDS);
    }

    private Optional<BlockPosition> getNearestBed(EntityInsentient var0) {
        return var0.getBrain().getMemory(MemoryModuleType.NEAREST_BED);
    }

    private boolean tiredOfWalking(WorldServer var0, EntityInsentient var1) {
        return !this.onOrOverBed(var0, var1) && this.remainingTimeToReachBed <= 0;
    }

    private boolean tiredOfJumping(WorldServer var0, EntityInsentient var1) {
        return this.onOrOverBed(var0, var1) && this.remainingJumps <= 0;
    }

    @Override
    protected /* synthetic */ boolean canStillUse(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        return this.canStillUse(worldServer, (EntityInsentient)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void tick(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.tick(worldServer, (EntityInsentient)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.start(worldServer, (EntityInsentient)entityLiving, l2);
    }
}

