/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.Applicative;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorPosition;
import net.minecraft.world.entity.ai.behavior.BehaviorPositionEntity;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.behavior.declarative.MemoryAccessor;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3D;

public class BehaviorPlay {
    private static final int MAX_FLEE_XZ_DIST = 20;
    private static final int MAX_FLEE_Y_DIST = 8;
    private static final float FLEE_SPEED_MODIFIER = 0.6f;
    private static final float CHASE_SPEED_MODIFIER = 0.6f;
    private static final int MAX_CHASERS_PER_TARGET = 5;
    private static final int AVERAGE_WAIT_TIME_BETWEEN_RUNS = 10;

    public static BehaviorControl<EntityCreature> create() {
        return BehaviorBuilder.create(var0 -> var0.group(var0.present(MemoryModuleType.VISIBLE_VILLAGER_BABIES), var0.absent(MemoryModuleType.WALK_TARGET), var0.registered(MemoryModuleType.LOOK_TARGET), var0.registered(MemoryModuleType.INTERACTION_TARGET)).apply((Applicative)var0, (var1, var2, var3, var4) -> (var5, var6, var7) -> {
            if (var5.getRandom().nextInt(10) != 0) {
                return false;
            }
            List var9 = (List)var0.get(var1);
            Optional<EntityLiving> var10 = var9.stream().filter(var1 -> BehaviorPlay.isFriendChasingMe(var6, var1)).findAny();
            if (var10.isPresent()) {
                for (int var11 = 0; var11 < 10; ++var11) {
                    Vec3D var122 = LandRandomPos.getPos(var6, 20, 8);
                    if (var122 == null || !var5.isVillage(BlockPosition.containing(var122))) continue;
                    var2.set(new MemoryTarget(var122, 0.6f, 0));
                    break;
                }
                return true;
            }
            Optional<EntityLiving> var11 = BehaviorPlay.findSomeoneBeingChased(var9);
            if (var11.isPresent()) {
                BehaviorPlay.chaseKid(var4, var3, var2, var11.get());
                return true;
            }
            var9.stream().findAny().ifPresent(var3 -> BehaviorPlay.chaseKid(var4, var3, var2, var3));
            return true;
        }));
    }

    private static void chaseKid(MemoryAccessor<?, EntityLiving> var0, MemoryAccessor<?, BehaviorPosition> var1, MemoryAccessor<?, MemoryTarget> var2, EntityLiving var3) {
        var0.set(var3);
        var1.set(new BehaviorPositionEntity(var3, true));
        var2.set(new MemoryTarget(new BehaviorPositionEntity(var3, false), 0.6f, 1));
    }

    private static Optional<EntityLiving> findSomeoneBeingChased(List<EntityLiving> var02) {
        Map<EntityLiving, Integer> var1 = BehaviorPlay.checkHowManyChasersEachFriendHas(var02);
        return var1.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getValue)).filter(var0 -> (Integer)var0.getValue() > 0 && (Integer)var0.getValue() <= 5).map(Map.Entry::getKey).findFirst();
    }

    private static Map<EntityLiving, Integer> checkHowManyChasersEachFriendHas(List<EntityLiving> var0) {
        HashMap var1 = Maps.newHashMap();
        var0.stream().filter(BehaviorPlay::isChasingSomeone).forEach(var12 -> var1.compute(BehaviorPlay.whoAreYouChasing(var12), (var0, var1) -> var1 == null ? 1 : var1 + 1));
        return var1;
    }

    private static EntityLiving whoAreYouChasing(EntityLiving var0) {
        return var0.getBrain().getMemory(MemoryModuleType.INTERACTION_TARGET).get();
    }

    private static boolean isChasingSomeone(EntityLiving var0) {
        return var0.getBrain().getMemory(MemoryModuleType.INTERACTION_TARGET).isPresent();
    }

    private static boolean isFriendChasingMe(EntityLiving var0, EntityLiving var12) {
        return var12.getBrain().getMemory(MemoryModuleType.INTERACTION_TARGET).filter(var1 -> var1 == var0).isPresent();
    }
}

