/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;

public class BehaviorVillageHeroGift
extends Behavior<EntityVillager> {
    private static final int THROW_GIFT_AT_DISTANCE = 5;
    private static final int MIN_TIME_BETWEEN_GIFTS = 600;
    private static final int MAX_TIME_BETWEEN_GIFTS = 6600;
    private static final int TIME_TO_DELAY_FOR_HEAD_TO_FINISH_TURNING = 20;
    private static final Map<ResourceKey<VillagerProfession>, ResourceKey<LootTable>> GIFTS = ImmutableMap.builder().put(VillagerProfession.ARMORER, LootTables.ARMORER_GIFT).put(VillagerProfession.BUTCHER, LootTables.BUTCHER_GIFT).put(VillagerProfession.CARTOGRAPHER, LootTables.CARTOGRAPHER_GIFT).put(VillagerProfession.CLERIC, LootTables.CLERIC_GIFT).put(VillagerProfession.FARMER, LootTables.FARMER_GIFT).put(VillagerProfession.FISHERMAN, LootTables.FISHERMAN_GIFT).put(VillagerProfession.FLETCHER, LootTables.FLETCHER_GIFT).put(VillagerProfession.LEATHERWORKER, LootTables.LEATHERWORKER_GIFT).put(VillagerProfession.LIBRARIAN, LootTables.LIBRARIAN_GIFT).put(VillagerProfession.MASON, LootTables.MASON_GIFT).put(VillagerProfession.SHEPHERD, LootTables.SHEPHERD_GIFT).put(VillagerProfession.TOOLSMITH, LootTables.TOOLSMITH_GIFT).put(VillagerProfession.WEAPONSMITH, LootTables.WEAPONSMITH_GIFT).build();
    private static final float SPEED_MODIFIER = 0.5f;
    private int timeUntilNextGift = 600;
    private boolean giftGivenDuringThisRun;
    private long timeSinceStart;

    public BehaviorVillageHeroGift(int var0) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.INTERACTION_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.NEAREST_VISIBLE_PLAYER, (Object)((Object)MemoryStatus.VALUE_PRESENT)), var0);
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityVillager var1) {
        if (!this.isHeroVisible(var1)) {
            return false;
        }
        if (this.timeUntilNextGift > 0) {
            --this.timeUntilNextGift;
            return false;
        }
        return true;
    }

    @Override
    protected void start(WorldServer var0, EntityVillager var1, long var2) {
        this.giftGivenDuringThisRun = false;
        this.timeSinceStart = var2;
        EntityHuman var4 = this.getNearestTargetableHero(var1).get();
        var1.getBrain().setMemory(MemoryModuleType.INTERACTION_TARGET, var4);
        BehaviorUtil.lookAtEntity(var1, var4);
    }

    @Override
    protected boolean canStillUse(WorldServer var0, EntityVillager var1, long var2) {
        return this.isHeroVisible(var1) && !this.giftGivenDuringThisRun;
    }

    @Override
    protected void tick(WorldServer var0, EntityVillager var1, long var2) {
        EntityHuman var4 = this.getNearestTargetableHero(var1).get();
        BehaviorUtil.lookAtEntity(var1, var4);
        if (this.isWithinThrowingDistance(var1, var4)) {
            if (var2 - this.timeSinceStart > 20L) {
                this.throwGift(var0, var1, var4);
                this.giftGivenDuringThisRun = true;
            }
        } else {
            BehaviorUtil.setWalkAndLookTargetMemories((EntityLiving)var1, var4, 0.5f, 5);
        }
    }

    @Override
    protected void stop(WorldServer var0, EntityVillager var1, long var2) {
        this.timeUntilNextGift = BehaviorVillageHeroGift.calculateTimeUntilNextGift(var0);
        var1.getBrain().eraseMemory(MemoryModuleType.INTERACTION_TARGET);
        var1.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        var1.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
    }

    private void throwGift(WorldServer var0, EntityVillager var1, EntityLiving var22) {
        var1.dropFromGiftLootTable(var0, BehaviorVillageHeroGift.getLootTableToThrow(var1), (var2, var3) -> BehaviorUtil.throwItem(var1, var3, var22.position()));
    }

    private static ResourceKey<LootTable> getLootTableToThrow(EntityVillager var0) {
        if (var0.isBaby()) {
            return LootTables.BABY_VILLAGER_GIFT;
        }
        Optional<ResourceKey<VillagerProfession>> var1 = var0.getVillagerData().profession().unwrapKey();
        if (var1.isEmpty()) {
            return LootTables.UNEMPLOYED_GIFT;
        }
        return GIFTS.getOrDefault(var1.get(), LootTables.UNEMPLOYED_GIFT);
    }

    private boolean isHeroVisible(EntityVillager var0) {
        return this.getNearestTargetableHero(var0).isPresent();
    }

    private Optional<EntityHuman> getNearestTargetableHero(EntityVillager var0) {
        return var0.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_PLAYER).filter(this::isHero);
    }

    private boolean isHero(EntityHuman var0) {
        return var0.hasEffect(MobEffects.HERO_OF_THE_VILLAGE);
    }

    private boolean isWithinThrowingDistance(EntityVillager var0, EntityHuman var1) {
        BlockPosition var2 = var1.blockPosition();
        BlockPosition var3 = var0.blockPosition();
        return var3.closerThan(var2, 5.0);
    }

    private static int calculateTimeUntilNextGift(WorldServer var0) {
        return 600 + var0.random.nextInt(6001);
    }

    @Override
    protected /* synthetic */ boolean canStillUse(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        return this.canStillUse(worldServer, (EntityVillager)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void stop(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.stop(worldServer, (EntityVillager)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.start(worldServer, (EntityVillager)entityLiving, l2);
    }
}

