/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveTowardsRestriction;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationGuardian;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntitySquid;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.monster.EntityGuardianElder;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;

public class EntityGuardian
extends EntityMonster {
    protected static final int ATTACK_TIME = 80;
    private static final DataWatcherObject<Boolean> DATA_ID_MOVING = DataWatcher.defineId(EntityGuardian.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<Integer> DATA_ID_ATTACK_TARGET = DataWatcher.defineId(EntityGuardian.class, DataWatcherRegistry.INT);
    private float clientSideTailAnimation;
    private float clientSideTailAnimationO;
    private float clientSideTailAnimationSpeed;
    private float clientSideSpikesAnimation;
    private float clientSideSpikesAnimationO;
    @Nullable
    private EntityLiving clientSideCachedAttackTarget;
    private int clientSideAttackTime;
    private boolean clientSideTouchedGround;
    @Nullable
    public PathfinderGoalRandomStroll randomStrollGoal;

    public EntityGuardian(EntityTypes<? extends EntityGuardian> var0, World var1) {
        super((EntityTypes<? extends EntityMonster>)var0, var1);
        this.xpReward = 10;
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new ControllerMoveGuardian(this);
        this.clientSideTailAnimationO = this.clientSideTailAnimation = this.random.nextFloat();
    }

    @Override
    protected void registerGoals() {
        PathfinderGoalMoveTowardsRestriction var0 = new PathfinderGoalMoveTowardsRestriction(this, 1.0);
        this.randomStrollGoal = new PathfinderGoalRandomStroll(this, 1.0, 80);
        this.goalSelector.addGoal(4, new PathfinderGoalGuardianAttack(this));
        this.goalSelector.addGoal(5, var0);
        this.goalSelector.addGoal(7, this.randomStrollGoal);
        this.goalSelector.addGoal(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.goalSelector.addGoal(8, new PathfinderGoalLookAtPlayer(this, EntityGuardian.class, 12.0f, 0.01f));
        this.goalSelector.addGoal(9, new PathfinderGoalRandomLookaround(this));
        this.randomStrollGoal.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE, PathfinderGoal.Type.LOOK));
        var0.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE, PathfinderGoal.Type.LOOK));
        this.targetSelector.addGoal(1, new PathfinderGoalNearestAttackableTarget<EntityLiving>(this, EntityLiving.class, 10, true, false, new EntitySelectorGuardianTargetHumanSquid(this)));
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityMonster.createMonsterAttributes().add(GenericAttributes.ATTACK_DAMAGE, 6.0).add(GenericAttributes.MOVEMENT_SPEED, 0.5).add(GenericAttributes.MAX_HEALTH, 30.0);
    }

    @Override
    protected NavigationAbstract createNavigation(World var0) {
        return new NavigationGuardian(this, var0);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_ID_MOVING, false);
        var0.define(DATA_ID_ATTACK_TARGET, 0);
    }

    public boolean isMoving() {
        return this.entityData.get(DATA_ID_MOVING);
    }

    void setMoving(boolean var0) {
        this.entityData.set(DATA_ID_MOVING, var0);
    }

    public int getAttackDuration() {
        return 80;
    }

    public void setActiveAttackTarget(int var0) {
        this.entityData.set(DATA_ID_ATTACK_TARGET, var0);
    }

    public boolean hasActiveAttackTarget() {
        return this.entityData.get(DATA_ID_ATTACK_TARGET) != 0;
    }

    @Nullable
    public EntityLiving getActiveAttackTarget() {
        if (!this.hasActiveAttackTarget()) {
            return null;
        }
        if (this.level().isClientSide()) {
            if (this.clientSideCachedAttackTarget != null) {
                return this.clientSideCachedAttackTarget;
            }
            Entity var0 = this.level().getEntity(this.entityData.get(DATA_ID_ATTACK_TARGET));
            if (var0 instanceof EntityLiving) {
                this.clientSideCachedAttackTarget = (EntityLiving)var0;
                return this.clientSideCachedAttackTarget;
            }
            return null;
        }
        return this.getTarget();
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        super.onSyncedDataUpdated(var0);
        if (DATA_ID_ATTACK_TARGET.equals(var0)) {
            this.clientSideAttackTime = 0;
            this.clientSideCachedAttackTarget = null;
        }
    }

    @Override
    public int getAmbientSoundInterval() {
        return 160;
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return this.isInWater() ? SoundEffects.GUARDIAN_AMBIENT : SoundEffects.GUARDIAN_AMBIENT_LAND;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return this.isInWater() ? SoundEffects.GUARDIAN_HURT : SoundEffects.GUARDIAN_HURT_LAND;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return this.isInWater() ? SoundEffects.GUARDIAN_DEATH : SoundEffects.GUARDIAN_DEATH_LAND;
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    @Override
    public float getWalkTargetValue(BlockPosition var0, IWorldReader var1) {
        if (var1.getFluidState(var0).is(TagsFluid.WATER)) {
            return 10.0f + var1.getPathfindingCostFromLightLevels(var0);
        }
        return super.getWalkTargetValue(var0, var1);
    }

    @Override
    public void aiStep() {
        if (this.isAlive()) {
            if (this.level().isClientSide()) {
                Object var0;
                this.clientSideTailAnimationO = this.clientSideTailAnimation;
                if (!this.isInWater()) {
                    this.clientSideTailAnimationSpeed = 2.0f;
                    var0 = this.getDeltaMovement();
                    if (((Vec3D)var0).y > 0.0 && this.clientSideTouchedGround && !this.isSilent()) {
                        this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), this.getFlopSound(), this.getSoundSource(), 1.0f, 1.0f, false);
                    }
                    this.clientSideTouchedGround = ((Vec3D)var0).y < 0.0 && this.level().loadedAndEntityCanStandOn(this.blockPosition().below(), this);
                } else {
                    this.clientSideTailAnimationSpeed = this.isMoving() ? (this.clientSideTailAnimationSpeed < 0.5f ? 4.0f : (this.clientSideTailAnimationSpeed += (0.5f - this.clientSideTailAnimationSpeed) * 0.1f)) : (this.clientSideTailAnimationSpeed += (0.125f - this.clientSideTailAnimationSpeed) * 0.2f);
                }
                this.clientSideTailAnimation += this.clientSideTailAnimationSpeed;
                this.clientSideSpikesAnimationO = this.clientSideSpikesAnimation;
                this.clientSideSpikesAnimation = !this.isInWater() ? this.random.nextFloat() : (this.isMoving() ? (this.clientSideSpikesAnimation += (0.0f - this.clientSideSpikesAnimation) * 0.25f) : (this.clientSideSpikesAnimation += (1.0f - this.clientSideSpikesAnimation) * 0.06f));
                if (this.isMoving() && this.isInWater()) {
                    var0 = this.getViewVector(0.0f);
                    for (int var1 = 0; var1 < 2; ++var1) {
                        this.level().addParticle(Particles.BUBBLE, this.getRandomX(0.5) - ((Vec3D)var0).x * 1.5, this.getRandomY() - ((Vec3D)var0).y * 1.5, this.getRandomZ(0.5) - ((Vec3D)var0).z * 1.5, 0.0, 0.0, 0.0);
                    }
                }
                if (this.hasActiveAttackTarget()) {
                    if (this.clientSideAttackTime < this.getAttackDuration()) {
                        ++this.clientSideAttackTime;
                    }
                    if ((var0 = this.getActiveAttackTarget()) != null) {
                        this.getLookControl().setLookAt((Entity)var0, 90.0f, 90.0f);
                        this.getLookControl().tick();
                        double var1 = this.getAttackAnimationScale(0.0f);
                        double var3 = ((Entity)var0).getX() - this.getX();
                        double var5 = ((Entity)var0).getY(0.5) - this.getEyeY();
                        double var7 = ((Entity)var0).getZ() - this.getZ();
                        double var9 = Math.sqrt(var3 * var3 + var5 * var5 + var7 * var7);
                        var3 /= var9;
                        var5 /= var9;
                        var7 /= var9;
                        double var11 = this.random.nextDouble();
                        while (var11 < var9) {
                            this.level().addParticle(Particles.BUBBLE, this.getX() + var3 * (var11 += 1.8 - var1 + this.random.nextDouble() * (1.7 - var1)), this.getEyeY() + var5 * var11, this.getZ() + var7 * var11, 0.0, 0.0, 0.0);
                        }
                    }
                }
            }
            if (this.isInWater()) {
                this.setAirSupply(300);
            } else if (this.onGround()) {
                this.setDeltaMovement(this.getDeltaMovement().add((this.random.nextFloat() * 2.0f - 1.0f) * 0.4f, 0.5, (this.random.nextFloat() * 2.0f - 1.0f) * 0.4f));
                this.setYRot(this.random.nextFloat() * 360.0f);
                this.setOnGround(false);
                this.hasImpulse = true;
            }
            if (this.hasActiveAttackTarget()) {
                this.setYRot(this.yHeadRot);
            }
        }
        super.aiStep();
    }

    protected SoundEffect getFlopSound() {
        return SoundEffects.GUARDIAN_FLOP;
    }

    public float getTailAnimation(float var0) {
        return MathHelper.lerp(var0, this.clientSideTailAnimationO, this.clientSideTailAnimation);
    }

    public float getSpikesAnimation(float var0) {
        return MathHelper.lerp(var0, this.clientSideSpikesAnimationO, this.clientSideSpikesAnimation);
    }

    public float getAttackAnimationScale(float var0) {
        return ((float)this.clientSideAttackTime + var0) / (float)this.getAttackDuration();
    }

    public float getClientSideAttackTime() {
        return this.clientSideAttackTime;
    }

    @Override
    public boolean checkSpawnObstruction(IWorldReader var0) {
        return var0.isUnobstructed(this);
    }

    public static boolean checkGuardianSpawnRules(EntityTypes<? extends EntityGuardian> var0, GeneratorAccess var1, EntitySpawnReason var2, BlockPosition var3, RandomSource var4) {
        return !(var4.nextInt(20) != 0 && var1.canSeeSkyFromBelowWater(var3) || var1.getDifficulty() == EnumDifficulty.PEACEFUL || !EntitySpawnReason.isSpawner(var2) && !var1.getFluidState(var3).is(TagsFluid.WATER) || !var1.getFluidState(var3.below()).is(TagsFluid.WATER));
    }

    @Override
    public boolean hurtServer(WorldServer var0, DamageSource var1, float var2) {
        Entity entity;
        if (!this.isMoving() && !var1.is(DamageTypeTags.AVOIDS_GUARDIAN_THORNS) && !var1.is(DamageTypes.THORNS) && (entity = var1.getDirectEntity()) instanceof EntityLiving) {
            EntityLiving var3 = (EntityLiving)entity;
            var3.hurtServer(var0, this.damageSources().thorns(this), 2.0f);
        }
        if (this.randomStrollGoal != null) {
            this.randomStrollGoal.trigger();
        }
        return super.hurtServer(var0, var1, var2);
    }

    @Override
    public int getMaxHeadXRot() {
        return 180;
    }

    @Override
    public void travel(Vec3D var0) {
        if (this.isInWater()) {
            this.moveRelative(0.1f, var0);
            this.move(EnumMoveType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
            if (!this.isMoving() && this.getTarget() == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
            }
        } else {
            super.travel(var0);
        }
    }

    static class ControllerMoveGuardian
    extends ControllerMove {
        private final EntityGuardian guardian;

        public ControllerMoveGuardian(EntityGuardian var0) {
            super(var0);
            this.guardian = var0;
        }

        @Override
        public void tick() {
            if (this.operation != ControllerMove.Operation.MOVE_TO || this.guardian.getNavigation().isDone()) {
                this.guardian.setSpeed(0.0f);
                this.guardian.setMoving(false);
                return;
            }
            Vec3D var0 = new Vec3D(this.wantedX - this.guardian.getX(), this.wantedY - this.guardian.getY(), this.wantedZ - this.guardian.getZ());
            double var1 = var0.length();
            double var3 = var0.x / var1;
            double var5 = var0.y / var1;
            double var7 = var0.z / var1;
            float var9 = (float)(MathHelper.atan2(var0.z, var0.x) * 57.2957763671875) - 90.0f;
            this.guardian.setYRot(this.rotlerp(this.guardian.getYRot(), var9, 90.0f));
            this.guardian.yBodyRot = this.guardian.getYRot();
            float var10 = (float)(this.speedModifier * this.guardian.getAttributeValue(GenericAttributes.MOVEMENT_SPEED));
            float var11 = MathHelper.lerp(0.125f, this.guardian.getSpeed(), var10);
            this.guardian.setSpeed(var11);
            double var12 = Math.sin((double)(this.guardian.tickCount + this.guardian.getId()) * 0.5) * 0.05;
            double var14 = Math.cos(this.guardian.getYRot() * ((float)Math.PI / 180));
            double var16 = Math.sin(this.guardian.getYRot() * ((float)Math.PI / 180));
            double var18 = Math.sin((double)(this.guardian.tickCount + this.guardian.getId()) * 0.75) * 0.05;
            this.guardian.setDeltaMovement(this.guardian.getDeltaMovement().add(var12 * var14, var18 * (var16 + var14) * 0.25 + (double)var11 * var5 * 0.1, var12 * var16));
            ControllerLook var20 = this.guardian.getLookControl();
            double var21 = this.guardian.getX() + var3 * 2.0;
            double var23 = this.guardian.getEyeY() + var5 / var1;
            double var25 = this.guardian.getZ() + var7 * 2.0;
            double var27 = var20.getWantedX();
            double var29 = var20.getWantedY();
            double var31 = var20.getWantedZ();
            if (!var20.isLookingAtTarget()) {
                var27 = var21;
                var29 = var23;
                var31 = var25;
            }
            this.guardian.getLookControl().setLookAt(MathHelper.lerp(0.125, var27, var21), MathHelper.lerp(0.125, var29, var23), MathHelper.lerp(0.125, var31, var25), 10.0f, 40.0f);
            this.guardian.setMoving(true);
        }
    }

    public static class PathfinderGoalGuardianAttack
    extends PathfinderGoal {
        private final EntityGuardian guardian;
        public int attackTime;
        private final boolean elder;

        public PathfinderGoalGuardianAttack(EntityGuardian var0) {
            this.guardian = var0;
            this.elder = var0 instanceof EntityGuardianElder;
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE, PathfinderGoal.Type.LOOK));
        }

        @Override
        public boolean canUse() {
            EntityLiving var0 = this.guardian.getTarget();
            return var0 != null && var0.isAlive();
        }

        @Override
        public boolean canContinueToUse() {
            return super.canContinueToUse() && (this.elder || this.guardian.getTarget() != null && this.guardian.distanceToSqr(this.guardian.getTarget()) > 9.0);
        }

        @Override
        public void start() {
            this.attackTime = -10;
            this.guardian.getNavigation().stop();
            EntityLiving var0 = this.guardian.getTarget();
            if (var0 != null) {
                this.guardian.getLookControl().setLookAt(var0, 90.0f, 90.0f);
            }
            this.guardian.hasImpulse = true;
        }

        @Override
        public void stop() {
            this.guardian.setActiveAttackTarget(0);
            this.guardian.setTarget(null);
            this.guardian.randomStrollGoal.trigger();
        }

        @Override
        public boolean requiresUpdateEveryTick() {
            return true;
        }

        @Override
        public void tick() {
            EntityLiving var0 = this.guardian.getTarget();
            if (var0 == null) {
                return;
            }
            this.guardian.getNavigation().stop();
            this.guardian.getLookControl().setLookAt(var0, 90.0f, 90.0f);
            if (!this.guardian.hasLineOfSight(var0)) {
                this.guardian.setTarget(null);
                return;
            }
            ++this.attackTime;
            if (this.attackTime == 0) {
                this.guardian.setActiveAttackTarget(var0.getId());
                if (!this.guardian.isSilent()) {
                    this.guardian.level().broadcastEntityEvent(this.guardian, (byte)21);
                }
            } else if (this.attackTime >= this.guardian.getAttackDuration()) {
                float var1 = 1.0f;
                if (this.guardian.level().getDifficulty() == EnumDifficulty.HARD) {
                    var1 += 2.0f;
                }
                if (this.elder) {
                    var1 += 2.0f;
                }
                WorldServer var2 = PathfinderGoalGuardianAttack.getServerLevel(this.guardian);
                var0.hurtServer(var2, this.guardian.damageSources().indirectMagic(this.guardian, this.guardian), var1);
                this.guardian.doHurtTarget(var2, var0);
                this.guardian.setTarget(null);
            }
            super.tick();
        }
    }

    static class EntitySelectorGuardianTargetHumanSquid
    implements PathfinderTargetCondition.a {
        private final EntityGuardian guardian;

        public EntitySelectorGuardianTargetHumanSquid(EntityGuardian var0) {
            this.guardian = var0;
        }

        @Override
        public boolean test(@Nullable EntityLiving var0, WorldServer var1) {
            return (var0 instanceof EntityHuman || var0 instanceof EntitySquid || var0 instanceof Axolotl) && var0.distanceToSqr(this.guardian) > 9.0;
        }
    }
}

