/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTargetWitch;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestHealableRaider;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ThrownSplashPotion;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;

public class EntityWitch
extends EntityRaider
implements IRangedEntity {
    private static final MinecraftKey SPEED_MODIFIER_DRINKING_ID = MinecraftKey.withDefaultNamespace("drinking");
    private static final AttributeModifier SPEED_MODIFIER_DRINKING = new AttributeModifier(SPEED_MODIFIER_DRINKING_ID, -0.25, AttributeModifier.Operation.ADD_VALUE);
    private static final DataWatcherObject<Boolean> DATA_USING_ITEM = DataWatcher.defineId(EntityWitch.class, DataWatcherRegistry.BOOLEAN);
    private int usingTime;
    private PathfinderGoalNearestHealableRaider<EntityRaider> healRaidersGoal;
    private PathfinderGoalNearestAttackableTargetWitch<EntityHuman> attackPlayersGoal;

    public EntityWitch(EntityTypes<? extends EntityWitch> var0, World var1) {
        super((EntityTypes<? extends EntityRaider>)var0, var1);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.healRaidersGoal = new PathfinderGoalNearestHealableRaider<EntityRaider>(this, EntityRaider.class, true, (var0, var1) -> this.hasActiveRaid() && var0.getType() != EntityTypes.WITCH);
        this.attackPlayersGoal = new PathfinderGoalNearestAttackableTargetWitch<EntityHuman>(this, EntityHuman.class, 10, true, false, null);
        this.goalSelector.addGoal(1, new PathfinderGoalFloat(this));
        this.goalSelector.addGoal(2, new PathfinderGoalArrowAttack(this, 1.0, 60, 10.0f));
        this.goalSelector.addGoal(2, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.goalSelector.addGoal(3, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.goalSelector.addGoal(3, new PathfinderGoalRandomLookaround(this));
        this.targetSelector.addGoal(1, new PathfinderGoalHurtByTarget(this, EntityRaider.class));
        this.targetSelector.addGoal(2, this.healRaidersGoal);
        this.targetSelector.addGoal(3, this.attackPlayersGoal);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_USING_ITEM, false);
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.WITCH_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.WITCH_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.WITCH_DEATH;
    }

    public void setUsingItem(boolean var0) {
        this.getEntityData().set(DATA_USING_ITEM, var0);
    }

    public boolean isDrinkingPotion() {
        return this.getEntityData().get(DATA_USING_ITEM);
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityMonster.createMonsterAttributes().add(GenericAttributes.MAX_HEALTH, 26.0).add(GenericAttributes.MOVEMENT_SPEED, 0.25);
    }

    @Override
    public void aiStep() {
        if (!this.level().isClientSide() && this.isAlive()) {
            this.healRaidersGoal.decrementCooldown();
            if (this.healRaidersGoal.getCooldown() <= 0) {
                this.attackPlayersGoal.setCanAttack(true);
            } else {
                this.attackPlayersGoal.setCanAttack(false);
            }
            if (this.isDrinkingPotion()) {
                if (this.usingTime-- <= 0) {
                    this.setUsingItem(false);
                    ItemStack var0 = this.getMainHandItem();
                    this.setItemSlot(EnumItemSlot.MAINHAND, ItemStack.EMPTY);
                    PotionContents var1 = var0.get(DataComponents.POTION_CONTENTS);
                    if (var0.is(Items.POTION) && var1 != null) {
                        var1.forEachEffect(this::addEffect, var0.getOrDefault(DataComponents.POTION_DURATION_SCALE, Float.valueOf(1.0f)).floatValue());
                    }
                    this.gameEvent(GameEvent.DRINK);
                    this.getAttribute(GenericAttributes.MOVEMENT_SPEED).removeModifier(SPEED_MODIFIER_DRINKING.id());
                }
            } else {
                Holder<PotionRegistry> var0 = null;
                if (this.random.nextFloat() < 0.15f && this.isEyeInFluid(TagsFluid.WATER) && !this.hasEffect(MobEffects.WATER_BREATHING)) {
                    var0 = Potions.WATER_BREATHING;
                } else if (this.random.nextFloat() < 0.15f && (this.isOnFire() || this.getLastDamageSource() != null && this.getLastDamageSource().is(DamageTypeTags.IS_FIRE)) && !this.hasEffect(MobEffects.FIRE_RESISTANCE)) {
                    var0 = Potions.FIRE_RESISTANCE;
                } else if (this.random.nextFloat() < 0.05f && this.getHealth() < this.getMaxHealth()) {
                    var0 = Potions.HEALING;
                } else if (this.random.nextFloat() < 0.5f && this.getTarget() != null && !this.hasEffect(MobEffects.SPEED) && this.getTarget().distanceToSqr(this) > 121.0) {
                    var0 = Potions.SWIFTNESS;
                }
                if (var0 != null) {
                    this.setItemSlot(EnumItemSlot.MAINHAND, PotionContents.createItemStack(Items.POTION, var0));
                    this.usingTime = this.getMainHandItem().getUseDuration(this);
                    this.setUsingItem(true);
                    if (!this.isSilent()) {
                        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEffects.WITCH_DRINK, this.getSoundSource(), 1.0f, 0.8f + this.random.nextFloat() * 0.4f);
                    }
                    AttributeModifiable var1 = this.getAttribute(GenericAttributes.MOVEMENT_SPEED);
                    var1.removeModifier(SPEED_MODIFIER_DRINKING_ID);
                    var1.addTransientModifier(SPEED_MODIFIER_DRINKING);
                }
            }
            if (this.random.nextFloat() < 7.5E-4f) {
                this.level().broadcastEntityEvent(this, (byte)15);
            }
        }
        super.aiStep();
    }

    @Override
    public SoundEffect getCelebrateSound() {
        return SoundEffects.WITCH_CELEBRATE;
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 15) {
            for (int var1 = 0; var1 < this.random.nextInt(35) + 10; ++var1) {
                this.level().addParticle(Particles.WITCH, this.getX() + this.random.nextGaussian() * (double)0.13f, this.getBoundingBox().maxY + 0.5 + this.random.nextGaussian() * (double)0.13f, this.getZ() + this.random.nextGaussian() * (double)0.13f, 0.0, 0.0, 0.0);
            }
        } else {
            super.handleEntityEvent(var0);
        }
    }

    @Override
    protected float getDamageAfterMagicAbsorb(DamageSource var0, float var1) {
        var1 = super.getDamageAfterMagicAbsorb(var0, var1);
        if (var0.getEntity() == this) {
            var1 = 0.0f;
        }
        if (var0.is(DamageTypeTags.WITCH_RESISTANT_TO)) {
            var1 *= 0.15f;
        }
        return var1;
    }

    @Override
    public void performRangedAttack(EntityLiving var0, float var1) {
        if (this.isDrinkingPotion()) {
            return;
        }
        Vec3D var2 = var0.getDeltaMovement();
        double var3 = var0.getX() + var2.x - this.getX();
        double var5 = var0.getEyeY() - (double)1.1f - this.getY();
        double var7 = var0.getZ() + var2.z - this.getZ();
        double var9 = Math.sqrt(var3 * var3 + var7 * var7);
        Holder<PotionRegistry> var11 = Potions.HARMING;
        if (var0 instanceof EntityRaider) {
            var11 = var0.getHealth() <= 4.0f ? Potions.HEALING : Potions.REGENERATION;
            this.setTarget(null);
        } else if (var9 >= 8.0 && !var0.hasEffect(MobEffects.SLOWNESS)) {
            var11 = Potions.SLOWNESS;
        } else if (var0.getHealth() >= 8.0f && !var0.hasEffect(MobEffects.POISON)) {
            var11 = Potions.POISON;
        } else if (var9 <= 3.0 && !var0.hasEffect(MobEffects.WEAKNESS) && this.random.nextFloat() < 0.25f) {
            var11 = Potions.WEAKNESS;
        }
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer var12 = (WorldServer)world;
            ItemStack var13 = PotionContents.createItemStack(Items.SPLASH_POTION, var11);
            IProjectile.spawnProjectileUsingShoot(ThrownSplashPotion::new, var12, var13, this, var3, var5 + var9 * 0.2, var7, 0.75f, 8.0f);
        }
        if (!this.isSilent()) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEffects.WITCH_THROW, this.getSoundSource(), 1.0f, 0.8f + this.random.nextFloat() * 0.4f);
        }
    }

    @Override
    public void applyRaidBuffs(WorldServer var0, int var1, boolean var2) {
    }

    @Override
    public boolean canBeLeader() {
        return false;
    }
}

