/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.hoglin;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.monster.hoglin.HoglinAI;
import net.minecraft.world.entity.monster.hoglin.IOglin;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class EntityHoglin
extends EntityAnimal
implements IMonster,
IOglin {
    private static final DataWatcherObject<Boolean> DATA_IMMUNE_TO_ZOMBIFICATION = DataWatcher.defineId(EntityHoglin.class, DataWatcherRegistry.BOOLEAN);
    private static final int MAX_HEALTH = 40;
    private static final float MOVEMENT_SPEED_WHEN_FIGHTING = 0.3f;
    private static final int ATTACK_KNOCKBACK = 1;
    private static final float KNOCKBACK_RESISTANCE = 0.6f;
    private static final int ATTACK_DAMAGE = 6;
    private static final float BABY_ATTACK_DAMAGE = 0.5f;
    private static final boolean DEFAULT_IMMUNE_TO_ZOMBIFICATION = false;
    private static final int DEFAULT_TIME_IN_OVERWORLD = 0;
    private static final boolean DEFAULT_CANNOT_BE_HUNTED = false;
    public static final int CONVERSION_TIME = 300;
    private int attackAnimationRemainingTicks;
    public int timeInOverworld = 0;
    public boolean cannotBeHunted = false;
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super EntityHoglin>>> SENSOR_TYPES = ImmutableList.of(SensorType.NEAREST_LIVING_ENTITIES, SensorType.NEAREST_PLAYERS, SensorType.NEAREST_ADULT, SensorType.HOGLIN_SPECIFIC_SENSOR);
    protected static final ImmutableList<? extends MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of(MemoryModuleType.BREED_TARGET, MemoryModuleType.NEAREST_LIVING_ENTITIES, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryModuleType.NEAREST_VISIBLE_PLAYER, MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER, MemoryModuleType.LOOK_TARGET, MemoryModuleType.WALK_TARGET, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, MemoryModuleType.PATH, MemoryModuleType.ATTACK_TARGET, MemoryModuleType.ATTACK_COOLING_DOWN, MemoryModuleType.NEAREST_VISIBLE_ADULT_PIGLIN, (Object[])new MemoryModuleType[]{MemoryModuleType.AVOID_TARGET, MemoryModuleType.VISIBLE_ADULT_PIGLIN_COUNT, MemoryModuleType.VISIBLE_ADULT_HOGLIN_COUNT, MemoryModuleType.NEAREST_VISIBLE_ADULT_HOGLINS, MemoryModuleType.NEAREST_VISIBLE_ADULT, MemoryModuleType.NEAREST_REPELLENT, MemoryModuleType.PACIFIED, MemoryModuleType.IS_PANICKING});

    public EntityHoglin(EntityTypes<? extends EntityHoglin> var0, World var1) {
        super((EntityTypes<? extends EntityAnimal>)var0, var1);
        this.xpReward = 5;
    }

    @VisibleForTesting
    public void setTimeInOverworld(int var0) {
        this.timeInOverworld = var0;
    }

    @Override
    public boolean canBeLeashed() {
        return true;
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityMonster.createMonsterAttributes().add(GenericAttributes.MAX_HEALTH, 40.0).add(GenericAttributes.MOVEMENT_SPEED, 0.3f).add(GenericAttributes.KNOCKBACK_RESISTANCE, 0.6f).add(GenericAttributes.ATTACK_KNOCKBACK, 1.0).add(GenericAttributes.ATTACK_DAMAGE, 6.0);
    }

    @Override
    public boolean doHurtTarget(WorldServer var0, Entity var1) {
        if (!(var1 instanceof EntityLiving)) {
            return false;
        }
        EntityLiving var2 = (EntityLiving)var1;
        this.attackAnimationRemainingTicks = 10;
        this.level().broadcastEntityEvent(this, (byte)4);
        this.makeSound(SoundEffects.HOGLIN_ATTACK);
        HoglinAI.onHitTarget(this, var2);
        return IOglin.hurtAndThrowTarget(var0, this, var2);
    }

    @Override
    protected void blockedByItem(EntityLiving var0) {
        if (this.isAdult()) {
            IOglin.throwTarget(this, var0);
        }
    }

    @Override
    public boolean hurtServer(WorldServer var0, DamageSource var1, float var2) {
        Entity entity;
        boolean var3 = super.hurtServer(var0, var1, var2);
        if (var3 && (entity = var1.getEntity()) instanceof EntityLiving) {
            EntityLiving var4 = (EntityLiving)entity;
            HoglinAI.wasHurtBy(var0, this, var4);
        }
        return var3;
    }

    protected BehaviorController.b<EntityHoglin> brainProvider() {
        return BehaviorController.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    @Override
    protected BehaviorController<?> makeBrain(Dynamic<?> var0) {
        return HoglinAI.makeBrain(this.brainProvider().makeBrain(var0));
    }

    public BehaviorController<EntityHoglin> getBrain() {
        return super.getBrain();
    }

    @Override
    protected void customServerAiStep(WorldServer var0) {
        GameProfilerFiller var1 = Profiler.get();
        var1.push("hoglinBrain");
        this.getBrain().tick(var0, this);
        var1.pop();
        HoglinAI.updateActivity(this);
        if (this.isConverting()) {
            ++this.timeInOverworld;
            if (this.timeInOverworld > 300) {
                this.makeSound(SoundEffects.HOGLIN_CONVERTED_TO_ZOMBIFIED);
                this.finishConversion();
            }
        } else {
            this.timeInOverworld = 0;
        }
    }

    @Override
    public void aiStep() {
        if (this.attackAnimationRemainingTicks > 0) {
            --this.attackAnimationRemainingTicks;
        }
        super.aiStep();
    }

    @Override
    protected void ageBoundaryReached() {
        if (this.isBaby()) {
            this.xpReward = 3;
            this.getAttribute(GenericAttributes.ATTACK_DAMAGE).setBaseValue(0.5);
        } else {
            this.xpReward = 5;
            this.getAttribute(GenericAttributes.ATTACK_DAMAGE).setBaseValue(6.0);
        }
    }

    public static boolean checkHoglinSpawnRules(EntityTypes<EntityHoglin> var0, GeneratorAccess var1, EntitySpawnReason var2, BlockPosition var3, RandomSource var4) {
        return !var1.getBlockState(var3.below()).is(Blocks.NETHER_WART_BLOCK);
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EntitySpawnReason var2, @Nullable GroupDataEntity var3) {
        if (var0.getRandom().nextFloat() < 0.2f) {
            this.setBaby(true);
        }
        return super.finalizeSpawn(var0, var1, var2, var3);
    }

    @Override
    public boolean removeWhenFarAway(double var0) {
        return !this.isPersistenceRequired();
    }

    @Override
    public float getWalkTargetValue(BlockPosition var0, IWorldReader var1) {
        if (HoglinAI.isPosNearNearestRepellent(this, var0)) {
            return -1.0f;
        }
        if (var1.getBlockState(var0.below()).is(Blocks.CRIMSON_NYLIUM)) {
            return 10.0f;
        }
        return 0.0f;
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        EnumInteractionResult var2 = super.mobInteract(var0, var1);
        if (var2.consumesAction()) {
            this.setPersistenceRequired();
        }
        return var2;
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 4) {
            this.attackAnimationRemainingTicks = 10;
            this.makeSound(SoundEffects.HOGLIN_ATTACK);
        } else {
            super.handleEntityEvent(var0);
        }
    }

    @Override
    public int getAttackAnimationRemainingTicks() {
        return this.attackAnimationRemainingTicks;
    }

    @Override
    public boolean shouldDropExperience() {
        return true;
    }

    @Override
    protected int getBaseExperienceReward(WorldServer var0) {
        return this.xpReward;
    }

    private void finishConversion() {
        this.convertTo(EntityTypes.ZOGLIN, ConversionParams.single(this, true, false), var0 -> var0.addEffect(new MobEffect(MobEffects.NAUSEA, 200, 0)));
    }

    @Override
    public boolean isFood(ItemStack var0) {
        return var0.is(TagsItem.HOGLIN_FOOD);
    }

    public boolean isAdult() {
        return !this.isBaby();
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_IMMUNE_TO_ZOMBIFICATION, false);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        var0.putBoolean("IsImmuneToZombification", this.isImmuneToZombification());
        var0.putInt("TimeInOverworld", this.timeInOverworld);
        var0.putBoolean("CannotBeHunted", this.cannotBeHunted);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        this.setImmuneToZombification(var0.getBooleanOr("IsImmuneToZombification", false));
        this.timeInOverworld = var0.getIntOr("TimeInOverworld", 0);
        this.setCannotBeHunted(var0.getBooleanOr("CannotBeHunted", false));
    }

    public void setImmuneToZombification(boolean var0) {
        this.getEntityData().set(DATA_IMMUNE_TO_ZOMBIFICATION, var0);
    }

    public boolean isImmuneToZombification() {
        return this.getEntityData().get(DATA_IMMUNE_TO_ZOMBIFICATION);
    }

    public boolean isConverting() {
        return !this.level().dimensionType().piglinSafe() && !this.isImmuneToZombification() && !this.isNoAi();
    }

    private void setCannotBeHunted(boolean var0) {
        this.cannotBeHunted = var0;
    }

    public boolean canBeHunted() {
        return this.isAdult() && !this.cannotBeHunted;
    }

    @Override
    @Nullable
    public EntityAgeable getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        EntityHoglin var2 = EntityTypes.HOGLIN.create(var0, EntitySpawnReason.BREEDING);
        if (var2 != null) {
            var2.setPersistenceRequired();
        }
        return var2;
    }

    @Override
    public boolean canFallInLove() {
        return !HoglinAI.isPacified(this) && super.canFallInLove();
    }

    @Override
    public SoundCategory getSoundSource() {
        return SoundCategory.HOSTILE;
    }

    @Override
    protected SoundEffect getAmbientSound() {
        if (this.level().isClientSide()) {
            return null;
        }
        return HoglinAI.getSoundForCurrentActivity(this).orElse(null);
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.HOGLIN_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.HOGLIN_DEATH;
    }

    @Override
    protected SoundEffect getSwimSound() {
        return SoundEffects.HOSTILE_SWIM;
    }

    @Override
    protected SoundEffect getSwimSplashSound() {
        return SoundEffects.HOSTILE_SPLASH;
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
        this.playSound(SoundEffects.HOGLIN_STEP, 0.15f, 1.0f);
    }

    @Override
    @Nullable
    public EntityLiving getTarget() {
        return this.getTargetFromBrain();
    }
}

