/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import java.util.ArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.IRecipeComplex;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.World;

public class RecipeArmorDye
extends IRecipeComplex {
    public RecipeArmorDye(CraftingBookCategory var0) {
        super(var0);
    }

    @Override
    public boolean matches(CraftingInput var0, World var1) {
        if (var0.ingredientCount() < 2) {
            return false;
        }
        boolean var2 = false;
        boolean var3 = false;
        for (int var4 = 0; var4 < var0.size(); ++var4) {
            ItemStack var5 = var0.getItem(var4);
            if (var5.isEmpty()) continue;
            if (var5.is(TagsItem.DYEABLE)) {
                if (var2) {
                    return false;
                }
                var2 = true;
                continue;
            }
            if (var5.getItem() instanceof ItemDye) {
                var3 = true;
                continue;
            }
            return false;
        }
        return var3 && var2;
    }

    @Override
    public ItemStack assemble(CraftingInput var0, HolderLookup.a var1) {
        ArrayList<ItemDye> var2 = new ArrayList<ItemDye>();
        ItemStack var3 = ItemStack.EMPTY;
        for (int var4 = 0; var4 < var0.size(); ++var4) {
            ItemStack var5 = var0.getItem(var4);
            if (var5.isEmpty()) continue;
            if (var5.is(TagsItem.DYEABLE)) {
                if (!var3.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                var3 = var5.copy();
                continue;
            }
            Item item = var5.getItem();
            if (item instanceof ItemDye) {
                ItemDye var6 = (ItemDye)item;
                var2.add(var6);
                continue;
            }
            return ItemStack.EMPTY;
        }
        if (var3.isEmpty() || var2.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return DyedItemColor.applyDyes(var3, var2);
    }

    @Override
    public RecipeSerializer<RecipeArmorDye> getSerializer() {
        return RecipeSerializer.ARMOR_DYE;
    }
}

