/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.level.World;

public class RecipeMap {
    public static final RecipeMap EMPTY = new RecipeMap((Multimap<Recipes<?>, RecipeHolder<?>>)ImmutableMultimap.of(), Map.of());
    public final Multimap<Recipes<?>, RecipeHolder<?>> byType;
    private final Map<ResourceKey<IRecipe<?>>, RecipeHolder<?>> byKey;

    private RecipeMap(Multimap<Recipes<?>, RecipeHolder<?>> var0, Map<ResourceKey<IRecipe<?>>, RecipeHolder<?>> var1) {
        this.byType = var0;
        this.byKey = var1;
    }

    public static RecipeMap create(Iterable<RecipeHolder<?>> var0) {
        ImmutableMultimap.Builder var1 = ImmutableMultimap.builder();
        ImmutableMap.Builder var2 = ImmutableMap.builder();
        for (RecipeHolder<?> var4 : var0) {
            var1.put(var4.value().getType(), var4);
            var2.put(var4.id(), var4);
        }
        return new RecipeMap((Multimap<Recipes<?>, RecipeHolder<?>>)var1.build(), (Map<ResourceKey<IRecipe<?>>, RecipeHolder<?>>)var2.build());
    }

    public <I extends RecipeInput, T extends IRecipe<I>> Collection<RecipeHolder<T>> byType(Recipes<T> var0) {
        return this.byType.get(var0);
    }

    public Collection<RecipeHolder<?>> values() {
        return this.byKey.values();
    }

    @Nullable
    public RecipeHolder<?> byKey(ResourceKey<IRecipe<?>> var0) {
        return this.byKey.get(var0);
    }

    public <I extends RecipeInput, T extends IRecipe<I>> Stream<RecipeHolder<T>> getRecipesFor(Recipes<T> var0, I var1, World var22) {
        if (var1.isEmpty()) {
            return Stream.empty();
        }
        return this.byType(var0).stream().filter(var2 -> var2.value().matches((RecipeInput)var1, var22));
    }
}

