/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.slf4j.Logger;

public class BiomeSettingsGeneration {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final BiomeSettingsGeneration EMPTY = new BiomeSettingsGeneration(HolderSet.direct(new Holder[0]), List.of());
    public static final MapCodec<BiomeSettingsGeneration> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)WorldGenCarverWrapper.LIST_CODEC.promotePartial(SystemUtils.prefix("Carver: ", arg_0 -> ((Logger)LOGGER).error(arg_0))).fieldOf("carvers").forGetter(var0 -> var0.carvers), (App)PlacedFeature.LIST_OF_LISTS_CODEC.promotePartial(SystemUtils.prefix("Features: ", arg_0 -> ((Logger)LOGGER).error(arg_0))).fieldOf("features").forGetter(var0 -> var0.features)).apply((Applicative)var02, BiomeSettingsGeneration::new));
    private final HolderSet<WorldGenCarverWrapper<?>> carvers;
    private final List<HolderSet<PlacedFeature>> features;
    private final Supplier<List<WorldGenFeatureConfigured<?, ?>>> flowerFeatures;
    private final Supplier<Set<PlacedFeature>> featureSet;

    BiomeSettingsGeneration(HolderSet<WorldGenCarverWrapper<?>> var0, List<HolderSet<PlacedFeature>> var1) {
        this.carvers = var0;
        this.features = var1;
        this.flowerFeatures = Suppliers.memoize(() -> (List)var1.stream().flatMap(HolderSet::stream).map(Holder::value).flatMap(PlacedFeature::getFeatures).filter(var0 -> var0.feature() == WorldGenerator.FLOWER).collect(ImmutableList.toImmutableList()));
        this.featureSet = Suppliers.memoize(() -> var1.stream().flatMap(HolderSet::stream).map(Holder::value).collect(Collectors.toSet()));
    }

    public Iterable<Holder<WorldGenCarverWrapper<?>>> getCarvers() {
        return this.carvers;
    }

    public List<WorldGenFeatureConfigured<?, ?>> getFlowerFeatures() {
        return this.flowerFeatures.get();
    }

    public List<HolderSet<PlacedFeature>> features() {
        return this.features;
    }

    public boolean hasFeature(PlacedFeature var0) {
        return this.featureSet.get().contains(var0);
    }

    public static class a
    extends b {
        private final HolderGetter<PlacedFeature> placedFeatures;
        private final HolderGetter<WorldGenCarverWrapper<?>> worldCarvers;

        public a(HolderGetter<PlacedFeature> var0, HolderGetter<WorldGenCarverWrapper<?>> var1) {
            this.placedFeatures = var0;
            this.worldCarvers = var1;
        }

        public a addFeature(WorldGenStage.Decoration var0, ResourceKey<PlacedFeature> var1) {
            this.addFeature(var0.ordinal(), this.placedFeatures.getOrThrow(var1));
            return this;
        }

        public a addCarver(ResourceKey<WorldGenCarverWrapper<?>> var0) {
            this.addCarver(this.worldCarvers.getOrThrow(var0));
            return this;
        }
    }

    public static class b {
        private final List<Holder<WorldGenCarverWrapper<?>>> carvers = new ArrayList();
        private final List<List<Holder<PlacedFeature>>> features = new ArrayList<List<Holder<PlacedFeature>>>();

        public b addFeature(WorldGenStage.Decoration var0, Holder<PlacedFeature> var1) {
            return this.addFeature(var0.ordinal(), var1);
        }

        public b addFeature(int var0, Holder<PlacedFeature> var1) {
            this.addFeatureStepsUpTo(var0);
            this.features.get(var0).add(var1);
            return this;
        }

        public b addCarver(Holder<WorldGenCarverWrapper<?>> var0) {
            this.carvers.add(var0);
            return this;
        }

        private void addFeatureStepsUpTo(int var0) {
            while (this.features.size() <= var0) {
                this.features.add(Lists.newArrayList());
            }
        }

        public BiomeSettingsGeneration build() {
            return new BiomeSettingsGeneration(HolderSet.direct(this.carvers), (List)this.features.stream().map(HolderSet::direct).collect(ImmutableList.toImmutableList()));
        }
    }
}

