/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;

public class BlockCauldron
extends AbstractCauldronBlock {
    public static final MapCodec<BlockCauldron> CODEC = BlockCauldron.simpleCodec(BlockCauldron::new);
    private static final float RAIN_FILL_CHANCE = 0.05f;
    private static final float POWDER_SNOW_FILL_CHANCE = 0.1f;

    public MapCodec<BlockCauldron> codec() {
        return CODEC;
    }

    public BlockCauldron(BlockBase.Info var0) {
        super(var0, CauldronInteraction.EMPTY);
    }

    @Override
    public boolean isFull(IBlockData var0) {
        return false;
    }

    protected static boolean shouldHandlePrecipitation(World var0, BiomeBase.Precipitation var1) {
        if (var1 == BiomeBase.Precipitation.RAIN) {
            return var0.getRandom().nextFloat() < 0.05f;
        }
        if (var1 == BiomeBase.Precipitation.SNOW) {
            return var0.getRandom().nextFloat() < 0.1f;
        }
        return false;
    }

    @Override
    public void handlePrecipitation(IBlockData var0, World var1, BlockPosition var2, BiomeBase.Precipitation var3) {
        if (!BlockCauldron.shouldHandlePrecipitation(var1, var3)) {
            return;
        }
        if (var3 == BiomeBase.Precipitation.RAIN) {
            var1.setBlockAndUpdate(var2, Blocks.WATER_CAULDRON.defaultBlockState());
            var1.gameEvent(null, GameEvent.BLOCK_CHANGE, var2);
        } else if (var3 == BiomeBase.Precipitation.SNOW) {
            var1.setBlockAndUpdate(var2, Blocks.POWDER_SNOW_CAULDRON.defaultBlockState());
            var1.gameEvent(null, GameEvent.BLOCK_CHANGE, var2);
        }
    }

    @Override
    protected boolean canReceiveStalactiteDrip(FluidType var0) {
        return true;
    }

    @Override
    protected void receiveStalactiteDrip(IBlockData var0, World var1, BlockPosition var2, FluidType var3) {
        if (var3 == FluidTypes.WATER) {
            IBlockData var4 = Blocks.WATER_CAULDRON.defaultBlockState();
            var1.setBlockAndUpdate(var2, var4);
            var1.gameEvent(GameEvent.BLOCK_CHANGE, var2, GameEvent.a.of(var4));
            var1.levelEvent(1047, var2, 0);
        } else if (var3 == FluidTypes.LAVA) {
            IBlockData var4 = Blocks.LAVA_CAULDRON.defaultBlockState();
            var1.setBlockAndUpdate(var2, var4);
            var1.gameEvent(GameEvent.BLOCK_CHANGE, var2, GameEvent.a.of(var4));
            var1.levelEvent(1046, var2, 0);
        }
    }
}

