/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockHalfTransparent;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockHoney
extends BlockHalfTransparent {
    public static final MapCodec<BlockHoney> CODEC = BlockHoney.simpleCodec(BlockHoney::new);
    private static final double SLIDE_STARTS_WHEN_VERTICAL_SPEED_IS_AT_LEAST = 0.13;
    private static final double MIN_FALL_SPEED_TO_BE_CONSIDERED_SLIDING = 0.08;
    private static final double THROTTLE_SLIDE_SPEED_TO = 0.05;
    private static final int SLIDE_ADVANCEMENT_CHECK_INTERVAL = 20;
    private static final VoxelShape SHAPE = Block.column(14.0, 0.0, 15.0);

    public MapCodec<BlockHoney> codec() {
        return CODEC;
    }

    public BlockHoney(BlockBase.Info var0) {
        super(var0);
    }

    private static boolean doesEntityDoHoneyBlockSlideEffects(Entity var0) {
        return var0 instanceof EntityLiving || var0 instanceof EntityMinecartAbstract || var0 instanceof EntityTNTPrimed || var0 instanceof AbstractBoat;
    }

    @Override
    protected VoxelShape getCollisionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE;
    }

    @Override
    public void fallOn(World var0, IBlockData var1, BlockPosition var2, Entity var3, double var4) {
        var3.playSound(SoundEffects.HONEY_BLOCK_SLIDE, 1.0f, 1.0f);
        if (!var0.isClientSide()) {
            var0.broadcastEntityEvent(var3, (byte)54);
        }
        if (var3.causeFallDamage(var4, 0.2f, var0.damageSources().fall())) {
            var3.playSound(this.soundType.getFallSound(), this.soundType.getVolume() * 0.5f, this.soundType.getPitch() * 0.75f);
        }
    }

    @Override
    protected void entityInside(IBlockData var0, World var1, BlockPosition var2, Entity var3, InsideBlockEffectApplier var4, boolean var5) {
        if (this.isSlidingDown(var2, var3)) {
            this.maybeDoSlideAchievement(var3, var2);
            this.doSlideMovement(var3);
            this.maybeDoSlideEffects(var1, var3);
        }
        super.entityInside(var0, var1, var2, var3, var4, var5);
    }

    private static double getOldDeltaY(double var0) {
        return var0 / (double)0.98f + 0.08;
    }

    private static double getNewDeltaY(double var0) {
        return (var0 - 0.08) * (double)0.98f;
    }

    private boolean isSlidingDown(BlockPosition var0, Entity var1) {
        if (var1.onGround()) {
            return false;
        }
        if (var1.getY() > (double)var0.getY() + 0.9375 - 1.0E-7) {
            return false;
        }
        if (BlockHoney.getOldDeltaY(var1.getDeltaMovement().y) >= -0.08) {
            return false;
        }
        double var2 = Math.abs((double)var0.getX() + 0.5 - var1.getX());
        double var4 = Math.abs((double)var0.getZ() + 0.5 - var1.getZ());
        double var6 = 0.4375 + (double)(var1.getBbWidth() / 2.0f);
        return var2 + 1.0E-7 > var6 || var4 + 1.0E-7 > var6;
    }

    private void maybeDoSlideAchievement(Entity var0, BlockPosition var1) {
        if (var0 instanceof EntityPlayer && var0.level().getGameTime() % 20L == 0L) {
            CriterionTriggers.HONEY_BLOCK_SLIDE.trigger((EntityPlayer)var0, var0.level().getBlockState(var1));
        }
    }

    private void doSlideMovement(Entity var0) {
        Vec3D var1 = var0.getDeltaMovement();
        if (BlockHoney.getOldDeltaY(var0.getDeltaMovement().y) < -0.13) {
            double var2 = -0.05 / BlockHoney.getOldDeltaY(var0.getDeltaMovement().y);
            var0.setDeltaMovement(new Vec3D(var1.x * var2, BlockHoney.getNewDeltaY(-0.05), var1.z * var2));
        } else {
            var0.setDeltaMovement(new Vec3D(var1.x, BlockHoney.getNewDeltaY(-0.05), var1.z));
        }
        var0.resetFallDistance();
    }

    private void maybeDoSlideEffects(World var0, Entity var1) {
        if (BlockHoney.doesEntityDoHoneyBlockSlideEffects(var1)) {
            if (var0.random.nextInt(5) == 0) {
                var1.playSound(SoundEffects.HONEY_BLOCK_SLIDE, 1.0f, 1.0f);
            }
            if (!var0.isClientSide() && var0.random.nextInt(5) == 0) {
                var0.broadcastEntityEvent(var1, (byte)53);
            }
        }
    }

    public static void showSlideParticles(Entity var0) {
        BlockHoney.showParticles(var0, 5);
    }

    public static void showJumpParticles(Entity var0) {
        BlockHoney.showParticles(var0, 10);
    }

    private static void showParticles(Entity var0, int var1) {
        if (!var0.level().isClientSide()) {
            return;
        }
        IBlockData var2 = Blocks.HONEY_BLOCK.defaultBlockState();
        for (int var3 = 0; var3 < var1; ++var3) {
            var0.level().addParticle(new ParticleParamBlock(Particles.BLOCK, var2), var0.getX(), var0.getY(), var0.getZ(), 0.0, 0.0, 0.0);
        }
    }
}

