/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockLadder
extends Block
implements IBlockWaterlogged {
    public static final MapCodec<BlockLadder> CODEC = BlockLadder.simpleCodec(BlockLadder::new);
    public static final BlockStateEnum<EnumDirection> FACING = BlockFacingHorizontal.FACING;
    public static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;
    public static final Map<EnumDirection, VoxelShape> SHAPES = VoxelShapes.rotateHorizontal(Block.boxZ(16.0, 13.0, 16.0));

    public MapCodec<BlockLadder> codec() {
        return CODEC;
    }

    protected BlockLadder(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH)).setValue(WATERLOGGED, false));
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPES.get(var0.getValue(FACING));
    }

    private boolean canAttachTo(IBlockAccess var0, BlockPosition var1, EnumDirection var2) {
        IBlockData var3 = var0.getBlockState(var1);
        return var3.isFaceSturdy(var0, var1, var2);
    }

    @Override
    protected boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        EnumDirection var3 = var0.getValue(FACING);
        return this.canAttachTo(var1, var2.relative(var3.getOpposite()), var3);
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (var4.getOpposite() == var0.getValue(FACING) && !var0.canSurvive(var1, var3)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var2.scheduleTick(var3, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var1));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    @Nullable
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        IBlockData var1;
        if (!var0.replacingClickedOnBlock() && (var1 = var0.getLevel().getBlockState(var0.getClickedPos().relative(var0.getClickedFace().getOpposite()))).is(this) && var1.getValue(FACING) == var0.getClickedFace()) {
            return null;
        }
        var1 = this.defaultBlockState();
        World var2 = var0.getLevel();
        BlockPosition var3 = var0.getClickedPos();
        Fluid var4 = var0.getLevel().getFluidState(var0.getClickedPos());
        for (EnumDirection var8 : var0.getNearestLookingDirections()) {
            if (!var8.getAxis().isHorizontal() || !(var1 = (IBlockData)var1.setValue(FACING, var8.getOpposite())).canSurvive(var2, var3)) continue;
            return (IBlockData)var1.setValue(WATERLOGGED, var4.getType() == FluidTypes.WATER);
        }
        return null;
    }

    @Override
    protected IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    protected IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING, WATERLOGGED);
    }

    @Override
    protected Fluid getFluidState(IBlockData var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return FluidTypes.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }
}

