/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleParamRedstone;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockAttachable;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyAttachPosition;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockLever
extends BlockAttachable {
    public static final MapCodec<BlockLever> CODEC = BlockLever.simpleCodec(BlockLever::new);
    public static final BlockStateBoolean POWERED = BlockProperties.POWERED;
    private final Function<IBlockData, VoxelShape> shapes;

    public MapCodec<BlockLever> codec() {
        return CODEC;
    }

    protected BlockLever(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH)).setValue(POWERED, false)).setValue(FACE, BlockPropertyAttachPosition.WALL));
        this.shapes = this.makeShapes();
    }

    private Function<IBlockData, VoxelShape> makeShapes() {
        Map<BlockPropertyAttachPosition, Map<EnumDirection, VoxelShape>> var0 = VoxelShapes.rotateAttachFace(Block.boxZ(6.0, 8.0, 10.0, 16.0));
        return this.getShapeForEachState(var1 -> (VoxelShape)((Map)var0.get(var1.getValue(FACE))).get(var1.getValue(FACING)), POWERED);
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return this.shapes.apply(var0);
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, MovingObjectPositionBlock var4) {
        if (var1.isClientSide()) {
            IBlockData var5 = (IBlockData)var0.cycle(POWERED);
            if (var5.getValue(POWERED).booleanValue()) {
                BlockLever.makeParticle(var5, var1, var2, 1.0f);
            }
        } else {
            this.pull(var0, var1, var2, null);
        }
        return EnumInteractionResult.SUCCESS;
    }

    @Override
    protected void onExplosionHit(IBlockData var0, WorldServer var1, BlockPosition var2, Explosion var3, BiConsumer<ItemStack, BlockPosition> var4) {
        if (var3.canTriggerBlocks()) {
            this.pull(var0, var1, var2, null);
        }
        super.onExplosionHit(var0, var1, var2, var3, var4);
    }

    public void pull(IBlockData var0, World var1, BlockPosition var2, @Nullable EntityHuman var3) {
        var0 = (IBlockData)var0.cycle(POWERED);
        var1.setBlock(var2, var0, 3);
        this.updateNeighbours(var0, var1, var2);
        BlockLever.playSound(var3, var1, var2, var0);
        var1.gameEvent((Entity)var3, var0.getValue(POWERED) != false ? GameEvent.BLOCK_ACTIVATE : GameEvent.BLOCK_DEACTIVATE, var2);
    }

    protected static void playSound(@Nullable EntityHuman var0, GeneratorAccess var1, BlockPosition var2, IBlockData var3) {
        float var4 = var3.getValue(POWERED) != false ? 0.6f : 0.5f;
        var1.playSound(var0, var2, SoundEffects.LEVER_CLICK, SoundCategory.BLOCKS, 0.3f, var4);
    }

    private static void makeParticle(IBlockData var0, GeneratorAccess var1, BlockPosition var2, float var3) {
        EnumDirection var4 = ((EnumDirection)var0.getValue(FACING)).getOpposite();
        EnumDirection var5 = BlockLever.getConnectedDirection(var0).getOpposite();
        double var6 = (double)var2.getX() + 0.5 + 0.1 * (double)var4.getStepX() + 0.2 * (double)var5.getStepX();
        double var8 = (double)var2.getY() + 0.5 + 0.1 * (double)var4.getStepY() + 0.2 * (double)var5.getStepY();
        double var10 = (double)var2.getZ() + 0.5 + 0.1 * (double)var4.getStepZ() + 0.2 * (double)var5.getStepZ();
        var1.addParticle(new ParticleParamRedstone(0xFF0000, var3), var6, var8, var10, 0.0, 0.0, 0.0);
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, RandomSource var3) {
        if (var0.getValue(POWERED).booleanValue() && var3.nextFloat() < 0.25f) {
            BlockLever.makeParticle(var0, var1, var2, 0.5f);
        }
    }

    @Override
    protected void affectNeighborsAfterRemoval(IBlockData var0, WorldServer var1, BlockPosition var2, boolean var3) {
        if (!var3 && var0.getValue(POWERED).booleanValue()) {
            this.updateNeighbours(var0, var1, var2);
        }
    }

    @Override
    protected int getSignal(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        return var0.getValue(POWERED) != false ? 15 : 0;
    }

    @Override
    protected int getDirectSignal(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        if (var0.getValue(POWERED).booleanValue() && BlockLever.getConnectedDirection(var0) == var3) {
            return 15;
        }
        return 0;
    }

    @Override
    protected boolean isSignalSource(IBlockData var0) {
        return true;
    }

    private void updateNeighbours(IBlockData var0, World var1, BlockPosition var2) {
        EnumDirection var3;
        Orientation var4 = ExperimentalRedstoneUtils.initialOrientation(var1, var3, (var3 = BlockLever.getConnectedDirection(var0).getOpposite()).getAxis().isHorizontal() ? EnumDirection.UP : (EnumDirection)var0.getValue(FACING));
        var1.updateNeighborsAt(var2, this, var4);
        var1.updateNeighborsAt(var2.relative(var3), this, var4);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACE, FACING, POWERED);
    }
}

