/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockPressurePlateAbstract;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;

public class BlockPressurePlateWeighted
extends BlockPressurePlateAbstract {
    public static final MapCodec<BlockPressurePlateWeighted> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)Codec.intRange((int)1, (int)1024).fieldOf("max_weight").forGetter(var0 -> var0.maxWeight), (App)BlockSetType.CODEC.fieldOf("block_set_type").forGetter(var0 -> var0.type), BlockPressurePlateWeighted.propertiesCodec()).apply((Applicative)var02, BlockPressurePlateWeighted::new));
    public static final BlockStateInteger POWER = BlockProperties.POWER;
    private final int maxWeight;

    public MapCodec<BlockPressurePlateWeighted> codec() {
        return CODEC;
    }

    protected BlockPressurePlateWeighted(int var0, BlockSetType var1, BlockBase.Info var2) {
        super(var2, var1);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(POWER, 0));
        this.maxWeight = var0;
    }

    @Override
    protected int getSignalStrength(World var0, BlockPosition var1) {
        int var2 = Math.min(BlockPressurePlateWeighted.getEntityCount(var0, TOUCH_AABB.move(var1), Entity.class), this.maxWeight);
        if (var2 > 0) {
            float var3 = (float)Math.min(this.maxWeight, var2) / (float)this.maxWeight;
            return MathHelper.ceil(var3 * 15.0f);
        }
        return 0;
    }

    @Override
    protected int getSignalForState(IBlockData var0) {
        return var0.getValue(POWER);
    }

    @Override
    protected IBlockData setSignalForState(IBlockData var0, int var1) {
        return (IBlockData)var0.setValue(POWER, var1);
    }

    @Override
    protected int getPressedTime() {
        return 10;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(POWER);
    }
}

