/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockPumpkinCarved;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.phys.MovingObjectPositionBlock;

public class BlockPumpkin
extends Block {
    public static final MapCodec<BlockPumpkin> CODEC = BlockPumpkin.simpleCodec(BlockPumpkin::new);

    public MapCodec<BlockPumpkin> codec() {
        return CODEC;
    }

    protected BlockPumpkin(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    protected EnumInteractionResult useItemOn(ItemStack var0, IBlockData var1, World var2, BlockPosition var32, EntityHuman var42, EnumHand var5, MovingObjectPositionBlock var6) {
        if (!var0.is(Items.SHEARS)) {
            return super.useItemOn(var0, var1, var2, var32, var42, var5, var6);
        }
        if (!(var2 instanceof WorldServer)) {
            return EnumInteractionResult.SUCCESS;
        }
        WorldServer var7 = (WorldServer)var2;
        EnumDirection var8 = var6.getDirection();
        EnumDirection var9 = var8.getAxis() == EnumDirection.EnumAxis.Y ? var42.getDirection().getOpposite() : var8;
        BlockPumpkin.dropFromBlockInteractLootTable(var7, LootTables.CARVE_PUMPKIN, var1, var2.getBlockEntity(var32), var0, var42, (var3, var4) -> {
            EntityItem var5 = new EntityItem(var2, (double)var32.getX() + 0.5 + (double)var9.getStepX() * 0.65, (double)var32.getY() + 0.1, (double)var32.getZ() + 0.5 + (double)var9.getStepZ() * 0.65, (ItemStack)var4);
            var5.setDeltaMovement(0.05 * (double)var9.getStepX() + var0.random.nextDouble() * 0.02, 0.05, 0.05 * (double)var9.getStepZ() + var0.random.nextDouble() * 0.02);
            var2.addFreshEntity(var5);
        });
        var2.playSound(null, var32, SoundEffects.PUMPKIN_CARVE, SoundCategory.BLOCKS, 1.0f, 1.0f);
        var2.setBlock(var32, (IBlockData)Blocks.CARVED_PUMPKIN.defaultBlockState().setValue(BlockPumpkinCarved.FACING, var9), 11);
        var0.hurtAndBreak(1, (EntityLiving)var42, var5.asEquipmentSlot());
        var2.gameEvent((Entity)var42, GameEvent.SHEAR, var32);
        var42.awardStat(StatisticList.ITEM_USED.get(Items.SHEARS));
        return EnumInteractionResult.SUCCESS;
    }
}

